define(['@microsoft/load-themed-styles', 'vue'], function (loadThemedStyles, Vue) {

	Vue = Vue && Vue.hasOwnProperty('default') ? Vue['default'] : Vue;

	var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function commonjsRequire () {
		throw new Error('Dynamic requires are not currently supported by rollup-plugin-commonjs');
	}

	function unwrapExports (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	function createCommonjsModule(fn, module) {
		return module = { exports: {} }, fn(module, module.exports), module.exports;
	}

	/*! *****************************************************************************
	Copyright (c) Microsoft Corporation. All rights reserved.
	Licensed under the Apache License, Version 2.0 (the "License"); you may not use
	this file except in compliance with the License. You may obtain a copy of the
	License at http://www.apache.org/licenses/LICENSE-2.0

	THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
	KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
	WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
	MERCHANTABLITY OR NON-INFRINGEMENT.

	See the Apache Version 2.0 License for specific language governing permissions
	and limitations under the License.
	***************************************************************************** */
	/* global Reflect, Promise */

	var extendStatics = Object.setPrototypeOf ||
	    ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
	    function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };

	function __extends(d, b) {
	    extendStatics(d, b);
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	}

	var __assign = Object.assign || function __assign(t) {
	    for (var s, i = 1, n = arguments.length; i < n; i++) {
	        s = arguments[i];
	        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
	    }
	    return t;
	};

	function __rest(s, e) {
	    var t = {};
	    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
	        t[p] = s[p];
	    if (s != null && typeof Object.getOwnPropertySymbols === "function")
	        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
	            t[p[i]] = s[p[i]];
	    return t;
	}

	function __decorate(decorators, target, key, desc) {
	    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
	    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
	    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
	    return c > 3 && r && Object.defineProperty(target, key, r), r;
	}

	function __param(paramIndex, decorator) {
	    return function (target, key) { decorator(target, key, paramIndex); }
	}

	function __metadata(metadataKey, metadataValue) {
	    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
	}

	function __awaiter(thisArg, _arguments, P, generator) {
	    return new (P || (P = Promise))(function (resolve, reject) {
	        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
	        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
	        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
	        step((generator = generator.apply(thisArg, _arguments || [])).next());
	    });
	}

	function __generator(thisArg, body) {
	    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
	    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
	    function verb(n) { return function (v) { return step([n, v]); }; }
	    function step(op) {
	        if (f) throw new TypeError("Generator is already executing.");
	        while (_) try {
	            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
	            if (y = 0, t) op = [0, t.value];
	            switch (op[0]) {
	                case 0: case 1: t = op; break;
	                case 4: _.label++; return { value: op[1], done: false };
	                case 5: _.label++; y = op[1]; op = [0]; continue;
	                case 7: op = _.ops.pop(); _.trys.pop(); continue;
	                default:
	                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
	                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
	                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
	                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
	                    if (t[2]) _.ops.pop();
	                    _.trys.pop(); continue;
	            }
	            op = body.call(thisArg, _);
	        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
	        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
	    }
	}

	function __exportStar(m, exports) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}

	function __values(o) {
	    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
	    if (m) return m.call(o);
	    return {
	        next: function () {
	            if (o && i >= o.length) o = void 0;
	            return { value: o && o[i++], done: !o };
	        }
	    };
	}

	function __read(o, n) {
	    var m = typeof Symbol === "function" && o[Symbol.iterator];
	    if (!m) return o;
	    var i = m.call(o), r, ar = [], e;
	    try {
	        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
	    }
	    catch (error) { e = { error: error }; }
	    finally {
	        try {
	            if (r && !r.done && (m = i["return"])) m.call(i);
	        }
	        finally { if (e) throw e.error; }
	    }
	    return ar;
	}

	function __spread() {
	    for (var ar = [], i = 0; i < arguments.length; i++)
	        ar = ar.concat(__read(arguments[i]));
	    return ar;
	}

	function __await(v) {
	    return this instanceof __await ? (this.v = v, this) : new __await(v);
	}

	function __asyncGenerator(thisArg, _arguments, generator) {
	    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
	    var g = generator.apply(thisArg, _arguments || []), i, q = [];
	    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
	    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
	    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
	    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);  }
	    function fulfill(value) { resume("next", value); }
	    function reject(value) { resume("throw", value); }
	    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
	}

	function __asyncDelegator(o) {
	    var i, p;
	    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
	    function verb(n, f) { if (o[n]) i[n] = function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; }; }
	}

	function __asyncValues(o) {
	    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
	    var m = o[Symbol.asyncIterator];
	    return m ? m.call(o) : typeof __values === "function" ? __values(o) : o[Symbol.iterator]();
	}

	function __makeTemplateObject(cooked, raw) {
	    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
	    return cooked;
	}

	var tslib_es6 = /*#__PURE__*/Object.freeze({
		__extends: __extends,
		__assign: __assign,
		__rest: __rest,
		__decorate: __decorate,
		__param: __param,
		__metadata: __metadata,
		__awaiter: __awaiter,
		__generator: __generator,
		__exportStar: __exportStar,
		__values: __values,
		__read: __read,
		__spread: __spread,
		__await: __await,
		__asyncGenerator: __asyncGenerator,
		__asyncDelegator: __asyncDelegator,
		__asyncValues: __asyncValues,
		__makeTemplateObject: __makeTemplateObject
	});

	var Stylesheet_1 = createCommonjsModule(function (module, exports) {
	Object.defineProperty(exports, "__esModule", { value: true });

	/**
	 * Injection mode for the stylesheet.
	 *
	 * @public
	 */
	var InjectionMode;
	(function (InjectionMode) {
	    /**
	     * Avoids style injection, use getRules() to read the styles.
	     */
	    InjectionMode[InjectionMode["none"] = 0] = "none";
	    /**
	     * Inserts rules using the insertRule api.
	     */
	    InjectionMode[InjectionMode["insertNode"] = 1] = "insertNode";
	    /**
	     * Appends rules using appendChild.
	     */
	    InjectionMode[InjectionMode["appendChild"] = 2] = "appendChild";
	})(InjectionMode = exports.InjectionMode || (exports.InjectionMode = {}));
	var STYLESHEET_SETTING = '__stylesheet__';
	var _stylesheet;
	/**
	 * Represents the state of styles registered in the page. Abstracts
	 * the surface for adding styles to the stylesheet, exposes helpers
	 * for reading the styles registered in server rendered scenarios.
	 *
	 * @public
	 */
	var Stylesheet = /** @class */ (function () {
	    function Stylesheet(config) {
	        this._rules = [];
	        this._rulesToInsert = [];
	        this._counter = 0;
	        this._keyToClassName = {};
	        // tslint:disable-next-line:no-any
	        this._classNameToArgs = {};
	        this._config = tslib_es6.__assign({ injectionMode: 1 /* insertNode */, defaultPrefix: 'css' }, config);
	    }
	    /**
	     * Gets the singleton instance.
	     */
	    Stylesheet.getInstance = function () {
	        // tslint:disable-next-line:no-any
	        var win = typeof window !== 'undefined' ? window : {};
	        _stylesheet = win[STYLESHEET_SETTING];
	        if (!_stylesheet) {
	            // tslint:disable-next-line:no-string-literal
	            var fabricConfig = (win && win['FabricConfig']) || {};
	            _stylesheet = win[STYLESHEET_SETTING] = new Stylesheet(fabricConfig.mergeStyles);
	        }
	        return _stylesheet;
	    };
	    /**
	     * Configures the stylesheet.
	     */
	    Stylesheet.prototype.setConfig = function (config) {
	        this._config = tslib_es6.__assign({}, this._config, config);
	    };
	    /**
	     * Generates a unique classname.
	     *
	     * @param displayName - Optional value to use as a prefix.
	     */
	    Stylesheet.prototype.getClassName = function (displayName) {
	        var prefix = displayName || this._config.defaultPrefix;
	        return prefix + "-" + this._counter++;
	    };
	    /**
	     * Used internally to cache information about a class which was
	     * registered with the stylesheet.
	     */
	    Stylesheet.prototype.cacheClassName = function (className, key, args, rules) {
	        this._keyToClassName[key] = className;
	        this._classNameToArgs[className] = {
	            args: args,
	            rules: rules
	        };
	    };
	    /**
	     * Gets the appropriate classname given a key which was previously
	     * registered using cacheClassName.
	     */
	    Stylesheet.prototype.classNameFromKey = function (key) {
	        return this._keyToClassName[key];
	    };
	    /**
	     * Gets the arguments associated with a given classname which was
	     * previously registered using cacheClassName.
	     */
	    Stylesheet.prototype.argsFromClassName = function (className) {
	        var entry = this._classNameToArgs[className];
	        return (entry && entry.args);
	    };
	    /**
	   * Gets the arguments associated with a given classname which was
	   * previously registered using cacheClassName.
	   */
	    Stylesheet.prototype.insertedRulesFromClassName = function (className) {
	        var entry = this._classNameToArgs[className];
	        return (entry && entry.rules);
	    };
	    /**
	     * Inserts a css rule into the stylesheet.
	     */
	    Stylesheet.prototype.insertRule = function (rule) {
	        var injectionMode = this._config.injectionMode;
	        var element = injectionMode !== 0 /* none */ ? this._getStyleElement() : undefined;
	        if (element) {
	            switch (this._config.injectionMode) {
	                case 1 /* insertNode */:
	                    var sheet = element.sheet;
	                    try {
	                        sheet.insertRule(rule, sheet.cssRules.length);
	                    }
	                    catch (e) {
	                        // The browser will throw exceptions on unsupported rules (such as a moz prefix in webkit.)
	                        // We need to swallow the exceptions for this scenario, otherwise we'd need to filter
	                        // which could be slower and bulkier.
	                    }
	                    break;
	                case 2 /* appendChild */:
	                    element.appendChild(document.createTextNode(rule));
	                    break;
	            }
	        }
	        else {
	            this._rules.push(rule);
	        }
	        if (this._config.onInsertRule) {
	            this._config.onInsertRule(rule);
	        }
	    };
	    /**
	     * Gets all rules registered with the stylesheet; only valid when
	     * using InsertionMode.none.
	     */
	    Stylesheet.prototype.getRules = function () {
	        return (this._rules.join('') || '') + (this._rulesToInsert.join('') || '');
	    };
	    /**
	     * Resets the internal state of the stylesheet. Only used in server
	     * rendered scenarios where we're using InsertionMode.none.
	     */
	    Stylesheet.prototype.reset = function () {
	        this._rules = [];
	        this._rulesToInsert = [];
	        this._counter = 0;
	        this._classNameToArgs = {};
	        this._keyToClassName = {};
	    };
	    // Forces the regeneration of incoming styles without totally resetting the stylesheet.
	    Stylesheet.prototype.resetKeys = function () {
	        this._keyToClassName = {};
	    };
	    Stylesheet.prototype._getStyleElement = function () {
	        var _this = this;
	        if (!this._styleElement && typeof document !== 'undefined') {
	            this._styleElement = this._createStyleElement();
	            // Reset the style element on the next frame.
	            window.requestAnimationFrame(function () {
	                _this._styleElement = undefined;
	            });
	        }
	        return this._styleElement;
	    };
	    Stylesheet.prototype._createStyleElement = function () {
	        var styleElement = document.createElement('style');
	        styleElement.setAttribute('data-merge-styles', 'true');
	        styleElement.type = 'text/css';
	        if (this._lastStyleElement && this._lastStyleElement.nextElementSibling) {
	            document.head.insertBefore(styleElement, this._lastStyleElement.nextElementSibling);
	        }
	        else {
	            document.head.appendChild(styleElement);
	        }
	        this._lastStyleElement = styleElement;
	        return styleElement;
	    };
	    return Stylesheet;
	}());
	exports.Stylesheet = Stylesheet;

	});

	unwrapExports(Stylesheet_1);
	var Stylesheet_2 = Stylesheet_1.InjectionMode;
	var Stylesheet_3 = Stylesheet_1.Stylesheet;

	var kebabRules_1 = createCommonjsModule(function (module, exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	function kebabRules(rulePairs, index) {
	    rulePairs[index] = rulePairs[index].replace(/([A-Z])/g, '-$1').toLowerCase();
	}
	exports.kebabRules = kebabRules;

	});

	unwrapExports(kebabRules_1);
	var kebabRules_2 = kebabRules_1.kebabRules;

	var getVendorSettings_1 = createCommonjsModule(function (module, exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	var _vendorSettings;
	function getVendorSettings() {
	    if (!_vendorSettings) {
	        var doc = typeof document !== 'undefined' ? document : undefined;
	        var nav = typeof navigator !== 'undefined' ? navigator : undefined;
	        var userAgent = nav ? nav.userAgent.toLowerCase() : undefined;
	        if (!doc) {
	            _vendorSettings = {
	                isWebkit: true,
	                isMoz: true,
	                isOpera: true,
	                isMs: true
	            };
	        }
	        else {
	            _vendorSettings = {
	                isWebkit: !!(doc && 'WebkitAppearance' in doc.documentElement.style),
	                isMoz: !!(userAgent && userAgent.indexOf('firefox') > -1),
	                isOpera: !!(userAgent && userAgent.indexOf('opera') > -1),
	                isMs: !!(nav && (/rv:11.0/i.test(nav.userAgent) || /Edge\/\d./i.test(navigator.userAgent)))
	            };
	        }
	    }
	    return _vendorSettings;
	}
	exports.getVendorSettings = getVendorSettings;
	/**
	 * Sets the vendor settings for prefixing and vendor specific operations.
	 */
	function setVendorSettings(vendorSettings) {
	    _vendorSettings = vendorSettings;
	}
	exports.setVendorSettings = setVendorSettings;

	});

	unwrapExports(getVendorSettings_1);
	var getVendorSettings_2 = getVendorSettings_1.getVendorSettings;
	var getVendorSettings_3 = getVendorSettings_1.setVendorSettings;

	var prefixRules_1 = createCommonjsModule(function (module, exports) {
	Object.defineProperty(exports, "__esModule", { value: true });

	var autoPrefixNames = {
	    'user-select': 1
	};
	function prefixRules(rulePairs, index) {
	    var vendorSettings = getVendorSettings_1.getVendorSettings();
	    var name = rulePairs[index];
	    if (autoPrefixNames[name]) {
	        var value = rulePairs[index + 1];
	        if (autoPrefixNames[name]) {
	            if (vendorSettings.isWebkit) {
	                rulePairs.push('-webkit-' + name, value);
	            }
	            if (vendorSettings.isMoz) {
	                rulePairs.push('-moz-' + name, value);
	            }
	            if (vendorSettings.isMs) {
	                rulePairs.push('-ms-' + name, value);
	            }
	            if (vendorSettings.isOpera) {
	                rulePairs.push('-o-' + name, value);
	            }
	        }
	    }
	}
	exports.prefixRules = prefixRules;

	});

	unwrapExports(prefixRules_1);
	var prefixRules_2 = prefixRules_1.prefixRules;

	var provideUnits_1 = createCommonjsModule(function (module, exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	var NON_PIXEL_NUMBER_PROPS = [
	    'column-count',
	    'font-weight',
	    'flex-basis',
	    'flex',
	    'flex-grow',
	    'flex-shrink',
	    'fill-opacity',
	    'opacity',
	    'order',
	    'z-index',
	    'zoom'
	];
	function provideUnits(rulePairs, index) {
	    var name = rulePairs[index];
	    var value = rulePairs[index + 1];
	    if (typeof value === 'number') {
	        var unit = (NON_PIXEL_NUMBER_PROPS.indexOf(name) === -1) ? 'px' : '';
	        rulePairs[index + 1] = "" + value + unit;
	    }
	}
	exports.provideUnits = provideUnits;

	});

	unwrapExports(provideUnits_1);
	var provideUnits_2 = provideUnits_1.provideUnits;

	var rtlifyRules_1 = createCommonjsModule(function (module, exports) {
	Object.defineProperty(exports, "__esModule", { value: true });

	var LEFT = 'left';
	var RIGHT = 'right';
	var NO_FLIP = '@noflip';
	var NAME_REPLACEMENTS = (_a = {},
	    _a[LEFT] = RIGHT,
	    _a[RIGHT] = LEFT,
	    _a);
	var VALUE_REPLACEMENTS = {
	    'w-resize': 'e-resize',
	    'sw-resize': 'se-resize',
	    'nw-resize': 'ne-resize'
	};
	var _rtl = getRTL();
	/**
	 * Sets the current RTL value.
	 */
	function setRTL(isRTL) {
	    if (_rtl !== isRTL) {
	        Stylesheet_1.Stylesheet.getInstance().resetKeys();
	        _rtl = isRTL;
	    }
	}
	exports.setRTL = setRTL;
	/**
	 * Gets the current RTL value.
	 */
	function getRTL() {
	    if (_rtl === undefined) {
	        _rtl = (typeof document !== 'undefined' &&
	            !!document.documentElement &&
	            document.documentElement.getAttribute('dir') === 'rtl');
	    }
	    return _rtl;
	}
	exports.getRTL = getRTL;
	/**
	 * RTLifies the rulePair in the array at the current index. This mutates the array for performance
	 * reasons.
	 */
	function rtlifyRules(rulePairs, index) {
	    if (getRTL()) {
	        var name_1 = rulePairs[index];
	        if (!name_1) {
	            return;
	        }
	        var value = rulePairs[index + 1];
	        if (typeof value === 'string' && value.indexOf(NO_FLIP) >= 0) {
	            rulePairs[index + 1] = value.replace(/\s*(?:\/\*\s*)?\@noflip\b(?:\s*\*\/)?\s*?/g, '');
	        }
	        else if (name_1.indexOf(LEFT) >= 0) {
	            rulePairs[index] = name_1.replace(LEFT, RIGHT);
	        }
	        else if (name_1.indexOf(RIGHT) >= 0) {
	            rulePairs[index] = name_1.replace(RIGHT, LEFT);
	        }
	        else if (String(value).indexOf(LEFT) >= 0) {
	            rulePairs[index + 1] = value.replace(LEFT, RIGHT);
	        }
	        else if (String(value).indexOf(RIGHT) >= 0) {
	            rulePairs[index + 1] = value.replace(RIGHT, LEFT);
	        }
	        else if (NAME_REPLACEMENTS[name_1]) {
	            rulePairs[index] = NAME_REPLACEMENTS[name_1];
	        }
	        else if (VALUE_REPLACEMENTS[value]) {
	            rulePairs[index + 1] = VALUE_REPLACEMENTS[value];
	        }
	        else {
	            switch (name_1) {
	                case 'margin':
	                case 'padding':
	                    rulePairs[index + 1] = flipQuad(value);
	                    break;
	                case 'box-shadow':
	                    rulePairs[index + 1] = negateNum(value, 0);
	                    break;
	            }
	        }
	    }
	}
	exports.rtlifyRules = rtlifyRules;
	/**
	 * Given a string value in a space delimited format (e.g. "1 2 3 4"), negates a particular value.
	 */
	function negateNum(value, partIndex) {
	    var parts = value.split(' ');
	    var numberVal = parseInt(parts[partIndex], 10);
	    parts[0] = parts[0].replace(String(numberVal), String(numberVal * -1));
	    return parts.join(' ');
	}
	/**
	 * Given a string quad, flips the left and right values.
	 */
	function flipQuad(value) {
	    if (typeof value === 'string') {
	        var parts = value.split(' ');
	        if (parts.length === 4) {
	            return parts[0] + " " + parts[3] + " " + parts[2] + " " + parts[1];
	        }
	    }
	    return value;
	}
	var _a;

	});

	unwrapExports(rtlifyRules_1);
	var rtlifyRules_2 = rtlifyRules_1.setRTL;
	var rtlifyRules_3 = rtlifyRules_1.getRTL;
	var rtlifyRules_4 = rtlifyRules_1.rtlifyRules;

	var styleToClassName_1 = createCommonjsModule(function (module, exports) {
	Object.defineProperty(exports, "__esModule", { value: true });





	var DISPLAY_NAME = 'displayName';
	function getDisplayName(rules) {
	    var rootStyle = rules && rules['&'];
	    return rootStyle ? rootStyle.displayName : undefined;
	}
	function extractRules(args, rules, currentSelector) {
	    if (rules === void 0) { rules = { __order: [] }; }
	    if (currentSelector === void 0) { currentSelector = '&'; }
	    var stylesheet = Stylesheet_1.Stylesheet.getInstance();
	    var currentRules = rules[currentSelector];
	    if (!currentRules) {
	        currentRules = {};
	        rules[currentSelector] = currentRules;
	        rules.__order.push(currentSelector);
	    }
	    for (var _i = 0, args_1 = args; _i < args_1.length; _i++) {
	        var arg = args_1[_i];
	        // If the arg is a string, we need to look up the class map and merge.
	        if (typeof arg === 'string') {
	            var expandedRules = stylesheet.argsFromClassName(arg);
	            if (expandedRules) {
	                extractRules(expandedRules, rules, currentSelector);
	            }
	            // Else if the arg is an array, we need to recurse in.
	        }
	        else if (Array.isArray(arg)) {
	            extractRules(arg, rules, currentSelector);
	        }
	        else {
	            // tslint:disable-next-line:no-any
	            for (var prop in arg) {
	                if (prop === 'selectors') {
	                    // tslint:disable-next-line:no-any
	                    var selectors = arg.selectors;
	                    for (var newSelector in selectors) {
	                        if (selectors.hasOwnProperty(newSelector)) {
	                            var selectorValue = selectors[newSelector];
	                            if (newSelector.indexOf(':global(') === 0) {
	                                newSelector = newSelector.replace(/:global\(|\)$/g, '');
	                            }
	                            else if (newSelector.indexOf('@media') === 0) {
	                                newSelector = newSelector + '{' + currentSelector;
	                            }
	                            else if (newSelector.indexOf(':') === 0) {
	                                newSelector = currentSelector + newSelector;
	                            }
	                            else if (newSelector.indexOf('&') < 0) {
	                                newSelector = currentSelector + ' ' + newSelector;
	                            }
	                            extractRules([selectorValue], rules, newSelector);
	                        }
	                    }
	                }
	                else {
	                    // Else, add the rule to the currentSelector.
	                    if (prop === 'margin' || prop === 'padding') {
	                        // tslint:disable-next-line:no-any
	                        expandQuads(currentRules, prop, arg[prop]);
	                    }
	                    else {
	                        // tslint:disable-next-line:no-any
	                        currentRules[prop] = arg[prop];
	                    }
	                }
	            }
	        }
	    }
	    return rules;
	}
	function expandQuads(currentRules, name, value) {
	    var parts = (typeof value === 'string') ? value.split(' ') : [value];
	    currentRules[name + 'Top'] = parts[0];
	    currentRules[name + 'Right'] = parts[1] || parts[0];
	    currentRules[name + 'Bottom'] = parts[2] || parts[0];
	    currentRules[name + 'Left'] = parts[3] || parts[1] || parts[0];
	}
	function getKeyForRules(rules) {
	    var serialized = [];
	    var hasProps = false;
	    for (var _i = 0, _a = rules.__order; _i < _a.length; _i++) {
	        var selector = _a[_i];
	        serialized.push(selector);
	        var rulesForSelector = rules[selector];
	        for (var propName in rulesForSelector) {
	            if (rulesForSelector.hasOwnProperty(propName) && rulesForSelector[propName] !== undefined) {
	                hasProps = true;
	                serialized.push(propName, rulesForSelector[propName]);
	            }
	        }
	    }
	    return hasProps ? serialized.join('') : undefined;
	}
	function serializeRuleEntries(ruleEntries) {
	    if (!ruleEntries) {
	        return '';
	    }
	    var allEntries = [];
	    for (var entry in ruleEntries) {
	        if (ruleEntries.hasOwnProperty(entry) && entry !== DISPLAY_NAME && ruleEntries[entry] !== undefined) {
	            allEntries.push(entry, ruleEntries[entry]);
	        }
	    }
	    // Apply transforms.
	    for (var i = 0; i < allEntries.length; i += 2) {
	        kebabRules_1.kebabRules(allEntries, i);
	        provideUnits_1.provideUnits(allEntries, i);
	        rtlifyRules_1.rtlifyRules(allEntries, i);
	        prefixRules_1.prefixRules(allEntries, i);
	    }
	    // Apply punctuation.
	    for (var i = 1; i < allEntries.length; i += 4) {
	        allEntries.splice(i, 1, ':', allEntries[i], ';');
	    }
	    return allEntries.join('');
	}
	exports.serializeRuleEntries = serializeRuleEntries;
	function styleToRegistration() {
	    var args = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	        args[_i] = arguments[_i];
	    }
	    var rules = extractRules(args);
	    var key = getKeyForRules(rules);
	    if (key) {
	        var stylesheet = Stylesheet_1.Stylesheet.getInstance();
	        var registration = {
	            className: stylesheet.classNameFromKey(key),
	            key: key,
	            args: args
	        };
	        if (!registration.className) {
	            registration.className = stylesheet.getClassName(getDisplayName(rules));
	            var rulesToInsert = [];
	            for (var _a = 0, _b = rules.__order; _a < _b.length; _a++) {
	                var selector = _b[_a];
	                rulesToInsert.push(selector, serializeRuleEntries(rules[selector]));
	            }
	            registration.rulesToInsert = rulesToInsert;
	        }
	        return registration;
	    }
	}
	exports.styleToRegistration = styleToRegistration;
	function applyRegistration(registration, classMap) {
	    var stylesheet = Stylesheet_1.Stylesheet.getInstance();
	    var className = registration.className, key = registration.key, args = registration.args, rulesToInsert = registration.rulesToInsert;
	    if (rulesToInsert) {
	        // rulesToInsert is an ordered array of selector/rule pairs.
	        for (var i = 0; i < rulesToInsert.length; i += 2) {
	            var rules = rulesToInsert[i + 1];
	            if (rules) {
	                var selector = rulesToInsert[i];
	                // Fix selector using map.
	                selector = selector.replace(/(&)|\$([\w-]+)\b/g, function (match, amp, cn) {
	                    if (amp) {
	                        return '.' + registration.className;
	                    }
	                    else if (cn) {
	                        return '.' + ((classMap && classMap[cn]) || cn);
	                    }
	                    return '';
	                });
	                // Insert. Note if a media query, we must close the query with a final bracket.
	                var processedRule = selector + "{" + rules + "}" + ((selector.indexOf('@media') === 0) ? '}' : '');
	                stylesheet.insertRule(processedRule);
	            }
	        }
	        stylesheet.cacheClassName(className, key, args, rulesToInsert);
	    }
	}
	exports.applyRegistration = applyRegistration;
	function styleToClassName() {
	    var args = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	        args[_i] = arguments[_i];
	    }
	    var registration = styleToRegistration.apply(void 0, args);
	    if (registration) {
	        applyRegistration(registration);
	        return registration.className;
	    }
	    return '';
	}
	exports.styleToClassName = styleToClassName;

	});

	unwrapExports(styleToClassName_1);
	var styleToClassName_2 = styleToClassName_1.serializeRuleEntries;
	var styleToClassName_3 = styleToClassName_1.styleToRegistration;
	var styleToClassName_4 = styleToClassName_1.applyRegistration;
	var styleToClassName_5 = styleToClassName_1.styleToClassName;

	var extractStyleParts_1 = createCommonjsModule(function (module, exports) {
	Object.defineProperty(exports, "__esModule", { value: true });

	/**
	 * Separates the classes and style objects. Any classes that are pre-registered
	 * args are auto expanded into objects.
	 */
	function extractStyleParts() {
	    var args = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	        args[_i] = arguments[_i];
	    }
	    var classes = [];
	    var objects = [];
	    var stylesheet = Stylesheet_1.Stylesheet.getInstance();
	    function _processArgs(argsList) {
	        for (var _i = 0, argsList_1 = argsList; _i < argsList_1.length; _i++) {
	            var arg = argsList_1[_i];
	            if (arg) {
	                if (typeof arg === 'string') {
	                    if (arg.indexOf(' ') >= 0) {
	                        _processArgs(arg.split(' '));
	                    }
	                    else {
	                        var translatedArgs = stylesheet.argsFromClassName(arg);
	                        if (translatedArgs) {
	                            _processArgs(translatedArgs);
	                        }
	                        else {
	                            // Avoid adding the same class twice.
	                            if (classes.indexOf(arg) === -1) {
	                                classes.push(arg);
	                            }
	                        }
	                    }
	                }
	                else if (Array.isArray(arg)) {
	                    _processArgs(arg);
	                }
	                else if (typeof arg === 'object') {
	                    objects.push(arg);
	                }
	            }
	        }
	    }
	    _processArgs(args);
	    return {
	        classes: classes,
	        objects: objects
	    };
	}
	exports.extractStyleParts = extractStyleParts;

	});

	unwrapExports(extractStyleParts_1);
	var extractStyleParts_2 = extractStyleParts_1.extractStyleParts;

	var mergeStyles_1 = createCommonjsModule(function (module, exports) {
	Object.defineProperty(exports, "__esModule", { value: true });


	/**
	 * Concatination helper, which can merge class names together. Skips over falsey values.
	 *
	 * @public
	 */
	function mergeStyles() {
	    var args = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	        args[_i] = arguments[_i];
	    }
	    var _a = extractStyleParts_1.extractStyleParts(args), classes = _a.classes, objects = _a.objects;
	    if (objects.length) {
	        classes.push(styleToClassName_1.styleToClassName(objects));
	    }
	    return classes.join(' ');
	}
	exports.mergeStyles = mergeStyles;

	});

	unwrapExports(mergeStyles_1);
	var mergeStyles_2 = mergeStyles_1.mergeStyles;

	var concatStyleSets_1 = createCommonjsModule(function (module, exports) {
	Object.defineProperty(exports, "__esModule", { value: true });
	/**
	 * Combine a set of styles together (but does not register css classes.)
	 * @public
	 */
	function concatStyleSets() {
	    var args = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	        args[_i] = arguments[_i];
	    }
	    // tslint:disable-next-line:no-any
	    var mergedSet = {};
	    for (var _a = 0, args_1 = args; _a < args_1.length; _a++) {
	        var currentSet = args_1[_a];
	        if (currentSet) {
	            for (var prop in currentSet) {
	                if (currentSet.hasOwnProperty(prop)) {
	                    var mergedValue = mergedSet[prop];
	                    var currentValue = currentSet[prop];
	                    if (mergedValue === undefined) {
	                        mergedSet[prop] = currentValue;
	                    }
	                    else {
	                        mergedSet[prop] = (Array.isArray(mergedValue) ? mergedValue : [mergedValue]).concat((Array.isArray(currentValue) ? currentValue : [currentValue]));
	                    }
	                }
	            }
	        }
	    }
	    return mergedSet;
	}
	exports.concatStyleSets = concatStyleSets;

	});

	unwrapExports(concatStyleSets_1);
	var concatStyleSets_2 = concatStyleSets_1.concatStyleSets;

	var mergeStyleSets_1 = createCommonjsModule(function (module, exports) {
	Object.defineProperty(exports, "__esModule", { value: true });



	/**
	 * Allows you to pass in 1 or more sets of areas which will return a merged
	 * set of classes.
	 *
	 * @public
	 */
	function mergeStyleSets() {
	    var cssSets = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	        cssSets[_i] = arguments[_i];
	    }
	    // tslint:disable-next-line:no-any
	    var classNameSet = {};
	    var classMap = {};
	    var cssSet = cssSets[0];
	    if (cssSet) {
	        if (cssSets.length > 1) {
	            cssSet = concatStyleSets_1.concatStyleSets.apply(void 0, cssSets);
	        }
	        var registrations = [];
	        for (var prop in cssSet) {
	            if (cssSet.hasOwnProperty(prop)) {
	                var args = cssSet[prop];
	                // tslint:disable-next-line:no-any
	                var _a = extractStyleParts_1.extractStyleParts(args), classes = _a.classes, objects = _a.objects;
	                var registration = styleToClassName_1.styleToRegistration({ displayName: prop }, objects);
	                registrations.push(registration);
	                if (registration) {
	                    classMap[prop] = registration.className;
	                    classNameSet[prop] = classes.concat([registration.className]).join(' ');
	                }
	            }
	        }
	        for (var _b = 0, registrations_1 = registrations; _b < registrations_1.length; _b++) {
	            var registration = registrations_1[_b];
	            if (registration) {
	                styleToClassName_1.applyRegistration(registration, classMap);
	            }
	        }
	    }
	    return classNameSet;
	}
	exports.mergeStyleSets = mergeStyleSets;

	});

	unwrapExports(mergeStyleSets_1);
	var mergeStyleSets_2 = mergeStyleSets_1.mergeStyleSets;

	var fontFace_1 = createCommonjsModule(function (module, exports) {
	Object.defineProperty(exports, "__esModule", { value: true });


	/**
	 * Registers a font face.
	 * @public
	 */
	function fontFace(font) {
	    Stylesheet_1.Stylesheet.getInstance().insertRule("@font-face{" + styleToClassName_1.serializeRuleEntries(font) + "}");
	}
	exports.fontFace = fontFace;

	});

	unwrapExports(fontFace_1);
	var fontFace_2 = fontFace_1.fontFace;

	var keyframes_1 = createCommonjsModule(function (module, exports) {
	Object.defineProperty(exports, "__esModule", { value: true });


	/**
	 * Registers keyframe definitions.
	 *
	 * @public
	 */
	function keyframes(timeline) {
	    var stylesheet = Stylesheet_1.Stylesheet.getInstance();
	    var name = stylesheet.getClassName();
	    var rulesArray = [];
	    for (var prop in timeline) {
	        if (timeline.hasOwnProperty(prop)) {
	            rulesArray.push(prop, '{', styleToClassName_1.serializeRuleEntries(timeline[prop]), '}');
	        }
	    }
	    var rules = rulesArray.join('');
	    stylesheet.insertRule("@keyframes " + name + "{" + rules + "}");
	    stylesheet.cacheClassName(name, rules, [], ['keyframes', rules]);
	    return name;
	}
	exports.keyframes = keyframes;

	});

	unwrapExports(keyframes_1);
	var keyframes_2 = keyframes_1.keyframes;

	var lib = createCommonjsModule(function (module, exports) {
	Object.defineProperty(exports, "__esModule", { value: true });

	exports.mergeStyles = mergeStyles_1.mergeStyles;

	exports.mergeStyleSets = mergeStyleSets_1.mergeStyleSets;

	exports.concatStyleSets = concatStyleSets_1.concatStyleSets;

	exports.fontFace = fontFace_1.fontFace;

	exports.keyframes = keyframes_1.keyframes;

	exports.InjectionMode = Stylesheet_1.InjectionMode;
	exports.Stylesheet = Stylesheet_1.Stylesheet;

	});

	unwrapExports(lib);
	var lib_1 = lib.mergeStyles;
	var lib_2 = lib.mergeStyleSets;
	var lib_3 = lib.concatStyleSets;
	var lib_4 = lib.fontFace;
	var lib_5 = lib.keyframes;
	var lib_6 = lib.InjectionMode;
	var lib_7 = lib.Stylesheet;

	var moment = createCommonjsModule(function (module, exports) {
	(function (global, factory) {
	    module.exports = factory();
	}(commonjsGlobal, (function () {
	    var hookCallback;

	    function hooks () {
	        return hookCallback.apply(null, arguments);
	    }

	    // This is done to register the method called with moment()
	    // without creating circular dependencies.
	    function setHookCallback (callback) {
	        hookCallback = callback;
	    }

	    function isArray(input) {
	        return input instanceof Array || Object.prototype.toString.call(input) === '[object Array]';
	    }

	    function isObject(input) {
	        // IE8 will treat undefined and null as object if it wasn't for
	        // input != null
	        return input != null && Object.prototype.toString.call(input) === '[object Object]';
	    }

	    function isObjectEmpty(obj) {
	        if (Object.getOwnPropertyNames) {
	            return (Object.getOwnPropertyNames(obj).length === 0);
	        } else {
	            var k;
	            for (k in obj) {
	                if (obj.hasOwnProperty(k)) {
	                    return false;
	                }
	            }
	            return true;
	        }
	    }

	    function isUndefined(input) {
	        return input === void 0;
	    }

	    function isNumber(input) {
	        return typeof input === 'number' || Object.prototype.toString.call(input) === '[object Number]';
	    }

	    function isDate(input) {
	        return input instanceof Date || Object.prototype.toString.call(input) === '[object Date]';
	    }

	    function map(arr, fn) {
	        var res = [], i;
	        for (i = 0; i < arr.length; ++i) {
	            res.push(fn(arr[i], i));
	        }
	        return res;
	    }

	    function hasOwnProp(a, b) {
	        return Object.prototype.hasOwnProperty.call(a, b);
	    }

	    function extend(a, b) {
	        for (var i in b) {
	            if (hasOwnProp(b, i)) {
	                a[i] = b[i];
	            }
	        }

	        if (hasOwnProp(b, 'toString')) {
	            a.toString = b.toString;
	        }

	        if (hasOwnProp(b, 'valueOf')) {
	            a.valueOf = b.valueOf;
	        }

	        return a;
	    }

	    function createUTC (input, format, locale, strict) {
	        return createLocalOrUTC(input, format, locale, strict, true).utc();
	    }

	    function defaultParsingFlags() {
	        // We need to deep clone this object.
	        return {
	            empty           : false,
	            unusedTokens    : [],
	            unusedInput     : [],
	            overflow        : -2,
	            charsLeftOver   : 0,
	            nullInput       : false,
	            invalidMonth    : null,
	            invalidFormat   : false,
	            userInvalidated : false,
	            iso             : false,
	            parsedDateParts : [],
	            meridiem        : null,
	            rfc2822         : false,
	            weekdayMismatch : false
	        };
	    }

	    function getParsingFlags(m) {
	        if (m._pf == null) {
	            m._pf = defaultParsingFlags();
	        }
	        return m._pf;
	    }

	    var some;
	    if (Array.prototype.some) {
	        some = Array.prototype.some;
	    } else {
	        some = function (fun) {
	            var t = Object(this);
	            var len = t.length >>> 0;

	            for (var i = 0; i < len; i++) {
	                if (i in t && fun.call(this, t[i], i, t)) {
	                    return true;
	                }
	            }

	            return false;
	        };
	    }

	    function isValid(m) {
	        if (m._isValid == null) {
	            var flags = getParsingFlags(m);
	            var parsedParts = some.call(flags.parsedDateParts, function (i) {
	                return i != null;
	            });
	            var isNowValid = !isNaN(m._d.getTime()) &&
	                flags.overflow < 0 &&
	                !flags.empty &&
	                !flags.invalidMonth &&
	                !flags.invalidWeekday &&
	                !flags.weekdayMismatch &&
	                !flags.nullInput &&
	                !flags.invalidFormat &&
	                !flags.userInvalidated &&
	                (!flags.meridiem || (flags.meridiem && parsedParts));

	            if (m._strict) {
	                isNowValid = isNowValid &&
	                    flags.charsLeftOver === 0 &&
	                    flags.unusedTokens.length === 0 &&
	                    flags.bigHour === undefined;
	            }

	            if (Object.isFrozen == null || !Object.isFrozen(m)) {
	                m._isValid = isNowValid;
	            }
	            else {
	                return isNowValid;
	            }
	        }
	        return m._isValid;
	    }

	    function createInvalid (flags) {
	        var m = createUTC(NaN);
	        if (flags != null) {
	            extend(getParsingFlags(m), flags);
	        }
	        else {
	            getParsingFlags(m).userInvalidated = true;
	        }

	        return m;
	    }

	    // Plugins that add properties should also add the key here (null value),
	    // so we can properly clone ourselves.
	    var momentProperties = hooks.momentProperties = [];

	    function copyConfig(to, from) {
	        var i, prop, val;

	        if (!isUndefined(from._isAMomentObject)) {
	            to._isAMomentObject = from._isAMomentObject;
	        }
	        if (!isUndefined(from._i)) {
	            to._i = from._i;
	        }
	        if (!isUndefined(from._f)) {
	            to._f = from._f;
	        }
	        if (!isUndefined(from._l)) {
	            to._l = from._l;
	        }
	        if (!isUndefined(from._strict)) {
	            to._strict = from._strict;
	        }
	        if (!isUndefined(from._tzm)) {
	            to._tzm = from._tzm;
	        }
	        if (!isUndefined(from._isUTC)) {
	            to._isUTC = from._isUTC;
	        }
	        if (!isUndefined(from._offset)) {
	            to._offset = from._offset;
	        }
	        if (!isUndefined(from._pf)) {
	            to._pf = getParsingFlags(from);
	        }
	        if (!isUndefined(from._locale)) {
	            to._locale = from._locale;
	        }

	        if (momentProperties.length > 0) {
	            for (i = 0; i < momentProperties.length; i++) {
	                prop = momentProperties[i];
	                val = from[prop];
	                if (!isUndefined(val)) {
	                    to[prop] = val;
	                }
	            }
	        }

	        return to;
	    }

	    var updateInProgress = false;

	    // Moment prototype object
	    function Moment(config) {
	        copyConfig(this, config);
	        this._d = new Date(config._d != null ? config._d.getTime() : NaN);
	        if (!this.isValid()) {
	            this._d = new Date(NaN);
	        }
	        // Prevent infinite loop in case updateOffset creates new moment
	        // objects.
	        if (updateInProgress === false) {
	            updateInProgress = true;
	            hooks.updateOffset(this);
	            updateInProgress = false;
	        }
	    }

	    function isMoment (obj) {
	        return obj instanceof Moment || (obj != null && obj._isAMomentObject != null);
	    }

	    function absFloor (number) {
	        if (number < 0) {
	            // -0 -> 0
	            return Math.ceil(number) || 0;
	        } else {
	            return Math.floor(number);
	        }
	    }

	    function toInt(argumentForCoercion) {
	        var coercedNumber = +argumentForCoercion,
	            value = 0;

	        if (coercedNumber !== 0 && isFinite(coercedNumber)) {
	            value = absFloor(coercedNumber);
	        }

	        return value;
	    }

	    // compare two arrays, return the number of differences
	    function compareArrays(array1, array2, dontConvert) {
	        var len = Math.min(array1.length, array2.length),
	            lengthDiff = Math.abs(array1.length - array2.length),
	            diffs = 0,
	            i;
	        for (i = 0; i < len; i++) {
	            if ((dontConvert && array1[i] !== array2[i]) ||
	                (!dontConvert && toInt(array1[i]) !== toInt(array2[i]))) {
	                diffs++;
	            }
	        }
	        return diffs + lengthDiff;
	    }

	    function warn(msg) {
	        if (hooks.suppressDeprecationWarnings === false &&
	                (typeof console !==  'undefined') && console.warn) {
	            console.warn('Deprecation warning: ' + msg);
	        }
	    }

	    function deprecate(msg, fn) {
	        var firstTime = true;

	        return extend(function () {
	            if (hooks.deprecationHandler != null) {
	                hooks.deprecationHandler(null, msg);
	            }
	            if (firstTime) {
	                var args = [];
	                var arg;
	                for (var i = 0; i < arguments.length; i++) {
	                    arg = '';
	                    if (typeof arguments[i] === 'object') {
	                        arg += '\n[' + i + '] ';
	                        for (var key in arguments[0]) {
	                            arg += key + ': ' + arguments[0][key] + ', ';
	                        }
	                        arg = arg.slice(0, -2); // Remove trailing comma and space
	                    } else {
	                        arg = arguments[i];
	                    }
	                    args.push(arg);
	                }
	                warn(msg + '\nArguments: ' + Array.prototype.slice.call(args).join('') + '\n' + (new Error()).stack);
	                firstTime = false;
	            }
	            return fn.apply(this, arguments);
	        }, fn);
	    }

	    var deprecations = {};

	    function deprecateSimple(name, msg) {
	        if (hooks.deprecationHandler != null) {
	            hooks.deprecationHandler(name, msg);
	        }
	        if (!deprecations[name]) {
	            warn(msg);
	            deprecations[name] = true;
	        }
	    }

	    hooks.suppressDeprecationWarnings = false;
	    hooks.deprecationHandler = null;

	    function isFunction(input) {
	        return input instanceof Function || Object.prototype.toString.call(input) === '[object Function]';
	    }

	    function set (config) {
	        var prop, i;
	        for (i in config) {
	            prop = config[i];
	            if (isFunction(prop)) {
	                this[i] = prop;
	            } else {
	                this['_' + i] = prop;
	            }
	        }
	        this._config = config;
	        // Lenient ordinal parsing accepts just a number in addition to
	        // number + (possibly) stuff coming from _dayOfMonthOrdinalParse.
	        // TODO: Remove "ordinalParse" fallback in next major release.
	        this._dayOfMonthOrdinalParseLenient = new RegExp(
	            (this._dayOfMonthOrdinalParse.source || this._ordinalParse.source) +
	                '|' + (/\d{1,2}/).source);
	    }

	    function mergeConfigs(parentConfig, childConfig) {
	        var res = extend({}, parentConfig), prop;
	        for (prop in childConfig) {
	            if (hasOwnProp(childConfig, prop)) {
	                if (isObject(parentConfig[prop]) && isObject(childConfig[prop])) {
	                    res[prop] = {};
	                    extend(res[prop], parentConfig[prop]);
	                    extend(res[prop], childConfig[prop]);
	                } else if (childConfig[prop] != null) {
	                    res[prop] = childConfig[prop];
	                } else {
	                    delete res[prop];
	                }
	            }
	        }
	        for (prop in parentConfig) {
	            if (hasOwnProp(parentConfig, prop) &&
	                    !hasOwnProp(childConfig, prop) &&
	                    isObject(parentConfig[prop])) {
	                // make sure changes to properties don't modify parent config
	                res[prop] = extend({}, res[prop]);
	            }
	        }
	        return res;
	    }

	    function Locale(config) {
	        if (config != null) {
	            this.set(config);
	        }
	    }

	    var keys;

	    if (Object.keys) {
	        keys = Object.keys;
	    } else {
	        keys = function (obj) {
	            var i, res = [];
	            for (i in obj) {
	                if (hasOwnProp(obj, i)) {
	                    res.push(i);
	                }
	            }
	            return res;
	        };
	    }

	    var defaultCalendar = {
	        sameDay : '[Today at] LT',
	        nextDay : '[Tomorrow at] LT',
	        nextWeek : 'dddd [at] LT',
	        lastDay : '[Yesterday at] LT',
	        lastWeek : '[Last] dddd [at] LT',
	        sameElse : 'L'
	    };

	    function calendar (key, mom, now) {
	        var output = this._calendar[key] || this._calendar['sameElse'];
	        return isFunction(output) ? output.call(mom, now) : output;
	    }

	    var defaultLongDateFormat = {
	        LTS  : 'h:mm:ss A',
	        LT   : 'h:mm A',
	        L    : 'MM/DD/YYYY',
	        LL   : 'MMMM D, YYYY',
	        LLL  : 'MMMM D, YYYY h:mm A',
	        LLLL : 'dddd, MMMM D, YYYY h:mm A'
	    };

	    function longDateFormat (key) {
	        var format = this._longDateFormat[key],
	            formatUpper = this._longDateFormat[key.toUpperCase()];

	        if (format || !formatUpper) {
	            return format;
	        }

	        this._longDateFormat[key] = formatUpper.replace(/MMMM|MM|DD|dddd/g, function (val) {
	            return val.slice(1);
	        });

	        return this._longDateFormat[key];
	    }

	    var defaultInvalidDate = 'Invalid date';

	    function invalidDate () {
	        return this._invalidDate;
	    }

	    var defaultOrdinal = '%d';
	    var defaultDayOfMonthOrdinalParse = /\d{1,2}/;

	    function ordinal (number) {
	        return this._ordinal.replace('%d', number);
	    }

	    var defaultRelativeTime = {
	        future : 'in %s',
	        past   : '%s ago',
	        s  : 'a few seconds',
	        ss : '%d seconds',
	        m  : 'a minute',
	        mm : '%d minutes',
	        h  : 'an hour',
	        hh : '%d hours',
	        d  : 'a day',
	        dd : '%d days',
	        M  : 'a month',
	        MM : '%d months',
	        y  : 'a year',
	        yy : '%d years'
	    };

	    function relativeTime (number, withoutSuffix, string, isFuture) {
	        var output = this._relativeTime[string];
	        return (isFunction(output)) ?
	            output(number, withoutSuffix, string, isFuture) :
	            output.replace(/%d/i, number);
	    }

	    function pastFuture (diff, output) {
	        var format = this._relativeTime[diff > 0 ? 'future' : 'past'];
	        return isFunction(format) ? format(output) : format.replace(/%s/i, output);
	    }

	    var aliases = {};

	    function addUnitAlias (unit, shorthand) {
	        var lowerCase = unit.toLowerCase();
	        aliases[lowerCase] = aliases[lowerCase + 's'] = aliases[shorthand] = unit;
	    }

	    function normalizeUnits(units) {
	        return typeof units === 'string' ? aliases[units] || aliases[units.toLowerCase()] : undefined;
	    }

	    function normalizeObjectUnits(inputObject) {
	        var normalizedInput = {},
	            normalizedProp,
	            prop;

	        for (prop in inputObject) {
	            if (hasOwnProp(inputObject, prop)) {
	                normalizedProp = normalizeUnits(prop);
	                if (normalizedProp) {
	                    normalizedInput[normalizedProp] = inputObject[prop];
	                }
	            }
	        }

	        return normalizedInput;
	    }

	    var priorities = {};

	    function addUnitPriority(unit, priority) {
	        priorities[unit] = priority;
	    }

	    function getPrioritizedUnits(unitsObj) {
	        var units = [];
	        for (var u in unitsObj) {
	            units.push({unit: u, priority: priorities[u]});
	        }
	        units.sort(function (a, b) {
	            return a.priority - b.priority;
	        });
	        return units;
	    }

	    function zeroFill(number, targetLength, forceSign) {
	        var absNumber = '' + Math.abs(number),
	            zerosToFill = targetLength - absNumber.length,
	            sign = number >= 0;
	        return (sign ? (forceSign ? '+' : '') : '-') +
	            Math.pow(10, Math.max(0, zerosToFill)).toString().substr(1) + absNumber;
	    }

	    var formattingTokens = /(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g;

	    var localFormattingTokens = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g;

	    var formatFunctions = {};

	    var formatTokenFunctions = {};

	    // token:    'M'
	    // padded:   ['MM', 2]
	    // ordinal:  'Mo'
	    // callback: function () { this.month() + 1 }
	    function addFormatToken (token, padded, ordinal, callback) {
	        var func = callback;
	        if (typeof callback === 'string') {
	            func = function () {
	                return this[callback]();
	            };
	        }
	        if (token) {
	            formatTokenFunctions[token] = func;
	        }
	        if (padded) {
	            formatTokenFunctions[padded[0]] = function () {
	                return zeroFill(func.apply(this, arguments), padded[1], padded[2]);
	            };
	        }
	        if (ordinal) {
	            formatTokenFunctions[ordinal] = function () {
	                return this.localeData().ordinal(func.apply(this, arguments), token);
	            };
	        }
	    }

	    function removeFormattingTokens(input) {
	        if (input.match(/\[[\s\S]/)) {
	            return input.replace(/^\[|\]$/g, '');
	        }
	        return input.replace(/\\/g, '');
	    }

	    function makeFormatFunction(format) {
	        var array = format.match(formattingTokens), i, length;

	        for (i = 0, length = array.length; i < length; i++) {
	            if (formatTokenFunctions[array[i]]) {
	                array[i] = formatTokenFunctions[array[i]];
	            } else {
	                array[i] = removeFormattingTokens(array[i]);
	            }
	        }

	        return function (mom) {
	            var output = '', i;
	            for (i = 0; i < length; i++) {
	                output += isFunction(array[i]) ? array[i].call(mom, format) : array[i];
	            }
	            return output;
	        };
	    }

	    // format date using native date object
	    function formatMoment(m, format) {
	        if (!m.isValid()) {
	            return m.localeData().invalidDate();
	        }

	        format = expandFormat(format, m.localeData());
	        formatFunctions[format] = formatFunctions[format] || makeFormatFunction(format);

	        return formatFunctions[format](m);
	    }

	    function expandFormat(format, locale) {
	        var i = 5;

	        function replaceLongDateFormatTokens(input) {
	            return locale.longDateFormat(input) || input;
	        }

	        localFormattingTokens.lastIndex = 0;
	        while (i >= 0 && localFormattingTokens.test(format)) {
	            format = format.replace(localFormattingTokens, replaceLongDateFormatTokens);
	            localFormattingTokens.lastIndex = 0;
	            i -= 1;
	        }

	        return format;
	    }

	    var match1         = /\d/;            //       0 - 9
	    var match2         = /\d\d/;          //      00 - 99
	    var match3         = /\d{3}/;         //     000 - 999
	    var match4         = /\d{4}/;         //    0000 - 9999
	    var match6         = /[+-]?\d{6}/;    // -999999 - 999999
	    var match1to2      = /\d\d?/;         //       0 - 99
	    var match3to4      = /\d\d\d\d?/;     //     999 - 9999
	    var match5to6      = /\d\d\d\d\d\d?/; //   99999 - 999999
	    var match1to3      = /\d{1,3}/;       //       0 - 999
	    var match1to4      = /\d{1,4}/;       //       0 - 9999
	    var match1to6      = /[+-]?\d{1,6}/;  // -999999 - 999999

	    var matchUnsigned  = /\d+/;           //       0 - inf
	    var matchSigned    = /[+-]?\d+/;      //    -inf - inf

	    var matchOffset    = /Z|[+-]\d\d:?\d\d/gi; // +00:00 -00:00 +0000 -0000 or Z
	    var matchShortOffset = /Z|[+-]\d\d(?::?\d\d)?/gi; // +00 -00 +00:00 -00:00 +0000 -0000 or Z

	    var matchTimestamp = /[+-]?\d+(\.\d{1,3})?/; // 123456789 123456789.123

	    // any word (or two) characters or numbers including two/three word month in arabic.
	    // includes scottish gaelic two word and hyphenated months
	    var matchWord = /[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i;

	    var regexes = {};

	    function addRegexToken (token, regex, strictRegex) {
	        regexes[token] = isFunction(regex) ? regex : function (isStrict, localeData) {
	            return (isStrict && strictRegex) ? strictRegex : regex;
	        };
	    }

	    function getParseRegexForToken (token, config) {
	        if (!hasOwnProp(regexes, token)) {
	            return new RegExp(unescapeFormat(token));
	        }

	        return regexes[token](config._strict, config._locale);
	    }

	    // Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript
	    function unescapeFormat(s) {
	        return regexEscape(s.replace('\\', '').replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g, function (matched, p1, p2, p3, p4) {
	            return p1 || p2 || p3 || p4;
	        }));
	    }

	    function regexEscape(s) {
	        return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
	    }

	    var tokens = {};

	    function addParseToken (token, callback) {
	        var i, func = callback;
	        if (typeof token === 'string') {
	            token = [token];
	        }
	        if (isNumber(callback)) {
	            func = function (input, array) {
	                array[callback] = toInt(input);
	            };
	        }
	        for (i = 0; i < token.length; i++) {
	            tokens[token[i]] = func;
	        }
	    }

	    function addWeekParseToken (token, callback) {
	        addParseToken(token, function (input, array, config, token) {
	            config._w = config._w || {};
	            callback(input, config._w, config, token);
	        });
	    }

	    function addTimeToArrayFromToken(token, input, config) {
	        if (input != null && hasOwnProp(tokens, token)) {
	            tokens[token](input, config._a, config, token);
	        }
	    }

	    var YEAR = 0;
	    var MONTH = 1;
	    var DATE = 2;
	    var HOUR = 3;
	    var MINUTE = 4;
	    var SECOND = 5;
	    var MILLISECOND = 6;
	    var WEEK = 7;
	    var WEEKDAY = 8;

	    // FORMATTING

	    addFormatToken('Y', 0, 0, function () {
	        var y = this.year();
	        return y <= 9999 ? '' + y : '+' + y;
	    });

	    addFormatToken(0, ['YY', 2], 0, function () {
	        return this.year() % 100;
	    });

	    addFormatToken(0, ['YYYY',   4],       0, 'year');
	    addFormatToken(0, ['YYYYY',  5],       0, 'year');
	    addFormatToken(0, ['YYYYYY', 6, true], 0, 'year');

	    // ALIASES

	    addUnitAlias('year', 'y');

	    // PRIORITIES

	    addUnitPriority('year', 1);

	    // PARSING

	    addRegexToken('Y',      matchSigned);
	    addRegexToken('YY',     match1to2, match2);
	    addRegexToken('YYYY',   match1to4, match4);
	    addRegexToken('YYYYY',  match1to6, match6);
	    addRegexToken('YYYYYY', match1to6, match6);

	    addParseToken(['YYYYY', 'YYYYYY'], YEAR);
	    addParseToken('YYYY', function (input, array) {
	        array[YEAR] = input.length === 2 ? hooks.parseTwoDigitYear(input) : toInt(input);
	    });
	    addParseToken('YY', function (input, array) {
	        array[YEAR] = hooks.parseTwoDigitYear(input);
	    });
	    addParseToken('Y', function (input, array) {
	        array[YEAR] = parseInt(input, 10);
	    });

	    // HELPERS

	    function daysInYear(year) {
	        return isLeapYear(year) ? 366 : 365;
	    }

	    function isLeapYear(year) {
	        return (year % 4 === 0 && year % 100 !== 0) || year % 400 === 0;
	    }

	    // HOOKS

	    hooks.parseTwoDigitYear = function (input) {
	        return toInt(input) + (toInt(input) > 68 ? 1900 : 2000);
	    };

	    // MOMENTS

	    var getSetYear = makeGetSet('FullYear', true);

	    function getIsLeapYear () {
	        return isLeapYear(this.year());
	    }

	    function makeGetSet (unit, keepTime) {
	        return function (value) {
	            if (value != null) {
	                set$1(this, unit, value);
	                hooks.updateOffset(this, keepTime);
	                return this;
	            } else {
	                return get(this, unit);
	            }
	        };
	    }

	    function get (mom, unit) {
	        return mom.isValid() ?
	            mom._d['get' + (mom._isUTC ? 'UTC' : '') + unit]() : NaN;
	    }

	    function set$1 (mom, unit, value) {
	        if (mom.isValid() && !isNaN(value)) {
	            if (unit === 'FullYear' && isLeapYear(mom.year()) && mom.month() === 1 && mom.date() === 29) {
	                mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value, mom.month(), daysInMonth(value, mom.month()));
	            }
	            else {
	                mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value);
	            }
	        }
	    }

	    // MOMENTS

	    function stringGet (units) {
	        units = normalizeUnits(units);
	        if (isFunction(this[units])) {
	            return this[units]();
	        }
	        return this;
	    }


	    function stringSet (units, value) {
	        if (typeof units === 'object') {
	            units = normalizeObjectUnits(units);
	            var prioritized = getPrioritizedUnits(units);
	            for (var i = 0; i < prioritized.length; i++) {
	                this[prioritized[i].unit](units[prioritized[i].unit]);
	            }
	        } else {
	            units = normalizeUnits(units);
	            if (isFunction(this[units])) {
	                return this[units](value);
	            }
	        }
	        return this;
	    }

	    function mod(n, x) {
	        return ((n % x) + x) % x;
	    }

	    var indexOf;

	    if (Array.prototype.indexOf) {
	        indexOf = Array.prototype.indexOf;
	    } else {
	        indexOf = function (o) {
	            // I know
	            var i;
	            for (i = 0; i < this.length; ++i) {
	                if (this[i] === o) {
	                    return i;
	                }
	            }
	            return -1;
	        };
	    }

	    function daysInMonth(year, month) {
	        if (isNaN(year) || isNaN(month)) {
	            return NaN;
	        }
	        var modMonth = mod(month, 12);
	        year += (month - modMonth) / 12;
	        return modMonth === 1 ? (isLeapYear(year) ? 29 : 28) : (31 - modMonth % 7 % 2);
	    }

	    // FORMATTING

	    addFormatToken('M', ['MM', 2], 'Mo', function () {
	        return this.month() + 1;
	    });

	    addFormatToken('MMM', 0, 0, function (format) {
	        return this.localeData().monthsShort(this, format);
	    });

	    addFormatToken('MMMM', 0, 0, function (format) {
	        return this.localeData().months(this, format);
	    });

	    // ALIASES

	    addUnitAlias('month', 'M');

	    // PRIORITY

	    addUnitPriority('month', 8);

	    // PARSING

	    addRegexToken('M',    match1to2);
	    addRegexToken('MM',   match1to2, match2);
	    addRegexToken('MMM',  function (isStrict, locale) {
	        return locale.monthsShortRegex(isStrict);
	    });
	    addRegexToken('MMMM', function (isStrict, locale) {
	        return locale.monthsRegex(isStrict);
	    });

	    addParseToken(['M', 'MM'], function (input, array) {
	        array[MONTH] = toInt(input) - 1;
	    });

	    addParseToken(['MMM', 'MMMM'], function (input, array, config, token) {
	        var month = config._locale.monthsParse(input, token, config._strict);
	        // if we didn't find a month name, mark the date as invalid.
	        if (month != null) {
	            array[MONTH] = month;
	        } else {
	            getParsingFlags(config).invalidMonth = input;
	        }
	    });

	    // LOCALES

	    var MONTHS_IN_FORMAT = /D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/;
	    var defaultLocaleMonths = 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_');
	    function localeMonths (m, format) {
	        if (!m) {
	            return isArray(this._months) ? this._months :
	                this._months['standalone'];
	        }
	        return isArray(this._months) ? this._months[m.month()] :
	            this._months[(this._months.isFormat || MONTHS_IN_FORMAT).test(format) ? 'format' : 'standalone'][m.month()];
	    }

	    var defaultLocaleMonthsShort = 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_');
	    function localeMonthsShort (m, format) {
	        if (!m) {
	            return isArray(this._monthsShort) ? this._monthsShort :
	                this._monthsShort['standalone'];
	        }
	        return isArray(this._monthsShort) ? this._monthsShort[m.month()] :
	            this._monthsShort[MONTHS_IN_FORMAT.test(format) ? 'format' : 'standalone'][m.month()];
	    }

	    function handleStrictParse(monthName, format, strict) {
	        var i, ii, mom, llc = monthName.toLocaleLowerCase();
	        if (!this._monthsParse) {
	            // this is not used
	            this._monthsParse = [];
	            this._longMonthsParse = [];
	            this._shortMonthsParse = [];
	            for (i = 0; i < 12; ++i) {
	                mom = createUTC([2000, i]);
	                this._shortMonthsParse[i] = this.monthsShort(mom, '').toLocaleLowerCase();
	                this._longMonthsParse[i] = this.months(mom, '').toLocaleLowerCase();
	            }
	        }

	        if (strict) {
	            if (format === 'MMM') {
	                ii = indexOf.call(this._shortMonthsParse, llc);
	                return ii !== -1 ? ii : null;
	            } else {
	                ii = indexOf.call(this._longMonthsParse, llc);
	                return ii !== -1 ? ii : null;
	            }
	        } else {
	            if (format === 'MMM') {
	                ii = indexOf.call(this._shortMonthsParse, llc);
	                if (ii !== -1) {
	                    return ii;
	                }
	                ii = indexOf.call(this._longMonthsParse, llc);
	                return ii !== -1 ? ii : null;
	            } else {
	                ii = indexOf.call(this._longMonthsParse, llc);
	                if (ii !== -1) {
	                    return ii;
	                }
	                ii = indexOf.call(this._shortMonthsParse, llc);
	                return ii !== -1 ? ii : null;
	            }
	        }
	    }

	    function localeMonthsParse (monthName, format, strict) {
	        var i, mom, regex;

	        if (this._monthsParseExact) {
	            return handleStrictParse.call(this, monthName, format, strict);
	        }

	        if (!this._monthsParse) {
	            this._monthsParse = [];
	            this._longMonthsParse = [];
	            this._shortMonthsParse = [];
	        }

	        // TODO: add sorting
	        // Sorting makes sure if one month (or abbr) is a prefix of another
	        // see sorting in computeMonthsParse
	        for (i = 0; i < 12; i++) {
	            // make the regex if we don't have it already
	            mom = createUTC([2000, i]);
	            if (strict && !this._longMonthsParse[i]) {
	                this._longMonthsParse[i] = new RegExp('^' + this.months(mom, '').replace('.', '') + '$', 'i');
	                this._shortMonthsParse[i] = new RegExp('^' + this.monthsShort(mom, '').replace('.', '') + '$', 'i');
	            }
	            if (!strict && !this._monthsParse[i]) {
	                regex = '^' + this.months(mom, '') + '|^' + this.monthsShort(mom, '');
	                this._monthsParse[i] = new RegExp(regex.replace('.', ''), 'i');
	            }
	            // test the regex
	            if (strict && format === 'MMMM' && this._longMonthsParse[i].test(monthName)) {
	                return i;
	            } else if (strict && format === 'MMM' && this._shortMonthsParse[i].test(monthName)) {
	                return i;
	            } else if (!strict && this._monthsParse[i].test(monthName)) {
	                return i;
	            }
	        }
	    }

	    // MOMENTS

	    function setMonth (mom, value) {
	        var dayOfMonth;

	        if (!mom.isValid()) {
	            // No op
	            return mom;
	        }

	        if (typeof value === 'string') {
	            if (/^\d+$/.test(value)) {
	                value = toInt(value);
	            } else {
	                value = mom.localeData().monthsParse(value);
	                // TODO: Another silent failure?
	                if (!isNumber(value)) {
	                    return mom;
	                }
	            }
	        }

	        dayOfMonth = Math.min(mom.date(), daysInMonth(mom.year(), value));
	        mom._d['set' + (mom._isUTC ? 'UTC' : '') + 'Month'](value, dayOfMonth);
	        return mom;
	    }

	    function getSetMonth (value) {
	        if (value != null) {
	            setMonth(this, value);
	            hooks.updateOffset(this, true);
	            return this;
	        } else {
	            return get(this, 'Month');
	        }
	    }

	    function getDaysInMonth () {
	        return daysInMonth(this.year(), this.month());
	    }

	    var defaultMonthsShortRegex = matchWord;
	    function monthsShortRegex (isStrict) {
	        if (this._monthsParseExact) {
	            if (!hasOwnProp(this, '_monthsRegex')) {
	                computeMonthsParse.call(this);
	            }
	            if (isStrict) {
	                return this._monthsShortStrictRegex;
	            } else {
	                return this._monthsShortRegex;
	            }
	        } else {
	            if (!hasOwnProp(this, '_monthsShortRegex')) {
	                this._monthsShortRegex = defaultMonthsShortRegex;
	            }
	            return this._monthsShortStrictRegex && isStrict ?
	                this._monthsShortStrictRegex : this._monthsShortRegex;
	        }
	    }

	    var defaultMonthsRegex = matchWord;
	    function monthsRegex (isStrict) {
	        if (this._monthsParseExact) {
	            if (!hasOwnProp(this, '_monthsRegex')) {
	                computeMonthsParse.call(this);
	            }
	            if (isStrict) {
	                return this._monthsStrictRegex;
	            } else {
	                return this._monthsRegex;
	            }
	        } else {
	            if (!hasOwnProp(this, '_monthsRegex')) {
	                this._monthsRegex = defaultMonthsRegex;
	            }
	            return this._monthsStrictRegex && isStrict ?
	                this._monthsStrictRegex : this._monthsRegex;
	        }
	    }

	    function computeMonthsParse () {
	        function cmpLenRev(a, b) {
	            return b.length - a.length;
	        }

	        var shortPieces = [], longPieces = [], mixedPieces = [],
	            i, mom;
	        for (i = 0; i < 12; i++) {
	            // make the regex if we don't have it already
	            mom = createUTC([2000, i]);
	            shortPieces.push(this.monthsShort(mom, ''));
	            longPieces.push(this.months(mom, ''));
	            mixedPieces.push(this.months(mom, ''));
	            mixedPieces.push(this.monthsShort(mom, ''));
	        }
	        // Sorting makes sure if one month (or abbr) is a prefix of another it
	        // will match the longer piece.
	        shortPieces.sort(cmpLenRev);
	        longPieces.sort(cmpLenRev);
	        mixedPieces.sort(cmpLenRev);
	        for (i = 0; i < 12; i++) {
	            shortPieces[i] = regexEscape(shortPieces[i]);
	            longPieces[i] = regexEscape(longPieces[i]);
	        }
	        for (i = 0; i < 24; i++) {
	            mixedPieces[i] = regexEscape(mixedPieces[i]);
	        }

	        this._monthsRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
	        this._monthsShortRegex = this._monthsRegex;
	        this._monthsStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
	        this._monthsShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
	    }

	    function createDate (y, m, d, h, M, s, ms) {
	        // can't just apply() to create a date:
	        // https://stackoverflow.com/q/181348
	        var date;
	        // the date constructor remaps years 0-99 to 1900-1999
	        if (y < 100 && y >= 0) {
	            // preserve leap years using a full 400 year cycle, then reset
	            date = new Date(y + 400, m, d, h, M, s, ms);
	            if (isFinite(date.getFullYear())) {
	                date.setFullYear(y);
	            }
	        } else {
	            date = new Date(y, m, d, h, M, s, ms);
	        }

	        return date;
	    }

	    function createUTCDate (y) {
	        var date;
	        // the Date.UTC function remaps years 0-99 to 1900-1999
	        if (y < 100 && y >= 0) {
	            var args = Array.prototype.slice.call(arguments);
	            // preserve leap years using a full 400 year cycle, then reset
	            args[0] = y + 400;
	            date = new Date(Date.UTC.apply(null, args));
	            if (isFinite(date.getUTCFullYear())) {
	                date.setUTCFullYear(y);
	            }
	        } else {
	            date = new Date(Date.UTC.apply(null, arguments));
	        }

	        return date;
	    }

	    // start-of-first-week - start-of-year
	    function firstWeekOffset(year, dow, doy) {
	        var // first-week day -- which january is always in the first week (4 for iso, 1 for other)
	            fwd = 7 + dow - doy,
	            // first-week day local weekday -- which local weekday is fwd
	            fwdlw = (7 + createUTCDate(year, 0, fwd).getUTCDay() - dow) % 7;

	        return -fwdlw + fwd - 1;
	    }

	    // https://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday
	    function dayOfYearFromWeeks(year, week, weekday, dow, doy) {
	        var localWeekday = (7 + weekday - dow) % 7,
	            weekOffset = firstWeekOffset(year, dow, doy),
	            dayOfYear = 1 + 7 * (week - 1) + localWeekday + weekOffset,
	            resYear, resDayOfYear;

	        if (dayOfYear <= 0) {
	            resYear = year - 1;
	            resDayOfYear = daysInYear(resYear) + dayOfYear;
	        } else if (dayOfYear > daysInYear(year)) {
	            resYear = year + 1;
	            resDayOfYear = dayOfYear - daysInYear(year);
	        } else {
	            resYear = year;
	            resDayOfYear = dayOfYear;
	        }

	        return {
	            year: resYear,
	            dayOfYear: resDayOfYear
	        };
	    }

	    function weekOfYear(mom, dow, doy) {
	        var weekOffset = firstWeekOffset(mom.year(), dow, doy),
	            week = Math.floor((mom.dayOfYear() - weekOffset - 1) / 7) + 1,
	            resWeek, resYear;

	        if (week < 1) {
	            resYear = mom.year() - 1;
	            resWeek = week + weeksInYear(resYear, dow, doy);
	        } else if (week > weeksInYear(mom.year(), dow, doy)) {
	            resWeek = week - weeksInYear(mom.year(), dow, doy);
	            resYear = mom.year() + 1;
	        } else {
	            resYear = mom.year();
	            resWeek = week;
	        }

	        return {
	            week: resWeek,
	            year: resYear
	        };
	    }

	    function weeksInYear(year, dow, doy) {
	        var weekOffset = firstWeekOffset(year, dow, doy),
	            weekOffsetNext = firstWeekOffset(year + 1, dow, doy);
	        return (daysInYear(year) - weekOffset + weekOffsetNext) / 7;
	    }

	    // FORMATTING

	    addFormatToken('w', ['ww', 2], 'wo', 'week');
	    addFormatToken('W', ['WW', 2], 'Wo', 'isoWeek');

	    // ALIASES

	    addUnitAlias('week', 'w');
	    addUnitAlias('isoWeek', 'W');

	    // PRIORITIES

	    addUnitPriority('week', 5);
	    addUnitPriority('isoWeek', 5);

	    // PARSING

	    addRegexToken('w',  match1to2);
	    addRegexToken('ww', match1to2, match2);
	    addRegexToken('W',  match1to2);
	    addRegexToken('WW', match1to2, match2);

	    addWeekParseToken(['w', 'ww', 'W', 'WW'], function (input, week, config, token) {
	        week[token.substr(0, 1)] = toInt(input);
	    });

	    // HELPERS

	    // LOCALES

	    function localeWeek (mom) {
	        return weekOfYear(mom, this._week.dow, this._week.doy).week;
	    }

	    var defaultLocaleWeek = {
	        dow : 0, // Sunday is the first day of the week.
	        doy : 6  // The week that contains Jan 6th is the first week of the year.
	    };

	    function localeFirstDayOfWeek () {
	        return this._week.dow;
	    }

	    function localeFirstDayOfYear () {
	        return this._week.doy;
	    }

	    // MOMENTS

	    function getSetWeek (input) {
	        var week = this.localeData().week(this);
	        return input == null ? week : this.add((input - week) * 7, 'd');
	    }

	    function getSetISOWeek (input) {
	        var week = weekOfYear(this, 1, 4).week;
	        return input == null ? week : this.add((input - week) * 7, 'd');
	    }

	    // FORMATTING

	    addFormatToken('d', 0, 'do', 'day');

	    addFormatToken('dd', 0, 0, function (format) {
	        return this.localeData().weekdaysMin(this, format);
	    });

	    addFormatToken('ddd', 0, 0, function (format) {
	        return this.localeData().weekdaysShort(this, format);
	    });

	    addFormatToken('dddd', 0, 0, function (format) {
	        return this.localeData().weekdays(this, format);
	    });

	    addFormatToken('e', 0, 0, 'weekday');
	    addFormatToken('E', 0, 0, 'isoWeekday');

	    // ALIASES

	    addUnitAlias('day', 'd');
	    addUnitAlias('weekday', 'e');
	    addUnitAlias('isoWeekday', 'E');

	    // PRIORITY
	    addUnitPriority('day', 11);
	    addUnitPriority('weekday', 11);
	    addUnitPriority('isoWeekday', 11);

	    // PARSING

	    addRegexToken('d',    match1to2);
	    addRegexToken('e',    match1to2);
	    addRegexToken('E',    match1to2);
	    addRegexToken('dd',   function (isStrict, locale) {
	        return locale.weekdaysMinRegex(isStrict);
	    });
	    addRegexToken('ddd',   function (isStrict, locale) {
	        return locale.weekdaysShortRegex(isStrict);
	    });
	    addRegexToken('dddd',   function (isStrict, locale) {
	        return locale.weekdaysRegex(isStrict);
	    });

	    addWeekParseToken(['dd', 'ddd', 'dddd'], function (input, week, config, token) {
	        var weekday = config._locale.weekdaysParse(input, token, config._strict);
	        // if we didn't get a weekday name, mark the date as invalid
	        if (weekday != null) {
	            week.d = weekday;
	        } else {
	            getParsingFlags(config).invalidWeekday = input;
	        }
	    });

	    addWeekParseToken(['d', 'e', 'E'], function (input, week, config, token) {
	        week[token] = toInt(input);
	    });

	    // HELPERS

	    function parseWeekday(input, locale) {
	        if (typeof input !== 'string') {
	            return input;
	        }

	        if (!isNaN(input)) {
	            return parseInt(input, 10);
	        }

	        input = locale.weekdaysParse(input);
	        if (typeof input === 'number') {
	            return input;
	        }

	        return null;
	    }

	    function parseIsoWeekday(input, locale) {
	        if (typeof input === 'string') {
	            return locale.weekdaysParse(input) % 7 || 7;
	        }
	        return isNaN(input) ? null : input;
	    }

	    // LOCALES
	    function shiftWeekdays (ws, n) {
	        return ws.slice(n, 7).concat(ws.slice(0, n));
	    }

	    var defaultLocaleWeekdays = 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_');
	    function localeWeekdays (m, format) {
	        var weekdays = isArray(this._weekdays) ? this._weekdays :
	            this._weekdays[(m && m !== true && this._weekdays.isFormat.test(format)) ? 'format' : 'standalone'];
	        return (m === true) ? shiftWeekdays(weekdays, this._week.dow)
	            : (m) ? weekdays[m.day()] : weekdays;
	    }

	    var defaultLocaleWeekdaysShort = 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_');
	    function localeWeekdaysShort (m) {
	        return (m === true) ? shiftWeekdays(this._weekdaysShort, this._week.dow)
	            : (m) ? this._weekdaysShort[m.day()] : this._weekdaysShort;
	    }

	    var defaultLocaleWeekdaysMin = 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_');
	    function localeWeekdaysMin (m) {
	        return (m === true) ? shiftWeekdays(this._weekdaysMin, this._week.dow)
	            : (m) ? this._weekdaysMin[m.day()] : this._weekdaysMin;
	    }

	    function handleStrictParse$1(weekdayName, format, strict) {
	        var i, ii, mom, llc = weekdayName.toLocaleLowerCase();
	        if (!this._weekdaysParse) {
	            this._weekdaysParse = [];
	            this._shortWeekdaysParse = [];
	            this._minWeekdaysParse = [];

	            for (i = 0; i < 7; ++i) {
	                mom = createUTC([2000, 1]).day(i);
	                this._minWeekdaysParse[i] = this.weekdaysMin(mom, '').toLocaleLowerCase();
	                this._shortWeekdaysParse[i] = this.weekdaysShort(mom, '').toLocaleLowerCase();
	                this._weekdaysParse[i] = this.weekdays(mom, '').toLocaleLowerCase();
	            }
	        }

	        if (strict) {
	            if (format === 'dddd') {
	                ii = indexOf.call(this._weekdaysParse, llc);
	                return ii !== -1 ? ii : null;
	            } else if (format === 'ddd') {
	                ii = indexOf.call(this._shortWeekdaysParse, llc);
	                return ii !== -1 ? ii : null;
	            } else {
	                ii = indexOf.call(this._minWeekdaysParse, llc);
	                return ii !== -1 ? ii : null;
	            }
	        } else {
	            if (format === 'dddd') {
	                ii = indexOf.call(this._weekdaysParse, llc);
	                if (ii !== -1) {
	                    return ii;
	                }
	                ii = indexOf.call(this._shortWeekdaysParse, llc);
	                if (ii !== -1) {
	                    return ii;
	                }
	                ii = indexOf.call(this._minWeekdaysParse, llc);
	                return ii !== -1 ? ii : null;
	            } else if (format === 'ddd') {
	                ii = indexOf.call(this._shortWeekdaysParse, llc);
	                if (ii !== -1) {
	                    return ii;
	                }
	                ii = indexOf.call(this._weekdaysParse, llc);
	                if (ii !== -1) {
	                    return ii;
	                }
	                ii = indexOf.call(this._minWeekdaysParse, llc);
	                return ii !== -1 ? ii : null;
	            } else {
	                ii = indexOf.call(this._minWeekdaysParse, llc);
	                if (ii !== -1) {
	                    return ii;
	                }
	                ii = indexOf.call(this._weekdaysParse, llc);
	                if (ii !== -1) {
	                    return ii;
	                }
	                ii = indexOf.call(this._shortWeekdaysParse, llc);
	                return ii !== -1 ? ii : null;
	            }
	        }
	    }

	    function localeWeekdaysParse (weekdayName, format, strict) {
	        var i, mom, regex;

	        if (this._weekdaysParseExact) {
	            return handleStrictParse$1.call(this, weekdayName, format, strict);
	        }

	        if (!this._weekdaysParse) {
	            this._weekdaysParse = [];
	            this._minWeekdaysParse = [];
	            this._shortWeekdaysParse = [];
	            this._fullWeekdaysParse = [];
	        }

	        for (i = 0; i < 7; i++) {
	            // make the regex if we don't have it already

	            mom = createUTC([2000, 1]).day(i);
	            if (strict && !this._fullWeekdaysParse[i]) {
	                this._fullWeekdaysParse[i] = new RegExp('^' + this.weekdays(mom, '').replace('.', '\\.?') + '$', 'i');
	                this._shortWeekdaysParse[i] = new RegExp('^' + this.weekdaysShort(mom, '').replace('.', '\\.?') + '$', 'i');
	                this._minWeekdaysParse[i] = new RegExp('^' + this.weekdaysMin(mom, '').replace('.', '\\.?') + '$', 'i');
	            }
	            if (!this._weekdaysParse[i]) {
	                regex = '^' + this.weekdays(mom, '') + '|^' + this.weekdaysShort(mom, '') + '|^' + this.weekdaysMin(mom, '');
	                this._weekdaysParse[i] = new RegExp(regex.replace('.', ''), 'i');
	            }
	            // test the regex
	            if (strict && format === 'dddd' && this._fullWeekdaysParse[i].test(weekdayName)) {
	                return i;
	            } else if (strict && format === 'ddd' && this._shortWeekdaysParse[i].test(weekdayName)) {
	                return i;
	            } else if (strict && format === 'dd' && this._minWeekdaysParse[i].test(weekdayName)) {
	                return i;
	            } else if (!strict && this._weekdaysParse[i].test(weekdayName)) {
	                return i;
	            }
	        }
	    }

	    // MOMENTS

	    function getSetDayOfWeek (input) {
	        if (!this.isValid()) {
	            return input != null ? this : NaN;
	        }
	        var day = this._isUTC ? this._d.getUTCDay() : this._d.getDay();
	        if (input != null) {
	            input = parseWeekday(input, this.localeData());
	            return this.add(input - day, 'd');
	        } else {
	            return day;
	        }
	    }

	    function getSetLocaleDayOfWeek (input) {
	        if (!this.isValid()) {
	            return input != null ? this : NaN;
	        }
	        var weekday = (this.day() + 7 - this.localeData()._week.dow) % 7;
	        return input == null ? weekday : this.add(input - weekday, 'd');
	    }

	    function getSetISODayOfWeek (input) {
	        if (!this.isValid()) {
	            return input != null ? this : NaN;
	        }

	        // behaves the same as moment#day except
	        // as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)
	        // as a setter, sunday should belong to the previous week.

	        if (input != null) {
	            var weekday = parseIsoWeekday(input, this.localeData());
	            return this.day(this.day() % 7 ? weekday : weekday - 7);
	        } else {
	            return this.day() || 7;
	        }
	    }

	    var defaultWeekdaysRegex = matchWord;
	    function weekdaysRegex (isStrict) {
	        if (this._weekdaysParseExact) {
	            if (!hasOwnProp(this, '_weekdaysRegex')) {
	                computeWeekdaysParse.call(this);
	            }
	            if (isStrict) {
	                return this._weekdaysStrictRegex;
	            } else {
	                return this._weekdaysRegex;
	            }
	        } else {
	            if (!hasOwnProp(this, '_weekdaysRegex')) {
	                this._weekdaysRegex = defaultWeekdaysRegex;
	            }
	            return this._weekdaysStrictRegex && isStrict ?
	                this._weekdaysStrictRegex : this._weekdaysRegex;
	        }
	    }

	    var defaultWeekdaysShortRegex = matchWord;
	    function weekdaysShortRegex (isStrict) {
	        if (this._weekdaysParseExact) {
	            if (!hasOwnProp(this, '_weekdaysRegex')) {
	                computeWeekdaysParse.call(this);
	            }
	            if (isStrict) {
	                return this._weekdaysShortStrictRegex;
	            } else {
	                return this._weekdaysShortRegex;
	            }
	        } else {
	            if (!hasOwnProp(this, '_weekdaysShortRegex')) {
	                this._weekdaysShortRegex = defaultWeekdaysShortRegex;
	            }
	            return this._weekdaysShortStrictRegex && isStrict ?
	                this._weekdaysShortStrictRegex : this._weekdaysShortRegex;
	        }
	    }

	    var defaultWeekdaysMinRegex = matchWord;
	    function weekdaysMinRegex (isStrict) {
	        if (this._weekdaysParseExact) {
	            if (!hasOwnProp(this, '_weekdaysRegex')) {
	                computeWeekdaysParse.call(this);
	            }
	            if (isStrict) {
	                return this._weekdaysMinStrictRegex;
	            } else {
	                return this._weekdaysMinRegex;
	            }
	        } else {
	            if (!hasOwnProp(this, '_weekdaysMinRegex')) {
	                this._weekdaysMinRegex = defaultWeekdaysMinRegex;
	            }
	            return this._weekdaysMinStrictRegex && isStrict ?
	                this._weekdaysMinStrictRegex : this._weekdaysMinRegex;
	        }
	    }


	    function computeWeekdaysParse () {
	        function cmpLenRev(a, b) {
	            return b.length - a.length;
	        }

	        var minPieces = [], shortPieces = [], longPieces = [], mixedPieces = [],
	            i, mom, minp, shortp, longp;
	        for (i = 0; i < 7; i++) {
	            // make the regex if we don't have it already
	            mom = createUTC([2000, 1]).day(i);
	            minp = this.weekdaysMin(mom, '');
	            shortp = this.weekdaysShort(mom, '');
	            longp = this.weekdays(mom, '');
	            minPieces.push(minp);
	            shortPieces.push(shortp);
	            longPieces.push(longp);
	            mixedPieces.push(minp);
	            mixedPieces.push(shortp);
	            mixedPieces.push(longp);
	        }
	        // Sorting makes sure if one weekday (or abbr) is a prefix of another it
	        // will match the longer piece.
	        minPieces.sort(cmpLenRev);
	        shortPieces.sort(cmpLenRev);
	        longPieces.sort(cmpLenRev);
	        mixedPieces.sort(cmpLenRev);
	        for (i = 0; i < 7; i++) {
	            shortPieces[i] = regexEscape(shortPieces[i]);
	            longPieces[i] = regexEscape(longPieces[i]);
	            mixedPieces[i] = regexEscape(mixedPieces[i]);
	        }

	        this._weekdaysRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
	        this._weekdaysShortRegex = this._weekdaysRegex;
	        this._weekdaysMinRegex = this._weekdaysRegex;

	        this._weekdaysStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
	        this._weekdaysShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
	        this._weekdaysMinStrictRegex = new RegExp('^(' + minPieces.join('|') + ')', 'i');
	    }

	    // FORMATTING

	    function hFormat() {
	        return this.hours() % 12 || 12;
	    }

	    function kFormat() {
	        return this.hours() || 24;
	    }

	    addFormatToken('H', ['HH', 2], 0, 'hour');
	    addFormatToken('h', ['hh', 2], 0, hFormat);
	    addFormatToken('k', ['kk', 2], 0, kFormat);

	    addFormatToken('hmm', 0, 0, function () {
	        return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2);
	    });

	    addFormatToken('hmmss', 0, 0, function () {
	        return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2) +
	            zeroFill(this.seconds(), 2);
	    });

	    addFormatToken('Hmm', 0, 0, function () {
	        return '' + this.hours() + zeroFill(this.minutes(), 2);
	    });

	    addFormatToken('Hmmss', 0, 0, function () {
	        return '' + this.hours() + zeroFill(this.minutes(), 2) +
	            zeroFill(this.seconds(), 2);
	    });

	    function meridiem (token, lowercase) {
	        addFormatToken(token, 0, 0, function () {
	            return this.localeData().meridiem(this.hours(), this.minutes(), lowercase);
	        });
	    }

	    meridiem('a', true);
	    meridiem('A', false);

	    // ALIASES

	    addUnitAlias('hour', 'h');

	    // PRIORITY
	    addUnitPriority('hour', 13);

	    // PARSING

	    function matchMeridiem (isStrict, locale) {
	        return locale._meridiemParse;
	    }

	    addRegexToken('a',  matchMeridiem);
	    addRegexToken('A',  matchMeridiem);
	    addRegexToken('H',  match1to2);
	    addRegexToken('h',  match1to2);
	    addRegexToken('k',  match1to2);
	    addRegexToken('HH', match1to2, match2);
	    addRegexToken('hh', match1to2, match2);
	    addRegexToken('kk', match1to2, match2);

	    addRegexToken('hmm', match3to4);
	    addRegexToken('hmmss', match5to6);
	    addRegexToken('Hmm', match3to4);
	    addRegexToken('Hmmss', match5to6);

	    addParseToken(['H', 'HH'], HOUR);
	    addParseToken(['k', 'kk'], function (input, array, config) {
	        var kInput = toInt(input);
	        array[HOUR] = kInput === 24 ? 0 : kInput;
	    });
	    addParseToken(['a', 'A'], function (input, array, config) {
	        config._isPm = config._locale.isPM(input);
	        config._meridiem = input;
	    });
	    addParseToken(['h', 'hh'], function (input, array, config) {
	        array[HOUR] = toInt(input);
	        getParsingFlags(config).bigHour = true;
	    });
	    addParseToken('hmm', function (input, array, config) {
	        var pos = input.length - 2;
	        array[HOUR] = toInt(input.substr(0, pos));
	        array[MINUTE] = toInt(input.substr(pos));
	        getParsingFlags(config).bigHour = true;
	    });
	    addParseToken('hmmss', function (input, array, config) {
	        var pos1 = input.length - 4;
	        var pos2 = input.length - 2;
	        array[HOUR] = toInt(input.substr(0, pos1));
	        array[MINUTE] = toInt(input.substr(pos1, 2));
	        array[SECOND] = toInt(input.substr(pos2));
	        getParsingFlags(config).bigHour = true;
	    });
	    addParseToken('Hmm', function (input, array, config) {
	        var pos = input.length - 2;
	        array[HOUR] = toInt(input.substr(0, pos));
	        array[MINUTE] = toInt(input.substr(pos));
	    });
	    addParseToken('Hmmss', function (input, array, config) {
	        var pos1 = input.length - 4;
	        var pos2 = input.length - 2;
	        array[HOUR] = toInt(input.substr(0, pos1));
	        array[MINUTE] = toInt(input.substr(pos1, 2));
	        array[SECOND] = toInt(input.substr(pos2));
	    });

	    // LOCALES

	    function localeIsPM (input) {
	        // IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays
	        // Using charAt should be more compatible.
	        return ((input + '').toLowerCase().charAt(0) === 'p');
	    }

	    var defaultLocaleMeridiemParse = /[ap]\.?m?\.?/i;
	    function localeMeridiem (hours, minutes, isLower) {
	        if (hours > 11) {
	            return isLower ? 'pm' : 'PM';
	        } else {
	            return isLower ? 'am' : 'AM';
	        }
	    }


	    // MOMENTS

	    // Setting the hour should keep the time, because the user explicitly
	    // specified which hour they want. So trying to maintain the same hour (in
	    // a new timezone) makes sense. Adding/subtracting hours does not follow
	    // this rule.
	    var getSetHour = makeGetSet('Hours', true);

	    var baseConfig = {
	        calendar: defaultCalendar,
	        longDateFormat: defaultLongDateFormat,
	        invalidDate: defaultInvalidDate,
	        ordinal: defaultOrdinal,
	        dayOfMonthOrdinalParse: defaultDayOfMonthOrdinalParse,
	        relativeTime: defaultRelativeTime,

	        months: defaultLocaleMonths,
	        monthsShort: defaultLocaleMonthsShort,

	        week: defaultLocaleWeek,

	        weekdays: defaultLocaleWeekdays,
	        weekdaysMin: defaultLocaleWeekdaysMin,
	        weekdaysShort: defaultLocaleWeekdaysShort,

	        meridiemParse: defaultLocaleMeridiemParse
	    };

	    // internal storage for locale config files
	    var locales = {};
	    var localeFamilies = {};
	    var globalLocale;

	    function normalizeLocale(key) {
	        return key ? key.toLowerCase().replace('_', '-') : key;
	    }

	    // pick the locale from the array
	    // try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each
	    // substring from most specific to least, but move to the next array item if it's a more specific variant than the current root
	    function chooseLocale(names) {
	        var i = 0, j, next, locale, split;

	        while (i < names.length) {
	            split = normalizeLocale(names[i]).split('-');
	            j = split.length;
	            next = normalizeLocale(names[i + 1]);
	            next = next ? next.split('-') : null;
	            while (j > 0) {
	                locale = loadLocale(split.slice(0, j).join('-'));
	                if (locale) {
	                    return locale;
	                }
	                if (next && next.length >= j && compareArrays(split, next, true) >= j - 1) {
	                    //the next array item is better than a shallower substring of this one
	                    break;
	                }
	                j--;
	            }
	            i++;
	        }
	        return globalLocale;
	    }

	    function loadLocale(name) {
	        var oldLocale = null;
	        // TODO: Find a better way to register and load all the locales in Node
	        if (!locales[name] && ('object' !== 'undefined') &&
	                module && module.exports) {
	            try {
	                oldLocale = globalLocale._abbr;
	                var aliasedRequire = commonjsRequire;
	                aliasedRequire('./locale/' + name);
	                getSetGlobalLocale(oldLocale);
	            } catch (e) {}
	        }
	        return locales[name];
	    }

	    // This function will load locale and then set the global locale.  If
	    // no arguments are passed in, it will simply return the current global
	    // locale key.
	    function getSetGlobalLocale (key, values) {
	        var data;
	        if (key) {
	            if (isUndefined(values)) {
	                data = getLocale(key);
	            }
	            else {
	                data = defineLocale(key, values);
	            }

	            if (data) {
	                // moment.duration._locale = moment._locale = data;
	                globalLocale = data;
	            }
	            else {
	                if ((typeof console !==  'undefined') && console.warn) {
	                    //warn user if arguments are passed but the locale could not be set
	                    console.warn('Locale ' + key +  ' not found. Did you forget to load it?');
	                }
	            }
	        }

	        return globalLocale._abbr;
	    }

	    function defineLocale (name, config) {
	        if (config !== null) {
	            var locale, parentConfig = baseConfig;
	            config.abbr = name;
	            if (locales[name] != null) {
	                deprecateSimple('defineLocaleOverride',
	                        'use moment.updateLocale(localeName, config) to change ' +
	                        'an existing locale. moment.defineLocale(localeName, ' +
	                        'config) should only be used for creating a new locale ' +
	                        'See http://momentjs.com/guides/#/warnings/define-locale/ for more info.');
	                parentConfig = locales[name]._config;
	            } else if (config.parentLocale != null) {
	                if (locales[config.parentLocale] != null) {
	                    parentConfig = locales[config.parentLocale]._config;
	                } else {
	                    locale = loadLocale(config.parentLocale);
	                    if (locale != null) {
	                        parentConfig = locale._config;
	                    } else {
	                        if (!localeFamilies[config.parentLocale]) {
	                            localeFamilies[config.parentLocale] = [];
	                        }
	                        localeFamilies[config.parentLocale].push({
	                            name: name,
	                            config: config
	                        });
	                        return null;
	                    }
	                }
	            }
	            locales[name] = new Locale(mergeConfigs(parentConfig, config));

	            if (localeFamilies[name]) {
	                localeFamilies[name].forEach(function (x) {
	                    defineLocale(x.name, x.config);
	                });
	            }

	            // backwards compat for now: also set the locale
	            // make sure we set the locale AFTER all child locales have been
	            // created, so we won't end up with the child locale set.
	            getSetGlobalLocale(name);


	            return locales[name];
	        } else {
	            // useful for testing
	            delete locales[name];
	            return null;
	        }
	    }

	    function updateLocale(name, config) {
	        if (config != null) {
	            var locale, tmpLocale, parentConfig = baseConfig;
	            // MERGE
	            tmpLocale = loadLocale(name);
	            if (tmpLocale != null) {
	                parentConfig = tmpLocale._config;
	            }
	            config = mergeConfigs(parentConfig, config);
	            locale = new Locale(config);
	            locale.parentLocale = locales[name];
	            locales[name] = locale;

	            // backwards compat for now: also set the locale
	            getSetGlobalLocale(name);
	        } else {
	            // pass null for config to unupdate, useful for tests
	            if (locales[name] != null) {
	                if (locales[name].parentLocale != null) {
	                    locales[name] = locales[name].parentLocale;
	                } else if (locales[name] != null) {
	                    delete locales[name];
	                }
	            }
	        }
	        return locales[name];
	    }

	    // returns locale data
	    function getLocale (key) {
	        var locale;

	        if (key && key._locale && key._locale._abbr) {
	            key = key._locale._abbr;
	        }

	        if (!key) {
	            return globalLocale;
	        }

	        if (!isArray(key)) {
	            //short-circuit everything else
	            locale = loadLocale(key);
	            if (locale) {
	                return locale;
	            }
	            key = [key];
	        }

	        return chooseLocale(key);
	    }

	    function listLocales() {
	        return keys(locales);
	    }

	    function checkOverflow (m) {
	        var overflow;
	        var a = m._a;

	        if (a && getParsingFlags(m).overflow === -2) {
	            overflow =
	                a[MONTH]       < 0 || a[MONTH]       > 11  ? MONTH :
	                a[DATE]        < 1 || a[DATE]        > daysInMonth(a[YEAR], a[MONTH]) ? DATE :
	                a[HOUR]        < 0 || a[HOUR]        > 24 || (a[HOUR] === 24 && (a[MINUTE] !== 0 || a[SECOND] !== 0 || a[MILLISECOND] !== 0)) ? HOUR :
	                a[MINUTE]      < 0 || a[MINUTE]      > 59  ? MINUTE :
	                a[SECOND]      < 0 || a[SECOND]      > 59  ? SECOND :
	                a[MILLISECOND] < 0 || a[MILLISECOND] > 999 ? MILLISECOND :
	                -1;

	            if (getParsingFlags(m)._overflowDayOfYear && (overflow < YEAR || overflow > DATE)) {
	                overflow = DATE;
	            }
	            if (getParsingFlags(m)._overflowWeeks && overflow === -1) {
	                overflow = WEEK;
	            }
	            if (getParsingFlags(m)._overflowWeekday && overflow === -1) {
	                overflow = WEEKDAY;
	            }

	            getParsingFlags(m).overflow = overflow;
	        }

	        return m;
	    }

	    // Pick the first defined of two or three arguments.
	    function defaults(a, b, c) {
	        if (a != null) {
	            return a;
	        }
	        if (b != null) {
	            return b;
	        }
	        return c;
	    }

	    function currentDateArray(config) {
	        // hooks is actually the exported moment object
	        var nowValue = new Date(hooks.now());
	        if (config._useUTC) {
	            return [nowValue.getUTCFullYear(), nowValue.getUTCMonth(), nowValue.getUTCDate()];
	        }
	        return [nowValue.getFullYear(), nowValue.getMonth(), nowValue.getDate()];
	    }

	    // convert an array to a date.
	    // the array should mirror the parameters below
	    // note: all values past the year are optional and will default to the lowest possible value.
	    // [year, month, day , hour, minute, second, millisecond]
	    function configFromArray (config) {
	        var i, date, input = [], currentDate, expectedWeekday, yearToUse;

	        if (config._d) {
	            return;
	        }

	        currentDate = currentDateArray(config);

	        //compute day of the year from weeks and weekdays
	        if (config._w && config._a[DATE] == null && config._a[MONTH] == null) {
	            dayOfYearFromWeekInfo(config);
	        }

	        //if the day of the year is set, figure out what it is
	        if (config._dayOfYear != null) {
	            yearToUse = defaults(config._a[YEAR], currentDate[YEAR]);

	            if (config._dayOfYear > daysInYear(yearToUse) || config._dayOfYear === 0) {
	                getParsingFlags(config)._overflowDayOfYear = true;
	            }

	            date = createUTCDate(yearToUse, 0, config._dayOfYear);
	            config._a[MONTH] = date.getUTCMonth();
	            config._a[DATE] = date.getUTCDate();
	        }

	        // Default to current date.
	        // * if no year, month, day of month are given, default to today
	        // * if day of month is given, default month and year
	        // * if month is given, default only year
	        // * if year is given, don't default anything
	        for (i = 0; i < 3 && config._a[i] == null; ++i) {
	            config._a[i] = input[i] = currentDate[i];
	        }

	        // Zero out whatever was not defaulted, including time
	        for (; i < 7; i++) {
	            config._a[i] = input[i] = (config._a[i] == null) ? (i === 2 ? 1 : 0) : config._a[i];
	        }

	        // Check for 24:00:00.000
	        if (config._a[HOUR] === 24 &&
	                config._a[MINUTE] === 0 &&
	                config._a[SECOND] === 0 &&
	                config._a[MILLISECOND] === 0) {
	            config._nextDay = true;
	            config._a[HOUR] = 0;
	        }

	        config._d = (config._useUTC ? createUTCDate : createDate).apply(null, input);
	        expectedWeekday = config._useUTC ? config._d.getUTCDay() : config._d.getDay();

	        // Apply timezone offset from input. The actual utcOffset can be changed
	        // with parseZone.
	        if (config._tzm != null) {
	            config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);
	        }

	        if (config._nextDay) {
	            config._a[HOUR] = 24;
	        }

	        // check for mismatching day of week
	        if (config._w && typeof config._w.d !== 'undefined' && config._w.d !== expectedWeekday) {
	            getParsingFlags(config).weekdayMismatch = true;
	        }
	    }

	    function dayOfYearFromWeekInfo(config) {
	        var w, weekYear, week, weekday, dow, doy, temp, weekdayOverflow;

	        w = config._w;
	        if (w.GG != null || w.W != null || w.E != null) {
	            dow = 1;
	            doy = 4;

	            // TODO: We need to take the current isoWeekYear, but that depends on
	            // how we interpret now (local, utc, fixed offset). So create
	            // a now version of current config (take local/utc/offset flags, and
	            // create now).
	            weekYear = defaults(w.GG, config._a[YEAR], weekOfYear(createLocal(), 1, 4).year);
	            week = defaults(w.W, 1);
	            weekday = defaults(w.E, 1);
	            if (weekday < 1 || weekday > 7) {
	                weekdayOverflow = true;
	            }
	        } else {
	            dow = config._locale._week.dow;
	            doy = config._locale._week.doy;

	            var curWeek = weekOfYear(createLocal(), dow, doy);

	            weekYear = defaults(w.gg, config._a[YEAR], curWeek.year);

	            // Default to current week.
	            week = defaults(w.w, curWeek.week);

	            if (w.d != null) {
	                // weekday -- low day numbers are considered next week
	                weekday = w.d;
	                if (weekday < 0 || weekday > 6) {
	                    weekdayOverflow = true;
	                }
	            } else if (w.e != null) {
	                // local weekday -- counting starts from beginning of week
	                weekday = w.e + dow;
	                if (w.e < 0 || w.e > 6) {
	                    weekdayOverflow = true;
	                }
	            } else {
	                // default to beginning of week
	                weekday = dow;
	            }
	        }
	        if (week < 1 || week > weeksInYear(weekYear, dow, doy)) {
	            getParsingFlags(config)._overflowWeeks = true;
	        } else if (weekdayOverflow != null) {
	            getParsingFlags(config)._overflowWeekday = true;
	        } else {
	            temp = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy);
	            config._a[YEAR] = temp.year;
	            config._dayOfYear = temp.dayOfYear;
	        }
	    }

	    // iso 8601 regex
	    // 0000-00-00 0000-W00 or 0000-W00-0 + T + 00 or 00:00 or 00:00:00 or 00:00:00.000 + +00:00 or +0000 or +00)
	    var extendedIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;
	    var basicIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;

	    var tzRegex = /Z|[+-]\d\d(?::?\d\d)?/;

	    var isoDates = [
	        ['YYYYYY-MM-DD', /[+-]\d{6}-\d\d-\d\d/],
	        ['YYYY-MM-DD', /\d{4}-\d\d-\d\d/],
	        ['GGGG-[W]WW-E', /\d{4}-W\d\d-\d/],
	        ['GGGG-[W]WW', /\d{4}-W\d\d/, false],
	        ['YYYY-DDD', /\d{4}-\d{3}/],
	        ['YYYY-MM', /\d{4}-\d\d/, false],
	        ['YYYYYYMMDD', /[+-]\d{10}/],
	        ['YYYYMMDD', /\d{8}/],
	        // YYYYMM is NOT allowed by the standard
	        ['GGGG[W]WWE', /\d{4}W\d{3}/],
	        ['GGGG[W]WW', /\d{4}W\d{2}/, false],
	        ['YYYYDDD', /\d{7}/]
	    ];

	    // iso time formats and regexes
	    var isoTimes = [
	        ['HH:mm:ss.SSSS', /\d\d:\d\d:\d\d\.\d+/],
	        ['HH:mm:ss,SSSS', /\d\d:\d\d:\d\d,\d+/],
	        ['HH:mm:ss', /\d\d:\d\d:\d\d/],
	        ['HH:mm', /\d\d:\d\d/],
	        ['HHmmss.SSSS', /\d\d\d\d\d\d\.\d+/],
	        ['HHmmss,SSSS', /\d\d\d\d\d\d,\d+/],
	        ['HHmmss', /\d\d\d\d\d\d/],
	        ['HHmm', /\d\d\d\d/],
	        ['HH', /\d\d/]
	    ];

	    var aspNetJsonRegex = /^\/?Date\((\-?\d+)/i;

	    // date from iso format
	    function configFromISO(config) {
	        var i, l,
	            string = config._i,
	            match = extendedIsoRegex.exec(string) || basicIsoRegex.exec(string),
	            allowTime, dateFormat, timeFormat, tzFormat;

	        if (match) {
	            getParsingFlags(config).iso = true;

	            for (i = 0, l = isoDates.length; i < l; i++) {
	                if (isoDates[i][1].exec(match[1])) {
	                    dateFormat = isoDates[i][0];
	                    allowTime = isoDates[i][2] !== false;
	                    break;
	                }
	            }
	            if (dateFormat == null) {
	                config._isValid = false;
	                return;
	            }
	            if (match[3]) {
	                for (i = 0, l = isoTimes.length; i < l; i++) {
	                    if (isoTimes[i][1].exec(match[3])) {
	                        // match[2] should be 'T' or space
	                        timeFormat = (match[2] || ' ') + isoTimes[i][0];
	                        break;
	                    }
	                }
	                if (timeFormat == null) {
	                    config._isValid = false;
	                    return;
	                }
	            }
	            if (!allowTime && timeFormat != null) {
	                config._isValid = false;
	                return;
	            }
	            if (match[4]) {
	                if (tzRegex.exec(match[4])) {
	                    tzFormat = 'Z';
	                } else {
	                    config._isValid = false;
	                    return;
	                }
	            }
	            config._f = dateFormat + (timeFormat || '') + (tzFormat || '');
	            configFromStringAndFormat(config);
	        } else {
	            config._isValid = false;
	        }
	    }

	    // RFC 2822 regex: For details see https://tools.ietf.org/html/rfc2822#section-3.3
	    var rfc2822 = /^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/;

	    function extractFromRFC2822Strings(yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr) {
	        var result = [
	            untruncateYear(yearStr),
	            defaultLocaleMonthsShort.indexOf(monthStr),
	            parseInt(dayStr, 10),
	            parseInt(hourStr, 10),
	            parseInt(minuteStr, 10)
	        ];

	        if (secondStr) {
	            result.push(parseInt(secondStr, 10));
	        }

	        return result;
	    }

	    function untruncateYear(yearStr) {
	        var year = parseInt(yearStr, 10);
	        if (year <= 49) {
	            return 2000 + year;
	        } else if (year <= 999) {
	            return 1900 + year;
	        }
	        return year;
	    }

	    function preprocessRFC2822(s) {
	        // Remove comments and folding whitespace and replace multiple-spaces with a single space
	        return s.replace(/\([^)]*\)|[\n\t]/g, ' ').replace(/(\s\s+)/g, ' ').replace(/^\s\s*/, '').replace(/\s\s*$/, '');
	    }

	    function checkWeekday(weekdayStr, parsedInput, config) {
	        if (weekdayStr) {
	            // TODO: Replace the vanilla JS Date object with an indepentent day-of-week check.
	            var weekdayProvided = defaultLocaleWeekdaysShort.indexOf(weekdayStr),
	                weekdayActual = new Date(parsedInput[0], parsedInput[1], parsedInput[2]).getDay();
	            if (weekdayProvided !== weekdayActual) {
	                getParsingFlags(config).weekdayMismatch = true;
	                config._isValid = false;
	                return false;
	            }
	        }
	        return true;
	    }

	    var obsOffsets = {
	        UT: 0,
	        GMT: 0,
	        EDT: -4 * 60,
	        EST: -5 * 60,
	        CDT: -5 * 60,
	        CST: -6 * 60,
	        MDT: -6 * 60,
	        MST: -7 * 60,
	        PDT: -7 * 60,
	        PST: -8 * 60
	    };

	    function calculateOffset(obsOffset, militaryOffset, numOffset) {
	        if (obsOffset) {
	            return obsOffsets[obsOffset];
	        } else if (militaryOffset) {
	            // the only allowed military tz is Z
	            return 0;
	        } else {
	            var hm = parseInt(numOffset, 10);
	            var m = hm % 100, h = (hm - m) / 100;
	            return h * 60 + m;
	        }
	    }

	    // date and time from ref 2822 format
	    function configFromRFC2822(config) {
	        var match = rfc2822.exec(preprocessRFC2822(config._i));
	        if (match) {
	            var parsedArray = extractFromRFC2822Strings(match[4], match[3], match[2], match[5], match[6], match[7]);
	            if (!checkWeekday(match[1], parsedArray, config)) {
	                return;
	            }

	            config._a = parsedArray;
	            config._tzm = calculateOffset(match[8], match[9], match[10]);

	            config._d = createUTCDate.apply(null, config._a);
	            config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);

	            getParsingFlags(config).rfc2822 = true;
	        } else {
	            config._isValid = false;
	        }
	    }

	    // date from iso format or fallback
	    function configFromString(config) {
	        var matched = aspNetJsonRegex.exec(config._i);

	        if (matched !== null) {
	            config._d = new Date(+matched[1]);
	            return;
	        }

	        configFromISO(config);
	        if (config._isValid === false) {
	            delete config._isValid;
	        } else {
	            return;
	        }

	        configFromRFC2822(config);
	        if (config._isValid === false) {
	            delete config._isValid;
	        } else {
	            return;
	        }

	        // Final attempt, use Input Fallback
	        hooks.createFromInputFallback(config);
	    }

	    hooks.createFromInputFallback = deprecate(
	        'value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), ' +
	        'which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are ' +
	        'discouraged and will be removed in an upcoming major release. Please refer to ' +
	        'http://momentjs.com/guides/#/warnings/js-date/ for more info.',
	        function (config) {
	            config._d = new Date(config._i + (config._useUTC ? ' UTC' : ''));
	        }
	    );

	    // constant that refers to the ISO standard
	    hooks.ISO_8601 = function () {};

	    // constant that refers to the RFC 2822 form
	    hooks.RFC_2822 = function () {};

	    // date from string and format string
	    function configFromStringAndFormat(config) {
	        // TODO: Move this to another part of the creation flow to prevent circular deps
	        if (config._f === hooks.ISO_8601) {
	            configFromISO(config);
	            return;
	        }
	        if (config._f === hooks.RFC_2822) {
	            configFromRFC2822(config);
	            return;
	        }
	        config._a = [];
	        getParsingFlags(config).empty = true;

	        // This array is used to make a Date, either with `new Date` or `Date.UTC`
	        var string = '' + config._i,
	            i, parsedInput, tokens, token, skipped,
	            stringLength = string.length,
	            totalParsedInputLength = 0;

	        tokens = expandFormat(config._f, config._locale).match(formattingTokens) || [];

	        for (i = 0; i < tokens.length; i++) {
	            token = tokens[i];
	            parsedInput = (string.match(getParseRegexForToken(token, config)) || [])[0];
	            // console.log('token', token, 'parsedInput', parsedInput,
	            //         'regex', getParseRegexForToken(token, config));
	            if (parsedInput) {
	                skipped = string.substr(0, string.indexOf(parsedInput));
	                if (skipped.length > 0) {
	                    getParsingFlags(config).unusedInput.push(skipped);
	                }
	                string = string.slice(string.indexOf(parsedInput) + parsedInput.length);
	                totalParsedInputLength += parsedInput.length;
	            }
	            // don't parse if it's not a known token
	            if (formatTokenFunctions[token]) {
	                if (parsedInput) {
	                    getParsingFlags(config).empty = false;
	                }
	                else {
	                    getParsingFlags(config).unusedTokens.push(token);
	                }
	                addTimeToArrayFromToken(token, parsedInput, config);
	            }
	            else if (config._strict && !parsedInput) {
	                getParsingFlags(config).unusedTokens.push(token);
	            }
	        }

	        // add remaining unparsed input length to the string
	        getParsingFlags(config).charsLeftOver = stringLength - totalParsedInputLength;
	        if (string.length > 0) {
	            getParsingFlags(config).unusedInput.push(string);
	        }

	        // clear _12h flag if hour is <= 12
	        if (config._a[HOUR] <= 12 &&
	            getParsingFlags(config).bigHour === true &&
	            config._a[HOUR] > 0) {
	            getParsingFlags(config).bigHour = undefined;
	        }

	        getParsingFlags(config).parsedDateParts = config._a.slice(0);
	        getParsingFlags(config).meridiem = config._meridiem;
	        // handle meridiem
	        config._a[HOUR] = meridiemFixWrap(config._locale, config._a[HOUR], config._meridiem);

	        configFromArray(config);
	        checkOverflow(config);
	    }


	    function meridiemFixWrap (locale, hour, meridiem) {
	        var isPm;

	        if (meridiem == null) {
	            // nothing to do
	            return hour;
	        }
	        if (locale.meridiemHour != null) {
	            return locale.meridiemHour(hour, meridiem);
	        } else if (locale.isPM != null) {
	            // Fallback
	            isPm = locale.isPM(meridiem);
	            if (isPm && hour < 12) {
	                hour += 12;
	            }
	            if (!isPm && hour === 12) {
	                hour = 0;
	            }
	            return hour;
	        } else {
	            // this is not supposed to happen
	            return hour;
	        }
	    }

	    // date from string and array of format strings
	    function configFromStringAndArray(config) {
	        var tempConfig,
	            bestMoment,

	            scoreToBeat,
	            i,
	            currentScore;

	        if (config._f.length === 0) {
	            getParsingFlags(config).invalidFormat = true;
	            config._d = new Date(NaN);
	            return;
	        }

	        for (i = 0; i < config._f.length; i++) {
	            currentScore = 0;
	            tempConfig = copyConfig({}, config);
	            if (config._useUTC != null) {
	                tempConfig._useUTC = config._useUTC;
	            }
	            tempConfig._f = config._f[i];
	            configFromStringAndFormat(tempConfig);

	            if (!isValid(tempConfig)) {
	                continue;
	            }

	            // if there is any input that was not parsed add a penalty for that format
	            currentScore += getParsingFlags(tempConfig).charsLeftOver;

	            //or tokens
	            currentScore += getParsingFlags(tempConfig).unusedTokens.length * 10;

	            getParsingFlags(tempConfig).score = currentScore;

	            if (scoreToBeat == null || currentScore < scoreToBeat) {
	                scoreToBeat = currentScore;
	                bestMoment = tempConfig;
	            }
	        }

	        extend(config, bestMoment || tempConfig);
	    }

	    function configFromObject(config) {
	        if (config._d) {
	            return;
	        }

	        var i = normalizeObjectUnits(config._i);
	        config._a = map([i.year, i.month, i.day || i.date, i.hour, i.minute, i.second, i.millisecond], function (obj) {
	            return obj && parseInt(obj, 10);
	        });

	        configFromArray(config);
	    }

	    function createFromConfig (config) {
	        var res = new Moment(checkOverflow(prepareConfig(config)));
	        if (res._nextDay) {
	            // Adding is smart enough around DST
	            res.add(1, 'd');
	            res._nextDay = undefined;
	        }

	        return res;
	    }

	    function prepareConfig (config) {
	        var input = config._i,
	            format = config._f;

	        config._locale = config._locale || getLocale(config._l);

	        if (input === null || (format === undefined && input === '')) {
	            return createInvalid({nullInput: true});
	        }

	        if (typeof input === 'string') {
	            config._i = input = config._locale.preparse(input);
	        }

	        if (isMoment(input)) {
	            return new Moment(checkOverflow(input));
	        } else if (isDate(input)) {
	            config._d = input;
	        } else if (isArray(format)) {
	            configFromStringAndArray(config);
	        } else if (format) {
	            configFromStringAndFormat(config);
	        }  else {
	            configFromInput(config);
	        }

	        if (!isValid(config)) {
	            config._d = null;
	        }

	        return config;
	    }

	    function configFromInput(config) {
	        var input = config._i;
	        if (isUndefined(input)) {
	            config._d = new Date(hooks.now());
	        } else if (isDate(input)) {
	            config._d = new Date(input.valueOf());
	        } else if (typeof input === 'string') {
	            configFromString(config);
	        } else if (isArray(input)) {
	            config._a = map(input.slice(0), function (obj) {
	                return parseInt(obj, 10);
	            });
	            configFromArray(config);
	        } else if (isObject(input)) {
	            configFromObject(config);
	        } else if (isNumber(input)) {
	            // from milliseconds
	            config._d = new Date(input);
	        } else {
	            hooks.createFromInputFallback(config);
	        }
	    }

	    function createLocalOrUTC (input, format, locale, strict, isUTC) {
	        var c = {};

	        if (locale === true || locale === false) {
	            strict = locale;
	            locale = undefined;
	        }

	        if ((isObject(input) && isObjectEmpty(input)) ||
	                (isArray(input) && input.length === 0)) {
	            input = undefined;
	        }
	        // object construction must be done this way.
	        // https://github.com/moment/moment/issues/1423
	        c._isAMomentObject = true;
	        c._useUTC = c._isUTC = isUTC;
	        c._l = locale;
	        c._i = input;
	        c._f = format;
	        c._strict = strict;

	        return createFromConfig(c);
	    }

	    function createLocal (input, format, locale, strict) {
	        return createLocalOrUTC(input, format, locale, strict, false);
	    }

	    var prototypeMin = deprecate(
	        'moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/',
	        function () {
	            var other = createLocal.apply(null, arguments);
	            if (this.isValid() && other.isValid()) {
	                return other < this ? this : other;
	            } else {
	                return createInvalid();
	            }
	        }
	    );

	    var prototypeMax = deprecate(
	        'moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/',
	        function () {
	            var other = createLocal.apply(null, arguments);
	            if (this.isValid() && other.isValid()) {
	                return other > this ? this : other;
	            } else {
	                return createInvalid();
	            }
	        }
	    );

	    // Pick a moment m from moments so that m[fn](other) is true for all
	    // other. This relies on the function fn to be transitive.
	    //
	    // moments should either be an array of moment objects or an array, whose
	    // first element is an array of moment objects.
	    function pickBy(fn, moments) {
	        var res, i;
	        if (moments.length === 1 && isArray(moments[0])) {
	            moments = moments[0];
	        }
	        if (!moments.length) {
	            return createLocal();
	        }
	        res = moments[0];
	        for (i = 1; i < moments.length; ++i) {
	            if (!moments[i].isValid() || moments[i][fn](res)) {
	                res = moments[i];
	            }
	        }
	        return res;
	    }

	    // TODO: Use [].sort instead?
	    function min () {
	        var args = [].slice.call(arguments, 0);

	        return pickBy('isBefore', args);
	    }

	    function max () {
	        var args = [].slice.call(arguments, 0);

	        return pickBy('isAfter', args);
	    }

	    var now = function () {
	        return Date.now ? Date.now() : +(new Date());
	    };

	    var ordering = ['year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', 'millisecond'];

	    function isDurationValid(m) {
	        for (var key in m) {
	            if (!(indexOf.call(ordering, key) !== -1 && (m[key] == null || !isNaN(m[key])))) {
	                return false;
	            }
	        }

	        var unitHasDecimal = false;
	        for (var i = 0; i < ordering.length; ++i) {
	            if (m[ordering[i]]) {
	                if (unitHasDecimal) {
	                    return false; // only allow non-integers for smallest unit
	                }
	                if (parseFloat(m[ordering[i]]) !== toInt(m[ordering[i]])) {
	                    unitHasDecimal = true;
	                }
	            }
	        }

	        return true;
	    }

	    function isValid$1() {
	        return this._isValid;
	    }

	    function createInvalid$1() {
	        return createDuration(NaN);
	    }

	    function Duration (duration) {
	        var normalizedInput = normalizeObjectUnits(duration),
	            years = normalizedInput.year || 0,
	            quarters = normalizedInput.quarter || 0,
	            months = normalizedInput.month || 0,
	            weeks = normalizedInput.week || normalizedInput.isoWeek || 0,
	            days = normalizedInput.day || 0,
	            hours = normalizedInput.hour || 0,
	            minutes = normalizedInput.minute || 0,
	            seconds = normalizedInput.second || 0,
	            milliseconds = normalizedInput.millisecond || 0;

	        this._isValid = isDurationValid(normalizedInput);

	        // representation for dateAddRemove
	        this._milliseconds = +milliseconds +
	            seconds * 1e3 + // 1000
	            minutes * 6e4 + // 1000 * 60
	            hours * 1000 * 60 * 60; //using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978
	        // Because of dateAddRemove treats 24 hours as different from a
	        // day when working around DST, we need to store them separately
	        this._days = +days +
	            weeks * 7;
	        // It is impossible to translate months into days without knowing
	        // which months you are are talking about, so we have to store
	        // it separately.
	        this._months = +months +
	            quarters * 3 +
	            years * 12;

	        this._data = {};

	        this._locale = getLocale();

	        this._bubble();
	    }

	    function isDuration (obj) {
	        return obj instanceof Duration;
	    }

	    function absRound (number) {
	        if (number < 0) {
	            return Math.round(-1 * number) * -1;
	        } else {
	            return Math.round(number);
	        }
	    }

	    // FORMATTING

	    function offset (token, separator) {
	        addFormatToken(token, 0, 0, function () {
	            var offset = this.utcOffset();
	            var sign = '+';
	            if (offset < 0) {
	                offset = -offset;
	                sign = '-';
	            }
	            return sign + zeroFill(~~(offset / 60), 2) + separator + zeroFill(~~(offset) % 60, 2);
	        });
	    }

	    offset('Z', ':');
	    offset('ZZ', '');

	    // PARSING

	    addRegexToken('Z',  matchShortOffset);
	    addRegexToken('ZZ', matchShortOffset);
	    addParseToken(['Z', 'ZZ'], function (input, array, config) {
	        config._useUTC = true;
	        config._tzm = offsetFromString(matchShortOffset, input);
	    });

	    // HELPERS

	    // timezone chunker
	    // '+10:00' > ['10',  '00']
	    // '-1530'  > ['-15', '30']
	    var chunkOffset = /([\+\-]|\d\d)/gi;

	    function offsetFromString(matcher, string) {
	        var matches = (string || '').match(matcher);

	        if (matches === null) {
	            return null;
	        }

	        var chunk   = matches[matches.length - 1] || [];
	        var parts   = (chunk + '').match(chunkOffset) || ['-', 0, 0];
	        var minutes = +(parts[1] * 60) + toInt(parts[2]);

	        return minutes === 0 ?
	          0 :
	          parts[0] === '+' ? minutes : -minutes;
	    }

	    // Return a moment from input, that is local/utc/zone equivalent to model.
	    function cloneWithOffset(input, model) {
	        var res, diff;
	        if (model._isUTC) {
	            res = model.clone();
	            diff = (isMoment(input) || isDate(input) ? input.valueOf() : createLocal(input).valueOf()) - res.valueOf();
	            // Use low-level api, because this fn is low-level api.
	            res._d.setTime(res._d.valueOf() + diff);
	            hooks.updateOffset(res, false);
	            return res;
	        } else {
	            return createLocal(input).local();
	        }
	    }

	    function getDateOffset (m) {
	        // On Firefox.24 Date#getTimezoneOffset returns a floating point.
	        // https://github.com/moment/moment/pull/1871
	        return -Math.round(m._d.getTimezoneOffset() / 15) * 15;
	    }

	    // HOOKS

	    // This function will be called whenever a moment is mutated.
	    // It is intended to keep the offset in sync with the timezone.
	    hooks.updateOffset = function () {};

	    // MOMENTS

	    // keepLocalTime = true means only change the timezone, without
	    // affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->
	    // 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset
	    // +0200, so we adjust the time as needed, to be valid.
	    //
	    // Keeping the time actually adds/subtracts (one hour)
	    // from the actual represented time. That is why we call updateOffset
	    // a second time. In case it wants us to change the offset again
	    // _changeInProgress == true case, then we have to adjust, because
	    // there is no such time in the given timezone.
	    function getSetOffset (input, keepLocalTime, keepMinutes) {
	        var offset = this._offset || 0,
	            localAdjust;
	        if (!this.isValid()) {
	            return input != null ? this : NaN;
	        }
	        if (input != null) {
	            if (typeof input === 'string') {
	                input = offsetFromString(matchShortOffset, input);
	                if (input === null) {
	                    return this;
	                }
	            } else if (Math.abs(input) < 16 && !keepMinutes) {
	                input = input * 60;
	            }
	            if (!this._isUTC && keepLocalTime) {
	                localAdjust = getDateOffset(this);
	            }
	            this._offset = input;
	            this._isUTC = true;
	            if (localAdjust != null) {
	                this.add(localAdjust, 'm');
	            }
	            if (offset !== input) {
	                if (!keepLocalTime || this._changeInProgress) {
	                    addSubtract(this, createDuration(input - offset, 'm'), 1, false);
	                } else if (!this._changeInProgress) {
	                    this._changeInProgress = true;
	                    hooks.updateOffset(this, true);
	                    this._changeInProgress = null;
	                }
	            }
	            return this;
	        } else {
	            return this._isUTC ? offset : getDateOffset(this);
	        }
	    }

	    function getSetZone (input, keepLocalTime) {
	        if (input != null) {
	            if (typeof input !== 'string') {
	                input = -input;
	            }

	            this.utcOffset(input, keepLocalTime);

	            return this;
	        } else {
	            return -this.utcOffset();
	        }
	    }

	    function setOffsetToUTC (keepLocalTime) {
	        return this.utcOffset(0, keepLocalTime);
	    }

	    function setOffsetToLocal (keepLocalTime) {
	        if (this._isUTC) {
	            this.utcOffset(0, keepLocalTime);
	            this._isUTC = false;

	            if (keepLocalTime) {
	                this.subtract(getDateOffset(this), 'm');
	            }
	        }
	        return this;
	    }

	    function setOffsetToParsedOffset () {
	        if (this._tzm != null) {
	            this.utcOffset(this._tzm, false, true);
	        } else if (typeof this._i === 'string') {
	            var tZone = offsetFromString(matchOffset, this._i);
	            if (tZone != null) {
	                this.utcOffset(tZone);
	            }
	            else {
	                this.utcOffset(0, true);
	            }
	        }
	        return this;
	    }

	    function hasAlignedHourOffset (input) {
	        if (!this.isValid()) {
	            return false;
	        }
	        input = input ? createLocal(input).utcOffset() : 0;

	        return (this.utcOffset() - input) % 60 === 0;
	    }

	    function isDaylightSavingTime () {
	        return (
	            this.utcOffset() > this.clone().month(0).utcOffset() ||
	            this.utcOffset() > this.clone().month(5).utcOffset()
	        );
	    }

	    function isDaylightSavingTimeShifted () {
	        if (!isUndefined(this._isDSTShifted)) {
	            return this._isDSTShifted;
	        }

	        var c = {};

	        copyConfig(c, this);
	        c = prepareConfig(c);

	        if (c._a) {
	            var other = c._isUTC ? createUTC(c._a) : createLocal(c._a);
	            this._isDSTShifted = this.isValid() &&
	                compareArrays(c._a, other.toArray()) > 0;
	        } else {
	            this._isDSTShifted = false;
	        }

	        return this._isDSTShifted;
	    }

	    function isLocal () {
	        return this.isValid() ? !this._isUTC : false;
	    }

	    function isUtcOffset () {
	        return this.isValid() ? this._isUTC : false;
	    }

	    function isUtc () {
	        return this.isValid() ? this._isUTC && this._offset === 0 : false;
	    }

	    // ASP.NET json date format regex
	    var aspNetRegex = /^(\-|\+)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/;

	    // from http://docs.closure-library.googlecode.com/git/closure_goog_date_date.js.source.html
	    // somewhat more in line with 4.4.3.2 2004 spec, but allows decimal anywhere
	    // and further modified to allow for strings containing both week and day
	    var isoRegex = /^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;

	    function createDuration (input, key) {
	        var duration = input,
	            // matching against regexp is expensive, do it on demand
	            match = null,
	            sign,
	            ret,
	            diffRes;

	        if (isDuration(input)) {
	            duration = {
	                ms : input._milliseconds,
	                d  : input._days,
	                M  : input._months
	            };
	        } else if (isNumber(input)) {
	            duration = {};
	            if (key) {
	                duration[key] = input;
	            } else {
	                duration.milliseconds = input;
	            }
	        } else if (!!(match = aspNetRegex.exec(input))) {
	            sign = (match[1] === '-') ? -1 : 1;
	            duration = {
	                y  : 0,
	                d  : toInt(match[DATE])                         * sign,
	                h  : toInt(match[HOUR])                         * sign,
	                m  : toInt(match[MINUTE])                       * sign,
	                s  : toInt(match[SECOND])                       * sign,
	                ms : toInt(absRound(match[MILLISECOND] * 1000)) * sign // the millisecond decimal point is included in the match
	            };
	        } else if (!!(match = isoRegex.exec(input))) {
	            sign = (match[1] === '-') ? -1 : 1;
	            duration = {
	                y : parseIso(match[2], sign),
	                M : parseIso(match[3], sign),
	                w : parseIso(match[4], sign),
	                d : parseIso(match[5], sign),
	                h : parseIso(match[6], sign),
	                m : parseIso(match[7], sign),
	                s : parseIso(match[8], sign)
	            };
	        } else if (duration == null) {// checks for null or undefined
	            duration = {};
	        } else if (typeof duration === 'object' && ('from' in duration || 'to' in duration)) {
	            diffRes = momentsDifference(createLocal(duration.from), createLocal(duration.to));

	            duration = {};
	            duration.ms = diffRes.milliseconds;
	            duration.M = diffRes.months;
	        }

	        ret = new Duration(duration);

	        if (isDuration(input) && hasOwnProp(input, '_locale')) {
	            ret._locale = input._locale;
	        }

	        return ret;
	    }

	    createDuration.fn = Duration.prototype;
	    createDuration.invalid = createInvalid$1;

	    function parseIso (inp, sign) {
	        // We'd normally use ~~inp for this, but unfortunately it also
	        // converts floats to ints.
	        // inp may be undefined, so careful calling replace on it.
	        var res = inp && parseFloat(inp.replace(',', '.'));
	        // apply sign while we're at it
	        return (isNaN(res) ? 0 : res) * sign;
	    }

	    function positiveMomentsDifference(base, other) {
	        var res = {};

	        res.months = other.month() - base.month() +
	            (other.year() - base.year()) * 12;
	        if (base.clone().add(res.months, 'M').isAfter(other)) {
	            --res.months;
	        }

	        res.milliseconds = +other - +(base.clone().add(res.months, 'M'));

	        return res;
	    }

	    function momentsDifference(base, other) {
	        var res;
	        if (!(base.isValid() && other.isValid())) {
	            return {milliseconds: 0, months: 0};
	        }

	        other = cloneWithOffset(other, base);
	        if (base.isBefore(other)) {
	            res = positiveMomentsDifference(base, other);
	        } else {
	            res = positiveMomentsDifference(other, base);
	            res.milliseconds = -res.milliseconds;
	            res.months = -res.months;
	        }

	        return res;
	    }

	    // TODO: remove 'name' arg after deprecation is removed
	    function createAdder(direction, name) {
	        return function (val, period) {
	            var dur, tmp;
	            //invert the arguments, but complain about it
	            if (period !== null && !isNaN(+period)) {
	                deprecateSimple(name, 'moment().' + name  + '(period, number) is deprecated. Please use moment().' + name + '(number, period). ' +
	                'See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.');
	                tmp = val; val = period; period = tmp;
	            }

	            val = typeof val === 'string' ? +val : val;
	            dur = createDuration(val, period);
	            addSubtract(this, dur, direction);
	            return this;
	        };
	    }

	    function addSubtract (mom, duration, isAdding, updateOffset) {
	        var milliseconds = duration._milliseconds,
	            days = absRound(duration._days),
	            months = absRound(duration._months);

	        if (!mom.isValid()) {
	            // No op
	            return;
	        }

	        updateOffset = updateOffset == null ? true : updateOffset;

	        if (months) {
	            setMonth(mom, get(mom, 'Month') + months * isAdding);
	        }
	        if (days) {
	            set$1(mom, 'Date', get(mom, 'Date') + days * isAdding);
	        }
	        if (milliseconds) {
	            mom._d.setTime(mom._d.valueOf() + milliseconds * isAdding);
	        }
	        if (updateOffset) {
	            hooks.updateOffset(mom, days || months);
	        }
	    }

	    var add      = createAdder(1, 'add');
	    var subtract = createAdder(-1, 'subtract');

	    function getCalendarFormat(myMoment, now) {
	        var diff = myMoment.diff(now, 'days', true);
	        return diff < -6 ? 'sameElse' :
	                diff < -1 ? 'lastWeek' :
	                diff < 0 ? 'lastDay' :
	                diff < 1 ? 'sameDay' :
	                diff < 2 ? 'nextDay' :
	                diff < 7 ? 'nextWeek' : 'sameElse';
	    }

	    function calendar$1 (time, formats) {
	        // We want to compare the start of today, vs this.
	        // Getting start-of-today depends on whether we're local/utc/offset or not.
	        var now = time || createLocal(),
	            sod = cloneWithOffset(now, this).startOf('day'),
	            format = hooks.calendarFormat(this, sod) || 'sameElse';

	        var output = formats && (isFunction(formats[format]) ? formats[format].call(this, now) : formats[format]);

	        return this.format(output || this.localeData().calendar(format, this, createLocal(now)));
	    }

	    function clone () {
	        return new Moment(this);
	    }

	    function isAfter (input, units) {
	        var localInput = isMoment(input) ? input : createLocal(input);
	        if (!(this.isValid() && localInput.isValid())) {
	            return false;
	        }
	        units = normalizeUnits(units) || 'millisecond';
	        if (units === 'millisecond') {
	            return this.valueOf() > localInput.valueOf();
	        } else {
	            return localInput.valueOf() < this.clone().startOf(units).valueOf();
	        }
	    }

	    function isBefore (input, units) {
	        var localInput = isMoment(input) ? input : createLocal(input);
	        if (!(this.isValid() && localInput.isValid())) {
	            return false;
	        }
	        units = normalizeUnits(units) || 'millisecond';
	        if (units === 'millisecond') {
	            return this.valueOf() < localInput.valueOf();
	        } else {
	            return this.clone().endOf(units).valueOf() < localInput.valueOf();
	        }
	    }

	    function isBetween (from, to, units, inclusivity) {
	        var localFrom = isMoment(from) ? from : createLocal(from),
	            localTo = isMoment(to) ? to : createLocal(to);
	        if (!(this.isValid() && localFrom.isValid() && localTo.isValid())) {
	            return false;
	        }
	        inclusivity = inclusivity || '()';
	        return (inclusivity[0] === '(' ? this.isAfter(localFrom, units) : !this.isBefore(localFrom, units)) &&
	            (inclusivity[1] === ')' ? this.isBefore(localTo, units) : !this.isAfter(localTo, units));
	    }

	    function isSame (input, units) {
	        var localInput = isMoment(input) ? input : createLocal(input),
	            inputMs;
	        if (!(this.isValid() && localInput.isValid())) {
	            return false;
	        }
	        units = normalizeUnits(units) || 'millisecond';
	        if (units === 'millisecond') {
	            return this.valueOf() === localInput.valueOf();
	        } else {
	            inputMs = localInput.valueOf();
	            return this.clone().startOf(units).valueOf() <= inputMs && inputMs <= this.clone().endOf(units).valueOf();
	        }
	    }

	    function isSameOrAfter (input, units) {
	        return this.isSame(input, units) || this.isAfter(input, units);
	    }

	    function isSameOrBefore (input, units) {
	        return this.isSame(input, units) || this.isBefore(input, units);
	    }

	    function diff (input, units, asFloat) {
	        var that,
	            zoneDelta,
	            output;

	        if (!this.isValid()) {
	            return NaN;
	        }

	        that = cloneWithOffset(input, this);

	        if (!that.isValid()) {
	            return NaN;
	        }

	        zoneDelta = (that.utcOffset() - this.utcOffset()) * 6e4;

	        units = normalizeUnits(units);

	        switch (units) {
	            case 'year': output = monthDiff(this, that) / 12; break;
	            case 'month': output = monthDiff(this, that); break;
	            case 'quarter': output = monthDiff(this, that) / 3; break;
	            case 'second': output = (this - that) / 1e3; break; // 1000
	            case 'minute': output = (this - that) / 6e4; break; // 1000 * 60
	            case 'hour': output = (this - that) / 36e5; break; // 1000 * 60 * 60
	            case 'day': output = (this - that - zoneDelta) / 864e5; break; // 1000 * 60 * 60 * 24, negate dst
	            case 'week': output = (this - that - zoneDelta) / 6048e5; break; // 1000 * 60 * 60 * 24 * 7, negate dst
	            default: output = this - that;
	        }

	        return asFloat ? output : absFloor(output);
	    }

	    function monthDiff (a, b) {
	        // difference in months
	        var wholeMonthDiff = ((b.year() - a.year()) * 12) + (b.month() - a.month()),
	            // b is in (anchor - 1 month, anchor + 1 month)
	            anchor = a.clone().add(wholeMonthDiff, 'months'),
	            anchor2, adjust;

	        if (b - anchor < 0) {
	            anchor2 = a.clone().add(wholeMonthDiff - 1, 'months');
	            // linear across the month
	            adjust = (b - anchor) / (anchor - anchor2);
	        } else {
	            anchor2 = a.clone().add(wholeMonthDiff + 1, 'months');
	            // linear across the month
	            adjust = (b - anchor) / (anchor2 - anchor);
	        }

	        //check for negative zero, return zero if negative zero
	        return -(wholeMonthDiff + adjust) || 0;
	    }

	    hooks.defaultFormat = 'YYYY-MM-DDTHH:mm:ssZ';
	    hooks.defaultFormatUtc = 'YYYY-MM-DDTHH:mm:ss[Z]';

	    function toString () {
	        return this.clone().locale('en').format('ddd MMM DD YYYY HH:mm:ss [GMT]ZZ');
	    }

	    function toISOString(keepOffset) {
	        if (!this.isValid()) {
	            return null;
	        }
	        var utc = keepOffset !== true;
	        var m = utc ? this.clone().utc() : this;
	        if (m.year() < 0 || m.year() > 9999) {
	            return formatMoment(m, utc ? 'YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]' : 'YYYYYY-MM-DD[T]HH:mm:ss.SSSZ');
	        }
	        if (isFunction(Date.prototype.toISOString)) {
	            // native implementation is ~50x faster, use it when we can
	            if (utc) {
	                return this.toDate().toISOString();
	            } else {
	                return new Date(this.valueOf() + this.utcOffset() * 60 * 1000).toISOString().replace('Z', formatMoment(m, 'Z'));
	            }
	        }
	        return formatMoment(m, utc ? 'YYYY-MM-DD[T]HH:mm:ss.SSS[Z]' : 'YYYY-MM-DD[T]HH:mm:ss.SSSZ');
	    }

	    /**
	     * Return a human readable representation of a moment that can
	     * also be evaluated to get a new moment which is the same
	     *
	     * @link https://nodejs.org/dist/latest/docs/api/util.html#util_custom_inspect_function_on_objects
	     */
	    function inspect () {
	        if (!this.isValid()) {
	            return 'moment.invalid(/* ' + this._i + ' */)';
	        }
	        var func = 'moment';
	        var zone = '';
	        if (!this.isLocal()) {
	            func = this.utcOffset() === 0 ? 'moment.utc' : 'moment.parseZone';
	            zone = 'Z';
	        }
	        var prefix = '[' + func + '("]';
	        var year = (0 <= this.year() && this.year() <= 9999) ? 'YYYY' : 'YYYYYY';
	        var datetime = '-MM-DD[T]HH:mm:ss.SSS';
	        var suffix = zone + '[")]';

	        return this.format(prefix + year + datetime + suffix);
	    }

	    function format (inputString) {
	        if (!inputString) {
	            inputString = this.isUtc() ? hooks.defaultFormatUtc : hooks.defaultFormat;
	        }
	        var output = formatMoment(this, inputString);
	        return this.localeData().postformat(output);
	    }

	    function from (time, withoutSuffix) {
	        if (this.isValid() &&
	                ((isMoment(time) && time.isValid()) ||
	                 createLocal(time).isValid())) {
	            return createDuration({to: this, from: time}).locale(this.locale()).humanize(!withoutSuffix);
	        } else {
	            return this.localeData().invalidDate();
	        }
	    }

	    function fromNow (withoutSuffix) {
	        return this.from(createLocal(), withoutSuffix);
	    }

	    function to (time, withoutSuffix) {
	        if (this.isValid() &&
	                ((isMoment(time) && time.isValid()) ||
	                 createLocal(time).isValid())) {
	            return createDuration({from: this, to: time}).locale(this.locale()).humanize(!withoutSuffix);
	        } else {
	            return this.localeData().invalidDate();
	        }
	    }

	    function toNow (withoutSuffix) {
	        return this.to(createLocal(), withoutSuffix);
	    }

	    // If passed a locale key, it will set the locale for this
	    // instance.  Otherwise, it will return the locale configuration
	    // variables for this instance.
	    function locale (key) {
	        var newLocaleData;

	        if (key === undefined) {
	            return this._locale._abbr;
	        } else {
	            newLocaleData = getLocale(key);
	            if (newLocaleData != null) {
	                this._locale = newLocaleData;
	            }
	            return this;
	        }
	    }

	    var lang = deprecate(
	        'moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.',
	        function (key) {
	            if (key === undefined) {
	                return this.localeData();
	            } else {
	                return this.locale(key);
	            }
	        }
	    );

	    function localeData () {
	        return this._locale;
	    }

	    var MS_PER_SECOND = 1000;
	    var MS_PER_MINUTE = 60 * MS_PER_SECOND;
	    var MS_PER_HOUR = 60 * MS_PER_MINUTE;
	    var MS_PER_400_YEARS = (365 * 400 + 97) * 24 * MS_PER_HOUR;

	    // actual modulo - handles negative numbers (for dates before 1970):
	    function mod$1(dividend, divisor) {
	        return (dividend % divisor + divisor) % divisor;
	    }

	    function localStartOfDate(y, m, d) {
	        // the date constructor remaps years 0-99 to 1900-1999
	        if (y < 100 && y >= 0) {
	            // preserve leap years using a full 400 year cycle, then reset
	            return new Date(y + 400, m, d) - MS_PER_400_YEARS;
	        } else {
	            return new Date(y, m, d).valueOf();
	        }
	    }

	    function utcStartOfDate(y, m, d) {
	        // Date.UTC remaps years 0-99 to 1900-1999
	        if (y < 100 && y >= 0) {
	            // preserve leap years using a full 400 year cycle, then reset
	            return Date.UTC(y + 400, m, d) - MS_PER_400_YEARS;
	        } else {
	            return Date.UTC(y, m, d);
	        }
	    }

	    function startOf (units) {
	        var time;
	        units = normalizeUnits(units);
	        if (units === undefined || units === 'millisecond' || !this.isValid()) {
	            return this;
	        }

	        var startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;

	        switch (units) {
	            case 'year':
	                time = startOfDate(this.year(), 0, 1);
	                break;
	            case 'quarter':
	                time = startOfDate(this.year(), this.month() - this.month() % 3, 1);
	                break;
	            case 'month':
	                time = startOfDate(this.year(), this.month(), 1);
	                break;
	            case 'week':
	                time = startOfDate(this.year(), this.month(), this.date() - this.weekday());
	                break;
	            case 'isoWeek':
	                time = startOfDate(this.year(), this.month(), this.date() - (this.isoWeekday() - 1));
	                break;
	            case 'day':
	            case 'date':
	                time = startOfDate(this.year(), this.month(), this.date());
	                break;
	            case 'hour':
	                time = this._d.valueOf();
	                time -= mod$1(time + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE), MS_PER_HOUR);
	                break;
	            case 'minute':
	                time = this._d.valueOf();
	                time -= mod$1(time, MS_PER_MINUTE);
	                break;
	            case 'second':
	                time = this._d.valueOf();
	                time -= mod$1(time, MS_PER_SECOND);
	                break;
	        }

	        this._d.setTime(time);
	        hooks.updateOffset(this, true);
	        return this;
	    }

	    function endOf (units) {
	        var time;
	        units = normalizeUnits(units);
	        if (units === undefined || units === 'millisecond' || !this.isValid()) {
	            return this;
	        }

	        var startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;

	        switch (units) {
	            case 'year':
	                time = startOfDate(this.year() + 1, 0, 1) - 1;
	                break;
	            case 'quarter':
	                time = startOfDate(this.year(), this.month() - this.month() % 3 + 3, 1) - 1;
	                break;
	            case 'month':
	                time = startOfDate(this.year(), this.month() + 1, 1) - 1;
	                break;
	            case 'week':
	                time = startOfDate(this.year(), this.month(), this.date() - this.weekday() + 7) - 1;
	                break;
	            case 'isoWeek':
	                time = startOfDate(this.year(), this.month(), this.date() - (this.isoWeekday() - 1) + 7) - 1;
	                break;
	            case 'day':
	            case 'date':
	                time = startOfDate(this.year(), this.month(), this.date() + 1) - 1;
	                break;
	            case 'hour':
	                time = this._d.valueOf();
	                time += MS_PER_HOUR - mod$1(time + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE), MS_PER_HOUR) - 1;
	                break;
	            case 'minute':
	                time = this._d.valueOf();
	                time += MS_PER_MINUTE - mod$1(time, MS_PER_MINUTE) - 1;
	                break;
	            case 'second':
	                time = this._d.valueOf();
	                time += MS_PER_SECOND - mod$1(time, MS_PER_SECOND) - 1;
	                break;
	        }

	        this._d.setTime(time);
	        hooks.updateOffset(this, true);
	        return this;
	    }

	    function valueOf () {
	        return this._d.valueOf() - ((this._offset || 0) * 60000);
	    }

	    function unix () {
	        return Math.floor(this.valueOf() / 1000);
	    }

	    function toDate () {
	        return new Date(this.valueOf());
	    }

	    function toArray () {
	        var m = this;
	        return [m.year(), m.month(), m.date(), m.hour(), m.minute(), m.second(), m.millisecond()];
	    }

	    function toObject () {
	        var m = this;
	        return {
	            years: m.year(),
	            months: m.month(),
	            date: m.date(),
	            hours: m.hours(),
	            minutes: m.minutes(),
	            seconds: m.seconds(),
	            milliseconds: m.milliseconds()
	        };
	    }

	    function toJSON () {
	        // new Date(NaN).toJSON() === null
	        return this.isValid() ? this.toISOString() : null;
	    }

	    function isValid$2 () {
	        return isValid(this);
	    }

	    function parsingFlags () {
	        return extend({}, getParsingFlags(this));
	    }

	    function invalidAt () {
	        return getParsingFlags(this).overflow;
	    }

	    function creationData() {
	        return {
	            input: this._i,
	            format: this._f,
	            locale: this._locale,
	            isUTC: this._isUTC,
	            strict: this._strict
	        };
	    }

	    // FORMATTING

	    addFormatToken(0, ['gg', 2], 0, function () {
	        return this.weekYear() % 100;
	    });

	    addFormatToken(0, ['GG', 2], 0, function () {
	        return this.isoWeekYear() % 100;
	    });

	    function addWeekYearFormatToken (token, getter) {
	        addFormatToken(0, [token, token.length], 0, getter);
	    }

	    addWeekYearFormatToken('gggg',     'weekYear');
	    addWeekYearFormatToken('ggggg',    'weekYear');
	    addWeekYearFormatToken('GGGG',  'isoWeekYear');
	    addWeekYearFormatToken('GGGGG', 'isoWeekYear');

	    // ALIASES

	    addUnitAlias('weekYear', 'gg');
	    addUnitAlias('isoWeekYear', 'GG');

	    // PRIORITY

	    addUnitPriority('weekYear', 1);
	    addUnitPriority('isoWeekYear', 1);


	    // PARSING

	    addRegexToken('G',      matchSigned);
	    addRegexToken('g',      matchSigned);
	    addRegexToken('GG',     match1to2, match2);
	    addRegexToken('gg',     match1to2, match2);
	    addRegexToken('GGGG',   match1to4, match4);
	    addRegexToken('gggg',   match1to4, match4);
	    addRegexToken('GGGGG',  match1to6, match6);
	    addRegexToken('ggggg',  match1to6, match6);

	    addWeekParseToken(['gggg', 'ggggg', 'GGGG', 'GGGGG'], function (input, week, config, token) {
	        week[token.substr(0, 2)] = toInt(input);
	    });

	    addWeekParseToken(['gg', 'GG'], function (input, week, config, token) {
	        week[token] = hooks.parseTwoDigitYear(input);
	    });

	    // MOMENTS

	    function getSetWeekYear (input) {
	        return getSetWeekYearHelper.call(this,
	                input,
	                this.week(),
	                this.weekday(),
	                this.localeData()._week.dow,
	                this.localeData()._week.doy);
	    }

	    function getSetISOWeekYear (input) {
	        return getSetWeekYearHelper.call(this,
	                input, this.isoWeek(), this.isoWeekday(), 1, 4);
	    }

	    function getISOWeeksInYear () {
	        return weeksInYear(this.year(), 1, 4);
	    }

	    function getWeeksInYear () {
	        var weekInfo = this.localeData()._week;
	        return weeksInYear(this.year(), weekInfo.dow, weekInfo.doy);
	    }

	    function getSetWeekYearHelper(input, week, weekday, dow, doy) {
	        var weeksTarget;
	        if (input == null) {
	            return weekOfYear(this, dow, doy).year;
	        } else {
	            weeksTarget = weeksInYear(input, dow, doy);
	            if (week > weeksTarget) {
	                week = weeksTarget;
	            }
	            return setWeekAll.call(this, input, week, weekday, dow, doy);
	        }
	    }

	    function setWeekAll(weekYear, week, weekday, dow, doy) {
	        var dayOfYearData = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy),
	            date = createUTCDate(dayOfYearData.year, 0, dayOfYearData.dayOfYear);

	        this.year(date.getUTCFullYear());
	        this.month(date.getUTCMonth());
	        this.date(date.getUTCDate());
	        return this;
	    }

	    // FORMATTING

	    addFormatToken('Q', 0, 'Qo', 'quarter');

	    // ALIASES

	    addUnitAlias('quarter', 'Q');

	    // PRIORITY

	    addUnitPriority('quarter', 7);

	    // PARSING

	    addRegexToken('Q', match1);
	    addParseToken('Q', function (input, array) {
	        array[MONTH] = (toInt(input) - 1) * 3;
	    });

	    // MOMENTS

	    function getSetQuarter (input) {
	        return input == null ? Math.ceil((this.month() + 1) / 3) : this.month((input - 1) * 3 + this.month() % 3);
	    }

	    // FORMATTING

	    addFormatToken('D', ['DD', 2], 'Do', 'date');

	    // ALIASES

	    addUnitAlias('date', 'D');

	    // PRIORITY
	    addUnitPriority('date', 9);

	    // PARSING

	    addRegexToken('D',  match1to2);
	    addRegexToken('DD', match1to2, match2);
	    addRegexToken('Do', function (isStrict, locale) {
	        // TODO: Remove "ordinalParse" fallback in next major release.
	        return isStrict ?
	          (locale._dayOfMonthOrdinalParse || locale._ordinalParse) :
	          locale._dayOfMonthOrdinalParseLenient;
	    });

	    addParseToken(['D', 'DD'], DATE);
	    addParseToken('Do', function (input, array) {
	        array[DATE] = toInt(input.match(match1to2)[0]);
	    });

	    // MOMENTS

	    var getSetDayOfMonth = makeGetSet('Date', true);

	    // FORMATTING

	    addFormatToken('DDD', ['DDDD', 3], 'DDDo', 'dayOfYear');

	    // ALIASES

	    addUnitAlias('dayOfYear', 'DDD');

	    // PRIORITY
	    addUnitPriority('dayOfYear', 4);

	    // PARSING

	    addRegexToken('DDD',  match1to3);
	    addRegexToken('DDDD', match3);
	    addParseToken(['DDD', 'DDDD'], function (input, array, config) {
	        config._dayOfYear = toInt(input);
	    });

	    // HELPERS

	    // MOMENTS

	    function getSetDayOfYear (input) {
	        var dayOfYear = Math.round((this.clone().startOf('day') - this.clone().startOf('year')) / 864e5) + 1;
	        return input == null ? dayOfYear : this.add((input - dayOfYear), 'd');
	    }

	    // FORMATTING

	    addFormatToken('m', ['mm', 2], 0, 'minute');

	    // ALIASES

	    addUnitAlias('minute', 'm');

	    // PRIORITY

	    addUnitPriority('minute', 14);

	    // PARSING

	    addRegexToken('m',  match1to2);
	    addRegexToken('mm', match1to2, match2);
	    addParseToken(['m', 'mm'], MINUTE);

	    // MOMENTS

	    var getSetMinute = makeGetSet('Minutes', false);

	    // FORMATTING

	    addFormatToken('s', ['ss', 2], 0, 'second');

	    // ALIASES

	    addUnitAlias('second', 's');

	    // PRIORITY

	    addUnitPriority('second', 15);

	    // PARSING

	    addRegexToken('s',  match1to2);
	    addRegexToken('ss', match1to2, match2);
	    addParseToken(['s', 'ss'], SECOND);

	    // MOMENTS

	    var getSetSecond = makeGetSet('Seconds', false);

	    // FORMATTING

	    addFormatToken('S', 0, 0, function () {
	        return ~~(this.millisecond() / 100);
	    });

	    addFormatToken(0, ['SS', 2], 0, function () {
	        return ~~(this.millisecond() / 10);
	    });

	    addFormatToken(0, ['SSS', 3], 0, 'millisecond');
	    addFormatToken(0, ['SSSS', 4], 0, function () {
	        return this.millisecond() * 10;
	    });
	    addFormatToken(0, ['SSSSS', 5], 0, function () {
	        return this.millisecond() * 100;
	    });
	    addFormatToken(0, ['SSSSSS', 6], 0, function () {
	        return this.millisecond() * 1000;
	    });
	    addFormatToken(0, ['SSSSSSS', 7], 0, function () {
	        return this.millisecond() * 10000;
	    });
	    addFormatToken(0, ['SSSSSSSS', 8], 0, function () {
	        return this.millisecond() * 100000;
	    });
	    addFormatToken(0, ['SSSSSSSSS', 9], 0, function () {
	        return this.millisecond() * 1000000;
	    });


	    // ALIASES

	    addUnitAlias('millisecond', 'ms');

	    // PRIORITY

	    addUnitPriority('millisecond', 16);

	    // PARSING

	    addRegexToken('S',    match1to3, match1);
	    addRegexToken('SS',   match1to3, match2);
	    addRegexToken('SSS',  match1to3, match3);

	    var token;
	    for (token = 'SSSS'; token.length <= 9; token += 'S') {
	        addRegexToken(token, matchUnsigned);
	    }

	    function parseMs(input, array) {
	        array[MILLISECOND] = toInt(('0.' + input) * 1000);
	    }

	    for (token = 'S'; token.length <= 9; token += 'S') {
	        addParseToken(token, parseMs);
	    }
	    // MOMENTS

	    var getSetMillisecond = makeGetSet('Milliseconds', false);

	    // FORMATTING

	    addFormatToken('z',  0, 0, 'zoneAbbr');
	    addFormatToken('zz', 0, 0, 'zoneName');

	    // MOMENTS

	    function getZoneAbbr () {
	        return this._isUTC ? 'UTC' : '';
	    }

	    function getZoneName () {
	        return this._isUTC ? 'Coordinated Universal Time' : '';
	    }

	    var proto = Moment.prototype;

	    proto.add               = add;
	    proto.calendar          = calendar$1;
	    proto.clone             = clone;
	    proto.diff              = diff;
	    proto.endOf             = endOf;
	    proto.format            = format;
	    proto.from              = from;
	    proto.fromNow           = fromNow;
	    proto.to                = to;
	    proto.toNow             = toNow;
	    proto.get               = stringGet;
	    proto.invalidAt         = invalidAt;
	    proto.isAfter           = isAfter;
	    proto.isBefore          = isBefore;
	    proto.isBetween         = isBetween;
	    proto.isSame            = isSame;
	    proto.isSameOrAfter     = isSameOrAfter;
	    proto.isSameOrBefore    = isSameOrBefore;
	    proto.isValid           = isValid$2;
	    proto.lang              = lang;
	    proto.locale            = locale;
	    proto.localeData        = localeData;
	    proto.max               = prototypeMax;
	    proto.min               = prototypeMin;
	    proto.parsingFlags      = parsingFlags;
	    proto.set               = stringSet;
	    proto.startOf           = startOf;
	    proto.subtract          = subtract;
	    proto.toArray           = toArray;
	    proto.toObject          = toObject;
	    proto.toDate            = toDate;
	    proto.toISOString       = toISOString;
	    proto.inspect           = inspect;
	    proto.toJSON            = toJSON;
	    proto.toString          = toString;
	    proto.unix              = unix;
	    proto.valueOf           = valueOf;
	    proto.creationData      = creationData;
	    proto.year       = getSetYear;
	    proto.isLeapYear = getIsLeapYear;
	    proto.weekYear    = getSetWeekYear;
	    proto.isoWeekYear = getSetISOWeekYear;
	    proto.quarter = proto.quarters = getSetQuarter;
	    proto.month       = getSetMonth;
	    proto.daysInMonth = getDaysInMonth;
	    proto.week           = proto.weeks        = getSetWeek;
	    proto.isoWeek        = proto.isoWeeks     = getSetISOWeek;
	    proto.weeksInYear    = getWeeksInYear;
	    proto.isoWeeksInYear = getISOWeeksInYear;
	    proto.date       = getSetDayOfMonth;
	    proto.day        = proto.days             = getSetDayOfWeek;
	    proto.weekday    = getSetLocaleDayOfWeek;
	    proto.isoWeekday = getSetISODayOfWeek;
	    proto.dayOfYear  = getSetDayOfYear;
	    proto.hour = proto.hours = getSetHour;
	    proto.minute = proto.minutes = getSetMinute;
	    proto.second = proto.seconds = getSetSecond;
	    proto.millisecond = proto.milliseconds = getSetMillisecond;
	    proto.utcOffset            = getSetOffset;
	    proto.utc                  = setOffsetToUTC;
	    proto.local                = setOffsetToLocal;
	    proto.parseZone            = setOffsetToParsedOffset;
	    proto.hasAlignedHourOffset = hasAlignedHourOffset;
	    proto.isDST                = isDaylightSavingTime;
	    proto.isLocal              = isLocal;
	    proto.isUtcOffset          = isUtcOffset;
	    proto.isUtc                = isUtc;
	    proto.isUTC                = isUtc;
	    proto.zoneAbbr = getZoneAbbr;
	    proto.zoneName = getZoneName;
	    proto.dates  = deprecate('dates accessor is deprecated. Use date instead.', getSetDayOfMonth);
	    proto.months = deprecate('months accessor is deprecated. Use month instead', getSetMonth);
	    proto.years  = deprecate('years accessor is deprecated. Use year instead', getSetYear);
	    proto.zone   = deprecate('moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/', getSetZone);
	    proto.isDSTShifted = deprecate('isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information', isDaylightSavingTimeShifted);

	    function createUnix (input) {
	        return createLocal(input * 1000);
	    }

	    function createInZone () {
	        return createLocal.apply(null, arguments).parseZone();
	    }

	    function preParsePostFormat (string) {
	        return string;
	    }

	    var proto$1 = Locale.prototype;

	    proto$1.calendar        = calendar;
	    proto$1.longDateFormat  = longDateFormat;
	    proto$1.invalidDate     = invalidDate;
	    proto$1.ordinal         = ordinal;
	    proto$1.preparse        = preParsePostFormat;
	    proto$1.postformat      = preParsePostFormat;
	    proto$1.relativeTime    = relativeTime;
	    proto$1.pastFuture      = pastFuture;
	    proto$1.set             = set;

	    proto$1.months            =        localeMonths;
	    proto$1.monthsShort       =        localeMonthsShort;
	    proto$1.monthsParse       =        localeMonthsParse;
	    proto$1.monthsRegex       = monthsRegex;
	    proto$1.monthsShortRegex  = monthsShortRegex;
	    proto$1.week = localeWeek;
	    proto$1.firstDayOfYear = localeFirstDayOfYear;
	    proto$1.firstDayOfWeek = localeFirstDayOfWeek;

	    proto$1.weekdays       =        localeWeekdays;
	    proto$1.weekdaysMin    =        localeWeekdaysMin;
	    proto$1.weekdaysShort  =        localeWeekdaysShort;
	    proto$1.weekdaysParse  =        localeWeekdaysParse;

	    proto$1.weekdaysRegex       =        weekdaysRegex;
	    proto$1.weekdaysShortRegex  =        weekdaysShortRegex;
	    proto$1.weekdaysMinRegex    =        weekdaysMinRegex;

	    proto$1.isPM = localeIsPM;
	    proto$1.meridiem = localeMeridiem;

	    function get$1 (format, index, field, setter) {
	        var locale = getLocale();
	        var utc = createUTC().set(setter, index);
	        return locale[field](utc, format);
	    }

	    function listMonthsImpl (format, index, field) {
	        if (isNumber(format)) {
	            index = format;
	            format = undefined;
	        }

	        format = format || '';

	        if (index != null) {
	            return get$1(format, index, field, 'month');
	        }

	        var i;
	        var out = [];
	        for (i = 0; i < 12; i++) {
	            out[i] = get$1(format, i, field, 'month');
	        }
	        return out;
	    }

	    // ()
	    // (5)
	    // (fmt, 5)
	    // (fmt)
	    // (true)
	    // (true, 5)
	    // (true, fmt, 5)
	    // (true, fmt)
	    function listWeekdaysImpl (localeSorted, format, index, field) {
	        if (typeof localeSorted === 'boolean') {
	            if (isNumber(format)) {
	                index = format;
	                format = undefined;
	            }

	            format = format || '';
	        } else {
	            format = localeSorted;
	            index = format;
	            localeSorted = false;

	            if (isNumber(format)) {
	                index = format;
	                format = undefined;
	            }

	            format = format || '';
	        }

	        var locale = getLocale(),
	            shift = localeSorted ? locale._week.dow : 0;

	        if (index != null) {
	            return get$1(format, (index + shift) % 7, field, 'day');
	        }

	        var i;
	        var out = [];
	        for (i = 0; i < 7; i++) {
	            out[i] = get$1(format, (i + shift) % 7, field, 'day');
	        }
	        return out;
	    }

	    function listMonths (format, index) {
	        return listMonthsImpl(format, index, 'months');
	    }

	    function listMonthsShort (format, index) {
	        return listMonthsImpl(format, index, 'monthsShort');
	    }

	    function listWeekdays (localeSorted, format, index) {
	        return listWeekdaysImpl(localeSorted, format, index, 'weekdays');
	    }

	    function listWeekdaysShort (localeSorted, format, index) {
	        return listWeekdaysImpl(localeSorted, format, index, 'weekdaysShort');
	    }

	    function listWeekdaysMin (localeSorted, format, index) {
	        return listWeekdaysImpl(localeSorted, format, index, 'weekdaysMin');
	    }

	    getSetGlobalLocale('en', {
	        dayOfMonthOrdinalParse: /\d{1,2}(th|st|nd|rd)/,
	        ordinal : function (number) {
	            var b = number % 10,
	                output = (toInt(number % 100 / 10) === 1) ? 'th' :
	                (b === 1) ? 'st' :
	                (b === 2) ? 'nd' :
	                (b === 3) ? 'rd' : 'th';
	            return number + output;
	        }
	    });

	    // Side effect imports

	    hooks.lang = deprecate('moment.lang is deprecated. Use moment.locale instead.', getSetGlobalLocale);
	    hooks.langData = deprecate('moment.langData is deprecated. Use moment.localeData instead.', getLocale);

	    var mathAbs = Math.abs;

	    function abs () {
	        var data           = this._data;

	        this._milliseconds = mathAbs(this._milliseconds);
	        this._days         = mathAbs(this._days);
	        this._months       = mathAbs(this._months);

	        data.milliseconds  = mathAbs(data.milliseconds);
	        data.seconds       = mathAbs(data.seconds);
	        data.minutes       = mathAbs(data.minutes);
	        data.hours         = mathAbs(data.hours);
	        data.months        = mathAbs(data.months);
	        data.years         = mathAbs(data.years);

	        return this;
	    }

	    function addSubtract$1 (duration, input, value, direction) {
	        var other = createDuration(input, value);

	        duration._milliseconds += direction * other._milliseconds;
	        duration._days         += direction * other._days;
	        duration._months       += direction * other._months;

	        return duration._bubble();
	    }

	    // supports only 2.0-style add(1, 's') or add(duration)
	    function add$1 (input, value) {
	        return addSubtract$1(this, input, value, 1);
	    }

	    // supports only 2.0-style subtract(1, 's') or subtract(duration)
	    function subtract$1 (input, value) {
	        return addSubtract$1(this, input, value, -1);
	    }

	    function absCeil (number) {
	        if (number < 0) {
	            return Math.floor(number);
	        } else {
	            return Math.ceil(number);
	        }
	    }

	    function bubble () {
	        var milliseconds = this._milliseconds;
	        var days         = this._days;
	        var months       = this._months;
	        var data         = this._data;
	        var seconds, minutes, hours, years, monthsFromDays;

	        // if we have a mix of positive and negative values, bubble down first
	        // check: https://github.com/moment/moment/issues/2166
	        if (!((milliseconds >= 0 && days >= 0 && months >= 0) ||
	                (milliseconds <= 0 && days <= 0 && months <= 0))) {
	            milliseconds += absCeil(monthsToDays(months) + days) * 864e5;
	            days = 0;
	            months = 0;
	        }

	        // The following code bubbles up values, see the tests for
	        // examples of what that means.
	        data.milliseconds = milliseconds % 1000;

	        seconds           = absFloor(milliseconds / 1000);
	        data.seconds      = seconds % 60;

	        minutes           = absFloor(seconds / 60);
	        data.minutes      = minutes % 60;

	        hours             = absFloor(minutes / 60);
	        data.hours        = hours % 24;

	        days += absFloor(hours / 24);

	        // convert days to months
	        monthsFromDays = absFloor(daysToMonths(days));
	        months += monthsFromDays;
	        days -= absCeil(monthsToDays(monthsFromDays));

	        // 12 months -> 1 year
	        years = absFloor(months / 12);
	        months %= 12;

	        data.days   = days;
	        data.months = months;
	        data.years  = years;

	        return this;
	    }

	    function daysToMonths (days) {
	        // 400 years have 146097 days (taking into account leap year rules)
	        // 400 years have 12 months === 4800
	        return days * 4800 / 146097;
	    }

	    function monthsToDays (months) {
	        // the reverse of daysToMonths
	        return months * 146097 / 4800;
	    }

	    function as (units) {
	        if (!this.isValid()) {
	            return NaN;
	        }
	        var days;
	        var months;
	        var milliseconds = this._milliseconds;

	        units = normalizeUnits(units);

	        if (units === 'month' || units === 'quarter' || units === 'year') {
	            days = this._days + milliseconds / 864e5;
	            months = this._months + daysToMonths(days);
	            switch (units) {
	                case 'month':   return months;
	                case 'quarter': return months / 3;
	                case 'year':    return months / 12;
	            }
	        } else {
	            // handle milliseconds separately because of floating point math errors (issue #1867)
	            days = this._days + Math.round(monthsToDays(this._months));
	            switch (units) {
	                case 'week'   : return days / 7     + milliseconds / 6048e5;
	                case 'day'    : return days         + milliseconds / 864e5;
	                case 'hour'   : return days * 24    + milliseconds / 36e5;
	                case 'minute' : return days * 1440  + milliseconds / 6e4;
	                case 'second' : return days * 86400 + milliseconds / 1000;
	                // Math.floor prevents floating point math errors here
	                case 'millisecond': return Math.floor(days * 864e5) + milliseconds;
	                default: throw new Error('Unknown unit ' + units);
	            }
	        }
	    }

	    // TODO: Use this.as('ms')?
	    function valueOf$1 () {
	        if (!this.isValid()) {
	            return NaN;
	        }
	        return (
	            this._milliseconds +
	            this._days * 864e5 +
	            (this._months % 12) * 2592e6 +
	            toInt(this._months / 12) * 31536e6
	        );
	    }

	    function makeAs (alias) {
	        return function () {
	            return this.as(alias);
	        };
	    }

	    var asMilliseconds = makeAs('ms');
	    var asSeconds      = makeAs('s');
	    var asMinutes      = makeAs('m');
	    var asHours        = makeAs('h');
	    var asDays         = makeAs('d');
	    var asWeeks        = makeAs('w');
	    var asMonths       = makeAs('M');
	    var asQuarters     = makeAs('Q');
	    var asYears        = makeAs('y');

	    function clone$1 () {
	        return createDuration(this);
	    }

	    function get$2 (units) {
	        units = normalizeUnits(units);
	        return this.isValid() ? this[units + 's']() : NaN;
	    }

	    function makeGetter(name) {
	        return function () {
	            return this.isValid() ? this._data[name] : NaN;
	        };
	    }

	    var milliseconds = makeGetter('milliseconds');
	    var seconds      = makeGetter('seconds');
	    var minutes      = makeGetter('minutes');
	    var hours        = makeGetter('hours');
	    var days         = makeGetter('days');
	    var months       = makeGetter('months');
	    var years        = makeGetter('years');

	    function weeks () {
	        return absFloor(this.days() / 7);
	    }

	    var round = Math.round;
	    var thresholds = {
	        ss: 44,         // a few seconds to seconds
	        s : 45,         // seconds to minute
	        m : 45,         // minutes to hour
	        h : 22,         // hours to day
	        d : 26,         // days to month
	        M : 11          // months to year
	    };

	    // helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize
	    function substituteTimeAgo(string, number, withoutSuffix, isFuture, locale) {
	        return locale.relativeTime(number || 1, !!withoutSuffix, string, isFuture);
	    }

	    function relativeTime$1 (posNegDuration, withoutSuffix, locale) {
	        var duration = createDuration(posNegDuration).abs();
	        var seconds  = round(duration.as('s'));
	        var minutes  = round(duration.as('m'));
	        var hours    = round(duration.as('h'));
	        var days     = round(duration.as('d'));
	        var months   = round(duration.as('M'));
	        var years    = round(duration.as('y'));

	        var a = seconds <= thresholds.ss && ['s', seconds]  ||
	                seconds < thresholds.s   && ['ss', seconds] ||
	                minutes <= 1             && ['m']           ||
	                minutes < thresholds.m   && ['mm', minutes] ||
	                hours   <= 1             && ['h']           ||
	                hours   < thresholds.h   && ['hh', hours]   ||
	                days    <= 1             && ['d']           ||
	                days    < thresholds.d   && ['dd', days]    ||
	                months  <= 1             && ['M']           ||
	                months  < thresholds.M   && ['MM', months]  ||
	                years   <= 1             && ['y']           || ['yy', years];

	        a[2] = withoutSuffix;
	        a[3] = +posNegDuration > 0;
	        a[4] = locale;
	        return substituteTimeAgo.apply(null, a);
	    }

	    // This function allows you to set the rounding function for relative time strings
	    function getSetRelativeTimeRounding (roundingFunction) {
	        if (roundingFunction === undefined) {
	            return round;
	        }
	        if (typeof(roundingFunction) === 'function') {
	            round = roundingFunction;
	            return true;
	        }
	        return false;
	    }

	    // This function allows you to set a threshold for relative time strings
	    function getSetRelativeTimeThreshold (threshold, limit) {
	        if (thresholds[threshold] === undefined) {
	            return false;
	        }
	        if (limit === undefined) {
	            return thresholds[threshold];
	        }
	        thresholds[threshold] = limit;
	        if (threshold === 's') {
	            thresholds.ss = limit - 1;
	        }
	        return true;
	    }

	    function humanize (withSuffix) {
	        if (!this.isValid()) {
	            return this.localeData().invalidDate();
	        }

	        var locale = this.localeData();
	        var output = relativeTime$1(this, !withSuffix, locale);

	        if (withSuffix) {
	            output = locale.pastFuture(+this, output);
	        }

	        return locale.postformat(output);
	    }

	    var abs$1 = Math.abs;

	    function sign(x) {
	        return ((x > 0) - (x < 0)) || +x;
	    }

	    function toISOString$1() {
	        // for ISO strings we do not use the normal bubbling rules:
	        //  * milliseconds bubble up until they become hours
	        //  * days do not bubble at all
	        //  * months bubble up until they become years
	        // This is because there is no context-free conversion between hours and days
	        // (think of clock changes)
	        // and also not between days and months (28-31 days per month)
	        if (!this.isValid()) {
	            return this.localeData().invalidDate();
	        }

	        var seconds = abs$1(this._milliseconds) / 1000;
	        var days         = abs$1(this._days);
	        var months       = abs$1(this._months);
	        var minutes, hours, years;

	        // 3600 seconds -> 60 minutes -> 1 hour
	        minutes           = absFloor(seconds / 60);
	        hours             = absFloor(minutes / 60);
	        seconds %= 60;
	        minutes %= 60;

	        // 12 months -> 1 year
	        years  = absFloor(months / 12);
	        months %= 12;


	        // inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js
	        var Y = years;
	        var M = months;
	        var D = days;
	        var h = hours;
	        var m = minutes;
	        var s = seconds ? seconds.toFixed(3).replace(/\.?0+$/, '') : '';
	        var total = this.asSeconds();

	        if (!total) {
	            // this is the same as C#'s (Noda) and python (isodate)...
	            // but not other JS (goog.date)
	            return 'P0D';
	        }

	        var totalSign = total < 0 ? '-' : '';
	        var ymSign = sign(this._months) !== sign(total) ? '-' : '';
	        var daysSign = sign(this._days) !== sign(total) ? '-' : '';
	        var hmsSign = sign(this._milliseconds) !== sign(total) ? '-' : '';

	        return totalSign + 'P' +
	            (Y ? ymSign + Y + 'Y' : '') +
	            (M ? ymSign + M + 'M' : '') +
	            (D ? daysSign + D + 'D' : '') +
	            ((h || m || s) ? 'T' : '') +
	            (h ? hmsSign + h + 'H' : '') +
	            (m ? hmsSign + m + 'M' : '') +
	            (s ? hmsSign + s + 'S' : '');
	    }

	    var proto$2 = Duration.prototype;

	    proto$2.isValid        = isValid$1;
	    proto$2.abs            = abs;
	    proto$2.add            = add$1;
	    proto$2.subtract       = subtract$1;
	    proto$2.as             = as;
	    proto$2.asMilliseconds = asMilliseconds;
	    proto$2.asSeconds      = asSeconds;
	    proto$2.asMinutes      = asMinutes;
	    proto$2.asHours        = asHours;
	    proto$2.asDays         = asDays;
	    proto$2.asWeeks        = asWeeks;
	    proto$2.asMonths       = asMonths;
	    proto$2.asQuarters     = asQuarters;
	    proto$2.asYears        = asYears;
	    proto$2.valueOf        = valueOf$1;
	    proto$2._bubble        = bubble;
	    proto$2.clone          = clone$1;
	    proto$2.get            = get$2;
	    proto$2.milliseconds   = milliseconds;
	    proto$2.seconds        = seconds;
	    proto$2.minutes        = minutes;
	    proto$2.hours          = hours;
	    proto$2.days           = days;
	    proto$2.weeks          = weeks;
	    proto$2.months         = months;
	    proto$2.years          = years;
	    proto$2.humanize       = humanize;
	    proto$2.toISOString    = toISOString$1;
	    proto$2.toString       = toISOString$1;
	    proto$2.toJSON         = toISOString$1;
	    proto$2.locale         = locale;
	    proto$2.localeData     = localeData;

	    proto$2.toIsoString = deprecate('toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)', toISOString$1);
	    proto$2.lang = lang;

	    // Side effect imports

	    // FORMATTING

	    addFormatToken('X', 0, 0, 'unix');
	    addFormatToken('x', 0, 0, 'valueOf');

	    // PARSING

	    addRegexToken('x', matchSigned);
	    addRegexToken('X', matchTimestamp);
	    addParseToken('X', function (input, array, config) {
	        config._d = new Date(parseFloat(input, 10) * 1000);
	    });
	    addParseToken('x', function (input, array, config) {
	        config._d = new Date(toInt(input));
	    });

	    // Side effect imports


	    hooks.version = '2.24.0';

	    setHookCallback(createLocal);

	    hooks.fn                    = proto;
	    hooks.min                   = min;
	    hooks.max                   = max;
	    hooks.now                   = now;
	    hooks.utc                   = createUTC;
	    hooks.unix                  = createUnix;
	    hooks.months                = listMonths;
	    hooks.isDate                = isDate;
	    hooks.locale                = getSetGlobalLocale;
	    hooks.invalid               = createInvalid;
	    hooks.duration              = createDuration;
	    hooks.isMoment              = isMoment;
	    hooks.weekdays              = listWeekdays;
	    hooks.parseZone             = createInZone;
	    hooks.localeData            = getLocale;
	    hooks.isDuration            = isDuration;
	    hooks.monthsShort           = listMonthsShort;
	    hooks.weekdaysMin           = listWeekdaysMin;
	    hooks.defineLocale          = defineLocale;
	    hooks.updateLocale          = updateLocale;
	    hooks.locales               = listLocales;
	    hooks.weekdaysShort         = listWeekdaysShort;
	    hooks.normalizeUnits        = normalizeUnits;
	    hooks.relativeTimeRounding  = getSetRelativeTimeRounding;
	    hooks.relativeTimeThreshold = getSetRelativeTimeThreshold;
	    hooks.calendarFormat        = getCalendarFormat;
	    hooks.prototype             = proto;

	    // currently HTML5 input type only supports 24-hour formats
	    hooks.HTML5_FMT = {
	        DATETIME_LOCAL: 'YYYY-MM-DDTHH:mm',             // <input type="datetime-local" />
	        DATETIME_LOCAL_SECONDS: 'YYYY-MM-DDTHH:mm:ss',  // <input type="datetime-local" step="1" />
	        DATETIME_LOCAL_MS: 'YYYY-MM-DDTHH:mm:ss.SSS',   // <input type="datetime-local" step="0.001" />
	        DATE: 'YYYY-MM-DD',                             // <input type="date" />
	        TIME: 'HH:mm',                                  // <input type="time" />
	        TIME_SECONDS: 'HH:mm:ss',                       // <input type="time" step="1" />
	        TIME_MS: 'HH:mm:ss.SSS',                        // <input type="time" step="0.001" />
	        WEEK: 'GGGG-[W]WW',                             // <input type="week" />
	        MONTH: 'YYYY-MM'                                // <input type="month" />
	    };

	    return hooks;

	})));
	});

	function type () {
	  var arguments$1 = arguments;

	  for (var _len = arguments.length, types = new Array(_len), _key = 0; _key < _len; _key++) {
	    types[_key] = arguments$1[_key];
	  }

	  types.push('');
	  return {
	    props: {
	      type: {
	        type: String,
	        default: '',
	        validator: function validator(value) {
	          return types.indexOf(value) !== -1;
	        }
	      }
	    }
	  };
	}

	var disabled = {
	  props: {
	    disabled: {
	      type: Boolean,
	      default: false
	    }
	  }
	};

	function _defineProperty(obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }

	  return obj;
	}

	function _extends() {
	  _extends = Object.assign || function (target) {
	    for (var i = 1; i < arguments.length; i++) {
	      var source = arguments[i];

	      for (var key in source) {
	        if (Object.prototype.hasOwnProperty.call(source, key)) {
	          target[key] = source[key];
	        }
	      }
	    }

	    return target;
	  };

	  return _extends.apply(this, arguments);
	}

	var icon = {
	  props: {
	    icon: String
	  },
	  computed: {
	    iconClass: function iconClass() {
	      return _defineProperty({}, "ms-Icon--".concat(this.icon), !!this.icon);
	    }
	  }
	};

	var button = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('button',{staticClass:"ms-Button",class:_vm.buttonClass,on:{"click":_vm.clickEvent}},[(_vm.icon && _vm.type == 'hero')?_c('span',{staticClass:"ms-Button-icon"},[_c('i',{staticClass:"ms-Icon",class:_vm.iconClass})]):_vm._e(),_vm._v(" "),_c('span',{staticClass:"ms-Button-label"},[_vm._t("default")],2),_vm._v(" "),(_vm.description && _vm.type == 'compound')?_c('span',{staticClass:"ms-Button-description"},[_vm._v(" "+_vm._s(_vm.description)+" ")]):_vm._e()])},staticRenderFns: [],
	  name: 'ou-button',

	  mixins: [
	    type('primary', 'hero', 'compound', 'small', 'default'),
	    disabled,
	    icon
	  ],

	  props: {
	    description: String
	  },

	  computed: {
	    buttonClass: function buttonClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-Button--" + (this.type))] = !!this.type, obj['is-disabled'] =  this.disabled, obj );
	    }
	  },

	  methods: {
	    clickEvent: function clickEvent() {
	      if (!this.disabled) { this.$emit('click'); }
	    }
	  }
	};

	var uiButton = {_scopeId: 'data-v-79820dd6',
	    beforeCreate: function beforeCreate(){ loadThemedStyles.loadStyles("/* Your use of the content in the files referenced here are subject to the terms of the license at http://aka.ms/fabric-font-license */ /* Theme related color values */ /* Natural Colors */ /* Base Colors */ /** Black #000 **/ /** Blue #0078d7 **/ /** Green #107c10 **/ /** Green #b4009e **/ /** Orange #d83b01 **/ /** Purble #5c2d91 **/ /** Red #e81123 **/ /*** Teal ***/ /** White **/ /** Yellow **/ /* State Colors */ /** Alerts **/ /** Error **/ /** Info ***/ /** Warning **/ /** Server Warning **/ /** Success **/ /* Get css for state objects for: alert, error, info, servere, success This includes color and background styles */ /* Get css for state objects for: alert, error, info, servere, success This includes only the color values */ /*** 100 Thin (Hairline) 200 Extra Light (Ultra Light) 300 Light 400 Normal 500 Medium 600 Semi Bold (Demi Bold) 700 Bold 800 Extra Bold (Ultra Bold) 900 Black (Heavy) **/ /* Natural Colors */ /* Base Colors */ /** Black #000 **/ /** Blue #0078d7 **/ /** Green #107c10 **/ /** Green #b4009e **/ /** Orange #d83b01 **/ /** Purble #5c2d91 **/ /** Red #e81123 **/ /*** Teal ***/ /** White **/ /** Yellow **/ /* State Colors */ /** Alerts **/ /** Error **/ /** Info ***/ /** Warning **/ /** Server Warning **/ /** Success **/ .ms-Button[data-v-79820dd6] { box-sizing: border-box; margin: 0; padding: 0; -webkit-box-shadow: none; -moz-box-shadow: none; box-shadow: none; font-family: \"Segoe UI WestEuropean\", \"Segoe UI\", -apple-system, BlinkMacSystemFont, \"Roboto\", \"Helvetica Neue\", sans-serif; -webkit-font-smoothing: antialiased; color: \"[theme:neutralPrimary, default: #333333]\"; font-size: 14px; font-weight: 400; background-color: \"[theme:neutralLighter, default: #f4f4f4]\"; border: 1px solid \"[theme:neutralLighter, default: #f4f4f4]\"; cursor: pointer; display: inline-block; height: 32px; min-width: 80px; padding: 4px 20px 6px; } .ms-Button.is-hidden[data-v-79820dd6] { display: none; } .ms-Button[data-v-79820dd6]:hover { background-color: \"[theme:neutralLight, default: #eaeaea]\"; border-color: \"[theme:neutralLight, default: #eaeaea]\"; } .ms-Button:hover .ms-Button-label[data-v-79820dd6] { color: \"[theme:black, default: #000000]\"; } @media screen and (-ms-high-contrast: active) { .ms-Button[data-v-79820dd6]:hover { color: #1AEBFF; border-color: #1AEBFF; } } @media screen and (-ms-high-contrast: black-on-white) { .ms-Button[data-v-79820dd6]:hover { color: #37006E; border-color: #37006E; } } .ms-Button[data-v-79820dd6]:focus { background-color: \"[theme:neutralLight, default: #eaeaea]\"; border-color: \"[theme:themePrimary, default: #0078d7]\"; outline: 1px solid transparent; } .ms-Button:focus .ms-Button-label[data-v-79820dd6] { color: \"[theme:black, default: #000000]\"; } .ms-Button[data-v-79820dd6]:active { background-color: \"[theme:themePrimary, default: #0078d7]\"; border-color: \"[theme:themePrimary, default: #0078d7]\"; } .ms-Button:active .ms-Button-label[data-v-79820dd6] { color: \"[theme:white, default: #ffffff]\"; } .ms-Button[data-v-79820dd6]:disabled, .ms-Button.is-disabled[data-v-79820dd6] { background-color: \"[theme:neutralLighter, default: #f4f4f4]\"; border-color: \"[theme:neutralLighter, default: #f4f4f4]\"; cursor: default; } .ms-Button:disabled .ms-Button-label[data-v-79820dd6], .ms-Button.is-disabled .ms-Button-label[data-v-79820dd6] { color: \"[theme:neutralTertiary, default: #a6a6a6]\"; } .ms-Button[data-v-79820dd6]:disabled:hover, .ms-Button[data-v-79820dd6]:disabled:focus, .ms-Button.is-disabled[data-v-79820dd6]:hover, .ms-Button.is-disabled[data-v-79820dd6]:focus { outline: 0; } .ms-Button-label[data-v-79820dd6] { color: \"[theme:neutralPrimary, default: #333333]\"; font-weight: 600; font-size: 14px; } .ms-Button-icon[data-v-79820dd6], .ms-Button-description[data-v-79820dd6] { display: none; } .ms-Button.ms-Button--primary[data-v-79820dd6] { background-color: \"[theme:themePrimary, default: #0078d7]\"; border-color: \"[theme:themePrimary, default: #0078d7]\"; } .ms-Button.ms-Button--primary .ms-Button-label[data-v-79820dd6] { color: \"[theme:white, default: #ffffff]\"; } .ms-Button.ms-Button--primary[data-v-79820dd6]:hover { background-color: \"[theme:themeDark, default: #005a9e]\"; border-color: \"[theme:themeDark, default: #005a9e]\"; } .ms-Button.ms-Button--primary[data-v-79820dd6]:focus { background-color: \"[theme:themeDark, default: #005a9e]\"; border-color: \"[theme:themeDarker, default: #004578]\"; } .ms-Button.ms-Button--primary[data-v-79820dd6]:active { background-color: \"[theme:themePrimary, default: #0078d7]\"; border-color: \"[theme:themePrimary, default: #0078d7]\"; } .ms-Button.ms-Button--primary[data-v-79820dd6]:disabled, .ms-Button.ms-Button--primary.is-disabled[data-v-79820dd6] { background-color: \"[theme:neutralLighter, default: #f4f4f4]\"; border-color: \"[theme:neutralLighter, default: #f4f4f4]\"; } .ms-Button.ms-Button--primary:disabled .ms-Button-label[data-v-79820dd6], .ms-Button.ms-Button--primary.is-disabled .ms-Button-label[data-v-79820dd6] { color: \"[theme:neutralTertiary, default: #a6a6a6]\"; } .ms-Button.ms-Button--small[data-v-79820dd6] { min-width: 60px; min-height: 24px; height: auto; padding-top: 0; padding-bottom: 4px; } .ms-Button.ms-Button--small .ms-Button-label[data-v-79820dd6] { font-weight: 400; font-size: 12px; } .ms-Button.ms-Button--hero[data-v-79820dd6] { align-items: center; background-color: transparent; border: 0; padding: 0; position: relative; } .ms-Button.ms-Button--hero .ms-Button-icon[data-v-79820dd6] { color: \"[theme:themePrimary, default: #0078d7]\"; display: inline-block; font-size: 12px; margin-right: 4px; padding-top: 5px; text-align: center; } .ms-Button.ms-Button--hero .ms-Button-icon .ms-Icon[data-v-79820dd6] { border-radius: 18px; border: 1px solid \"[theme:themePrimary, default: #0078d7]\"; font-size: 12px; height: 18px; line-height: 18px; width: 18px; } .ms-Button.ms-Button--hero .ms-Button-label[data-v-79820dd6] { color: \"[theme:themePrimary, default: #0078d7]\"; font-size: 21px; font-weight: 100; position: relative; text-decoration: none; vertical-align: top; } .ms-Button.ms-Button--hero:hover .ms-Button-icon[data-v-79820dd6], .ms-Button.ms-Button--hero:focus .ms-Button-icon[data-v-79820dd6] { color: \"[theme:themeDark, default: #005a9e]\"; } .ms-Button.ms-Button--hero:hover .ms-Button-icon .ms-Icon[data-v-79820dd6], .ms-Button.ms-Button--hero:focus .ms-Button-icon .ms-Icon[data-v-79820dd6] { border: 1px solid \"[theme:themeDark, default: #005a9e]\"; } .ms-Button.ms-Button--hero:hover .ms-Button-label[data-v-79820dd6], .ms-Button.ms-Button--hero:focus .ms-Button-label[data-v-79820dd6] { color: \"[theme:themeDarker, default: #004578]\"; } .ms-Button.ms-Button--hero:active .ms-Button-icon[data-v-79820dd6] { color: \"[theme:themePrimary, default: #0078d7]\"; } .ms-Button.ms-Button--hero:active .ms-Button-icon .ms-Icon[data-v-79820dd6] { border: 1px solid \"[theme:themePrimary, default: #0078d7]\"; } .ms-Button.ms-Button--hero:active .ms-Button-label[data-v-79820dd6] { color: \"[theme:themePrimary, default: #0078d7]\"; } .ms-Button.ms-Button--hero:disabled .ms-Button-icon[data-v-79820dd6], .ms-Button.ms-Button--hero.is-disabled .ms-Button-icon[data-v-79820dd6] { color: \"[theme:neutralTertiaryAlt, default: #c8c8c8]\"; } .ms-Button.ms-Button--hero:disabled .ms-Button-icon .ms-Icon[data-v-79820dd6], .ms-Button.ms-Button--hero.is-disabled .ms-Button-icon .ms-Icon[data-v-79820dd6] { border: 1px solid \"[theme:neutralTertiaryAlt, default: #c8c8c8]\"; } .ms-Button.ms-Button--hero:disabled .ms-Button-label[data-v-79820dd6], .ms-Button.ms-Button--hero.is-disabled .ms-Button-label[data-v-79820dd6] { color: \"[theme:neutralTertiary, default: #a6a6a6]\"; } .ms-Button.ms-Button--compound[data-v-79820dd6] { display: block; height: auto; max-width: 280px; min-height: 72px; padding: 20px; } .ms-Button.ms-Button--compound .ms-Button-label[data-v-79820dd6] { display: block; font-weight: 600; position: relative; text-align: left; margin-top: -5px; } .ms-Button.ms-Button--compound .ms-Button-description[data-v-79820dd6] { color: \"[theme:neutralSecondary, default: #666666]\"; display: block; font-weight: 400; font-size: 12px; position: relative; text-align: left; top: 3px; } .ms-Button.ms-Button--compound:hover .ms-Button-description[data-v-79820dd6] { color: \"[theme:neutralDark, default: #212121]\"; } .ms-Button.ms-Button--compound[data-v-79820dd6]:focus { border-color: \"[theme:themePrimary, default: #0078d7]\"; background-color: \"[theme:neutralLighter, default: #f4f4f4]\"; } .ms-Button.ms-Button--compound:focus .ms-Button-label[data-v-79820dd6] { color: \"[theme:neutralPrimary, default: #333333]\"; } .ms-Button.ms-Button--compound:focus .ms-Button-description[data-v-79820dd6] { color: \"[theme:neutralSecondary, default: #666666]\"; } .ms-Button.ms-Button--compound[data-v-79820dd6]:active { background-color: \"[theme:themePrimary, default: #0078d7]\"; } .ms-Button.ms-Button--compound:active .ms-Button-description[data-v-79820dd6], .ms-Button.ms-Button--compound:active .ms-Button-label[data-v-79820dd6] { color: \"[theme:white, default: #ffffff]\"; } .ms-Button.ms-Button--compound:disabled .ms-Button-label[data-v-79820dd6], .ms-Button.ms-Button--compound:disabled .ms-Button-description[data-v-79820dd6], .ms-Button.ms-Button--compound.is-disabled .ms-Button-label[data-v-79820dd6], .ms-Button.ms-Button--compound.is-disabled .ms-Button-description[data-v-79820dd6] { color: \"[theme:neutralTertiary, default: #a6a6a6]\"; } .ms-Button.ms-Button--compound[data-v-79820dd6]:disabled:focus, .ms-Button.ms-Button--compound[data-v-79820dd6]:disabled:active, .ms-Button.ms-Button--compound.is-disabled[data-v-79820dd6]:focus, .ms-Button.ms-Button--compound.is-disabled[data-v-79820dd6]:active { border-color: \"[theme:neutralLighter, default: #f4f4f4]\"; background-color: \"[theme:neutralLighter, default: #f4f4f4]\"; } .ms-Button.ms-Button--compound:disabled:focus .ms-Button-label[data-v-79820dd6], .ms-Button.ms-Button--compound:disabled:focus .ms-Button-description[data-v-79820dd6], .ms-Button.ms-Button--compound:disabled:active .ms-Button-label[data-v-79820dd6], .ms-Button.ms-Button--compound:disabled:active .ms-Button-description[data-v-79820dd6], .ms-Button.ms-Button--compound.is-disabled:focus .ms-Button-label[data-v-79820dd6], .ms-Button.ms-Button--compound.is-disabled:focus .ms-Button-description[data-v-79820dd6], .ms-Button.ms-Button--compound.is-disabled:active .ms-Button-label[data-v-79820dd6], .ms-Button.ms-Button--compound.is-disabled:active .ms-Button-description[data-v-79820dd6] { color: \"[theme:neutralTertiary, default: #a6a6a6]\"; } ");},
	    extends :  button
	};

	var callout = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',[_c('div',{ref:"callout",staticClass:"ms-Callout is-hidden",class:_vm.calloutClass},[_c('div',{staticClass:"ms-Callout-main"},[(_vm.showClose)?_c('button',{staticClass:"ms-Callout-close"},[_c('i',{staticClass:"ms-Icon ms-Icon--Clear"})]):_vm._e(),_vm._v(" "),_c('div',{staticClass:"ms-Callout-header"},[_c('p',{staticClass:"ms-Callout-title"},[_vm._v(_vm._s(_vm.title))])]),_vm._v(" "),_c('div',{staticClass:"ms-Callout-inner"},[_c('div',{staticClass:"ms-Callout-content"},[(_vm.content)?_c('p',{staticClass:"ms-Callout-subText"},[_vm._v(_vm._s(_vm.content))]):_vm._t("content")],2),_vm._v(" "),_c('div',{staticClass:"ms-Callout-actions"},[_vm._t("actions")],2)])])]),_vm._v(" "),_c('span',{ref:"calloutTrigger"},[_vm._t("default")],2)])},staticRenderFns: [],
	  name: 'ou-callout',

	  mixins: [type('actionText', 'OOBE', 'peek')],

	  props: {
	    position: {
	      type: String,
	      default: 'right',
	      validator: function validator(value) {
	        return ['right', 'left', 'top', 'bottom'].includes(value);
	      }
	    },

	    showClose: {
	      type: Boolean,
	      default: false
	    },

	    title: String,
	    content: String
	  },
	  data: function data() {
	    return {
	      calloutInstance: null
	    };
	  },
	  computed: {
	    calloutClass: function calloutClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-Callout--" + (this.type))] = !!this.type, obj['ms-Callout--close'] =  this.showClose, obj );
	    }
	  },

	  mounted: function mounted() {
	    this.calloutInstance = new this.$fabric.Callout(
	      this.$refs.callout,
	      this.$refs.calloutTrigger,
	      this.position
	    );
	  }
	};

	var CONTEXT_STATE_CLASS = "is-open";
	var MODAL_STATE_POSITIONED = "is-positioned";
	var CONTEXT_HOST_MAIN_CLASS = "ms-ContextualHost-main";
	var CONTEXT_HOST_BEAK_CLASS = "ms-ContextualHost-beak";
	var ARROW_LEFT_CLASS = "ms-ContextualHost--arrowLeft";
	var ARROW_TOP_CLASS = "ms-ContextualHost--arrowTop";
	var ARROW_BOTTOM_CLASS = "ms-ContextualHost--arrowBottom";
	var ARROW_RIGHT_CLASS = "ms-ContextualHost--arrowRight";
	var MODIFIER_BASE = "ms-ContextualHost--";
	var ARROW_SIZE = 28;
	var ARROW_OFFSET = 8;

	var ContextualHost = function () {
	  function ContextualHost(content, direction, targetElement, hasArrow, modifiers, matchTargetWidth, disposalCallback) {
	    if (hasArrow === void 0) {
	      hasArrow = true;
	    }

	    this._resizeAction = this._resizeAction.bind(this);
	    this._dismissAction = this._dismissAction.bind(this);
	    this._handleKeyUpDismiss = this._handleKeyUpDismiss.bind(this);
	    this._matchTargetWidth = matchTargetWidth || false;
	    this._direction = direction;
	    this._container = this.createContainer();
	    this._contextualHost = this._container;
	    this._contextualHostMain = this._contextualHost.getElementsByClassName(CONTEXT_HOST_MAIN_CLASS)[0];

	    this._contextualHostMain.appendChild(content);

	    this._hasArrow = hasArrow;
	    this._arrow = this._container.getElementsByClassName(CONTEXT_HOST_BEAK_CLASS)[0];
	    this._targetElement = targetElement;

	    this._openModal();

	    this._setResizeDisposal();

	    if (disposalCallback) {
	      this._disposalCallback = disposalCallback;
	    }

	    if (modifiers) {
	      for (var i = 0; i < modifiers.length; i++) {
	        this._container.classList.add(MODIFIER_BASE + modifiers[i]);
	      }
	    }

	    if (!ContextualHost.hosts) {
	      ContextualHost.hosts = [];
	    }

	    ContextualHost.hosts.push(this);
	  }

	  ContextualHost.prototype.disposeModal = function () {
	    if (ContextualHost.hosts.length > 0) {
	      window.removeEventListener("resize", this._resizeAction, false);
	      document.removeEventListener("click", this._dismissAction, true);
	      document.removeEventListener("keyup", this._handleKeyUpDismiss, true);

	      this._container.parentNode.removeChild(this._container);

	      if (this._disposalCallback) {
	        this._disposalCallback();
	      }

	      var index$$1 = ContextualHost.hosts.indexOf(this);
	      ContextualHost.hosts.splice(index$$1, 1);
	      var i = ContextualHost.hosts.length;

	      while (i--) {
	        ContextualHost.hosts[i].disposeModal();
	        ContextualHost.hosts.splice(i, 1);
	      }
	    }
	  };

	  ContextualHost.prototype.setChildren = function (value) {
	    if (!this._children) {
	      this._children = [];
	    }

	    this._children.push(value);
	  };

	  ContextualHost.prototype.contains = function (value) {
	    return this._container.contains(value);
	  };

	  ContextualHost.prototype.createContainer = function () {
	    var ContextualHost0 = document.createElement("div");
	    ContextualHost0.setAttribute("class", "ms-ContextualHost");
	    ContextualHost0.innerHTML += " ";
	    var ContextualHost0c1 = document.createElement("div");
	    ContextualHost0c1.setAttribute("class", CONTEXT_HOST_MAIN_CLASS);
	    ContextualHost0c1.innerHTML += " ";
	    ContextualHost0.appendChild(ContextualHost0c1);
	    ContextualHost0.innerHTML += " ";
	    var ContextualHost0c3 = document.createElement("div");
	    ContextualHost0c3.setAttribute("class", CONTEXT_HOST_BEAK_CLASS);
	    ContextualHost0.appendChild(ContextualHost0c3);
	    ContextualHost0.innerHTML += "";
	    return ContextualHost0;
	  };

	  ContextualHost.prototype._openModal = function () {
	    var _this = this;

	    this._copyModalToBody();

	    this._saveModalSize();

	    this._findAvailablePosition();

	    this._showModal();

	    setTimeout(function () {
	      _this._setDismissClick();
	    }, 100);
	  };

	  ContextualHost.prototype._findAvailablePosition = function () {
	    var _posOk;

	    switch (this._direction) {
	      case "left":
	        _posOk = this._positionOk(this._tryPosModalLeft.bind(this), this._tryPosModalRight.bind(this), this._tryPosModalBottom.bind(this), this._tryPosModalTop.bind(this));

	        this._setPosition(_posOk);

	        break;

	      case "right":
	        _posOk = this._positionOk(this._tryPosModalRight.bind(this), this._tryPosModalLeft.bind(this), this._tryPosModalBottom.bind(this), this._tryPosModalTop.bind(this));

	        this._setPosition(_posOk);

	        break;

	      case "top":
	        _posOk = this._positionOk(this._tryPosModalTop.bind(this), this._tryPosModalBottom.bind(this));

	        this._setPosition(_posOk);

	        break;

	      case "bottom":
	        _posOk = this._positionOk(this._tryPosModalBottom.bind(this), this._tryPosModalTop.bind(this));

	        this._setPosition(_posOk);

	        break;

	      default:
	        this._setPosition();

	    }
	  };

	  ContextualHost.prototype._showModal = function () {
	    this._container.classList.add(CONTEXT_STATE_CLASS);
	  };

	  ContextualHost.prototype._positionOk = function (pos1, pos2, pos3, pos4) {
	    var _posOk;

	    _posOk = pos1();

	    if (!_posOk) {
	      _posOk = pos2();

	      if (!_posOk && pos3) {
	        _posOk = pos3();

	        if (!_posOk && pos4) {
	          _posOk = pos4();
	        }
	      }
	    }

	    return _posOk;
	  };

	  ContextualHost.prototype._calcLeft = function (mWidth, teWidth, teLeft) {
	    var mHalfWidth = mWidth / 2;
	    var teHalf = teWidth / 2;
	    var mHLeft = teLeft + teHalf - mHalfWidth;
	    mHLeft = mHLeft < mHalfWidth ? teLeft : mHLeft;
	    return mHLeft;
	  };

	  ContextualHost.prototype._calcTop = function (mHeight, teHeight, teTop) {
	    var mHalfWidth = mHeight / 2;
	    var teHalf = teHeight / 2;
	    var mHLeft = teTop + teHalf - mHalfWidth;
	    mHLeft = mHLeft < mHalfWidth ? teTop : mHLeft;
	    return mHLeft;
	  };

	  ContextualHost.prototype._setPosition = function (curDirection) {
	    var teBR = this._targetElement.getBoundingClientRect();

	    var teLeft = teBR.left;
	    var teRight = teBR.right;
	    var teTop = teBR.top;
	    var teWidth = teBR.width;
	    var teHeight = teBR.height;
	    var mHLeft;
	    var mHTop;
	    var mWidth = "";
	    var arrowTop;
	    var arrowLeft;
	    var windowX = window.scrollX ? window.scrollX : 0;
	    var windowY = window.scrollY ? window.scrollY : 0;
	    var arrowSpace = this._hasArrow ? ARROW_SIZE : 0;

	    if (this._matchTargetWidth) {
	      mWidth = "width: " + this._modalWidth + "px;";
	    }

	    switch (curDirection) {
	      case "left":
	        mHLeft = teLeft - this._modalWidth - arrowSpace;
	        mHTop = this._calcTop(this._modalHeight, teHeight, teTop);
	        mHTop += window.scrollY ? window.scrollY : 0;

	        this._container.setAttribute("style", "top: " + mHTop + "px; left: " + mHLeft + "px;" + mWidth);

	        this._container.classList.add(MODAL_STATE_POSITIONED);

	        if (this._hasArrow) {
	          this._container.classList.add(ARROW_RIGHT_CLASS);

	          arrowTop = teTop + windowY - mHTop + ARROW_OFFSET;

	          this._arrow.setAttribute("style", "top: " + arrowTop + "px;");
	        }

	        break;

	      case "right":
	        mHTop = this._calcTop(this._modalHeight, teHeight, teTop);
	        mHTop += windowY;
	        mHLeft = teRight + arrowSpace;

	        this._container.setAttribute("style", "top: " + mHTop + "px; left: " + mHLeft + "px;" + mWidth);

	        this._container.classList.add(MODAL_STATE_POSITIONED);

	        if (this._hasArrow) {
	          arrowTop = windowY + teTop - mHTop + ARROW_OFFSET;

	          this._arrow.setAttribute("style", "top: " + arrowTop + "px;");

	          this._container.classList.add(ARROW_LEFT_CLASS);
	        }

	        break;

	      case "top":
	        mHLeft = this._calcLeft(this._modalWidth, this._teWidth, teLeft);
	        mHTop = teTop - this._modalHeight - arrowSpace;
	        mHTop += windowY;

	        this._container.setAttribute("style", "top: " + mHTop + "px; left: " + mHLeft + "px;" + mWidth);

	        this._container.classList.add(MODAL_STATE_POSITIONED);

	        if (this._hasArrow) {
	          arrowTop = this._modalHeight - arrowSpace / 2;
	          arrowLeft = Math.max(windowX + teLeft - mHLeft + (teWidth - arrowSpace) / 2, ARROW_OFFSET);

	          this._arrow.setAttribute("style", "top: " + arrowTop + "px; left: " + arrowLeft + "px;");

	          this._container.classList.add(ARROW_BOTTOM_CLASS);
	        }

	        break;

	      case "bottom":
	        mHLeft = mHLeft = this._calcLeft(this._modalWidth, this._teWidth, teLeft);
	        mHTop = teTop + teHeight + arrowSpace;
	        mHTop += window.scrollY ? window.scrollY : 0;

	        this._container.setAttribute("style", "top: " + mHTop + "px; left: " + mHLeft + "px;" + mWidth);

	        this._container.classList.add(MODAL_STATE_POSITIONED);

	        if (this._hasArrow) {
	          arrowLeft = Math.max(windowX + teLeft - mHLeft + (teWidth - arrowSpace) / 2, ARROW_OFFSET);

	          this._arrow.setAttribute("style", "left: " + arrowLeft + "px;");

	          this._container.classList.add(ARROW_TOP_CLASS);
	        }

	        break;

	      default:
	        this._container.setAttribute("style", "top: 50%; left: 50%; transform: translateX(-50%) translateY(-50%);");

	    }
	  };

	  ContextualHost.prototype._tryPosModalLeft = function () {
	    var teLeft = this._targetElement.getBoundingClientRect().left;

	    if (teLeft < this._modalWidth) {
	      return false;
	    } else {
	      return "left";
	    }
	  };

	  ContextualHost.prototype._tryPosModalRight = function () {
	    var teRight = this._targetElement.getBoundingClientRect().right;

	    var w = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);

	    if (w - teRight < this._modalWidth) {
	      return false;
	    } else {
	      return "right";
	    }
	  };

	  ContextualHost.prototype._tryPosModalBottom = function () {
	    var teBottom = window.innerHeight - this._targetElement.getBoundingClientRect().bottom;

	    if (teBottom < this._modalHeight) {
	      return false;
	    } else {
	      return "bottom";
	    }
	  };

	  ContextualHost.prototype._tryPosModalTop = function () {
	    var teTop = this._targetElement.getBoundingClientRect().top;

	    if (teTop < this._modalHeight) {
	      return false;
	    } else {
	      return "top";
	    }
	  };

	  ContextualHost.prototype._copyModalToBody = function () {
	    document.body.appendChild(this._container);
	  };

	  ContextualHost.prototype._saveModalSize = function () {
	    var _modalStyles = window.getComputedStyle(this._container);

	    this._container.setAttribute("style", "opacity: 0; z-index: -1");

	    this._container.classList.add(MODAL_STATE_POSITIONED);

	    this._container.classList.add(CONTEXT_STATE_CLASS);

	    if (this._matchTargetWidth) {
	      var teStyles = window.getComputedStyle(this._targetElement);
	      this._modalWidth = this._targetElement.getBoundingClientRect().width + (parseInt(teStyles.marginLeft, 10) + parseInt(teStyles.marginLeft, 10));
	    } else {
	      this._modalWidth = this._container.getBoundingClientRect().width + (parseInt(_modalStyles.marginLeft, 10) + parseInt(_modalStyles.marginRight, 10));

	      this._container.setAttribute("style", "");
	    }

	    this._modalHeight = this._container.getBoundingClientRect().height + (parseInt(_modalStyles.marginTop, 10) + parseInt(_modalStyles.marginBottom, 10));

	    this._container.classList.remove(MODAL_STATE_POSITIONED);

	    this._container.classList.remove(CONTEXT_STATE_CLASS);

	    this._teWidth = this._targetElement.getBoundingClientRect().width;
	    this._teHeight = this._targetElement.getBoundingClientRect().height;
	  };

	  ContextualHost.prototype._dismissAction = function (e) {
	    if (!this._container.contains(e.target) && e.target !== this._container) {
	      if (this._children !== undefined) {
	        var isChild_1 = false;

	        this._children.map(function (child) {
	          if (child !== undefined) {
	            isChild_1 = child.contains(e.target);
	          }
	        });

	        if (!isChild_1) {
	          this.disposeModal();
	        }
	      } else {
	        this.disposeModal();
	      }
	    }
	  };

	  ContextualHost.prototype._setDismissClick = function () {
	    document.addEventListener("click", this._dismissAction, true);
	    document.addEventListener("keyup", this._handleKeyUpDismiss, true);
	  };

	  ContextualHost.prototype._handleKeyUpDismiss = function (e) {
	    if (e.keyCode === 32 || e.keyCode === 27) {
	      this._dismissAction(e);
	    }
	  };

	  ContextualHost.prototype._resizeAction = function () {
	    this.disposeModal();
	  };

	  ContextualHost.prototype._setResizeDisposal = function () {
	    window.addEventListener("resize", this._resizeAction, false);
	  };

	  return ContextualHost;
	}();

	var STATE_HIDDEN = "is-hidden";
	var CLOSE_BUTTON_CLASS = ".ms-Callout-close";
	var MODIFIER_OOBE_CLASS = "ms-Callout--OOBE";

	var Callout = function () {
	  function Callout(container, addTarget, position) {
	    this._container = container;
	    this._addTarget = addTarget;
	    this._position = position;
	    this._closeButton = container.querySelector(CLOSE_BUTTON_CLASS);

	    this._setOpener();
	  }

	  Callout.prototype._setOpener = function () {
	    this._addTarget.addEventListener("click", this._clickHandler.bind(this), true);

	    this._addTarget.addEventListener("keyup", this._keyupHandler.bind(this), true);
	  };

	  Callout.prototype._openContextMenu = function () {
	    var modifiers = [];

	    if (this._hasModifier(MODIFIER_OOBE_CLASS)) {
	      modifiers.push("primaryArrow");
	    }

	    this._container.classList.remove(STATE_HIDDEN);

	    this._contextualHost = new ContextualHost(this._container, this._position, this._addTarget, true, modifiers);

	    if (this._closeButton) {
	      this._closeButton.addEventListener("click", this._closeHandler.bind(this), false);
	    }
	  };

	  Callout.prototype._hasModifier = function (modifierClass) {
	    return this._container.classList.contains(modifierClass);
	  };

	  Callout.prototype._closeHandler = function (e) {
	    if (this._contextualHost != null) {
	      this._contextualHost.disposeModal();
	    }

	    this._closeButton.removeEventListener("click", this._closeHandler.bind(this), false);

	    this._addTarget.removeEventListener("click", this._clickHandler.bind(this), true);

	    this._addTarget.removeEventListener("keyup", this._keyupHandler.bind(this), true);
	  };

	  Callout.prototype._clickHandler = function (e) {
	    this._openContextMenu();
	  };

	  Callout.prototype._keyupHandler = function (event) {
	    if (event.keyCode === 32) {
	      event.stopPropagation();
	      event.preventDefault();

	      this._openContextMenu();
	    } else {
	      this._closeHandler(event);
	    }
	  };

	  return Callout;
	}();

	var CheckBox = function () {
	  function CheckBox(container) {
	    this._container = container;
	    this._choiceField = this._container.querySelector(".ms-CheckBox-field");
	    this._choiceInput = this._container.querySelector(".ms-CheckBox-input");

	    if (this._choiceInput.checked) {
	      this._choiceField.setAttribute("aria-checked", "true");
	    }

	    if (this._choiceField.getAttribute("aria-checked") === "true") {
	      this._choiceField.classList.add("is-checked");
	    }

	    this._addListeners();
	  }

	  CheckBox.prototype.getValue = function () {
	    return this._choiceField.getAttribute("aria-checked") === "true" ? true : false;
	  };

	  CheckBox.prototype.toggle = function () {
	    if (this.getValue()) {
	      this.unCheck();
	    } else {
	      this.check();
	    }

	    this._choiceInput.click();
	  };

	  CheckBox.prototype.check = function () {
	    this._choiceField.setAttribute("aria-checked", "true");

	    this._choiceField.classList.add("is-checked");
	  };

	  CheckBox.prototype.unCheck = function () {
	    this._choiceField.setAttribute("aria-checked", "false");

	    this._choiceField.classList.remove("is-checked");
	  };

	  CheckBox.prototype.removeListeners = function () {
	    this._choiceField.removeEventListener("focus", this._FocusHandler.bind(this));

	    this._choiceField.removeEventListener("blur", this._BlurHandler.bind(this));

	    this._choiceField.removeEventListener("click", this._ClickHandler.bind(this));

	    this._choiceField.removeEventListener("keydown", this._KeydownHandler.bind(this));
	  };

	  CheckBox.prototype._addListeners = function (events) {
	    var ignore = events && events.ignore;

	    if (!ignore || !(ignore.indexOf("focus") > -1)) {
	      this._choiceField.addEventListener("focus", this._FocusHandler.bind(this), false);
	    }

	    if (!ignore || !(ignore.indexOf("blur") > -1)) {
	      this._choiceField.addEventListener("blur", this._BlurHandler.bind(this), false);
	    }

	    if (!ignore || !(ignore.indexOf("click") > -1)) {
	      this._choiceField.addEventListener("click", this._ClickHandler.bind(this), false);
	    }

	    if (!ignore || !(ignore.indexOf("keydown") > -1)) {
	      this._choiceField.addEventListener("keydown", this._KeydownHandler.bind(this), false);
	    }
	  };

	  CheckBox.prototype._FocusHandler = function () {
	    this._choiceField.classList.add("in-focus");
	  };

	  CheckBox.prototype._BlurHandler = function () {
	    this._choiceField.classList.remove("in-focus");
	  };

	  CheckBox.prototype._ClickHandler = function (event) {
	    event.stopPropagation();
	    event.preventDefault();

	    if (!this._choiceField.classList.contains("is-disabled")) {
	      this.toggle();
	    }
	  };

	  CheckBox.prototype._KeydownHandler = function (event) {
	    if (event.keyCode === 32) {
	      event.stopPropagation();
	      event.preventDefault();

	      if (!this._choiceField.classList.contains("is-disabled")) {
	        this.toggle();
	      }
	    }
	  };

	  return CheckBox;
	}();

	var eventHub = {
	  data: function data() {
	    return {
	      eventHub: new Vue()
	    };
	  },
	  provide: function provide() {
	    return {
	      eventHub: this.eventHub
	    };
	  }
	};

	var RadioButton = function () {
	  function RadioButton(container) {
	    this._container = container;
	    this._choiceField = this._container.querySelector(".ms-RadioButton-field");
	    this._choiceInput = this._container.querySelector(".ms-RadioButton-input");

	    if (this._choiceField.getAttribute("aria-checked") === "true") {
	      this._choiceField.classList.add("is-checked");
	    }

	    this._addListeners();
	  }

	  RadioButton.prototype.getValue = function () {
	    return this._choiceField.getAttribute("aria-checked") === "true" ? true : false;
	  };

	  RadioButton.prototype.toggle = function () {
	    if (this.getValue()) {
	      this.unCheck();
	    } else {
	      this.check();
	    }
	  };

	  RadioButton.prototype.check = function () {
	    this._choiceField.setAttribute("aria-checked", "true");

	    this._choiceField.classList.add("is-checked");

	    this._choiceInput.checked = true;
	  };

	  RadioButton.prototype.unCheck = function () {
	    this._choiceField.setAttribute("aria-checked", "false");

	    this._choiceField.classList.remove("is-checked");

	    this._choiceInput.checked = false;
	  };

	  RadioButton.prototype.removeListeners = function () {
	    this._choiceField.removeEventListener("focus", this._FocusHandler.bind(this));

	    this._choiceField.removeEventListener("blur", this._BlurHandler.bind(this));

	    this._choiceField.removeEventListener("click", this._RadioClickHandler.bind(this));

	    this._choiceField.addEventListener("keydown", this._RadioKeydownHandler.bind(this));
	  };

	  RadioButton.prototype._addListeners = function () {
	    this._choiceField.addEventListener("focus", this._FocusHandler.bind(this), false);

	    this._choiceField.addEventListener("blur", this._BlurHandler.bind(this), false);

	    this._choiceField.addEventListener("click", this._RadioClickHandler.bind(this), false);

	    this._choiceField.addEventListener("keydown", this._RadioKeydownHandler.bind(this), false);
	  };

	  RadioButton.prototype._RadioClickHandler = function (event) {
	    event.stopPropagation();
	    event.preventDefault();

	    if (!this._choiceField.classList.contains("is-disabled")) {
	      this._dispatchSelectEvent();
	    }
	  };

	  RadioButton.prototype._dispatchSelectEvent = function () {
	    var objDict = {
	      bubbles: true,
	      cancelable: true,
	      detail: {
	        name: this._choiceField.getAttribute("name"),
	        item: this
	      }
	    };

	    this._choiceField.dispatchEvent(new CustomEvent("msChoicefield", objDict));
	  };

	  RadioButton.prototype._RadioKeydownHandler = function (event) {
	    if (event.keyCode === 32) {
	      event.stopPropagation();
	      event.preventDefault();

	      if (!this._choiceField.classList.contains("is-disabled")) {
	        this._dispatchSelectEvent();
	      }
	    }
	  };

	  RadioButton.prototype._FocusHandler = function () {
	    this._choiceField.classList.add("in-focus");
	  };

	  RadioButton.prototype._BlurHandler = function () {
	    this._choiceField.classList.remove("in-focus");
	  };

	  return RadioButton;
	}();

	var ChoiceFieldGroup$1 = function () {
	  function ChoiceFieldGroup(container) {
	    this._choiceFieldGroup = container;
	    this._choiceFieldComponents = [];

	    this._initalSetup();

	    this._addListeners();
	  }

	  ChoiceFieldGroup.prototype.removeListeners = function () {
	    this._choiceFieldGroup.removeEventListener("msChoicefield", this._ChoiceFieldHandler.bind(this));
	  };

	  ChoiceFieldGroup.prototype._initalSetup = function () {
	    var choiceFieldElements = this._choiceFieldGroup.querySelectorAll(".ms-RadioButton");

	    for (var i = 0; i < choiceFieldElements.length; i++) {
	      this._choiceFieldComponents[i] = new RadioButton(choiceFieldElements[i]);
	    }
	  };

	  ChoiceFieldGroup.prototype._addListeners = function () {
	    document.addEventListener("msChoicefield", this._ChoiceFieldHandler.bind(this), false);
	  };

	  ChoiceFieldGroup.prototype._ChoiceFieldHandler = function (event) {
	    var name = event.detail.name;
	    var selectedChoice = event.detail.item;

	    if (this._choiceFieldGroup.id === name) {
	      for (var i = 0; i < this._choiceFieldComponents.length; i++) {
	        this._choiceFieldComponents[i].unCheck();
	      }

	      selectedChoice.check();
	    }
	  };

	  return ChoiceFieldGroup;
	}();

	var ContextualMenu = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"inline-block"},[_c('span',{ref:"contextualMenuTrigger",staticClass:"inline-block"},[_vm._t("default")],2),_vm._v(" "),_c('ul',{ref:"contextualMenu",staticClass:"ms-ContextualMenu is-hidden",class:_vm.contextualMenuClass},[_vm._t("list")],2)])},staticRenderFns: [],_scopeId: 'data-v-4d60802a',
	    name: 'ou-contextual-menu',

	    mixins: [type('multiselect'), eventHub],

	    props: {
	      value: {
	        type: Array,
	        default: function default$1() {
	          return [];
	        }
	      }
	    },

	    computed: {
	      contextualMenuClass: function contextualMenuClass() {
	        var obj;

	        return ( obj = {}, obj[("ms-ContextualMenu--" + (this.type))] = !!this.type, obj );
	      }
	    },

	    watch: {
	      value: function value() {
	        this.setChildrenValue();
	      }
	    },

	    created: function created() {
	      this.eventHub.$on('updateValue', this.updateValue);
	    },
		data: function data(){
			return {
				contextualMenuInstance : null
			}
		},
	    mounted: function mounted() {
	      this.setChildrenValue();

	      this.contextualMenuInstance = new this.$fabric.ContextualMenu(
	        this.$refs.contextualMenu,
	        this.$refs.contextualMenuTrigger
	      );
	    },

	    beforeDestroy: function beforeDestroy() {
	      this.eventHub.$off('updateValue', this.updateValue);
	    },

	    methods: {
	      setChildrenValue: function setChildrenValue() {
	        if (this.type == 'multiselect') {
	          this.eventHub.$emit('setSelected', this.value);
	        }
	      },

	      updateValue: function updateValue(value) {
	        if (this.type != 'multiselect') { return; }

	        var newValue;

	        if (this.value.includes(value)) {
	          newValue = this.value.filter(function (item) {
	            return item !== value;
	          });
	        } else {
	          newValue = this.value.concat(value);
	        }

	        this.$emit('input', newValue);
	      }
	    }
	  };

	var MODAL_POSITION = "bottom";
	var SUBMENU_POSITION = "right";

	var ContextualMenu$1 = function () {
	  function ContextualMenu(container, hostTarget, position) {
	    this._container = container;
	    this._hostTarget = hostTarget;
	    this._position = position ? position : MODAL_POSITION;
	    this._isOpen = false;

	    this._setOpener(hostTarget);

	    this._init();
	  }

	  ContextualMenu.prototype.getHost = function () {
	    return this._host;
	  };

	  ContextualMenu.prototype._init = function () {
	    this._container.addEventListener("click", this._onContextualMenuClick.bind(this), true);

	    document.addEventListener("click", this._onDocumentClick.bind(this), false);
	  };

	  ContextualMenu.prototype._onDocumentClick = function (event) {
	    if (event.target instanceof HTMLElement) {
	      var target = event.target;
	      var classList = target.classList;

	      if (!this._hostTarget.contains(target) && !classList.contains("ms-ContextualMenu-link")) {
	        this._isOpen = false;
	      }
	    }
	  };

	  ContextualMenu.prototype._onContextualMenuClick = function (event) {
	    var target = event.target;
	    var classList = target.classList;

	    if (classList.contains("ms-ContextualMenu-link") && !classList.contains("is-disabled")) {
	      if (this._container.classList.contains("ms-ContextualMenu--multiselect")) {
	        this._multiSelect(target);
	      } else {
	        this._singleSelect(target);

	        if (!target.parentElement.classList.contains("ms-ContextualMenu-item--hasMenu")) {
	          this._host.disposeModal();

	          this._isOpen = false;
	        }
	      }
	    }
	  };

	  ContextualMenu.prototype._multiSelect = function (target) {
	    if (target.classList.contains("is-selected")) {
	      target.classList.remove("is-selected");
	    } else {
	      target.classList.add("is-selected");
	    }
	  };

	  ContextualMenu.prototype._singleSelect = function (target) {
	    var selecteds = this._container.querySelectorAll(".is-selected");

	    var i = selecteds.length;

	    while (i--) {
	      selecteds[i].classList.remove("is-selected");
	    }

	    target.classList.add("is-selected");
	  };

	  ContextualMenu.prototype._toggleMenu = function (event) {
	    !this._isOpen ? this._openContextMenu(event) : this._host.disposeModal();
	    this._isOpen = !this._isOpen;
	  };

	  ContextualMenu.prototype._setOpener = function (hostTarget) {
	    var _this = this;

	    hostTarget.addEventListener("click", function (event) {
	      event.preventDefault();

	      _this._toggleMenu(event);
	    });
	  };

	  ContextualMenu.prototype._openContextMenu = function (event) {
	    this._createModalHostView(this._container, this._position, this._hostTarget);

	    this._checkForSubmenus(this._container);
	  };

	  ContextualMenu.prototype._checkForSubmenus = function (container) {
	    var _this = this;

	    var submenus = container.querySelectorAll(".ms-ContextualMenu-item.ms-ContextualMenu-item--hasMenu");
	    var i = submenus.length;

	    if (submenus.length) {
	      var _loop_1 = function _loop_1() {
	        var button = submenus[i].querySelector(".ms-ContextualMenu-link");
	        var menu = submenus[i].querySelector(".ms-ContextualMenu");

	        if (menu) {
	          var contextualMenu_1 = new ContextualMenu(menu, button, SUBMENU_POSITION);
	          menu.addEventListener("hostAdded", function () {
	            _this._host.setChildren(contextualMenu_1.getHost());
	          });
	        }
	      };

	      while (i--) {
	        _loop_1();
	      }
	    }
	  };

	  ContextualMenu.prototype._createModalHostView = function (container, position, hostTarget) {
	    container.classList.remove("is-hidden");
	    this._host = new ContextualHost(container, position, hostTarget, false);
	    var event = document.createEvent("Event");
	    event.initEvent("hostAdded", true, true);
	    container.dispatchEvent(event);
	  };

	  return ContextualMenu;
	}();

	var ContextualMenuItem = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('li',{staticClass:"ms-ContextualMenu-item",class:_vm.contextualMenuItemClass},[(_vm.type == 'header')?_c('span',[_vm._v(_vm._s(_vm.name))]):_vm._e(),_vm._v(" "),(_vm.hasLink)?_c('a',{staticClass:"ms-ContextualMenu-link",class:_vm.contextualMenuLinkClass,on:{"click":_vm.clickEvent}},[_vm._v(" "+_vm._s(_vm.name)+" ")]):_vm._e(),_vm._v(" "),(_vm.hasMenu)?_c('i',{staticClass:"ms-ContextualMenu-subMenuIcon ms-Icon ms-Icon--ChevronRight"}):_vm._e(),_vm._v(" "),(_vm.hasMenu)?_c('ul',{staticClass:"ms-ContextualMenu is-hidden"},[_vm._t("default")],2):_vm._e()])},staticRenderFns: [],
	  name: 'ou-contextual-menu-item',

	  mixins: [type('divider', 'header', 'hasMenu'), disabled],

	  inject: ['eventHub'],

	  data: function data() {
	    return {
	      selected: false
	    };
	  },

	  props: {
	    name: String,
	    value: [String, Number]
	  },

	  computed: {
	    hasLink: function hasLink() {
	      return this.type == 'hasMenu' || this.type == '';
	    },

	    hasMenu: function hasMenu() {
	      return this.type == 'hasMenu';
	    },

	    contextualMenuItemClass: function contextualMenuItemClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-ContextualMenu-item--" + (this.type))] = !!this.type, obj );
	    },

	    contextualMenuLinkClass: function contextualMenuLinkClass() {
	      return {
	        'is-disabled': this.disabled,
	        'is-selected': this.selected
	      };
	    }
	  },

	  created: function created() {
	    this.eventHub.$on('setSelected', this.setSelected);
	  },

	  beforeDestroy: function beforeDestroy() {
	    this.eventHub.$off('setSelected', this.setSelected);
	  },

	  methods: {
	    clickEvent: function clickEvent() {
	      if (this.value) {
	        this.eventHub.$emit('updateValue', this.value);
	      } else if (!this.type && !this.disabled) {
	        this.$emit('click');
	      }
	    },

	    setSelected: function setSelected(values) {
	      if (values.includes(this.value)) {
	        this.selected = true;
	      } else {
	        this.selected = false;
	      }
	    }
	  }
	};

	var SB_FIELD = ".ms-SearchBox-field";
	var SB_CLEAR_BUTTON = ".ms-SearchBox-clear";
	var SB_EXIT_BUTTON = ".ms-SearchBox-exit";
	var SB_HAS_TEXT = "has-text";
	var SB_IS_ACTIVE = "is-active";
	var SB_IS_ANIMATED = "is-animated";

	var SearchBox = function () {
	  function SearchBox(container) {
	    var _this = this;

	    this._container = container;

	    this._saveDOMRefs(this._container);

	    this._boundExpandSearchHandler = this._expandSearchHandler.bind(this);
	    this._boundEnableClose = this._enableClose.bind(this);
	    this._boundCollapseSearchBox = this._collapseSearchBox.bind(this);
	    this._boundClearSearchBox = this._clearSearchBox.bind(this);
	    this._boundHandleBlur = this._handleBlur.bind(this);
	    this._boundExitSearchBox = this._exitSearchBox.bind(this);

	    this._setHasText();

	    this._setFocusAction(this._container);

	    this._setClearButtonAction();

	    this._setBlurAction();

	    this._clearOnly = false;
	    setTimeout(function () {
	      _this._checkState();

	      _this._addAnimation();
	    }, 10);
	  }

	  SearchBox.prototype.setCollapsedListeners = function () {
	    this._disposeListeners();

	    this._searchBox.addEventListener("click", this._boundExpandSearchHandler, false);

	    this._searchBoxField.addEventListener("focus", this._boundExpandSearchHandler, true);
	  };

	  SearchBox.prototype.getInputField = function () {
	    return this._searchBoxField;
	  };

	  SearchBox.prototype._saveDOMRefs = function (context) {
	    this._searchBox = context;
	    this._searchBoxField = this._searchBox.querySelector(SB_FIELD);
	    this._searchBoxClearButton = this._searchBox.querySelector(SB_CLEAR_BUTTON);
	    this._searchBoxExitButton = this._searchBox.querySelector(SB_EXIT_BUTTON);
	  };

	  SearchBox.prototype._disposeListeners = function () {
	    this._searchBox.removeEventListener("click", this._boundExpandSearchHandler);

	    this._searchBoxField.removeEventListener("focus", this._boundExpandSearchHandler);
	  };

	  SearchBox.prototype._exitSearchBox = function (event) {
	    event.stopPropagation();
	    event.target.blur();

	    this._clearSearchBox();

	    this._collapseSearchBox();

	    this._searchBox.removeEventListener("keyup", this._boundEnableClose);

	    this.setCollapsedListeners();
	  };

	  SearchBox.prototype._collapseSearchBox = function () {
	    this._searchBox.classList.remove("is-active");

	    var event = document.createEvent("Event");
	    event.initEvent("searchCollapse", true, true);

	    this._searchBoxField.dispatchEvent(event);
	  };

	  SearchBox.prototype._expandSearchHandler = function () {
	    this._disposeListeners();

	    this._searchBox.classList.add("is-active");

	    this._searchBoxField.focus();
	  };

	  SearchBox.prototype._enableClose = function () {
	    this._setHasText();
	  };

	  SearchBox.prototype._setHasText = function () {
	    if (this._searchBoxField.value.length > 0) {
	      this._searchBox.classList.add(SB_HAS_TEXT);
	    } else {
	      this._searchBox.classList.remove(SB_HAS_TEXT);
	    }
	  };

	  SearchBox.prototype._setFocusAction = function (context) {
	    var _this = this;

	    this._searchBoxField.addEventListener("focus", function () {
	      _this._setHasText();

	      _this._searchBox.addEventListener("keyup", _this._boundEnableClose, false);

	      _this._searchBox.classList.add(SB_IS_ACTIVE);

	      _this._searchBox.classList.add(SB_IS_ACTIVE);
	    }, true);
	  };

	  SearchBox.prototype._clearSearchBox = function (event) {
	    var _this = this;

	    this._clearOnly = true;
	    this._searchBoxField.value = "";

	    this._setHasText();

	    setTimeout(function () {
	      _this._clearOnly = false;
	    }, 10);
	  };

	  SearchBox.prototype._setClearButtonAction = function () {
	    var _this = this;

	    if (this._searchBoxExitButton) {
	      this._searchBoxExitButton.addEventListener("click", this._boundExitSearchBox, false);
	    }

	    this._searchBoxClearButton.addEventListener("mousedown", this._boundClearSearchBox, false);

	    this._searchBoxClearButton.addEventListener("keydown", function (e) {
	      var keyCode = e.keyCode;

	      if (keyCode === 13) {
	        _this._clearSearchBox(e);
	      }
	    }, false);
	  };

	  SearchBox.prototype._handleBlur = function (event) {
	    var _this = this;

	    console.log("_handleBlur");
	    if (this._searchBox.classList.contains("ignoreBlur")) { return; }

	    if (!this._clearOnly) {
	      this._searchBox.removeEventListener("keyup", this._boundEnableClose);

	      setTimeout(function () {
	        if (!_this._searchBox.contains(document.activeElement)) {
	          _this._clearSearchBox();

	          _this._collapseSearchBox();

	          _this.setCollapsedListeners();
	        }
	      }, 10);
	    } else {
	      this._searchBoxField.focus();
	    }

	    this._clearOnly = false;
	  };

	  SearchBox.prototype._setBlurAction = function () {
	    this._searchBoxField.addEventListener("blur", this._boundHandleBlur, true);

	    this._searchBoxClearButton.addEventListener("blur", this._boundHandleBlur, true);
	  };

	  SearchBox.prototype._checkState = function () {
	    if (this._searchBox.classList.contains("is-collapsed")) {
	      this.setCollapsedListeners();
	    }
	  };

	  SearchBox.prototype._addAnimation = function () {
	    this._container.classList.add(SB_IS_ANIMATED);
	  };

	  return SearchBox;
	}();

	var CONTEXT_CLASS = ".ms-ContextualMenu";
	var CB_SPLIT_CLASS = ".ms-CommandButton-splitIcon";
	var CB_BUTTON_CLASS = ".ms-CommandButton-button";
	var MODAL_POSITION$1 = "bottom";

	var CommandButton = function () {
	  function CommandButton(container, contextMenu) {
	    this._container = container;
	    this._command = this._container;
	    this._commandButton = this._command.querySelector(CB_BUTTON_CLASS);
	    this._splitButton = this._command.querySelector(CB_SPLIT_CLASS);

	    if (contextMenu) {
	      this._contextualMenu = contextMenu;
	    } else {
	      this._contextualMenu = this._container.querySelector(CONTEXT_CLASS);
	    }

	    this._checkForMenu();
	  }

	  CommandButton.prototype._createModalHostView = function () {
	    this._modalHostView = new ContextualHost(this._contextualMenu, MODAL_POSITION$1, this._command, false);
	  };

	  CommandButton.prototype._setClick = function () {
	    if (this._splitButton) {
	      this._splitButton.addEventListener("click", this._createModalHostView.bind(this), false);
	    } else {
	      this._commandButton.addEventListener("click", this._createModalHostView.bind(this), false);
	    }
	  };

	  CommandButton.prototype._checkForMenu = function () {
	    if (this._contextualMenu) {
	      this._setClick();
	    }
	  };

	  return CommandButton;
	}();

	var CONTEXTUAL_MENU = ".ms-ContextualMenu";
	var CONTEXTUAL_MENU_ITEM = ".ms-ContextualMenu-item";
	var CONTEXTUAL_MENU_LINK = ".ms-ContextualMenu-link";
	var CB_SEARCH_BOX = ".ms-SearchBox";
	var CB_MAIN_AREA = ".ms-CommandBar-mainArea";
	var CB_SIDE_COMMAND_AREA = ".ms-CommandBar-sideCommands";
	var CB_ITEM_OVERFLOW = ".ms-CommandBar-overflowButton";
	var CB_NO_LABEL_CLASS = "ms-CommandButton--noLabel";
	var SEARCH_BOX_CLOSE = ".ms-SearchBox-closeField";
	var COMMAND_BUTTON = ".ms-CommandButton";
	var COMMAND_BUTTON_LABEL = ".ms-CommandButton-label";
	var ICON = ".ms-Icon";
	var OVERFLOW_WIDTH = 40;
	var OVERFLOW_LEFT_RIGHT_PADDING = 30;

	var CommandBar = function () {
	  function CommandBar(container) {
	    this.responsiveSizes = {
	      "sm-min": 320,
	      "md-min": 480,
	      "lg-min": 640,
	      "xl-min": 1024,
	      "xxl-min": 1366,
	      "xxxl-min": 1920
	    };
	    this.visibleCommands = [];
	    this.commandWidths = [];
	    this.overflowCommands = [];
	    this.itemCollection = [];
	    this._sideAreaCollection = [];
	    this.breakpoint = "sm";
	    this._container = container;
	    this.responsiveSizes["sm-max"] = this.responsiveSizes["md-min"] - 1;
	    this.responsiveSizes["md-max"] = this.responsiveSizes["lg-min"] - 1;
	    this.responsiveSizes["lg-max"] = this.responsiveSizes["xl-min"] - 1;
	    this.responsiveSizes["xl-max"] = this.responsiveSizes["xxl-min"] - 1;
	    this.responsiveSizes["xxl-max"] = this.responsiveSizes["xxxl-min"] - 1;

	    this._setElements();

	    this._setBreakpoint();

	    if (this._elements.overflowCommand) {
	      this._initOverflow();
	    }

	    this._setUIState();
	  }

	  CommandBar.prototype._runsSearchBox = function (state) {
	    if (state === void 0) {
	      state = "add";
	    }

	    this._changeSearchState("is-collapsed", state);
	  };

	  CommandBar.prototype._runOverflow = function () {
	    if (this._elements.overflowCommand) {
	      this._saveCommandWidths();

	      this._redrawMenu();

	      this._updateCommands();

	      this._drawCommands();

	      this._checkOverflow();
	    }
	  };

	  CommandBar.prototype._initOverflow = function () {
	    this._createContextualRef();

	    this._createItemCollection(this.itemCollection, CB_MAIN_AREA);

	    this._createItemCollection(this._sideAreaCollection, CB_SIDE_COMMAND_AREA);

	    this._saveCommandWidths();

	    this._updateCommands();

	    this._drawCommands();

	    this._setWindowEvent();

	    this._checkOverflow();
	  };

	  CommandBar.prototype._hasClass = function (element, cls) {
	    return (" " + element.className + " ").indexOf(" " + cls + " ") > -1;
	  };

	  CommandBar.prototype._onSearchExpand = function () {
	    if (this.breakpoint === "lg") {
	      this._container.classList.add("search-expanded");

	      this._doResize();
	    }
	  };

	  CommandBar.prototype._onSearchCollapse = function () {
	    if (this.breakpoint === "lg") {
	      this._container.classList.remove("search-expanded");

	      this._doResize();
	    }
	  };

	  CommandBar.prototype._getScreenSize = function () {
	    var w = window;
	    var wSize = {
	      x: 0,
	      y: 0
	    };
	    var d = document,
	        e = d.documentElement,
	        g = d.getElementsByTagName("body")[0];
	    wSize.x = w.innerWidth || e.clientWidth || g.clientWidth;
	    wSize.y = w.innerHeight || e.clientHeight || g.clientHeight;
	    return wSize;
	  };

	  CommandBar.prototype._setBreakpoint = function () {
	    var screenSize = this._getScreenSize().x;

	    switch (true) {
	      case screenSize <= this.responsiveSizes["sm-max"]:
	        this.breakpoint = "sm";
	        break;

	      case screenSize >= this.responsiveSizes["md-min"] && screenSize <= this.responsiveSizes["md-max"]:
	        this.breakpoint = "md";
	        break;

	      case screenSize >= this.responsiveSizes["lg-min"] && screenSize <= this.responsiveSizes["lg-max"]:
	        this.breakpoint = "lg";
	        break;

	      case screenSize >= this.responsiveSizes["xl-min"] && screenSize <= this.responsiveSizes["xl-max"]:
	        this.breakpoint = "xl";
	        break;

	      case screenSize >= this.responsiveSizes["xxl-min"] && screenSize <= this.responsiveSizes["xxl-max"]:
	        this.breakpoint = "xxl";
	        break;

	      case screenSize >= this.responsiveSizes["xxxl-min"]:
	        this.breakpoint = "xxxl";
	        break;
	    }
	  };

	  CommandBar.prototype._createSearchInstance = function () {
	    if (this._elements.searchBox) {
	      return new SearchBox(this._elements.searchBox);
	    } else {
	      return false;
	    }
	  };

	  CommandBar.prototype._changeSearchState = function (state, action) {
	    if (this._elements.searchBox) {
	      switch (action) {
	        case "remove":
	          this._elements.searchBox.classList.remove(state);

	          break;

	        case "add":
	          this._elements.searchBox.classList.add(state);

	          break;

	        default:
	          break;
	      }
	    }
	  };

	  CommandBar.prototype._setElements = function () {
	    var _this = this;

	    this._elements = {
	      mainArea: this._container.querySelector(CB_MAIN_AREA)
	    };

	    if (this._container.querySelector(CB_SIDE_COMMAND_AREA)) {
	      this._elements.sideCommandArea = this._container.querySelector(CB_SIDE_COMMAND_AREA);
	    }

	    if (this._container.querySelector(CB_ITEM_OVERFLOW)) {
	      this._elements.overflowCommand = this._container.querySelector(CB_ITEM_OVERFLOW);
	      this._elements.contextMenu = this._container.querySelector(CB_ITEM_OVERFLOW).querySelector(CONTEXTUAL_MENU);
	    }

	    if (this._container.querySelector(CB_MAIN_AREA + " " + CB_SEARCH_BOX)) {
	      this._elements.searchBox = this._container.querySelector(CB_MAIN_AREA + " " + CB_SEARCH_BOX);
	      this._elements.searchBoxClose = this._container.querySelector(SEARCH_BOX_CLOSE);
	      this.searchBoxInstance = this._createSearchInstance();
	      this.searchBoxInstance.getInputField().addEventListener("focus", function () {
	        _this._onSearchExpand();
	      }, false);
	      this.searchBoxInstance.getInputField().addEventListener("searchCollapse", function () {
	        _this._onSearchCollapse();
	      }, false);
	    }
	  };

	  CommandBar.prototype._createItemCollection = function (iCollection, areaClass) {
	    var item,
	        label,
	        iconClasses,
	        splitClasses,
	        items = this._container.querySelectorAll(areaClass + " > " + COMMAND_BUTTON + ":not(" + CB_ITEM_OVERFLOW + ")");

	    this._commandButtonInstance = new CommandButton(this._elements.overflowCommand);

	    for (var i = 0; i < items.length; i++) {
	      item = items[i];
	      label = item.querySelector(COMMAND_BUTTON_LABEL).textContent;
	      var icon = item.querySelector(ICON);

	      if (icon) {
	        iconClasses = icon.className;
	        splitClasses = iconClasses.split(" ");

	        for (var o = 0; o < splitClasses.length; o++) {
	          if (splitClasses[o].indexOf(ICON.replace(".", "") + "--") > -1) {
	            icon = splitClasses[o];
	            break;
	          }
	        }
	      }

	      iCollection.push({
	        item: item,
	        label: label,
	        icon: icon,
	        isCollapsed: item.classList.contains(CB_NO_LABEL_CLASS) ? true : false,
	        commandButtonRef: new CommandButton(item)
	      });
	    }

	    return;
	  };

	  CommandBar.prototype._createContextualRef = function () {
	    this.contextualItemContainerRef = this._elements.contextMenu.querySelector(CONTEXTUAL_MENU_ITEM).cloneNode(true);
	    this.contextualItemLink = this._elements.contextMenu.querySelector(CONTEXTUAL_MENU_LINK).cloneNode(false);
	    this.contextualItemIcon = this._elements.contextMenu.querySelector(".ms-Icon").cloneNode(false);
	    this._elements.contextMenu.innerHTML = "";
	  };

	  CommandBar.prototype._getElementWidth = function (element) {
	    var width, styles;

	    if (element.offsetParent === null) {
	      element.setAttribute("style", "position: absolute; opacity: 0; display: block;");
	    }

	    width = element.getBoundingClientRect().width;
	    styles = window.getComputedStyle(element);
	    width += parseInt(styles.marginLeft, 10) + parseInt(styles.marginRight, 10);
	    element.setAttribute("style", "");
	    return width;
	  };

	  CommandBar.prototype._saveCommandWidths = function () {
	    for (var i = 0; i < this.itemCollection.length; i++) {
	      var item = this.itemCollection[i].item;

	      var width = this._getElementWidth(item);

	      this.commandWidths[i] = width;
	    }
	  };

	  CommandBar.prototype._updateCommands = function () {
	    var searchCommandWidth = 0;

	    var mainAreaWidth = this._elements.mainArea.getBoundingClientRect().width;

	    if (this._elements.searchBox) {
	      searchCommandWidth = this._getElementWidth(this._elements.searchBox);
	    }

	    var offset = searchCommandWidth + OVERFLOW_WIDTH + OVERFLOW_LEFT_RIGHT_PADDING;
	    var totalAreaWidth = mainAreaWidth - offset;
	    this.visibleCommands = [];
	    this.overflowCommands = [];
	    var totalWidths = 0;

	    for (var i = 0; i < this.itemCollection.length; i++) {
	      totalWidths += this.commandWidths[i];

	      if (totalWidths < totalAreaWidth) {
	        this.visibleCommands.push(this.itemCollection[i]);
	      } else {
	        this.overflowCommands.push(this.itemCollection[i]);
	      }
	    }
	  };

	  CommandBar.prototype._drawCommands = function () {
	    this._elements.contextMenu.innerHTML = "";

	    for (var i = 0; i < this.overflowCommands.length; i++) {
	      this.overflowCommands[i].item.classList.add("is-hidden");
	      var newCItem = this.contextualItemContainerRef.cloneNode(false);
	      var newClink = this.contextualItemLink.cloneNode(false);
	      var iconClass = this.overflowCommands[i].icon;
	      newClink.innerText = this.overflowCommands[i].label;
	      newCItem.appendChild(newClink);

	      if (iconClass) {
	        var newIcon = this.contextualItemIcon.cloneNode(false);
	        newIcon.className = ICON.replace(".", "") + " " + iconClass;
	        newCItem.appendChild(newIcon);
	      }

	      this._elements.contextMenu.appendChild(newCItem);
	    }

	    for (var x = 0; x < this.visibleCommands.length; x++) {
	      this.visibleCommands[x].item.classList.remove("is-hidden");
	    }
	  };

	  CommandBar.prototype._setWindowEvent = function () {
	    var _this = this;

	    window.addEventListener("resize", function () {
	      _this._doResize();
	    }, false);
	  };

	  CommandBar.prototype._processCollapsedClasses = function (type) {
	    for (var i = 0; i < this.itemCollection.length; i++) {
	      var thisItem = this.itemCollection[i];

	      if (!thisItem.isCollapsed) {
	        if (type === "add") {
	          thisItem.item.classList.add(CB_NO_LABEL_CLASS);
	        } else {
	          thisItem.item.classList.remove(CB_NO_LABEL_CLASS);
	        }
	      }
	    }

	    for (var i = 0; i < this._sideAreaCollection.length; i++) {
	      var thisItem = this._sideAreaCollection[i];

	      if (!thisItem.isCollapsed) {
	        if (type === "add") {
	          thisItem.item.classList.add(CB_NO_LABEL_CLASS);
	        } else {
	          thisItem.item.classList.remove(CB_NO_LABEL_CLASS);
	        }
	      }
	    }
	  };

	  CommandBar.prototype._setUIState = function () {
	    switch (this.breakpoint) {
	      case "sm":
	        this._runsSearchBox();

	        this._processCollapsedClasses("add");

	        this._runOverflow();

	        break;

	      case "md":
	        this._runsSearchBox();

	        this._processCollapsedClasses("add");

	        this._runOverflow();

	        break;

	      case "lg":
	        this._runsSearchBox();

	        this._processCollapsedClasses("remove");

	        this._runOverflow();

	        break;

	      case "xl":
	        this._runsSearchBox("remove");

	        this._processCollapsedClasses("remove");

	        this._runOverflow();

	        break;

	      default:
	        this._runsSearchBox("remove");

	        this._processCollapsedClasses("remove");

	        this._runOverflow();

	        break;
	    }
	  };

	  CommandBar.prototype._checkOverflow = function () {
	    if (this.overflowCommands.length > 0) {
	      this._elements.overflowCommand.classList.remove("is-hidden");
	    } else {
	      this._elements.overflowCommand.classList.add("is-hidden");

	      if (this.activeCommand === this._elements.overflowCommand) {
	        this._elements.contextMenu.classList.remove("is-open");
	      }
	    }
	  };

	  CommandBar.prototype._redrawMenu = function () {
	    var left;

	    if (this._hasClass(this._elements.contextMenu, "is-open")) {
	      left = this.activeCommand.getBoundingClientRect().left;

	      this._drawOverflowMenu(left);
	    }
	  };

	  CommandBar.prototype._drawOverflowMenu = function (left) {
	    this._elements.contextMenu.setAttribute("style", "left: " + left + "px; transform: translateX(-50%)");
	  };

	  CommandBar.prototype._doResize = function () {
	    this._setBreakpoint();

	    this._setUIState();
	  };

	  return CommandBar;
	}();

	var commandbutton = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-CommandButton",class:_vm.commandButtonClass,on:{"click":_vm.clickEvent}},[_c('button',{staticClass:"ms-CommandButton-button"},[(_vm.icon)?_c('span',{staticClass:"ms-CommandButton-icon ms-fontColor-themePrimary"},[_c('i',{staticClass:"ms-Icon",class:_vm.iconClass})]):_vm._e(),_vm._v(" "),_c('span',{staticClass:"ms-CommandButton-label"},[_vm._t("default")],2),_vm._v(" "),(_vm.type == 'dropdown')?_c('span',{staticClass:"ms-CommandButton-dropdownIcon"},[_c('i',{staticClass:"ms-Icon ms-Icon--ChevronDown"})]):_vm._e()])])},staticRenderFns: [],
	  name: 'ou-command-button',

	  mixins: [
	    type('noLabel', 'inline', 'dropdown'),
	    disabled,
	    icon
	  ],

	  computed: {
	    commandButtonClass: function commandButtonClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-CommandButton--" + (this.type))] = !!this.type, obj['is-disabled'] =  this.disabled, obj );
	    }
	  },

	  methods: {
	    clickEvent: function clickEvent() {
	      if (!this.disabled) { this.$emit('click'); }
	    }
	  }
	};

	var CONTEXT_CLASS$1 = ".ms-ContextualMenu";
	var CB_SPLIT_CLASS$1 = ".ms-CommandButton-splitIcon";
	var CB_BUTTON_CLASS$1 = ".ms-CommandButton-button";
	var MODAL_POSITION$2 = "bottom";

	var CommandButton$1 = function () {
	  function CommandButton(container, contextMenu) {
	    this._container = container;
	    this._command = this._container;
	    this._commandButton = this._command.querySelector(CB_BUTTON_CLASS$1);
	    this._splitButton = this._command.querySelector(CB_SPLIT_CLASS$1);

	    if (contextMenu) {
	      this._contextualMenu = contextMenu;
	    } else {
	      this._contextualMenu = this._container.querySelector(CONTEXT_CLASS$1);
	    }

	    this._checkForMenu();
	  }

	  CommandButton.prototype._createModalHostView = function () {
	    this._modalHostView = new ContextualHost(this._contextualMenu, MODAL_POSITION$2, this._command, false);
	  };

	  CommandButton.prototype._setClick = function () {
	    if (this._splitButton) {
	      this._splitButton.addEventListener("click", this._createModalHostView.bind(this), false);
	    } else {
	      this._commandButton.addEventListener("click", this._createModalHostView.bind(this), false);
	    }
	  };

	  CommandButton.prototype._checkForMenu = function () {
	    if (this._contextualMenu) {
	      this._setClick();
	    }
	  };

	  return CommandButton;
	}();

	var dialog = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"dialog",staticClass:"ms-Dialog",class:_vm.dialogClass},[(_vm.type == 'close')?_c('button',{staticClass:"ms-Dialog-button ms-Dialog-buttonClose",on:{"click":_vm.closeDialog}},[_c('i',{staticClass:"ms-Icon ms-Icon--Cancel"})]):_vm._e(),_vm._v(" "),_c('div',{staticClass:"ms-Dialog-title"},[_vm._v(_vm._s(_vm.title))]),_vm._v(" "),_c('div',{staticClass:"ms-Dialog-content"},[_c('p',{staticClass:"ms-Dialog-subText"},[_vm._v(_vm._s(_vm.subText))]),_vm._v(" "),_vm._t("default")],2),_vm._v(" "),_c('div',{staticClass:"ms-Dialog-actions"},[_vm._t("actions")],2)])},staticRenderFns: [],
	  name: 'ou-dialog',

	  mixins: [type('multiline', 'lgHeader', 'blocking', 'close')],

	  props: {
	    title: String,
	    subText: String,

	    value: {
	      type: Boolean,
	      default: false
	    }
	  },

	  data: function data() {
	    return {
	      dialogInstance: null
	    };
	  },

	  computed: {
	    dialogClass: function dialogClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-Dialog--" + (this.type))] = !!this.type, obj );
	    }
	  },

	  watch: {
	    value: function value(value$1) {
	      this.setDialogVisibility(value$1);
	    }
	  },

	  mounted: function mounted() {
	    this.dialogInstance = new this.$fabric.Dialog(this.$refs.dialog);
	    this.setDialogVisibility(this.value);
	  },

	  methods: {
	    setDialogVisibility: function setDialogVisibility(value) {
	      if (value) {
	        this.dialogInstance.open();

	        // Because the office ui fabric js don't support on_close or on_open event in dialog
	        // component, So I have to write some hacking code to change the visible status when
	        // click the overlay. Otherwise the visible status can't change, when click the overlay
	        // to close the dialog.
	        this.bindOverlayCloseEvent();
	      } else if (this.isOpen()) {
	        // Avoid to destroy overlay element twice, and get errors, so determine if the dialog
	        // was opened before close it.
	        this.dialogInstance.close();
	      }
	    },

	    bindOverlayCloseEvent: function bindOverlayCloseEvent() {
	      var this$1 = this;

	      if (this.dialogInstance._overlay) {
	        var overlayElement = this.dialogInstance._overlay.overlayElement;

	        var closeOverlay = function () {
	          overlayElement.removeEventListener('click', closeOverlay);
	          this$1.$emit('input', false);
	        };

	        overlayElement.addEventListener('click', closeOverlay);
	      }
	    },

	    isOpen: function isOpen() {
	      // When the dialog is shown, the dialog element add a class name of 'is-open',
	      // So use this to determine the dialog if was opened.
	      return this.$refs.dialog.classList.contains('is-open');
	    },

	    closeDialog: function closeDialog(event) {
	      this.$emit('input', false);


	      // Because the original close button element have the click event to close the dialog,
	      // when I fire the click event, the original click event function will fire behind it,
	      // So stop the original click event, when I fire the click event.
	      event.stopImmediatePropagation();
	    }
	  }
	};

	var Overlay = function () {
	  function Overlay(overlayElement) {
	    if (overlayElement) {
	      this.overlayElement = overlayElement;
	    } else {
	      var overlayContainer = document.createElement("div");
	      overlayContainer.setAttribute("class", "ms-Overlay");
	      this.overlayElement = overlayContainer;
	    }

	    this.overlayElement.addEventListener("click", this.hide.bind(this), false);
	  }

	  Overlay.prototype.remove = function () {
	    this.overlayElement.parentElement.removeChild(this.overlayElement);
	  };

	  Overlay.prototype.show = function () {
	    this.overlayElement.classList.add("is-visible");
	    document.body.classList.add("ms-u-overflowHidden");
	  };

	  Overlay.prototype.hide = function () {
	    this.overlayElement.classList.remove("is-visible");
	    document.body.classList.remove("ms-u-overflowHidden");
	  };

	  return Overlay;
	}();

	var Dialog = function () {
	  function Dialog(dialog) {
	    this._dialog = dialog;
	    this._closeButtonElement = this._dialog.querySelector(".ms-Dialog-buttonClose");
	    this._actionButtonElements = this._dialog.querySelectorAll(".ms-Dialog-action");

	    if (this._closeButtonElement) {
	      this._closeButtonElement.addEventListener("click", this.close.bind(this), false);
	    }

	    for (var i = 0; i < this._actionButtonElements.length; i++) {
	      this._actionButtonElements[i].addEventListener("click", this.close.bind(this), false);
	    }
	  }

	  Dialog.prototype.close = function () {
	    this._overlay.remove();

	    this._dialog.classList.remove("is-open");

	    document.body.classList.remove("ms-u-overflowHidden");

	    this._overlay.overlayElement.removeEventListener("click", this.close.bind(this));
	  };

	  Dialog.prototype.open = function () {
	    this._dialog.classList.add("is-open");

	    this._overlay = new Overlay();

	    if (!this._dialog.classList.contains("ms-Dialog--blocking")) {
	      this._overlay.overlayElement.addEventListener("click", this.close.bind(this), false);

	      this._overlay.show();

	      document.body.classList.add("ms-u-overflowHidden");
	    }

	    this._dialog.parentElement.appendChild(this._overlay.overlayElement);
	  };

	  return Dialog;
	}();

	var PANEL_HOST_CLASS = "ms-PanelHost";

	var PanelHost = function () {
	  function PanelHost(layer, callBack) {
	    this._layer = layer;
	    this._callBack = callBack;

	    this._createElements();

	    this._renderElements();
	  }

	  PanelHost.prototype.dismiss = function () {
	    this.overlay.hide();
	    document.body.removeChild(this.panelHost);
	  };

	  PanelHost.prototype.update = function (layer, callBack) {
	    this.panelHost.replaceChild(layer, this._layer);

	    if (callBack) {
	      callBack();
	    }
	  };

	  PanelHost.prototype._renderElements = function () {
	    document.body.appendChild(this.panelHost);

	    if (this._callBack) {
	      this._callBack(this._layer);
	    }
	  };

	  PanelHost.prototype._createElements = function () {
	    this.panelHost = document.createElement("div");
	    this.panelHost.classList.add(PANEL_HOST_CLASS);
	    this.panelHost.appendChild(this._layer);
	    this.overlay = new Overlay(this._overlayContainer);
	    this.overlay.show();
	    this.panelHost.appendChild(this.overlay.overlayElement);
	  };

	  return PanelHost;
	}();

	var ANIMATE_IN_STATE = "animate-in";
	var ANIMATE_OUT_STATE = "animate-out";
	var ANIMATION_END = 400;

	var Panel = function () {
	  function Panel(panel, direction, animateOverlay) {
	    this._panel = panel;
	    this._direction = direction || "right";
	    this._animateOverlay = animateOverlay || true;
	    this.panelHost = new PanelHost(this._panel, this._animateInPanel);
	    this._closeButton = this._panel.querySelector(".ms-PanelAction-close");
	    this._clickHandler = this.dismiss.bind(this, null);

	    this._setEvents();

	    document.body.setAttribute("style", "height: 100%; overflow: hidden;");
	  }

	  Panel.prototype.dismiss = function (callBack) {
	    var _this = this;

	    this._panel.classList.add(ANIMATE_OUT_STATE);

	    setTimeout(function () {
	      _this._panel.classList.remove(ANIMATE_OUT_STATE);

	      _this._panel.classList.remove("is-open");

	      _this.panelHost.dismiss();

	      if (callBack) {
	        callBack();
	      }

	      document.body.setAttribute("style", "");
	    }, ANIMATION_END);

	    if (this._closeButton !== null) {
	      this._closeButton.removeEventListener("click", this._clickHandler);
	    }
	  };

	  Panel.prototype._setEvents = function () {
	    this.panelHost.overlay.overlayElement.addEventListener("click", this._clickHandler);

	    if (this._closeButton !== null) {
	      this._closeButton.addEventListener("click", this._clickHandler);
	    }
	  };

	  Panel.prototype._animateInPanel = function (layer) {
	    layer.classList.add(ANIMATE_IN_STATE);
	    layer.classList.add("is-open");
	    setTimeout(function () {
	      layer.classList.remove(ANIMATE_IN_STATE);
	    }, ANIMATION_END);
	  };

	  return Panel;
	}();

	var DROPDOWN_CLASS = "ms-Dropdown";
	var DROPDOWN_TITLE_CLASS = "ms-Dropdown-title";
	var DROPDOWN_LABEL_HELPER = "ms-Dropdown-truncator";
	var DROPDOWN_ITEMS_CLASS = "ms-Dropdown-items";
	var DROPDOWN_ITEM_CLASS = "ms-Dropdown-item";
	var DROPDOWN_SELECT_CLASS_SELECTOR = ".ms-Dropdown-select";
	var PANEL_CLASS = "ms-Panel";
	var IS_OPEN_CLASS = "is-open";
	var IS_DISABLED_CLASS = "is-disabled";
	var IS_SELECTED_CLASS = "is-selected";
	var ANIMATE_IN_CLASS = "animate-in";
	var SMALL_MAX_WIDTH = 479;

	var Dropdown$1 = function () {
	  function Dropdown(container) {
	    this._container = container;
	    this._dropdownLabelHelper = document.createElement("span");

	    this._dropdownLabelHelper.classList.add(DROPDOWN_LABEL_HELPER);

	    this._dropdownLabelHelper.classList.add(DROPDOWN_TITLE_CLASS);

	    this._newDropdownLabel = document.createElement("span");

	    this._newDropdownLabel.classList.add(DROPDOWN_TITLE_CLASS);

	    this._newDropdown = document.createElement("ul");

	    this._newDropdown.classList.add(DROPDOWN_ITEMS_CLASS);

	    this._dropdownItems = [];
	    this._originalDropdown = container.querySelector(DROPDOWN_SELECT_CLASS_SELECTOR);

	    var _originalOptions = this._originalDropdown.querySelectorAll("option");

	    this._onCloseDropdown = this._onCloseDropdown.bind(this);
	    this._onItemSelection = this._onItemSelection.bind(this);
	    this._onOpenDropdown = this._onOpenDropdown.bind(this);

	    for (var i = 0; i < _originalOptions.length; ++i) {
	      var option = _originalOptions[i];

	      if (option.selected) {
	        this._newDropdownLabel.innerHTML = option.text;
	      }

	      var newItem = document.createElement("li");
	      newItem.classList.add(DROPDOWN_ITEM_CLASS);

	      if (option.disabled) {
	        newItem.classList.add(IS_DISABLED_CLASS);
	      }

	      if (option.selected) {
	        newItem.classList.add(IS_SELECTED_CLASS);
	      }

	      newItem.innerHTML = option.text;
	      newItem.addEventListener("click", this._onItemSelection);

	      this._newDropdown.appendChild(newItem);

	      this._dropdownItems.push({
	        oldOption: option,
	        newItem: newItem
	      });
	    }

	    container.appendChild(this._newDropdownLabel);
	    container.appendChild(this._newDropdown);
	    container.appendChild(this._dropdownLabelHelper);

	    this._newDropdownLabel.addEventListener("click", this._onOpenDropdown);

	    this._checkTruncation();

	    this._setWindowEvent();
	  }

	  Dropdown.prototype._setWindowEvent = function () {
	    var _this = this;

	    window.addEventListener("resize", function () {
	      _this._doResize();

	      _this._checkTruncation();
	    }, false);
	  };

	  Dropdown.prototype._checkTruncation = function () {
	    var selected = this._newDropdown.querySelector("." + IS_SELECTED_CLASS);

	    var origText = selected ? selected.textContent : this._newDropdown.querySelectorAll("." + DROPDOWN_ITEM_CLASS)[0].textContent;
	    this._dropdownLabelHelper.textContent = origText;

	    if (this._dropdownLabelHelper.offsetHeight > this._newDropdownLabel.offsetHeight) {
	      var i = 0;
	      var ellipsis = "...";
	      var newText = void 0;

	      do {
	        i--;
	        newText = origText.slice(0, i);
	        this._dropdownLabelHelper.textContent = newText + ellipsis;
	      } while (this._dropdownLabelHelper.offsetHeight > this._newDropdownLabel.offsetHeight);
	    }

	    this._newDropdownLabel.textContent = this._dropdownLabelHelper.textContent;
	  };

	  Dropdown.prototype._getScreenSize = function () {
	    var w = window;
	    var wSize = {
	      x: 0,
	      y: 0
	    };
	    var d = document,
	        e = d.documentElement,
	        g = d.getElementsByTagName("body")[0];
	    wSize.x = w.innerWidth || e.clientWidth || g.clientWidth;
	    wSize.y = w.innerHeight || e.clientHeight || g.clientHeight;
	    return wSize;
	  };

	  Dropdown.prototype._doResize = function () {
	    var isOpen = this._container.classList.contains(IS_OPEN_CLASS);

	    if (!isOpen) {
	      return;
	    }

	    var screenSize = this._getScreenSize().x;

	    if (screenSize <= SMALL_MAX_WIDTH) {
	      this._openDropdownAsPanel();
	    } else {
	      this._removeDropdownAsPanel();
	    }
	  };

	  Dropdown.prototype._openDropdownAsPanel = function () {
	    if (this._panel === undefined) {
	      this._panelContainer = document.createElement("div");

	      this._panelContainer.classList.add(PANEL_CLASS);

	      this._panelContainer.classList.add(DROPDOWN_CLASS);

	      this._panelContainer.classList.add(IS_OPEN_CLASS);

	      this._panelContainer.classList.add(ANIMATE_IN_CLASS);

	      this._panelContainer.appendChild(this._newDropdown);

	      this._panel = new Panel(this._panelContainer);
	    }
	  };

	  Dropdown.prototype._removeDropdownAsPanel = function (evt) {
	    var _this = this;

	    if (this._panel !== undefined) {
	      if (evt && evt.target === this._panel.panelHost.overlay.overlayElement) {
	        this._container.appendChild(this._newDropdown);
	      } else {
	        this._panel.dismiss(function () {
	          _this._container.appendChild(_this._newDropdown);
	        });
	      }

	      this._panel = undefined;
	    }
	  };

	  Dropdown.prototype._onOpenDropdown = function (evt) {
	    var isDisabled = this._container.classList.contains(IS_DISABLED_CLASS);

	    var isOpen = this._container.classList.contains(IS_OPEN_CLASS);

	    if (!isDisabled && !isOpen) {
	      evt.stopPropagation();

	      this._closeOtherDropdowns();

	      this._container.classList.add(IS_OPEN_CLASS);

	      document.addEventListener("click", this._onCloseDropdown);

	      var screenSize = this._getScreenSize().x;

	      if (screenSize <= SMALL_MAX_WIDTH) {
	        this._openDropdownAsPanel();
	      }
	    }
	  };

	  Dropdown.prototype._closeOtherDropdowns = function () {
	    var dropdowns = document.querySelectorAll("." + DROPDOWN_CLASS + "." + IS_OPEN_CLASS);

	    for (var i = 0; i < dropdowns.length; i++) {
	      dropdowns[i].classList.remove(IS_OPEN_CLASS);
	    }
	  };

	  Dropdown.prototype._onCloseDropdown = function (evt) {
	    this._removeDropdownAsPanel(evt);

	    this._container.classList.remove(IS_OPEN_CLASS);

	    document.removeEventListener("click", this._onCloseDropdown);
	  };

	  Dropdown.prototype._onItemSelection = function (evt) {
	    var item = evt.target;

	    var isDropdownDisabled = this._container.classList.contains(IS_DISABLED_CLASS);

	    var isOptionDisabled = item.classList.contains(IS_DISABLED_CLASS);

	    if (!isDropdownDisabled && !isOptionDisabled) {
	      for (var i = 0; i < this._dropdownItems.length; ++i) {
	        if (this._dropdownItems[i].newItem === item) {
	          this._dropdownItems[i].newItem.classList.add(IS_SELECTED_CLASS);

	          this._dropdownItems[i].oldOption.selected = true;
	        } else {
	          this._dropdownItems[i].newItem.classList.remove(IS_SELECTED_CLASS);

	          this._dropdownItems[i].oldOption.selected = false;
	        }
	      }

	      this._newDropdownLabel.innerHTML = item.textContent;

	      this._checkTruncation();

	      var changeEvent = document.createEvent("HTMLEvents");
	      changeEvent.initEvent("change", false, true);

	      this._originalDropdown.dispatchEvent(changeEvent);
	    }
	  };

	  return Dropdown;
	}();

	var ListItem = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('li',{ref:"listItem",staticClass:"ms-ListItem",class:_vm.listItemClass,on:{"click":_vm.clickEvent}},[(_vm.type == 'image')?_c('img',{staticClass:"ms-ListItem-image",attrs:{"src":_vm.imageSrc}}):_vm._e(),_vm._v(" "),(_vm.primaryText)?_c('span',{staticClass:"ms-ListItem-primaryText"},[_vm._v(_vm._s(_vm.primaryText))]):_vm._e(),_vm._v(" "),(_vm.secondaryText)?_c('span',{staticClass:"ms-ListItem-secondaryText"},[_vm._v(_vm._s(_vm.secondaryText))]):_vm._e(),_vm._v(" "),(_vm.tertiaryText)?_c('span',{staticClass:"ms-ListItem-tertiaryText"},[_vm._v(_vm._s(_vm.tertiaryText))]):_vm._e(),_vm._v(" "),(_vm.metaText)?_c('span',{staticClass:"ms-ListItem-metaText"},[_vm._v(_vm._s(_vm.metaText))]):_vm._e(),_vm._v(" "),(_vm.isSelectable)?_c('div',{staticClass:"ms-ListItem-selectionTarget",on:{"click":function($event){$event.stopPropagation();return _vm.toggle($event)}}}):_vm._e(),_vm._v(" "),_vm._t("default")],2)},staticRenderFns: [],
	  name: 'ou-list-item',

	  mixins: [type('image', 'document')],

	  props: {
	    isUnread: Boolean,
	    isSelectable: Boolean,
	    isUnseen: Boolean,
	    value: Boolean,

	    imageSrc: String,
	    primaryText: String,
	    secondaryText: String,
	    tertiaryText: String,
	    metaText: String
	  },

	  computed: {
	    listItemClass: function listItemClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-ListItem--" + (this.type))] = !!this.type, obj['is-selectable'] =  this.isSelectable, obj['is-selected'] =  this.value, obj['is-unread'] =  this.isUnread, obj['is-unseen'] =  this.isUnseen, obj );
	    }
	  },

	  methods: {
	    toggle: function toggle() {
	      if (this.isSelectable) {
	        this.$emit('input', !this.value);
	      }
	    },

	    clickEvent: function clickEvent() {
	      this.$emit('click');
	    }
	  }
	};

	var MessageBar = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-MessageBar",class:_vm.messageBarClass},[_c('div',{staticClass:"ms-MessageBar-content"},[(_vm.icon)?_c('div',{staticClass:"ms-MessageBar-icon"},[_c('i',{staticClass:"ms-Icon",class:_vm.iconClass})]):_vm._e(),_vm._v(" "),_c('div',{staticClass:"ms-MessageBar-text"},[_vm._t("default")],2)])])},staticRenderFns: [],
	  name: 'ou-message-bar',

	  mixins: [
	    type('success', 'error', 'blocked', 'warning', 'severeWarning'),
	    icon
	  ],

	  computed: {
	    messageBarClass: function messageBarClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-MessageBar--" + (this.type))] = !!this.type, obj );
	    }
	  }
	};

	var overlay = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"overlay",staticClass:"ms-Overlay",class:_vm.overlayClass})},staticRenderFns: [],
	  name: 'ou-overlay',

	  mixins: [type('dark')],

	  props: {
	    value: Boolean
	  },

	  data: function data() {
	    return {
	      overlayInstance: null
	    };
	  },

	  watch: {
	    value: function value() {
	      this.setOverlayVisibility();
	    }
	  },

	  computed: {
	    overlayClass: function overlayClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-Overlay--" + (this.type))] = !!this.type, obj );
	    }
	  },

	  mounted: function mounted() {
	    this.overlayInstance = new this.$fabric.Overlay(this.$refs.overlay);

	    this.setOverlayVisibility();
	    this.bindOverlayCloseEvent();
	  },

	  methods: {
	    setOverlayVisibility: function setOverlayVisibility() {
	      this.value ? this.overlayInstance.show() : this.overlayInstance.hide();
	    },

	    bindOverlayCloseEvent: function bindOverlayCloseEvent() {
	      var this$1 = this;

	      // Because the overlay component don't have callback when overlay closed,
	      // So add a click event when click the overlay to set the value to false
	      var overlayElement = this.$refs.overlay;
	      var closeOverlay = function () {
	        this$1.$emit('input', false);
	      };

	      overlayElement.addEventListener('click', closeOverlay);
	    }
	  }
	};

	function size () {
	  var arguments$1 = arguments;

	  for (var _len = arguments.length, size = new Array(_len), _key = 0; _key < _len; _key++) {
	    size[_key] = arguments$1[_key];
	  }

	  size.push('');
	  return {
	    props: {
	      size: {
	        type: String,
	        default: '',
	        validator: function validator(value) {
	          return size.indexOf(value) !== -1;
	        }
	      }
	    }
	  };
	}

	var panel = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"panel",staticClass:"ms-Panel",class:_vm.panelClass},[_c('button',{staticClass:"ms-Panel-closeButton ms-PanelAction-close",on:{"click":_vm.closePanel}},[_c('i',{staticClass:"ms-Panel-closeIcon ms-Icon ms-Icon--Cancel"})]),_vm._v(" "),_c('div',{staticClass:"ms-Panel-contentInner"},[_c('p',{staticClass:"ms-Panel-headerText"},[_vm._v(_vm._s(_vm.title))]),_vm._v(" "),_c('div',{staticClass:"ms-Panel-content"},[_vm._t("default")],2)])])},staticRenderFns: [],
	  name: 'ou-panel',

	  mixins: [size('md', 'lg', 'xl', 'xxl')],

	  props: {
	    value: Boolean,
	    title: String,

	    fixed: {
	      type: Boolean,
	      default: false
	    },

	    left: {
	      type: Boolean,
	      default: false
	    },

	    block: {
	      type: Boolean,
	      default: false
	    }
	  },

	  data: function data() {
	    return {
	      panelInstance: null
	    };
	  },

	  watch: {
	    value: function value() {
	      this.setPanelVisibility();
	    }
	  },

	  computed: {
	    panelClass: function panelClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-Panel--" + (this.size))] = !!this.size, obj['ms-Panel--fixed'] =  this.fixed, obj['ms-Panel--left'] =  this.left, obj );
	    }
	  },

	  mounted: function mounted() {
	    this.setPanelVisibility();
	  },

	  methods: {
	    setPanelVisibility: function setPanelVisibility() {
	      if (this.value) {
	        this.panelInstance = new this.$fabric.Panel(this.$refs.panel);
	        this.bindOverlayCloseEvent();
	      } else if (this.panelInstance) {
	        this.panelInstance.dismiss();
	      }
	    },

	    // Because the office ui fabric js don't support on_close or on_open event in panel
	    // component, So I have to write some hacking code to change the visible status when
	    // click the overlay. Otherwise the visible status can't change, when click the overlay
	    // to close the panel.
	    bindOverlayCloseEvent: function bindOverlayCloseEvent() {
	      var overlayElement = this.panelInstance.panelHost.overlay.overlayElement;

	      if (this.block) {
	        // Remove overlayElement to avoid close panel when click overlay.
	        overlayElement.remove();
	      } else {
	        overlayElement.addEventListener('click', this.closePanel);
	      }
	    },

	    closePanel: function closePanel() {
	      this.$emit('input', false);

	      // Because the panel overlay have event to fire dismiss method when click it to
	      // close panel. To prevent fire the panel dismiss method again and raise some error,
	      // so set the panelInstance to null
	      this.panelInstance = null;
	    }
	  }
	};

	var ANIMATE_IN_STATE$1 = "animate-in";
	var ANIMATE_OUT_STATE$1 = "animate-out";
	var ANIMATION_END$1 = 400;

	var Panel$1 = function () {
	  function Panel(panel, direction, animateOverlay) {
	    this._panel = panel;
	    this._direction = direction || "right";
	    this._animateOverlay = animateOverlay || true;
	    this.panelHost = new PanelHost(this._panel, this._animateInPanel);
	    this._closeButton = this._panel.querySelector(".ms-PanelAction-close");
	    this._clickHandler = this.dismiss.bind(this, null);

	    this._setEvents();

	    document.body.setAttribute("style", "height: 100%; overflow: hidden;");
	  }

	  Panel.prototype.dismiss = function (callBack) {
	    var _this = this;

	    this._panel.classList.add(ANIMATE_OUT_STATE$1);

	    setTimeout(function () {
	      _this._panel.classList.remove(ANIMATE_OUT_STATE$1);

	      _this._panel.classList.remove("is-open");

	      _this.panelHost.dismiss();

	      if (callBack) {
	        callBack();
	      }

	      document.body.setAttribute("style", "");
	    }, ANIMATION_END$1);

	    if (this._closeButton !== null) {
	      this._closeButton.removeEventListener("click", this._clickHandler);
	    }
	  };

	  Panel.prototype._setEvents = function () {
	    this.panelHost.overlay.overlayElement.addEventListener("click", this._clickHandler);

	    if (this._closeButton !== null) {
	      this._closeButton.addEventListener("click", this._clickHandler);
	    }
	  };

	  Panel.prototype._animateInPanel = function (layer) {
	    layer.classList.add(ANIMATE_IN_STATE$1);
	    layer.classList.add("is-open");
	    setTimeout(function () {
	      layer.classList.remove(ANIMATE_IN_STATE$1);
	    }, ANIMATION_END$1);
	  };

	  return Panel;
	}();

	var persona = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{staticClass:"ms-Persona",class:_vm.personaClass},[_c('div',{staticClass:"ms-Persona-imageArea"},[(!_vm.initials)?_c('img',{staticClass:"ms-Persona-image",attrs:{"src":_vm.src}}):_c('div',{staticClass:"ms-Persona-initials",class:_vm.initialsPersonaClass},[_vm._v(_vm._s(_vm.initials.toUpperCase()))])]),_vm._v(" "),(_vm.type)?_c('div',{staticClass:"ms-Persona-presence"},[_c('i',{staticClass:"ms-Persona-presenceIcon ms-Icon",class:_vm.personaIconClass})]):_vm._e(),_vm._v(" "),_c('div',{staticClass:"ms-Persona-details"},[_c('div',{staticClass:"ms-Persona-primaryText"},[_vm._v(_vm._s(_vm.primaryText))]),_vm._v(" "),_c('div',{staticClass:"ms-Persona-secondaryText"},[_vm._v(_vm._s(_vm.secondaryText))]),_vm._v(" "),_c('div',{staticClass:"ms-Persona-tertiaryText"},[_vm._v(_vm._s(_vm.tertiaryText))]),_vm._v(" "),_c('div',{staticClass:"ms-Persona-optionalText"},[_vm._v(_vm._s(_vm.optionalText))])])])},staticRenderFns: [],
	  name: 'ou-persona',

	  mixins: [
	    size('tiny', 'xs', 'sm', 'lg', 'xl'),
	    type('available', 'away', 'blocked', 'busy', 'dnd', 'offline')
	  ],

	  data: function data() {
	    if (this.initials) {
	      var validateColor = [
	        'blue',
	        'blueLight',
	        'blueDark',
	        'teal',
	        'greenLight',
	        'green',
	        'greenDark',
	        'magentaLight',
	        'magenta',
	        'purpleLight',
	        'purple',
	        'black',
	        'orange',
	        'red',
	        'redDark'
	      ];

	      var initialsLetter = this.initials[0].toUpperCase();
	      var initialsIndex = initialsLetter.charCodeAt() - 65;

	      // get radom color from validateColor
	      return {
	        initialsColor: validateColor[Math.round((validateColor.length / 26) * initialsIndex)]
	      };
	    }

	    return { initialsColor: '' };
	  },

	  props: {
	    src: String,
	    initials: String,
	    primaryText: String,
	    secondaryText: String,
	    tertiaryText: String,
	    optionalText: String
	  },

	  computed: {
	    personaClass: function personaClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-Persona--" + (this.size))] = !!this.size, obj[("ms-Persona--" + (this.type))] = !!this.type, obj );
	    },

	    initialsPersonaClass: function initialsPersonaClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-Persona-initials--" + (this.initialsColor))] = !!this.initialsColor, obj );
	    },

	    personaIconClass: function personaIconClass() {
	      var icon = '';

	      switch (this.type) {
	        case 'available':
	          icon = 'SkypeCheck';
	          break;
	        case 'away':
	          icon = 'SkypeClock';
	          break;
	        case 'dnd':
	          icon = 'SkypeMinus';
	          break;
	      }

	      if (icon) {
	        return ("ms-Icon--" + icon);
	      }
	    }
	  }
	};

	var SCROLL_FRAME_RATE = 33;

	var Animate = function () {
	  function Animate() {}

	  Animate.transition = function (element, props) {
	    var obj = {
	      element: element,
	      props: props,
	      transformations: {}
	    };

	    Animate._animationObjects.push(obj);

	    Animate._parseProperties(obj);

	    Animate._createTransition(obj);

	    setTimeout(Animate._setProperties, 0, obj);

	    Animate._setCallback(obj);
	  };

	  Animate.animation = function (element, keyframes, props) {
	    var obj = {
	      element: element,
	      keyframes: keyframes,
	      props: props
	    };

	    Animate._animationObjects.push(obj);

	    Animate._parseProperties(obj);

	    Animate._createAnimation(obj);

	    Animate._setCallback(obj);
	  };

	  Animate.scrollTo = function (element, props) {
	    var obj = {
	      element: element,
	      props: props,
	      step: 0
	    };

	    Animate._setScrollProperties(obj);

	    if (obj.props.delay) {
	      setTimeout(Animate._animationObjects, obj.props.delay * 1000, obj);
	    } else {
	      Animate._animateScroll(obj);
	    }

	    Animate._animationObjects.push(obj);
	  };

	  Animate._setScrollProperties = function (obj) {
	    obj.beginTop = obj.element.scrollTop;
	    obj.change = obj.props.top - obj.beginTop;
	    obj.props.duration = obj.props.duration * 1000;
	  };

	  Animate._parseProperties = function (obj) {
	    var nonTweenProps = Animate._timeProps.concat(Animate._callbackProps);

	    obj.tweenObj = {};

	    for (var key in obj.props) {
	      if (Animate._contains(nonTweenProps, key)) {
	        obj[key] = obj.props[key];
	      } else {
	        obj.tweenObj[key] = obj.props[key];
	      }
	    }
	  };

	  Animate._animateScroll = function (obj) {
	    var totalSteps = obj.props.duration / SCROLL_FRAME_RATE;

	    var top = Animate._easeOutExpo(obj.step++, obj.beginTop, obj.change, totalSteps);

	    obj.element.scrollTop = top;

	    if (obj.step >= totalSteps) {
	      obj.element.scrollTop = obj.props.top;

	      Animate._executeCallback(obj.props);

	      Animate._removeAnimationObject(obj);
	    } else {
	      setTimeout(function () {
	        requestAnimationFrame(function () {
	          Animate._animateScroll(obj);
	        });
	      }, SCROLL_FRAME_RATE);
	    }
	  };

	  Animate._createTransition = function (obj) {
	    var duration = obj.duration || 0;
	    var delay = obj.delay || 0;
	    obj.element.style.transitionProperty = Animate._getTransitionProperties(obj.tweenObj);
	    obj.element.style.transitionDuration = duration.toString() + "s";
	    obj.element.style.transitionTimingFunction = obj.ease || "linear";
	    obj.element.style.transitionDelay = delay.toString() + "s";
	  };

	  Animate._createAnimation = function (obj) {
	    var duration = obj.duration || 0;
	    var delay = obj.delay || 0;
	    obj.element.style.animationName = obj.keyframes;
	    obj.element.style.animationDuration = duration.toString() + "s";
	    obj.element.style.animationTimingFunction = obj.ease || "linear";
	    obj.element.style.animationDelay = delay.toString() + "s";
	    obj.element.style.animationFillMode = "both";
	  };

	  Animate._getTransitionProperties = function (obj) {
	    var hasTransform = false;
	    var hasFilter = false;
	    var properties = [];

	    for (var key in obj) {
	      if (Animate._contains(Animate._transformProps, key)) {
	        hasTransform = true;
	      } else if (Animate._contains(Animate._filters, key)) {
	        hasFilter = true;
	      } else {
	        properties.push(Animate._camelCaseToDash(key));
	      }
	    }

	    if (hasTransform) {
	      properties.push("transform");
	    }

	    if (hasFilter) {
	      properties.push("-webkit-filter");
	      properties.push("filter");
	    }

	    return properties.join(", ");
	  };

	  Animate._setProperties = function (obj) {
	    for (var key in obj.tweenObj) {
	      if (Animate._contains(Animate._transformProps, key)) {
	        Animate._setTransformValues(obj, key);
	      } else if (Animate._contains(Animate._filters, key)) {
	        Animate._setFilterValues(obj, key);
	      } else {
	        Animate._setRegularValues(obj, key);
	      }
	    }

	    if (obj.transformations) {
	      Animate._setTransformations(obj);
	    }
	  };

	  Animate._setRegularValues = function (obj, key) {
	    var value = obj.tweenObj[key];

	    if (value.toString().indexOf("%") === -1) {
	      value += key !== "opacity" && key !== "backgroundColor" && key !== "boxShadow" ? "px" : "";
	    }

	    obj.element.style[key] = value;
	  };

	  Animate._setFilterValues = function (obj, key) {
	    var value = obj.tweenObj[key];

	    if (key === "hueRotate") {
	      value = "(" + value + "deg)";
	    } else {
	      value = key === "blur" ? "(" + value + "px)" : "(" + value + "%)";
	    }

	    key = Animate._camelCaseToDash(key);
	    obj.element.style.webkitFilter = key + value;
	    obj.element.style.filter = key + value;
	  };

	  Animate._setTransformValues = function (obj, key) {
	    if (/x|y|z|scaleX|scaleY|scaleZ|rotate|rotateX|rotateY|rotateZ|skewX|skewY/.test(key)) {
	      obj.transformations[key] = obj.tweenObj[key];
	    }
	  };

	  Animate._setTransformations = function (obj) {
	    var rotate = "",
	        scale = "",
	        skew = "",
	        translate = "";
	    var trans = obj.transformations;
	    translate += trans.x !== undefined && trans.x ? "translateX(" + trans.x + "px) " : "";
	    translate += trans.y !== undefined && trans.y ? "translateY(" + trans.y + "px) " : "";
	    translate += trans.z !== undefined && trans.z ? "translateZ(" + trans.z + "px) " : "";
	    rotate += trans.rotate !== undefined && trans.rotate ? "rotate(" + trans.rotate + "deg) " : "";
	    rotate += trans.rotateX !== undefined && trans.rotateX ? "rotateX(" + trans.rotateX + "deg) " : "";
	    rotate += trans.rotateY !== undefined && trans.rotateY ? "rotate(" + trans.rotateY + "deg) " : "";
	    rotate += trans.rotateZ !== undefined && trans.rotateZ ? "rotate(" + trans.rotateZ + "deg) " : "";
	    scale += trans.scaleX !== undefined && trans.scaleX ? "scaleX(" + trans.scaleX + ") " : "";
	    scale += trans.scaleY !== undefined && trans.scaleY ? "scaleY(" + trans.scaleY + ") " : "";
	    scale += trans.scaleZ !== undefined && trans.scaleZ ? "scaleZ(" + trans.scaleZ + ") " : "";
	    skew += trans.skewX !== undefined && trans.skewX ? "skewX(" + trans.skewX + "deg) " : "";
	    skew += trans.skewY !== undefined && trans.skewY ? "skewY(" + trans.skewY + "deg) " : "";
	    obj.element.style.transform = translate + rotate + scale + skew;
	  };

	  Animate._setCallback = function (obj) {
	    obj.element.addEventListener("webkitTransitionEnd", Animate._complete, false);
	    obj.element.addEventListener("transitionend", Animate._complete, false);
	    obj.element.addEventListener("webkitAnimationEnd", Animate._complete, false);
	    obj.element.addEventListener("animationend", Animate._complete, false);
	  };

	  Animate._complete = function (event) {
	    event.target.removeEventListener("webkitTransitionEnd", Animate._complete);
	    event.target.removeEventListener("transitionend", Animate._complete);
	    event.target.removeEventListener("webkitAnimationEnd", Animate._complete);
	    event.target.removeEventListener("animationend", Animate._complete);

	    var obj = Animate._getAnimationObjByElement(event.target);

	    Animate._executeCallback(obj);

	    Animate._removeAnimationObject(obj);
	  };

	  Animate._getAnimationObjByElement = function (element) {
	    var i = Animate._animationObjects.length;

	    while (i--) {
	      if (Animate._animationObjects[i].element === element) {
	        return Animate._animationObjects[i];
	      }
	    }

	    return null;
	  };

	  Animate._removeAnimationObject = function (obj) {
	    var i = Animate._animationObjects.length;

	    while (i--) {
	      if (Animate._animationObjects[i] === obj) {
	        Animate._animationObjects.splice(i, 1);
	      }
	    }
	  };

	  Animate._executeCallback = function (obj) {
	    if (obj.onEnd) {
	      var endArgs = obj.onEndArgs || [];
	      obj.onEnd.apply(null, endArgs);
	    }
	  };

	  Animate._contains = function (array, value) {
	    var i = array.length;

	    while (i--) {
	      if (value === array[i]) {
	        return true;
	      }
	    }

	    return false;
	  };

	  Animate._camelCaseToDash = function (value) {
	    return value.replace(/\W+/g, "-").replace(/([a-z\d])([A-Z])/g, "$1-$2").toLowerCase();
	  };

	  Animate._easeOutExpo = function (time, begin, change, duration) {
	    return time === duration ? begin + change : change * (-Math.pow(2, -10 * time / duration) + 1) + begin;
	  };

	  Animate._transformProps = ["x", "y", "z", "scaleX", "scaleY", "scaleZ", "rotate", "rotateX", "rotateY", "rotateZ", "skewX", "skewY"];
	  Animate._filters = ["blur", "brightness", "contrast", "dropShadow", "grayscale", "hueRotate", "invert", "saturate", "sepia"];
	  Animate._timeProps = ["duration", "ease", "delay"];
	  Animate._callbackProps = ["onEnd", "onEndArgs"];
	  Animate._animationObjects = [];
	  return Animate;
	}();

	var Ease = function () {
	  function Ease() {}

	  Ease.CB = "cubic-bezier";
	  Ease.QUAD_EASE_IN = Ease.CB + "(0.550, 0.085, 0.680, 0.530)";
	  Ease.CUBIC_EASE_IN = Ease.CB + "(0.550, 0.055, 0.675, 0.190)";
	  Ease.QUART_EASE_IN = Ease.CB + "(0.895, 0.030, 0.685, 0.220)";
	  Ease.QUINT_EASE_IN = Ease.CB + "(0.755, 0.050, 0.855, 0.060)";
	  Ease.SINE_EASE_IN = Ease.CB + "(0.470, 0, 0.745, 0.715)";
	  Ease.EXPO_EASE_IN = Ease.CB + "(0.950, 0.050, 0.795, 0.035)";
	  Ease.CIRC_EASE_IN = Ease.CB + "(0.600, 0.040, 0.980, 0.335)";
	  Ease.BACK_EASE_IN = Ease.CB + "(0.600, 0.040, 0.980, 0.335)";
	  Ease.QUAD_EASE_OUT = Ease.CB + "(0.250, 0.460, 0.450, 0.940)";
	  Ease.CUBIC_EASE_OUT = Ease.CB + "(0.215, 0.610, 0.355, 1)";
	  Ease.QUART_EASE_OUT = Ease.CB + "(0.165, 0.840, 0.440, 1)";
	  Ease.QUINT_EASE_OUT = Ease.CB + "(0.230, 1, 0.320, 1)";
	  Ease.SINE_EASE_OUT = Ease.CB + "(0.390, 0.575, 0.565, 1)";
	  Ease.EXPO_EASE_OUT = Ease.CB + "(0.190, 1, 0.220, 1)";
	  Ease.CIRC_EASE_OUT = Ease.CB + "(0.075, 0.820, 0.165, 1)";
	  Ease.BACK_EASE_OUT = Ease.CB + "(0.175, 0.885, 0.320, 1.275)";
	  Ease.QUAD_EASE_IN_OUT = Ease.CB + "(0.455, 0.030, 0.515, 0.955)";
	  Ease.CUBIC_EASE_IN_OUT = Ease.CB + "(0.645, 0.045, 0.355, 1)";
	  Ease.QUART_EASE_IN_OUT = Ease.CB + "(0.770, 0, 0.175, 1)";
	  Ease.QUINT_EASE_IN_OUT = Ease.CB + "(0.860, 0, 0.070, 1)";
	  Ease.SINE_EASE_IN_OUT = Ease.CB + "(0.445, 0.050, 0.550, 0.950)";
	  Ease.EXPO_EASE_IN_OUT = Ease.CB + "(1, 0, 0, 1)";
	  Ease.CIRC_EASE_IN_OUT = Ease.CB + "(0.785, 0.135, 0.150, 0.860)";
	  Ease.BACK_EASE_IN_OUT = Ease.CB + "(0.680, -0.550, 0.265, 1.550)";
	  return Ease;
	}();

	var PersonaCard = function () {
	  function PersonaCard(container) {
	    this._container = container;

	    var activeElement = this._container.querySelector(".ms-PersonaCard-action.is-active");

	    var activeId = activeElement.getAttribute("data-action-id");
	    this._actions = this._container.querySelector(".ms-PersonaCard-actions");
	    this._expander = this._container.querySelector(".ms-PersonaCard-detailExpander");
	    this._actionDetailBox = this._container.querySelector(".ms-PersonaCard-actionDetailBox");

	    this._setDetail(activeId);

	    this._boundOnActionClick = this._onActionClick.bind(this);
	    this._boundOnExpanderClick = this._onExpanderClick.bind(this);
	    this._boundOnTab = this._onTab.bind(this);

	    this._addListeners();
	  }

	  PersonaCard.prototype.removeListeners = function () {
	    this._actions.removeEventListener("click", this._boundOnActionClick);

	    this._expander.removeEventListener("click", this._boundOnExpanderClick);

	    this._container.removeEventListener("keydown", this._boundOnTab);
	  };

	  PersonaCard.prototype._addListeners = function () {
	    this._actions.addEventListener("click", this._boundOnActionClick, false);

	    this._expander.addEventListener("click", this._boundOnExpanderClick, false);

	    this._container.addEventListener("keydown", this._boundOnTab, false);
	  };

	  PersonaCard.prototype._onTab = function (event) {
	    var target = event.target;

	    if (event.keyCode === 9 && target.classList.contains("ms-PersonaCard-action")) {
	      this._onActionClick(event);
	    }
	  };

	  PersonaCard.prototype._onExpanderClick = function (event) {
	    var parent = event.target.parentElement;

	    if (parent.classList.contains("is-collapsed")) {
	      parent.classList.remove("is-collapsed");
	    } else {
	      parent.classList.add("is-collapsed");
	    }

	    var parentHeight = parent.clientHeight;

	    this._animateDetail(parentHeight);
	  };

	  PersonaCard.prototype._onActionClick = function (event) {
	    var target = event.target;
	    var actionId = target.getAttribute("data-action-id");

	    if (actionId && target.className.indexOf("is-active") === -1) {
	      this._setAction(target);

	      this._setDetail(actionId);
	    }
	  };

	  PersonaCard.prototype._setAction = function (target) {
	    var activeElement = this._container.querySelector(".ms-PersonaCard-action.is-active");

	    activeElement.classList.remove("is-active");
	    target.classList.add("is-active");
	  };

	  PersonaCard.prototype._setDetail = function (activeId) {
	    var selector = ".ms-PersonaCard-details[data-detail-id='" + activeId + "']";

	    var lastDetail = this._container.querySelector(".ms-PersonaCard-details.is-active");

	    var activeDetail = this._container.querySelector(selector);

	    if (lastDetail) {
	      lastDetail.classList.remove("is-active");
	    }

	    activeDetail.classList.add("is-active");
	    var detailHeight = activeDetail.clientHeight;

	    this._animateDetail(detailHeight);
	  };

	  PersonaCard.prototype._animateDetail = function (height) {
	    var _this = this;

	    this._actionDetailBox.style.overflowY = "hidden";
	    Animate.transition(this._actionDetailBox, {
	      height: height,
	      duration: 0.25,
	      ease: Ease.SINE_EASE_OUT,
	      onEnd: function onEnd() {
	        _this._actionDetailBox.style.overflowY = "auto";
	      }
	    });
	  };

	  return PersonaCard;
	}();

	var MODAL_POSITION$3 = "top";

	var Persona = function () {
	  function Persona(container) {
	    this._persona = container;
	    this._personaCard = this._persona.querySelector(".ms-PersonaCard");

	    if (this._personaCard) {
	      this._assignEvents();

	      this._personaCard.setAttribute("style", "display: none;");

	      this._createPersonaCard();
	    }
	  }

	  Persona.prototype._createPersonaCard = function () {
	    this._personaCardInstance = new PersonaCard(this._personaCard);
	  };

	  Persona.prototype._createContextualHostInstance = function () {
	    this._personaCard.setAttribute("style", "display: block;");

	    this._contextualHostInstance = new ContextualHost(this._personaCard, MODAL_POSITION$3, this._persona);
	  };

	  Persona.prototype._personaEventHandler = function () {
	    this._createContextualHostInstance();
	  };

	  Persona.prototype._assignEvents = function () {
	    var _this = this;

	    this._persona.addEventListener("click", this._personaEventHandler.bind(this), false);

	    this._persona.addEventListener("keyup", function (e) {
	      return e.keyCode === 32 ? _this._personaEventHandler() : null;
	    }, false);
	  };

	  return Persona;
	}();

	var pivot = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"pivot",staticClass:"ms-Pivot",class:_vm.pivotClass},[_c('ul',{staticClass:"ms-Pivot-links",on:{"click":_vm.clickEvent}},_vm._l((_vm.pivotItems),function(item,index$$1){return _c('li',{staticClass:"ms-Pivot-link",class:{ 'is-selected': index$$1 == 0 },attrs:{"tabindex":"1","data-content":item,"title":item}},[_vm._v(" "+_vm._s(item)+" ")])}),0),_vm._v(" "),_vm._t("default")],2)},staticRenderFns: [],
	  name: 'ou-pivot',

	  mixins: [
	    size('large'),
	    type('tabs'),
	    eventHub
	  ],

	  data: function data() {
	    return {
	      pivotItems: []
	    };
	  },

	  computed: {
	    pivotClass: function pivotClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-Pivot--" + (this.size))] = !!this.size, obj[("ms-Pivot--" + (this.type))] = !!this.type, obj );
	    }
	  },

	  created: function created() {
	    this.eventHub.$on('addPivotItem', this.addPivotItem);
	  },

	  beforeDestroy: function beforeDestroy() {
	    this.eventHub.$off('addPivotItem', this.addPivotItem);
	  },

	  mounted: function mounted() {
	    new this.$fabric.Pivot(this.$refs.pivot);
	  },

	  methods: {
	    addPivotItem: function addPivotItem(label) {
	      this.pivotItems.push(label);
	    },

	    clickEvent: function clickEvent(event) {
	      if (event.target.tagName == 'LI') {
	        this.$emit('click', event);
	      }
	    }
	  }
	};

	var Pivot = function () {
	  function Pivot(container) {
	    this._container = container;

	    this._addListeners();

	    var firstContent = this._container.querySelector(".ms-Pivot-content");

	    firstContent.style.display = "block";
	  }

	  Pivot.prototype.removeListeners = function () {
	    this._container.removeEventListener("click", this._selectTab.bind(this));
	  };

	  Pivot.prototype._addListeners = function () {
	    var _this = this;

	    this._container.querySelector(".ms-Pivot-links").addEventListener("click", this._selectTabMouse.bind(this), false);

	    this._container.addEventListener("keyup", function (event) {
	      if (event.keyCode === 13) {
	        _this._selectTabKeyboard(event);
	      }
	    }, true);
	  };

	  Pivot.prototype._selectTab = function (selectedTab) {
	    if (selectedTab.classList.contains("ms-Pivot-link") && !selectedTab.querySelector(".ms-Pivot-ellipsis")) {
	      var sibling = selectedTab.parentElement.firstElementChild;

	      while (sibling) {
	        sibling.classList.remove("is-selected");
	        sibling = sibling.nextElementSibling;
	      }

	      selectedTab.classList.add("is-selected");

	      var containers = this._container.querySelectorAll(".ms-Pivot-content");

	      Array.prototype.forEach.call(containers, function (el, i) {
	        el.style.display = "none";
	      });
	      var selectedContentName = selectedTab.getAttribute("data-content");

	      var selectedContent = this._container.querySelector(".ms-Pivot-content[data-content='" + selectedContentName + "']");

	      selectedContent.style.display = "block";
	    }
	  };

	  Pivot.prototype._selectTabMouse = function (event) {
	    event.preventDefault();
	    var selectedTab = event.target;

	    this._selectTab(selectedTab);
	  };

	  Pivot.prototype._selectTabKeyboard = function (event) {
	    event.preventDefault();
	    var selectedTab = event.target;

	    this._selectTab(selectedTab);
	  };

	  return Pivot;
	}();

	var ProgressIndicator$1 = function () {
	  function ProgressIndicator(container) {
	    this.container = container;
	    this.cacheDOM();
	  }

	  ProgressIndicator.prototype.setProgressPercent = function (percent) {
	    this._progressBar.style.width = Math.round(this._width * percent) + "px";
	  };

	  ProgressIndicator.prototype.setProgress = function (progress) {
	    this._progress = progress;
	    var percentage = this._progress / this._total;
	    this.setProgressPercent(percentage);
	  };

	  ProgressIndicator.prototype.setTotal = function (total) {
	    this._total = total;
	  };

	  ProgressIndicator.prototype.setName = function (name) {
	    this._itemName.innerHTML = name;
	  };

	  ProgressIndicator.prototype.setDescription = function (description) {
	    this._itemDescription.innerHTML = description;
	  };

	  ProgressIndicator.prototype.cacheDOM = function () {
	    this._itemName = this.container.querySelector(".ms-ProgressIndicator-itemName") || null;
	    this._itemDescription = this.container.querySelector(".ms-ProgressIndicator-itemDescription") || null;
	    this._progressBar = this.container.querySelector(".ms-ProgressIndicator-progressBar");
	    var itemProgress = this.container.querySelector(".ms-ProgressIndicator-itemProgress");
	    this._width = itemProgress.offsetWidth;
	  };

	  return ProgressIndicator;
	}();

	var searchBox = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"searchBox",staticClass:"ms-SearchBox",class:_vm.searchBoxClass},[_c('input',{ref:"searchBoxInput",staticClass:"ms-SearchBox-field",attrs:{"type":"text"},domProps:{"value":_vm.value},on:{"input":_vm.updateValue}}),_vm._v(" "),_c('label',{staticClass:"ms-SearchBox-label"},[_c('i',{staticClass:"ms-SearchBox-icon ms-Icon ms-Icon--Search"}),_vm._v(" "),(!_vm.hasValue)?_c('span',{staticClass:"ms-SearchBox-text"},[_vm._v(_vm._s(_vm.placeholder))]):_vm._e()]),_vm._v(" "),_c('div',{staticClass:"ms-CommandButton ms-SearchBox-clear ms-CommandButton--noLabel",on:{"mousedown":_vm.clearValue}},[_vm._m(0)])])},staticRenderFns: [function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('button',{staticClass:"ms-CommandButton-button"},[_c('span',{staticClass:"ms-CommandButton-icon"},[_c('i',{staticClass:"ms-Icon ms-Icon--Clear"})]),_vm._v(" "),_c('span',{staticClass:"ms-CommandButton-label"})])}],
	  name: 'ou-search-box',

	  mixins: [type('commandBar')],

	  props: {
	    value: String,
	    placeholder: String,

	    collapsed: {
	      type: Boolean,
	      default: false
	    }
	  },

	  data: function data() {
	    return {
	      hasValue: !!this.value,
	      searchBoxInstance: null
	    };
	  },

	  computed: {
	    searchBoxClass: function searchBoxClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-SearchBox--" + (this.type))] = !!this.type, obj['is-collapsed'] =  this.collapsed, obj );
	    }
	  },

	  mounted: function mounted() {
	    this.searchBoxInstance = new this.$fabric.SearchBox(this.$refs.searchBox);

	    // Overwrite the default blur event on searchBoxField
	    // to prevent lose content when searchBox blur.
	    // You can see here https://github.com/OfficeDev/office-ui-fabric-js/issues/301
	    this.searchBoxInstance._searchBoxField.removeEventListener('blur', this.searchBoxInstance._boundHandleBlur, true);
	    this.searchBoxInstance._searchBoxField.addEventListener('blur', this.blurEvent, true);
	  },

	  methods: {
	    updateValue: function updateValue(event) {
	      this.$emit('input', event.target.value);
	    },

	    clearValue: function clearValue() {
	      this.$emit('input', '');
	    },

	    blurEvent: function blurEvent() {
	      var self = this.searchBoxInstance;

	      if (!self._clearOnly) {
	        self._searchBox.removeEventListener('keyup', self._boundEnableClose);
	        setTimeout(function () {
	          if (!self._searchBox.contains(document.activeElement) && self._searchBoxField.value == '') {
	            self._clearSearchBox();
	            self._collapseSearchBox();
	            self.setCollapsedListeners();
	          }
	        }, 10);
	      } else {
	        self._searchBoxField.focus();
	      }

	      self._clearOnly = false;
	    }
	  }
	};

	var Spinner = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"spinner",staticClass:"ms-Spinner",class:_vm.spinnerClass},[(_vm.label)?_c('div',{staticClass:"ms-Spinner-label"},[_vm._v(_vm._s(_vm.label))]):_vm._e()])},staticRenderFns: [],
	  name: 'ou-spinner',

	  mixins: [type('large')],

	  props: {
	    label: String
	  },

	  computed: {
	    spinnerClass: function spinnerClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-Spinner--" + (this.type))] = !!this.type, obj );
	    }
	  },

	  mounted: function mounted() {
	    new this.$fabric.Spinner(this.$refs.spinner);
	  }
	};

	var CircleObject = function () {
	  function CircleObject(element, j) {
	    this.element = element;
	    this.j = j;
	  }

	  return CircleObject;
	}();

	var Spinner$1 = function () {
	  function Spinner(container) {
	    this.eightSize = 0.2;
	    this.animationSpeed = 90;
	    this.parentSize = 20;
	    this.fadeIncrement = 0;
	    this.circleObjects = [];
	    this._target = container;

	    this._init();
	  }

	  Spinner.prototype.start = function () {
	    var _this = this;

	    this.stop();
	    this.interval = setInterval(function () {
	      var i = _this.circleObjects.length;

	      while (i--) {
	        _this._fade(_this.circleObjects[i]);
	      }
	    }, this.animationSpeed);
	  };

	  Spinner.prototype.stop = function () {
	    clearInterval(this.interval);
	  };

	  Spinner.prototype._init = function () {
	    this._setTargetElement();

	    this._setPropertiesForSize();

	    this._createCirclesAndArrange();

	    this._initializeOpacities();

	    this.start();
	  };

	  Spinner.prototype._setPropertiesForSize = function () {
	    if (this.spinner.className.indexOf("large") > -1) {
	      this.parentSize = 28;
	      this.eightSize = 0.179;
	    }

	    this.offsetSize = this.eightSize;
	    this.numCircles = 8;
	  };

	  Spinner.prototype._setTargetElement = function () {
	    if (this._target.className.indexOf("ms-Spinner") === -1) {
	      this.spinner = document.createElement("div");
	      this.spinner.className = "ms-Spinner";

	      this._target.appendChild(this.spinner);
	    } else {
	      this.spinner = this._target;
	    }
	  };

	  Spinner.prototype._initializeOpacities = function () {
	    var i = 0;
	    var j = 1;
	    var opacity;
	    this.fadeIncrement = 1 / this.numCircles;

	    for (i; i < this.numCircles; i++) {
	      var circleObject = this.circleObjects[i];
	      opacity = this.fadeIncrement * j++;

	      this._setOpacity(circleObject.element, opacity);
	    }
	  };

	  Spinner.prototype._fade = function (circleObject) {
	    var opacity = this._getOpacity(circleObject.element) - this.fadeIncrement;

	    if (opacity <= 0) {
	      opacity = 1;
	    }

	    this._setOpacity(circleObject.element, opacity);
	  };

	  Spinner.prototype._getOpacity = function (element) {
	    return parseFloat(window.getComputedStyle(element).getPropertyValue("opacity"));
	  };

	  Spinner.prototype._setOpacity = function (element, opacity) {
	    element.style.opacity = opacity.toString();
	  };

	  Spinner.prototype._createCircle = function () {
	    var circle = document.createElement("div");
	    circle.className = "ms-Spinner-circle";
	    circle.style.width = circle.style.height = this.parentSize * this.offsetSize + "px";
	    return circle;
	  };

	  Spinner.prototype._createCirclesAndArrange = function () {
	    var angle = 0;
	    var offset = this.parentSize * this.offsetSize;
	    var step = 2 * Math.PI / this.numCircles;
	    var i = this.numCircles;
	    var circleObject;
	    var radius = (this.parentSize - offset) * 0.5;

	    while (i--) {
	      var circle = this._createCircle();

	      var x = Math.round(this.parentSize * 0.5 + radius * Math.cos(angle) - circle.clientWidth * 0.5) - offset * 0.5;
	      var y = Math.round(this.parentSize * 0.5 + radius * Math.sin(angle) - circle.clientHeight * 0.5) - offset * 0.5;
	      this.spinner.appendChild(circle);
	      circle.style.left = x + "px";
	      circle.style.top = y + "px";
	      angle += step;
	      circleObject = new CircleObject(circle, i);
	      this.circleObjects.push(circleObject);
	    }
	  };

	  return Spinner;
	}();

	var textField = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"textField",staticClass:"ms-TextField",class:_vm.textFieldClass},[_c('label',{staticClass:"ms-Label"},[_vm._v(_vm._s(_vm.label))]),_vm._v(" "),(_vm.type == 'multiline')?_c('textarea',_vm._b({staticClass:"ms-TextField-field",attrs:{"placeholder":_vm.placeholder,"type":"text","disabled":_vm.disabled},domProps:{"value":_vm.value},on:{"input":_vm.updateValue,"change":_vm.changeEvent,"blur":_vm.blurEvent}},'textarea',_vm.attrs,false)):_c('input',_vm._b({staticClass:"ms-TextField-field",attrs:{"placeholder":_vm.placeholder,"type":_vm.inputType,"disabled":_vm.disabled},domProps:{"value":_vm.value},on:{"input":_vm.updateValue,"change":_vm.changeEvent,"blur":_vm.blurEvent}},'input',_vm.attrs,false))])},staticRenderFns: [],
	  name: 'ou-text-field',
	  inheritAttrs: false,
	  mixins: [type('multiline', 'underlined'), disabled],

	  props: {
	    value: [String, Number],
	    label: String,
	    placeholder: String,
	    inputType: {
	      type: String,
	      default: 'text',
	      validator: function validator(value) {
	        return ['text', 'password', 'file', 'number'].includes(value);
	      }
	    }
	  },

	  computed: {
	    attrs: function attrs(){return this.$attrs},
	    textFieldClass: function textFieldClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-TextField--" + (this.type))] = !!this.type, obj['is-disabled'] =  this.disabled, obj );
	    }
	  },

	  mounted: function mounted() {
	    new this.$fabric.TextField(this.$refs.textField);
	  },

	  methods: {
	    updateValue: function updateValue(event) {
	      this.$emit('input', event.target.value);
	    },
	    blurEvent: function blurEvent(event){
	      this.$emit('blur', event.target.value);
	    },
	    changeEvent: function changeEvent(event) {
	      this.$emit('change', event.target.value);
	    }
	  }
	};

	var TextFieldConsts;

	(function (TextFieldConsts) {
	  var Type;

	  (function (Type) {
	    Type[Type["Placeholder"] = 0] = "Placeholder";
	    Type[Type["Underlined"] = 1] = "Underlined";
	  })(Type = TextFieldConsts.Type || (TextFieldConsts.Type = {}));
	})(TextFieldConsts || (TextFieldConsts = {}));

	var TextField = function () {
	  function TextField(container) {
	    this._container = container;
	    this._type = [];
	    this._textField = this._container.querySelector(".ms-TextField-field");
	    this._textFieldLabel = this._container.querySelector(".ms-Label");

	    this._setTextFieldType();

	    this._addListeners();
	  }

	  TextField.prototype._setTextFieldType = function () {
	    if (this._container.classList.contains("ms-TextField--placeholder")) {
	      this._type.push(TextFieldConsts.Type.Placeholder);
	    }

	    if (this._container.classList.contains("ms-TextField--underlined")) {
	      this._type.push(TextFieldConsts.Type.Underlined);
	    }
	  };

	  TextField.prototype._addListeners = function () {
	    var _this = this;

	    this._textFieldLabel.addEventListener("click", function (event) {
	      _this._textField.focus();
	    });

	    if (this._type.indexOf(TextFieldConsts.Type.Placeholder) >= 0) {
	      this._textField.addEventListener("focus", function (event) {
	        _this._textFieldLabel.style.display = "none";
	      });

	      this._textField.addEventListener("blur", function (event) {
	        if (_this._textField.value.length === 0) {
	          _this._textFieldLabel.style.display = "block";
	        }
	      });
	    }

	    if (this._type.indexOf(TextFieldConsts.Type.Underlined) >= 0) {
	      this._textField.addEventListener("focus", function (event) {
	        _this._container.classList.add("is-active");
	      });

	      this._textField.addEventListener("blur", function (event) {
	        _this._container.classList.remove("is-active");
	      });
	    }
	  };

	  return TextField;
	}();

	var toggle = {render: function(){var _vm=this;var _h=_vm.$createElement;var _c=_vm._self._c||_h;return _c('div',{ref:"toggle",staticClass:"ms-Toggle",class:_vm.toggleClass},[(_vm.description)?_c('span',{staticClass:"ms-Toggle-description"},[_vm._v(" "+_vm._s(_vm.description)+" ")]):_vm._e(),_vm._v(" "),_c('input',{staticClass:"ms-Toggle-input",attrs:{"type":"checkbox"}}),_vm._v(" "),_c('span',{staticClass:"ms-Toggle-trigger",on:{"click":_vm.toggle}},[_c('label',{ref:"toggleLabel",staticClass:"ms-Toggle-field",class:{ 'is-selected': _vm.value },attrs:{"tabindex":"0"}},[_c('span',{staticClass:"ms-Label ms-Label--off"},[_vm._v(_vm._s(_vm.offLabel))]),_vm._v(" "),_c('span',{staticClass:"ms-Label ms-Label--on"},[_vm._v(_vm._s(_vm.onLabel))])])])])},staticRenderFns: [],
	  name: 'ou-toggle',

	  mixins: [type('textLeft'), disabled],

	  props: {
	    value: Boolean,
	    onLabel: String,
	    offLabel: String,
	    description: String
	  },

	  computed: {
	    toggleClass: function toggleClass() {
	      var obj;

	      return ( obj = {}, obj[("ms-Toggle--" + (this.type))] = !!this.type, obj['is-disabled'] =  this.disabled, obj );
	    }
	  },

	  mounted: function mounted() {
	    new this.$fabric.Toggle(this.$refs.toggle);
	  },

	  methods: {
	    toggle: function toggle() {
	      if (!this.disabled) {
	        this.$emit('input', !this.value);
	      }
	    }
	  }
	};

	var Toggle = function () {
	  function Toggle(container) {
	    this._container = container;
	    this._toggleField = this._container.querySelector(".ms-Toggle-field");

	    this._addListeners();
	  }

	  Toggle.prototype.removeListeners = function () {
	    this._toggleField.removeEventListener("click", this._toggleHandler.bind(this));
	  };

	  Toggle.prototype._addListeners = function () {
	    var _this = this;

	    this._toggleField.addEventListener("click", this._toggleHandler.bind(this), false);

	    this._toggleField.addEventListener("keyup", function (e) {
	      return e.keyCode === 32 ? _this._toggleHandler() : null;
	    }, false);
	  };

	  Toggle.prototype._toggleHandler = function () {
	    this._toggleField.classList.toggle("is-selected");
	  };

	  return Toggle;
	}();

	var commonjsGlobal$1 = typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

	function createCommonjsModule$1(fn, module) {
		return module = { exports: {} }, fn(module, module.exports), module.exports;
	}

	/**!
	 * @fileOverview Kickass library to create and place poppers near their reference elements.
	 * @version 1.15.0
	 * @license
	 * Copyright (c) 2016 Federico Zivolo and contributors
	 *
	 * Permission is hereby granted, free of charge, to any person obtaining a copy
	 * of this software and associated documentation files (the "Software"), to deal
	 * in the Software without restriction, including without limitation the rights
	 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	 * copies of the Software, and to permit persons to whom the Software is
	 * furnished to do so, subject to the following conditions:
	 *
	 * The above copyright notice and this permission notice shall be included in all
	 * copies or substantial portions of the Software.
	 *
	 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
	 * SOFTWARE.
	 */
	var isBrowser = typeof window !== 'undefined' && typeof document !== 'undefined';
	var longerTimeoutBrowsers = ['Edge', 'Trident', 'Firefox'];
	var timeoutDuration = 0;

	for (var i = 0; i < longerTimeoutBrowsers.length; i += 1) {
	  if (isBrowser && navigator.userAgent.indexOf(longerTimeoutBrowsers[i]) >= 0) {
	    timeoutDuration = 1;
	    break;
	  }
	}

	function microtaskDebounce(fn) {
	  var called = false;
	  return function () {
	    if (called) {
	      return;
	    }

	    called = true;
	    window.Promise.resolve().then(function () {
	      called = false;
	      fn();
	    });
	  };
	}

	function taskDebounce(fn) {
	  var scheduled = false;
	  return function () {
	    if (!scheduled) {
	      scheduled = true;
	      setTimeout(function () {
	        scheduled = false;
	        fn();
	      }, timeoutDuration);
	    }
	  };
	}

	var supportsMicroTasks = isBrowser && window.Promise;
	/**
	* Create a debounced version of a method, that's asynchronously deferred
	* but called in the minimum time possible.
	*
	* @method
	* @memberof Popper.Utils
	* @argument {Function} fn
	* @returns {Function}
	*/

	var debounce = supportsMicroTasks ? microtaskDebounce : taskDebounce;
	/**
	 * Check if the given variable is a function
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Any} functionToCheck - variable to check
	 * @returns {Boolean} answer to: is a function?
	 */

	function isFunction(functionToCheck) {
	  var getType = {};
	  return functionToCheck && getType.toString.call(functionToCheck) === '[object Function]';
	}
	/**
	 * Get CSS computed property of the given element
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Eement} element
	 * @argument {String} property
	 */


	function getStyleComputedProperty(element, property) {
	  if (element.nodeType !== 1) {
	    return [];
	  } // NOTE: 1 DOM access here


	  var window = element.ownerDocument.defaultView;
	  var css = window.getComputedStyle(element, null);
	  return property ? css[property] : css;
	}
	/**
	 * Returns the parentNode or the host of the element
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element
	 * @returns {Element} parent
	 */


	function getParentNode(element) {
	  if (element.nodeName === 'HTML') {
	    return element;
	  }

	  return element.parentNode || element.host;
	}
	/**
	 * Returns the scrolling parent of the given element
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element
	 * @returns {Element} scroll parent
	 */


	function getScrollParent(element) {
	  // Return body, `getScroll` will take care to get the correct `scrollTop` from it
	  if (!element) {
	    return document.body;
	  }

	  switch (element.nodeName) {
	    case 'HTML':
	    case 'BODY':
	      return element.ownerDocument.body;

	    case '#document':
	      return element.body;
	  } // Firefox want us to check `-x` and `-y` variations as well


	  var _getStyleComputedProp = getStyleComputedProperty(element),
	      overflow = _getStyleComputedProp.overflow,
	      overflowX = _getStyleComputedProp.overflowX,
	      overflowY = _getStyleComputedProp.overflowY;

	  if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
	    return element;
	  }

	  return getScrollParent(getParentNode(element));
	}

	var isIE11 = isBrowser && !!(window.MSInputMethodContext && document.documentMode);
	var isIE10 = isBrowser && /MSIE 10/.test(navigator.userAgent);
	/**
	 * Determines if the browser is Internet Explorer
	 * @method
	 * @memberof Popper.Utils
	 * @param {Number} version to check
	 * @returns {Boolean} isIE
	 */

	function isIE(version) {
	  if (version === 11) {
	    return isIE11;
	  }

	  if (version === 10) {
	    return isIE10;
	  }

	  return isIE11 || isIE10;
	}
	/**
	 * Returns the offset parent of the given element
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element
	 * @returns {Element} offset parent
	 */


	function getOffsetParent(element) {
	  if (!element) {
	    return document.documentElement;
	  }

	  var noOffsetParent = isIE(10) ? document.body : null; // NOTE: 1 DOM access here

	  var offsetParent = element.offsetParent || null; // Skip hidden elements which don't have an offsetParent

	  while (offsetParent === noOffsetParent && element.nextElementSibling) {
	    offsetParent = (element = element.nextElementSibling).offsetParent;
	  }

	  var nodeName = offsetParent && offsetParent.nodeName;

	  if (!nodeName || nodeName === 'BODY' || nodeName === 'HTML') {
	    return element ? element.ownerDocument.documentElement : document.documentElement;
	  } // .offsetParent will return the closest TH, TD or TABLE in case
	  // no offsetParent is present, I hate this job...


	  if (['TH', 'TD', 'TABLE'].indexOf(offsetParent.nodeName) !== -1 && getStyleComputedProperty(offsetParent, 'position') === 'static') {
	    return getOffsetParent(offsetParent);
	  }

	  return offsetParent;
	}

	function isOffsetContainer(element) {
	  var nodeName = element.nodeName;

	  if (nodeName === 'BODY') {
	    return false;
	  }

	  return nodeName === 'HTML' || getOffsetParent(element.firstElementChild) === element;
	}
	/**
	 * Finds the root node (document, shadowDOM root) of the given element
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} node
	 * @returns {Element} root node
	 */


	function getRoot(node) {
	  if (node.parentNode !== null) {
	    return getRoot(node.parentNode);
	  }

	  return node;
	}
	/**
	 * Finds the offset parent common to the two provided nodes
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element1
	 * @argument {Element} element2
	 * @returns {Element} common offset parent
	 */


	function findCommonOffsetParent(element1, element2) {
	  // This check is needed to avoid errors in case one of the elements isn't defined for any reason
	  if (!element1 || !element1.nodeType || !element2 || !element2.nodeType) {
	    return document.documentElement;
	  } // Here we make sure to give as "start" the element that comes first in the DOM


	  var order = element1.compareDocumentPosition(element2) & Node.DOCUMENT_POSITION_FOLLOWING;
	  var start = order ? element1 : element2;
	  var end = order ? element2 : element1; // Get common ancestor container

	  var range = document.createRange();
	  range.setStart(start, 0);
	  range.setEnd(end, 0);
	  var commonAncestorContainer = range.commonAncestorContainer; // Both nodes are inside #document

	  if (element1 !== commonAncestorContainer && element2 !== commonAncestorContainer || start.contains(end)) {
	    if (isOffsetContainer(commonAncestorContainer)) {
	      return commonAncestorContainer;
	    }

	    return getOffsetParent(commonAncestorContainer);
	  } // one of the nodes is inside shadowDOM, find which one


	  var element1root = getRoot(element1);

	  if (element1root.host) {
	    return findCommonOffsetParent(element1root.host, element2);
	  } else {
	    return findCommonOffsetParent(element1, getRoot(element2).host);
	  }
	}
	/**
	 * Gets the scroll value of the given element in the given side (top and left)
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element
	 * @argument {String} side `top` or `left`
	 * @returns {number} amount of scrolled pixels
	 */


	function getScroll(element) {
	  var side = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'top';
	  var upperSide = side === 'top' ? 'scrollTop' : 'scrollLeft';
	  var nodeName = element.nodeName;

	  if (nodeName === 'BODY' || nodeName === 'HTML') {
	    var html = element.ownerDocument.documentElement;
	    var scrollingElement = element.ownerDocument.scrollingElement || html;
	    return scrollingElement[upperSide];
	  }

	  return element[upperSide];
	}
	/*
	 * Sum or subtract the element scroll values (left and top) from a given rect object
	 * @method
	 * @memberof Popper.Utils
	 * @param {Object} rect - Rect object you want to change
	 * @param {HTMLElement} element - The element from the function reads the scroll values
	 * @param {Boolean} subtract - set to true if you want to subtract the scroll values
	 * @return {Object} rect - The modifier rect object
	 */


	function includeScroll(rect, element) {
	  var subtract = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	  var scrollTop = getScroll(element, 'top');
	  var scrollLeft = getScroll(element, 'left');
	  var modifier = subtract ? -1 : 1;
	  rect.top += scrollTop * modifier;
	  rect.bottom += scrollTop * modifier;
	  rect.left += scrollLeft * modifier;
	  rect.right += scrollLeft * modifier;
	  return rect;
	}
	/*
	 * Helper to detect borders of a given element
	 * @method
	 * @memberof Popper.Utils
	 * @param {CSSStyleDeclaration} styles
	 * Result of `getStyleComputedProperty` on the given element
	 * @param {String} axis - `x` or `y`
	 * @return {number} borders - The borders size of the given axis
	 */


	function getBordersSize(styles, axis) {
	  var sideA = axis === 'x' ? 'Left' : 'Top';
	  var sideB = sideA === 'Left' ? 'Right' : 'Bottom';
	  return parseFloat(styles['border' + sideA + 'Width'], 10) + parseFloat(styles['border' + sideB + 'Width'], 10);
	}

	function getSize(axis, body, html, computedStyle) {
	  return Math.max(body['offset' + axis], body['scroll' + axis], html['client' + axis], html['offset' + axis], html['scroll' + axis], isIE(10) ? parseInt(html['offset' + axis]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Top' : 'Left')]) + parseInt(computedStyle['margin' + (axis === 'Height' ? 'Bottom' : 'Right')]) : 0);
	}

	function getWindowSizes(document) {
	  var body = document.body;
	  var html = document.documentElement;
	  var computedStyle = isIE(10) && getComputedStyle(html);
	  return {
	    height: getSize('Height', body, html, computedStyle),
	    width: getSize('Width', body, html, computedStyle)
	  };
	}

	var classCallCheck = function classCallCheck(instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	};

	var createClass = function () {
	  function defineProperties(target, props) {
	    for (var i = 0; i < props.length; i++) {
	      var descriptor = props[i];
	      descriptor.enumerable = descriptor.enumerable || false;
	      descriptor.configurable = true;
	      if ("value" in descriptor) { descriptor.writable = true; }
	      Object.defineProperty(target, descriptor.key, descriptor);
	    }
	  }

	  return function (Constructor, protoProps, staticProps) {
	    if (protoProps) { defineProperties(Constructor.prototype, protoProps); }
	    if (staticProps) { defineProperties(Constructor, staticProps); }
	    return Constructor;
	  };
	}();

	var defineProperty = function defineProperty(obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }

	  return obj;
	};

	var _extends$1 = Object.assign || function (target) {
	  var arguments$1 = arguments;

	  for (var i = 1; i < arguments.length; i++) {
	    var source = arguments$1[i];

	    for (var key in source) {
	      if (Object.prototype.hasOwnProperty.call(source, key)) {
	        target[key] = source[key];
	      }
	    }
	  }

	  return target;
	};
	/**
	 * Given element offsets, generate an output similar to getBoundingClientRect
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Object} offsets
	 * @returns {Object} ClientRect like output
	 */


	function getClientRect(offsets) {
	  return _extends$1({}, offsets, {
	    right: offsets.left + offsets.width,
	    bottom: offsets.top + offsets.height
	  });
	}
	/**
	 * Get bounding client rect of given element
	 * @method
	 * @memberof Popper.Utils
	 * @param {HTMLElement} element
	 * @return {Object} client rect
	 */


	function getBoundingClientRect(element) {
	  var rect = {}; // IE10 10 FIX: Please, don't ask, the element isn't
	  // considered in DOM in some circumstances...
	  // This isn't reproducible in IE10 compatibility mode of IE11

	  try {
	    if (isIE(10)) {
	      rect = element.getBoundingClientRect();
	      var scrollTop = getScroll(element, 'top');
	      var scrollLeft = getScroll(element, 'left');
	      rect.top += scrollTop;
	      rect.left += scrollLeft;
	      rect.bottom += scrollTop;
	      rect.right += scrollLeft;
	    } else {
	      rect = element.getBoundingClientRect();
	    }
	  } catch (e) {}

	  var result = {
	    left: rect.left,
	    top: rect.top,
	    width: rect.right - rect.left,
	    height: rect.bottom - rect.top
	  }; // subtract scrollbar size from sizes

	  var sizes = element.nodeName === 'HTML' ? getWindowSizes(element.ownerDocument) : {};
	  var width = sizes.width || element.clientWidth || result.right - result.left;
	  var height = sizes.height || element.clientHeight || result.bottom - result.top;
	  var horizScrollbar = element.offsetWidth - width;
	  var vertScrollbar = element.offsetHeight - height; // if an hypothetical scrollbar is detected, we must be sure it's not a `border`
	  // we make this check conditional for performance reasons

	  if (horizScrollbar || vertScrollbar) {
	    var styles = getStyleComputedProperty(element);
	    horizScrollbar -= getBordersSize(styles, 'x');
	    vertScrollbar -= getBordersSize(styles, 'y');
	    result.width -= horizScrollbar;
	    result.height -= vertScrollbar;
	  }

	  return getClientRect(result);
	}

	function getOffsetRectRelativeToArbitraryNode(children, parent) {
	  var fixedPosition = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
	  var isIE10 = isIE(10);
	  var isHTML = parent.nodeName === 'HTML';
	  var childrenRect = getBoundingClientRect(children);
	  var parentRect = getBoundingClientRect(parent);
	  var scrollParent = getScrollParent(children);
	  var styles = getStyleComputedProperty(parent);
	  var borderTopWidth = parseFloat(styles.borderTopWidth, 10);
	  var borderLeftWidth = parseFloat(styles.borderLeftWidth, 10); // In cases where the parent is fixed, we must ignore negative scroll in offset calc

	  if (fixedPosition && isHTML) {
	    parentRect.top = Math.max(parentRect.top, 0);
	    parentRect.left = Math.max(parentRect.left, 0);
	  }

	  var offsets = getClientRect({
	    top: childrenRect.top - parentRect.top - borderTopWidth,
	    left: childrenRect.left - parentRect.left - borderLeftWidth,
	    width: childrenRect.width,
	    height: childrenRect.height
	  });
	  offsets.marginTop = 0;
	  offsets.marginLeft = 0; // Subtract margins of documentElement in case it's being used as parent
	  // we do this only on HTML because it's the only element that behaves
	  // differently when margins are applied to it. The margins are included in
	  // the box of the documentElement, in the other cases not.

	  if (!isIE10 && isHTML) {
	    var marginTop = parseFloat(styles.marginTop, 10);
	    var marginLeft = parseFloat(styles.marginLeft, 10);
	    offsets.top -= borderTopWidth - marginTop;
	    offsets.bottom -= borderTopWidth - marginTop;
	    offsets.left -= borderLeftWidth - marginLeft;
	    offsets.right -= borderLeftWidth - marginLeft; // Attach marginTop and marginLeft because in some circumstances we may need them

	    offsets.marginTop = marginTop;
	    offsets.marginLeft = marginLeft;
	  }

	  if (isIE10 && !fixedPosition ? parent.contains(scrollParent) : parent === scrollParent && scrollParent.nodeName !== 'BODY') {
	    offsets = includeScroll(offsets, parent);
	  }

	  return offsets;
	}

	function getViewportOffsetRectRelativeToArtbitraryNode(element) {
	  var excludeScroll = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	  var html = element.ownerDocument.documentElement;
	  var relativeOffset = getOffsetRectRelativeToArbitraryNode(element, html);
	  var width = Math.max(html.clientWidth, window.innerWidth || 0);
	  var height = Math.max(html.clientHeight, window.innerHeight || 0);
	  var scrollTop = !excludeScroll ? getScroll(html) : 0;
	  var scrollLeft = !excludeScroll ? getScroll(html, 'left') : 0;
	  var offset = {
	    top: scrollTop - relativeOffset.top + relativeOffset.marginTop,
	    left: scrollLeft - relativeOffset.left + relativeOffset.marginLeft,
	    width: width,
	    height: height
	  };
	  return getClientRect(offset);
	}
	/**
	 * Check if the given element is fixed or is inside a fixed parent
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element
	 * @argument {Element} customContainer
	 * @returns {Boolean} answer to "isFixed?"
	 */


	function isFixed(element) {
	  var nodeName = element.nodeName;

	  if (nodeName === 'BODY' || nodeName === 'HTML') {
	    return false;
	  }

	  if (getStyleComputedProperty(element, 'position') === 'fixed') {
	    return true;
	  }

	  var parentNode = getParentNode(element);

	  if (!parentNode) {
	    return false;
	  }

	  return isFixed(parentNode);
	}
	/**
	 * Finds the first parent of an element that has a transformed property defined
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element
	 * @returns {Element} first transformed parent or documentElement
	 */


	function getFixedPositionOffsetParent(element) {
	  // This check is needed to avoid errors in case one of the elements isn't defined for any reason
	  if (!element || !element.parentElement || isIE()) {
	    return document.documentElement;
	  }

	  var el = element.parentElement;

	  while (el && getStyleComputedProperty(el, 'transform') === 'none') {
	    el = el.parentElement;
	  }

	  return el || document.documentElement;
	}
	/**
	 * Computed the boundaries limits and return them
	 * @method
	 * @memberof Popper.Utils
	 * @param {HTMLElement} popper
	 * @param {HTMLElement} reference
	 * @param {number} padding
	 * @param {HTMLElement} boundariesElement - Element used to define the boundaries
	 * @param {Boolean} fixedPosition - Is in fixed position mode
	 * @returns {Object} Coordinates of the boundaries
	 */


	function getBoundaries(popper, reference, padding, boundariesElement) {
	  var fixedPosition = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false; // NOTE: 1 DOM access here

	  var boundaries = {
	    top: 0,
	    left: 0
	  };
	  var offsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, reference); // Handle viewport case

	  if (boundariesElement === 'viewport') {
	    boundaries = getViewportOffsetRectRelativeToArtbitraryNode(offsetParent, fixedPosition);
	  } else {
	    // Handle other cases based on DOM element used as boundaries
	    var boundariesNode = void 0;

	    if (boundariesElement === 'scrollParent') {
	      boundariesNode = getScrollParent(getParentNode(reference));

	      if (boundariesNode.nodeName === 'BODY') {
	        boundariesNode = popper.ownerDocument.documentElement;
	      }
	    } else if (boundariesElement === 'window') {
	      boundariesNode = popper.ownerDocument.documentElement;
	    } else {
	      boundariesNode = boundariesElement;
	    }

	    var offsets = getOffsetRectRelativeToArbitraryNode(boundariesNode, offsetParent, fixedPosition); // In case of HTML, we need a different computation

	    if (boundariesNode.nodeName === 'HTML' && !isFixed(offsetParent)) {
	      var _getWindowSizes = getWindowSizes(popper.ownerDocument),
	          height = _getWindowSizes.height,
	          width = _getWindowSizes.width;

	      boundaries.top += offsets.top - offsets.marginTop;
	      boundaries.bottom = height + offsets.top;
	      boundaries.left += offsets.left - offsets.marginLeft;
	      boundaries.right = width + offsets.left;
	    } else {
	      // for all the other DOM elements, this one is good
	      boundaries = offsets;
	    }
	  } // Add paddings


	  padding = padding || 0;
	  var isPaddingNumber = typeof padding === 'number';
	  boundaries.left += isPaddingNumber ? padding : padding.left || 0;
	  boundaries.top += isPaddingNumber ? padding : padding.top || 0;
	  boundaries.right -= isPaddingNumber ? padding : padding.right || 0;
	  boundaries.bottom -= isPaddingNumber ? padding : padding.bottom || 0;
	  return boundaries;
	}

	function getArea(_ref) {
	  var width = _ref.width,
	      height = _ref.height;
	  return width * height;
	}
	/**
	 * Utility used to transform the `auto` placement to the placement with more
	 * available space.
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Object} data - The data object generated by update method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */


	function computeAutoPlacement(placement, refRect, popper, reference, boundariesElement) {
	  var padding = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 0;

	  if (placement.indexOf('auto') === -1) {
	    return placement;
	  }

	  var boundaries = getBoundaries(popper, reference, padding, boundariesElement);
	  var rects = {
	    top: {
	      width: boundaries.width,
	      height: refRect.top - boundaries.top
	    },
	    right: {
	      width: boundaries.right - refRect.right,
	      height: boundaries.height
	    },
	    bottom: {
	      width: boundaries.width,
	      height: boundaries.bottom - refRect.bottom
	    },
	    left: {
	      width: refRect.left - boundaries.left,
	      height: boundaries.height
	    }
	  };
	  var sortedAreas = Object.keys(rects).map(function (key) {
	    return _extends$1({
	      key: key
	    }, rects[key], {
	      area: getArea(rects[key])
	    });
	  }).sort(function (a, b) {
	    return b.area - a.area;
	  });
	  var filteredAreas = sortedAreas.filter(function (_ref2) {
	    var width = _ref2.width,
	        height = _ref2.height;
	    return width >= popper.clientWidth && height >= popper.clientHeight;
	  });
	  var computedPlacement = filteredAreas.length > 0 ? filteredAreas[0].key : sortedAreas[0].key;
	  var variation = placement.split('-')[1];
	  return computedPlacement + (variation ? '-' + variation : '');
	}
	/**
	 * Get offsets to the reference element
	 * @method
	 * @memberof Popper.Utils
	 * @param {Object} state
	 * @param {Element} popper - the popper element
	 * @param {Element} reference - the reference element (the popper will be relative to this)
	 * @param {Element} fixedPosition - is in fixed position mode
	 * @returns {Object} An object containing the offsets which will be applied to the popper
	 */


	function getReferenceOffsets(state, popper, reference) {
	  var fixedPosition = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
	  var commonOffsetParent = fixedPosition ? getFixedPositionOffsetParent(popper) : findCommonOffsetParent(popper, reference);
	  return getOffsetRectRelativeToArbitraryNode(reference, commonOffsetParent, fixedPosition);
	}
	/**
	 * Get the outer sizes of the given element (offset size + margins)
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element
	 * @returns {Object} object containing width and height properties
	 */


	function getOuterSizes(element) {
	  var window = element.ownerDocument.defaultView;
	  var styles = window.getComputedStyle(element);
	  var x = parseFloat(styles.marginTop || 0) + parseFloat(styles.marginBottom || 0);
	  var y = parseFloat(styles.marginLeft || 0) + parseFloat(styles.marginRight || 0);
	  var result = {
	    width: element.offsetWidth + y,
	    height: element.offsetHeight + x
	  };
	  return result;
	}
	/**
	 * Get the opposite placement of the given one
	 * @method
	 * @memberof Popper.Utils
	 * @argument {String} placement
	 * @returns {String} flipped placement
	 */


	function getOppositePlacement(placement) {
	  var hash = {
	    left: 'right',
	    right: 'left',
	    bottom: 'top',
	    top: 'bottom'
	  };
	  return placement.replace(/left|right|bottom|top/g, function (matched) {
	    return hash[matched];
	  });
	}
	/**
	 * Get offsets to the popper
	 * @method
	 * @memberof Popper.Utils
	 * @param {Object} position - CSS position the Popper will get applied
	 * @param {HTMLElement} popper - the popper element
	 * @param {Object} referenceOffsets - the reference offsets (the popper will be relative to this)
	 * @param {String} placement - one of the valid placement options
	 * @returns {Object} popperOffsets - An object containing the offsets which will be applied to the popper
	 */


	function getPopperOffsets(popper, referenceOffsets, placement) {
	  placement = placement.split('-')[0]; // Get popper node sizes

	  var popperRect = getOuterSizes(popper); // Add position, width and height to our offsets object

	  var popperOffsets = {
	    width: popperRect.width,
	    height: popperRect.height
	  }; // depending by the popper placement we have to compute its offsets slightly differently

	  var isHoriz = ['right', 'left'].indexOf(placement) !== -1;
	  var mainSide = isHoriz ? 'top' : 'left';
	  var secondarySide = isHoriz ? 'left' : 'top';
	  var measurement = isHoriz ? 'height' : 'width';
	  var secondaryMeasurement = !isHoriz ? 'height' : 'width';
	  popperOffsets[mainSide] = referenceOffsets[mainSide] + referenceOffsets[measurement] / 2 - popperRect[measurement] / 2;

	  if (placement === secondarySide) {
	    popperOffsets[secondarySide] = referenceOffsets[secondarySide] - popperRect[secondaryMeasurement];
	  } else {
	    popperOffsets[secondarySide] = referenceOffsets[getOppositePlacement(secondarySide)];
	  }

	  return popperOffsets;
	}
	/**
	 * Mimics the `find` method of Array
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Array} arr
	 * @argument prop
	 * @argument value
	 * @returns index or -1
	 */


	function find(arr, check) {
	  // use native find if supported
	  if (Array.prototype.find) {
	    return arr.find(check);
	  } // use `filter` to obtain the same behavior of `find`


	  return arr.filter(check)[0];
	}
	/**
	 * Return the index of the matching object
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Array} arr
	 * @argument prop
	 * @argument value
	 * @returns index or -1
	 */


	function findIndex(arr, prop, value) {
	  // use native findIndex if supported
	  if (Array.prototype.findIndex) {
	    return arr.findIndex(function (cur) {
	      return cur[prop] === value;
	    });
	  } // use `find` + `indexOf` if `findIndex` isn't supported


	  var match = find(arr, function (obj) {
	    return obj[prop] === value;
	  });
	  return arr.indexOf(match);
	}
	/**
	 * Loop trough the list of modifiers and run them in order,
	 * each of them will then edit the data object.
	 * @method
	 * @memberof Popper.Utils
	 * @param {dataObject} data
	 * @param {Array} modifiers
	 * @param {String} ends - Optional modifier name used as stopper
	 * @returns {dataObject}
	 */


	function runModifiers(modifiers, data, ends) {
	  var modifiersToRun = ends === undefined ? modifiers : modifiers.slice(0, findIndex(modifiers, 'name', ends));
	  modifiersToRun.forEach(function (modifier) {
	    if (modifier['function']) {
	      // eslint-disable-line dot-notation
	      console.warn('`modifier.function` is deprecated, use `modifier.fn`!');
	    }

	    var fn = modifier['function'] || modifier.fn; // eslint-disable-line dot-notation

	    if (modifier.enabled && isFunction(fn)) {
	      // Add properties to offsets to make them a complete clientRect object
	      // we do this before each modifier to make sure the previous one doesn't
	      // mess with these values
	      data.offsets.popper = getClientRect(data.offsets.popper);
	      data.offsets.reference = getClientRect(data.offsets.reference);
	      data = fn(data, modifier);
	    }
	  });
	  return data;
	}
	/**
	 * Updates the position of the popper, computing the new offsets and applying
	 * the new style.<br />
	 * Prefer `scheduleUpdate` over `update` because of performance reasons.
	 * @method
	 * @memberof Popper
	 */


	function update() {
	  // if popper is destroyed, don't perform any further update
	  if (this.state.isDestroyed) {
	    return;
	  }

	  var data = {
	    instance: this,
	    styles: {},
	    arrowStyles: {},
	    attributes: {},
	    flipped: false,
	    offsets: {}
	  }; // compute reference element offsets

	  data.offsets.reference = getReferenceOffsets(this.state, this.popper, this.reference, this.options.positionFixed); // compute auto placement, store placement inside the data object,
	  // modifiers will be able to edit `placement` if needed
	  // and refer to originalPlacement to know the original value

	  data.placement = computeAutoPlacement(this.options.placement, data.offsets.reference, this.popper, this.reference, this.options.modifiers.flip.boundariesElement, this.options.modifiers.flip.padding); // store the computed placement inside `originalPlacement`

	  data.originalPlacement = data.placement;
	  data.positionFixed = this.options.positionFixed; // compute the popper offsets

	  data.offsets.popper = getPopperOffsets(this.popper, data.offsets.reference, data.placement);
	  data.offsets.popper.position = this.options.positionFixed ? 'fixed' : 'absolute'; // run the modifiers

	  data = runModifiers(this.modifiers, data); // the first `update` will call `onCreate` callback
	  // the other ones will call `onUpdate` callback

	  if (!this.state.isCreated) {
	    this.state.isCreated = true;
	    this.options.onCreate(data);
	  } else {
	    this.options.onUpdate(data);
	  }
	}
	/**
	 * Helper used to know if the given modifier is enabled.
	 * @method
	 * @memberof Popper.Utils
	 * @returns {Boolean}
	 */


	function isModifierEnabled(modifiers, modifierName) {
	  return modifiers.some(function (_ref) {
	    var name = _ref.name,
	        enabled = _ref.enabled;
	    return enabled && name === modifierName;
	  });
	}
	/**
	 * Get the prefixed supported property name
	 * @method
	 * @memberof Popper.Utils
	 * @argument {String} property (camelCase)
	 * @returns {String} prefixed property (camelCase or PascalCase, depending on the vendor prefix)
	 */


	function getSupportedPropertyName(property) {
	  var prefixes = [false, 'ms', 'Webkit', 'Moz', 'O'];
	  var upperProp = property.charAt(0).toUpperCase() + property.slice(1);

	  for (var i = 0; i < prefixes.length; i++) {
	    var prefix = prefixes[i];
	    var toCheck = prefix ? '' + prefix + upperProp : property;

	    if (typeof document.body.style[toCheck] !== 'undefined') {
	      return toCheck;
	    }
	  }

	  return null;
	}
	/**
	 * Destroys the popper.
	 * @method
	 * @memberof Popper
	 */


	function destroy() {
	  this.state.isDestroyed = true; // touch DOM only if `applyStyle` modifier is enabled

	  if (isModifierEnabled(this.modifiers, 'applyStyle')) {
	    this.popper.removeAttribute('x-placement');
	    this.popper.style.position = '';
	    this.popper.style.top = '';
	    this.popper.style.left = '';
	    this.popper.style.right = '';
	    this.popper.style.bottom = '';
	    this.popper.style.willChange = '';
	    this.popper.style[getSupportedPropertyName('transform')] = '';
	  }

	  this.disableEventListeners(); // remove the popper if user explicity asked for the deletion on destroy
	  // do not use `remove` because IE11 doesn't support it

	  if (this.options.removeOnDestroy) {
	    this.popper.parentNode.removeChild(this.popper);
	  }

	  return this;
	}
	/**
	 * Get the window associated with the element
	 * @argument {Element} element
	 * @returns {Window}
	 */


	function getWindow(element) {
	  var ownerDocument = element.ownerDocument;
	  return ownerDocument ? ownerDocument.defaultView : window;
	}

	function attachToScrollParents(scrollParent, event, callback, scrollParents) {
	  var isBody = scrollParent.nodeName === 'BODY';
	  var target = isBody ? scrollParent.ownerDocument.defaultView : scrollParent;
	  target.addEventListener(event, callback, {
	    passive: true
	  });

	  if (!isBody) {
	    attachToScrollParents(getScrollParent(target.parentNode), event, callback, scrollParents);
	  }

	  scrollParents.push(target);
	}
	/**
	 * Setup needed event listeners used to update the popper position
	 * @method
	 * @memberof Popper.Utils
	 * @private
	 */


	function setupEventListeners(reference, options, state, updateBound) {
	  // Resize event listener on window
	  state.updateBound = updateBound;
	  getWindow(reference).addEventListener('resize', state.updateBound, {
	    passive: true
	  }); // Scroll event listener on scroll parents

	  var scrollElement = getScrollParent(reference);
	  attachToScrollParents(scrollElement, 'scroll', state.updateBound, state.scrollParents);
	  state.scrollElement = scrollElement;
	  state.eventsEnabled = true;
	  return state;
	}
	/**
	 * It will add resize/scroll events and start recalculating
	 * position of the popper element when they are triggered.
	 * @method
	 * @memberof Popper
	 */


	function enableEventListeners() {
	  if (!this.state.eventsEnabled) {
	    this.state = setupEventListeners(this.reference, this.options, this.state, this.scheduleUpdate);
	  }
	}
	/**
	 * Remove event listeners used to update the popper position
	 * @method
	 * @memberof Popper.Utils
	 * @private
	 */


	function removeEventListeners(reference, state) {
	  // Remove resize event listener on window
	  getWindow(reference).removeEventListener('resize', state.updateBound); // Remove scroll event listener on scroll parents

	  state.scrollParents.forEach(function (target) {
	    target.removeEventListener('scroll', state.updateBound);
	  }); // Reset state

	  state.updateBound = null;
	  state.scrollParents = [];
	  state.scrollElement = null;
	  state.eventsEnabled = false;
	  return state;
	}
	/**
	 * It will remove resize/scroll events and won't recalculate popper position
	 * when they are triggered. It also won't trigger `onUpdate` callback anymore,
	 * unless you call `update` method manually.
	 * @method
	 * @memberof Popper
	 */


	function disableEventListeners() {
	  if (this.state.eventsEnabled) {
	    cancelAnimationFrame(this.scheduleUpdate);
	    this.state = removeEventListeners(this.reference, this.state);
	  }
	}
	/**
	 * Tells if a given input is a number
	 * @method
	 * @memberof Popper.Utils
	 * @param {*} input to check
	 * @return {Boolean}
	 */


	function isNumeric(n) {
	  return n !== '' && !isNaN(parseFloat(n)) && isFinite(n);
	}
	/**
	 * Set the style to the given popper
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element - Element to apply the style to
	 * @argument {Object} styles
	 * Object with a list of properties and values which will be applied to the element
	 */


	function setStyles(element, styles) {
	  Object.keys(styles).forEach(function (prop) {
	    var unit = ''; // add unit if the value is numeric and is one of the following

	    if (['width', 'height', 'top', 'right', 'bottom', 'left'].indexOf(prop) !== -1 && isNumeric(styles[prop])) {
	      unit = 'px';
	    }

	    element.style[prop] = styles[prop] + unit;
	  });
	}
	/**
	 * Set the attributes to the given popper
	 * @method
	 * @memberof Popper.Utils
	 * @argument {Element} element - Element to apply the attributes to
	 * @argument {Object} styles
	 * Object with a list of properties and values which will be applied to the element
	 */


	function setAttributes(element, attributes) {
	  Object.keys(attributes).forEach(function (prop) {
	    var value = attributes[prop];

	    if (value !== false) {
	      element.setAttribute(prop, attributes[prop]);
	    } else {
	      element.removeAttribute(prop);
	    }
	  });
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by `update` method
	 * @argument {Object} data.styles - List of style properties - values to apply to popper element
	 * @argument {Object} data.attributes - List of attribute properties - values to apply to popper element
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The same data object
	 */


	function applyStyle(data) {
	  // any property present in `data.styles` will be applied to the popper,
	  // in this way we can make the 3rd party modifiers add custom styles to it
	  // Be aware, modifiers could override the properties defined in the previous
	  // lines of this modifier!
	  setStyles(data.instance.popper, data.styles); // any property present in `data.attributes` will be applied to the popper,
	  // they will be set as HTML attributes of the element

	  setAttributes(data.instance.popper, data.attributes); // if arrowElement is defined and arrowStyles has some properties

	  if (data.arrowElement && Object.keys(data.arrowStyles).length) {
	    setStyles(data.arrowElement, data.arrowStyles);
	  }

	  return data;
	}
	/**
	 * Set the x-placement attribute before everything else because it could be used
	 * to add margins to the popper margins needs to be calculated to get the
	 * correct popper offsets.
	 * @method
	 * @memberof Popper.modifiers
	 * @param {HTMLElement} reference - The reference element used to position the popper
	 * @param {HTMLElement} popper - The HTML element used as popper
	 * @param {Object} options - Popper.js options
	 */


	function applyStyleOnLoad(reference, popper, options, modifierOptions, state) {
	  // compute reference element offsets
	  var referenceOffsets = getReferenceOffsets(state, popper, reference, options.positionFixed); // compute auto placement, store placement inside the data object,
	  // modifiers will be able to edit `placement` if needed
	  // and refer to originalPlacement to know the original value

	  var placement = computeAutoPlacement(options.placement, referenceOffsets, popper, reference, options.modifiers.flip.boundariesElement, options.modifiers.flip.padding);
	  popper.setAttribute('x-placement', placement); // Apply `position` to popper before anything else because
	  // without the position applied we can't guarantee correct computations

	  setStyles(popper, {
	    position: options.positionFixed ? 'fixed' : 'absolute'
	  });
	  return options;
	}
	/**
	 * @function
	 * @memberof Popper.Utils
	 * @argument {Object} data - The data object generated by `update` method
	 * @argument {Boolean} shouldRound - If the offsets should be rounded at all
	 * @returns {Object} The popper's position offsets rounded
	 *
	 * The tale of pixel-perfect positioning. It's still not 100% perfect, but as
	 * good as it can be within reason.
	 * Discussion here: https://github.com/FezVrasta/popper.js/pull/715
	 *
	 * Low DPI screens cause a popper to be blurry if not using full pixels (Safari
	 * as well on High DPI screens).
	 *
	 * Firefox prefers no rounding for positioning and does not have blurriness on
	 * high DPI screens.
	 *
	 * Only horizontal placement and left/right values need to be considered.
	 */


	function getRoundedOffsets(data, shouldRound) {
	  var _data$offsets = data.offsets,
	      popper = _data$offsets.popper,
	      reference = _data$offsets.reference;
	  var round = Math.round,
	      floor = Math.floor;

	  var noRound = function noRound(v) {
	    return v;
	  };

	  var referenceWidth = round(reference.width);
	  var popperWidth = round(popper.width);
	  var isVertical = ['left', 'right'].indexOf(data.placement) !== -1;
	  var isVariation = data.placement.indexOf('-') !== -1;
	  var sameWidthParity = referenceWidth % 2 === popperWidth % 2;
	  var bothOddWidth = referenceWidth % 2 === 1 && popperWidth % 2 === 1;
	  var horizontalToInteger = !shouldRound ? noRound : isVertical || isVariation || sameWidthParity ? round : floor;
	  var verticalToInteger = !shouldRound ? noRound : round;
	  return {
	    left: horizontalToInteger(bothOddWidth && !isVariation && shouldRound ? popper.left - 1 : popper.left),
	    top: verticalToInteger(popper.top),
	    bottom: verticalToInteger(popper.bottom),
	    right: horizontalToInteger(popper.right)
	  };
	}

	var isFirefox = isBrowser && /Firefox/i.test(navigator.userAgent);
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by `update` method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */

	function computeStyle(data, options) {
	  var x = options.x,
	      y = options.y;
	  var popper = data.offsets.popper; // Remove this legacy support in Popper.js v2

	  var legacyGpuAccelerationOption = find(data.instance.modifiers, function (modifier) {
	    return modifier.name === 'applyStyle';
	  }).gpuAcceleration;

	  if (legacyGpuAccelerationOption !== undefined) {
	    console.warn('WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!');
	  }

	  var gpuAcceleration = legacyGpuAccelerationOption !== undefined ? legacyGpuAccelerationOption : options.gpuAcceleration;
	  var offsetParent = getOffsetParent(data.instance.popper);
	  var offsetParentRect = getBoundingClientRect(offsetParent); // Styles

	  var styles = {
	    position: popper.position
	  };
	  var offsets = getRoundedOffsets(data, window.devicePixelRatio < 2 || !isFirefox);
	  var sideA = x === 'bottom' ? 'top' : 'bottom';
	  var sideB = y === 'right' ? 'left' : 'right'; // if gpuAcceleration is set to `true` and transform is supported,
	  //  we use `translate3d` to apply the position to the popper we
	  // automatically use the supported prefixed version if needed

	  var prefixedProperty = getSupportedPropertyName('transform'); // now, let's make a step back and look at this code closely (wtf?)
	  // If the content of the popper grows once it's been positioned, it
	  // may happen that the popper gets misplaced because of the new content
	  // overflowing its reference element
	  // To avoid this problem, we provide two options (x and y), which allow
	  // the consumer to define the offset origin.
	  // If we position a popper on top of a reference element, we can set
	  // `x` to `top` to make the popper grow towards its top instead of
	  // its bottom.

	  var left = void 0,
	      top = void 0;

	  if (sideA === 'bottom') {
	    // when offsetParent is <html> the positioning is relative to the bottom of the screen (excluding the scrollbar)
	    // and not the bottom of the html element
	    if (offsetParent.nodeName === 'HTML') {
	      top = -offsetParent.clientHeight + offsets.bottom;
	    } else {
	      top = -offsetParentRect.height + offsets.bottom;
	    }
	  } else {
	    top = offsets.top;
	  }

	  if (sideB === 'right') {
	    if (offsetParent.nodeName === 'HTML') {
	      left = -offsetParent.clientWidth + offsets.right;
	    } else {
	      left = -offsetParentRect.width + offsets.right;
	    }
	  } else {
	    left = offsets.left;
	  }

	  if (gpuAcceleration && prefixedProperty) {
	    styles[prefixedProperty] = 'translate3d(' + left + 'px, ' + top + 'px, 0)';
	    styles[sideA] = 0;
	    styles[sideB] = 0;
	    styles.willChange = 'transform';
	  } else {
	    // othwerise, we use the standard `top`, `left`, `bottom` and `right` properties
	    var invertTop = sideA === 'bottom' ? -1 : 1;
	    var invertLeft = sideB === 'right' ? -1 : 1;
	    styles[sideA] = top * invertTop;
	    styles[sideB] = left * invertLeft;
	    styles.willChange = sideA + ', ' + sideB;
	  } // Attributes


	  var attributes = {
	    'x-placement': data.placement
	  }; // Update `data` attributes, styles and arrowStyles

	  data.attributes = _extends$1({}, attributes, data.attributes);
	  data.styles = _extends$1({}, styles, data.styles);
	  data.arrowStyles = _extends$1({}, data.offsets.arrow, data.arrowStyles);
	  return data;
	}
	/**
	 * Helper used to know if the given modifier depends from another one.<br />
	 * It checks if the needed modifier is listed and enabled.
	 * @method
	 * @memberof Popper.Utils
	 * @param {Array} modifiers - list of modifiers
	 * @param {String} requestingName - name of requesting modifier
	 * @param {String} requestedName - name of requested modifier
	 * @returns {Boolean}
	 */


	function isModifierRequired(modifiers, requestingName, requestedName) {
	  var requesting = find(modifiers, function (_ref) {
	    var name = _ref.name;
	    return name === requestingName;
	  });
	  var isRequired = !!requesting && modifiers.some(function (modifier) {
	    return modifier.name === requestedName && modifier.enabled && modifier.order < requesting.order;
	  });

	  if (!isRequired) {
	    var _requesting = '`' + requestingName + '`';

	    var requested = '`' + requestedName + '`';
	    console.warn(requested + ' modifier is required by ' + _requesting + ' modifier in order to work, be sure to include it before ' + _requesting + '!');
	  }

	  return isRequired;
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by update method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */


	function arrow(data, options) {
	  var _data$offsets$arrow; // arrow depends on keepTogether in order to work


	  if (!isModifierRequired(data.instance.modifiers, 'arrow', 'keepTogether')) {
	    return data;
	  }

	  var arrowElement = options.element; // if arrowElement is a string, suppose it's a CSS selector

	  if (typeof arrowElement === 'string') {
	    arrowElement = data.instance.popper.querySelector(arrowElement); // if arrowElement is not found, don't run the modifier

	    if (!arrowElement) {
	      return data;
	    }
	  } else {
	    // if the arrowElement isn't a query selector we must check that the
	    // provided DOM node is child of its popper node
	    if (!data.instance.popper.contains(arrowElement)) {
	      console.warn('WARNING: `arrow.element` must be child of its popper element!');
	      return data;
	    }
	  }

	  var placement = data.placement.split('-')[0];
	  var _data$offsets = data.offsets,
	      popper = _data$offsets.popper,
	      reference = _data$offsets.reference;
	  var isVertical = ['left', 'right'].indexOf(placement) !== -1;
	  var len = isVertical ? 'height' : 'width';
	  var sideCapitalized = isVertical ? 'Top' : 'Left';
	  var side = sideCapitalized.toLowerCase();
	  var altSide = isVertical ? 'left' : 'top';
	  var opSide = isVertical ? 'bottom' : 'right';
	  var arrowElementSize = getOuterSizes(arrowElement)[len]; //
	  // extends keepTogether behavior making sure the popper and its
	  // reference have enough pixels in conjunction
	  //
	  // top/left side

	  if (reference[opSide] - arrowElementSize < popper[side]) {
	    data.offsets.popper[side] -= popper[side] - (reference[opSide] - arrowElementSize);
	  } // bottom/right side


	  if (reference[side] + arrowElementSize > popper[opSide]) {
	    data.offsets.popper[side] += reference[side] + arrowElementSize - popper[opSide];
	  }

	  data.offsets.popper = getClientRect(data.offsets.popper); // compute center of the popper

	  var center = reference[side] + reference[len] / 2 - arrowElementSize / 2; // Compute the sideValue using the updated popper offsets
	  // take popper margin in account because we don't have this info available

	  var css = getStyleComputedProperty(data.instance.popper);
	  var popperMarginSide = parseFloat(css['margin' + sideCapitalized], 10);
	  var popperBorderSide = parseFloat(css['border' + sideCapitalized + 'Width'], 10);
	  var sideValue = center - data.offsets.popper[side] - popperMarginSide - popperBorderSide; // prevent arrowElement from being placed not contiguously to its popper

	  sideValue = Math.max(Math.min(popper[len] - arrowElementSize, sideValue), 0);
	  data.arrowElement = arrowElement;
	  data.offsets.arrow = (_data$offsets$arrow = {}, defineProperty(_data$offsets$arrow, side, Math.round(sideValue)), defineProperty(_data$offsets$arrow, altSide, ''), _data$offsets$arrow);
	  return data;
	}
	/**
	 * Get the opposite placement variation of the given one
	 * @method
	 * @memberof Popper.Utils
	 * @argument {String} placement variation
	 * @returns {String} flipped placement variation
	 */


	function getOppositeVariation(variation) {
	  if (variation === 'end') {
	    return 'start';
	  } else if (variation === 'start') {
	    return 'end';
	  }

	  return variation;
	}
	/**
	 * List of accepted placements to use as values of the `placement` option.<br />
	 * Valid placements are:
	 * - `auto`
	 * - `top`
	 * - `right`
	 * - `bottom`
	 * - `left`
	 *
	 * Each placement can have a variation from this list:
	 * - `-start`
	 * - `-end`
	 *
	 * Variations are interpreted easily if you think of them as the left to right
	 * written languages. Horizontally (`top` and `bottom`), `start` is left and `end`
	 * is right.<br />
	 * Vertically (`left` and `right`), `start` is top and `end` is bottom.
	 *
	 * Some valid examples are:
	 * - `top-end` (on top of reference, right aligned)
	 * - `right-start` (on right of reference, top aligned)
	 * - `bottom` (on bottom, centered)
	 * - `auto-end` (on the side with more space available, alignment depends by placement)
	 *
	 * @static
	 * @type {Array}
	 * @enum {String}
	 * @readonly
	 * @method placements
	 * @memberof Popper
	 */


	var placements = ['auto-start', 'auto', 'auto-end', 'top-start', 'top', 'top-end', 'right-start', 'right', 'right-end', 'bottom-end', 'bottom', 'bottom-start', 'left-end', 'left', 'left-start']; // Get rid of `auto` `auto-start` and `auto-end`

	var validPlacements = placements.slice(3);
	/**
	 * Given an initial placement, returns all the subsequent placements
	 * clockwise (or counter-clockwise).
	 *
	 * @method
	 * @memberof Popper.Utils
	 * @argument {String} placement - A valid placement (it accepts variations)
	 * @argument {Boolean} counter - Set to true to walk the placements counterclockwise
	 * @returns {Array} placements including their variations
	 */

	function clockwise(placement) {
	  var counter = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
	  var index$$1 = validPlacements.indexOf(placement);
	  var arr = validPlacements.slice(index$$1 + 1).concat(validPlacements.slice(0, index$$1));
	  return counter ? arr.reverse() : arr;
	}

	var BEHAVIORS = {
	  FLIP: 'flip',
	  CLOCKWISE: 'clockwise',
	  COUNTERCLOCKWISE: 'counterclockwise'
	};
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by update method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */

	function flip(data, options) {
	  // if `inner` modifier is enabled, we can't use the `flip` modifier
	  if (isModifierEnabled(data.instance.modifiers, 'inner')) {
	    return data;
	  }

	  if (data.flipped && data.placement === data.originalPlacement) {
	    // seems like flip is trying to loop, probably there's not enough space on any of the flippable sides
	    return data;
	  }

	  var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, options.boundariesElement, data.positionFixed);
	  var placement = data.placement.split('-')[0];
	  var placementOpposite = getOppositePlacement(placement);
	  var variation = data.placement.split('-')[1] || '';
	  var flipOrder = [];

	  switch (options.behavior) {
	    case BEHAVIORS.FLIP:
	      flipOrder = [placement, placementOpposite];
	      break;

	    case BEHAVIORS.CLOCKWISE:
	      flipOrder = clockwise(placement);
	      break;

	    case BEHAVIORS.COUNTERCLOCKWISE:
	      flipOrder = clockwise(placement, true);
	      break;

	    default:
	      flipOrder = options.behavior;
	  }

	  flipOrder.forEach(function (step, index$$1) {
	    if (placement !== step || flipOrder.length === index$$1 + 1) {
	      return data;
	    }

	    placement = data.placement.split('-')[0];
	    placementOpposite = getOppositePlacement(placement);
	    var popperOffsets = data.offsets.popper;
	    var refOffsets = data.offsets.reference; // using floor because the reference offsets may contain decimals we are not going to consider here

	    var floor = Math.floor;
	    var overlapsRef = placement === 'left' && floor(popperOffsets.right) > floor(refOffsets.left) || placement === 'right' && floor(popperOffsets.left) < floor(refOffsets.right) || placement === 'top' && floor(popperOffsets.bottom) > floor(refOffsets.top) || placement === 'bottom' && floor(popperOffsets.top) < floor(refOffsets.bottom);
	    var overflowsLeft = floor(popperOffsets.left) < floor(boundaries.left);
	    var overflowsRight = floor(popperOffsets.right) > floor(boundaries.right);
	    var overflowsTop = floor(popperOffsets.top) < floor(boundaries.top);
	    var overflowsBottom = floor(popperOffsets.bottom) > floor(boundaries.bottom);
	    var overflowsBoundaries = placement === 'left' && overflowsLeft || placement === 'right' && overflowsRight || placement === 'top' && overflowsTop || placement === 'bottom' && overflowsBottom; // flip the variation if required

	    var isVertical = ['top', 'bottom'].indexOf(placement) !== -1; // flips variation if reference element overflows boundaries

	    var flippedVariationByRef = !!options.flipVariations && (isVertical && variation === 'start' && overflowsLeft || isVertical && variation === 'end' && overflowsRight || !isVertical && variation === 'start' && overflowsTop || !isVertical && variation === 'end' && overflowsBottom); // flips variation if popper content overflows boundaries

	    var flippedVariationByContent = !!options.flipVariationsByContent && (isVertical && variation === 'start' && overflowsRight || isVertical && variation === 'end' && overflowsLeft || !isVertical && variation === 'start' && overflowsBottom || !isVertical && variation === 'end' && overflowsTop);
	    var flippedVariation = flippedVariationByRef || flippedVariationByContent;

	    if (overlapsRef || overflowsBoundaries || flippedVariation) {
	      // this boolean to detect any flip loop
	      data.flipped = true;

	      if (overlapsRef || overflowsBoundaries) {
	        placement = flipOrder[index$$1 + 1];
	      }

	      if (flippedVariation) {
	        variation = getOppositeVariation(variation);
	      }

	      data.placement = placement + (variation ? '-' + variation : ''); // this object contains `position`, we want to preserve it along with
	      // any additional property we may add in the future

	      data.offsets.popper = _extends$1({}, data.offsets.popper, getPopperOffsets(data.instance.popper, data.offsets.reference, data.placement));
	      data = runModifiers(data.instance.modifiers, data, 'flip');
	    }
	  });
	  return data;
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by update method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */


	function keepTogether(data) {
	  var _data$offsets = data.offsets,
	      popper = _data$offsets.popper,
	      reference = _data$offsets.reference;
	  var placement = data.placement.split('-')[0];
	  var floor = Math.floor;
	  var isVertical = ['top', 'bottom'].indexOf(placement) !== -1;
	  var side = isVertical ? 'right' : 'bottom';
	  var opSide = isVertical ? 'left' : 'top';
	  var measurement = isVertical ? 'width' : 'height';

	  if (popper[side] < floor(reference[opSide])) {
	    data.offsets.popper[opSide] = floor(reference[opSide]) - popper[measurement];
	  }

	  if (popper[opSide] > floor(reference[side])) {
	    data.offsets.popper[opSide] = floor(reference[side]);
	  }

	  return data;
	}
	/**
	 * Converts a string containing value + unit into a px value number
	 * @function
	 * @memberof {modifiers~offset}
	 * @private
	 * @argument {String} str - Value + unit string
	 * @argument {String} measurement - `height` or `width`
	 * @argument {Object} popperOffsets
	 * @argument {Object} referenceOffsets
	 * @returns {Number|String}
	 * Value in pixels, or original string if no values were extracted
	 */


	function toValue(str, measurement, popperOffsets, referenceOffsets) {
	  // separate value from unit
	  var split = str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/);
	  var value = +split[1];
	  var unit = split[2]; // If it's not a number it's an operator, I guess

	  if (!value) {
	    return str;
	  }

	  if (unit.indexOf('%') === 0) {
	    var element = void 0;

	    switch (unit) {
	      case '%p':
	        element = popperOffsets;
	        break;

	      case '%':
	      case '%r':
	      default:
	        element = referenceOffsets;
	    }

	    var rect = getClientRect(element);
	    return rect[measurement] / 100 * value;
	  } else if (unit === 'vh' || unit === 'vw') {
	    // if is a vh or vw, we calculate the size based on the viewport
	    var size = void 0;

	    if (unit === 'vh') {
	      size = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
	    } else {
	      size = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
	    }

	    return size / 100 * value;
	  } else {
	    // if is an explicit pixel unit, we get rid of the unit and keep the value
	    // if is an implicit unit, it's px, and we return just the value
	    return value;
	  }
	}
	/**
	 * Parse an `offset` string to extrapolate `x` and `y` numeric offsets.
	 * @function
	 * @memberof {modifiers~offset}
	 * @private
	 * @argument {String} offset
	 * @argument {Object} popperOffsets
	 * @argument {Object} referenceOffsets
	 * @argument {String} basePlacement
	 * @returns {Array} a two cells array with x and y offsets in numbers
	 */


	function parseOffset(offset, popperOffsets, referenceOffsets, basePlacement) {
	  var offsets = [0, 0]; // Use height if placement is left or right and index is 0 otherwise use width
	  // in this way the first offset will use an axis and the second one
	  // will use the other one

	  var useHeight = ['right', 'left'].indexOf(basePlacement) !== -1; // Split the offset string to obtain a list of values and operands
	  // The regex addresses values with the plus or minus sign in front (+10, -20, etc)

	  var fragments = offset.split(/(\+|\-)/).map(function (frag) {
	    return frag.trim();
	  }); // Detect if the offset string contains a pair of values or a single one
	  // they could be separated by comma or space

	  var divider = fragments.indexOf(find(fragments, function (frag) {
	    return frag.search(/,|\s/) !== -1;
	  }));

	  if (fragments[divider] && fragments[divider].indexOf(',') === -1) {
	    console.warn('Offsets separated by white space(s) are deprecated, use a comma (,) instead.');
	  } // If divider is found, we divide the list of values and operands to divide
	  // them by ofset X and Y.


	  var splitRegex = /\s*,\s*|\s+/;
	  var ops = divider !== -1 ? [fragments.slice(0, divider).concat([fragments[divider].split(splitRegex)[0]]), [fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider + 1))] : [fragments]; // Convert the values with units to absolute pixels to allow our computations

	  ops = ops.map(function (op, index$$1) {
	    // Most of the units rely on the orientation of the popper
	    var measurement = (index$$1 === 1 ? !useHeight : useHeight) ? 'height' : 'width';
	    var mergeWithPrevious = false;
	    return op // This aggregates any `+` or `-` sign that aren't considered operators
	    // e.g.: 10 + +5 => [10, +, +5]
	    .reduce(function (a, b) {
	      if (a[a.length - 1] === '' && ['+', '-'].indexOf(b) !== -1) {
	        a[a.length - 1] = b;
	        mergeWithPrevious = true;
	        return a;
	      } else if (mergeWithPrevious) {
	        a[a.length - 1] += b;
	        mergeWithPrevious = false;
	        return a;
	      } else {
	        return a.concat(b);
	      }
	    }, []) // Here we convert the string values into number values (in px)
	    .map(function (str) {
	      return toValue(str, measurement, popperOffsets, referenceOffsets);
	    });
	  }); // Loop trough the offsets arrays and execute the operations

	  ops.forEach(function (op, index$$1) {
	    op.forEach(function (frag, index2) {
	      if (isNumeric(frag)) {
	        offsets[index$$1] += frag * (op[index2 - 1] === '-' ? -1 : 1);
	      }
	    });
	  });
	  return offsets;
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by update method
	 * @argument {Object} options - Modifiers configuration and options
	 * @argument {Number|String} options.offset=0
	 * The offset value as described in the modifier description
	 * @returns {Object} The data object, properly modified
	 */


	function offset(data, _ref) {
	  var offset = _ref.offset;
	  var placement = data.placement,
	      _data$offsets = data.offsets,
	      popper = _data$offsets.popper,
	      reference = _data$offsets.reference;
	  var basePlacement = placement.split('-')[0];
	  var offsets = void 0;

	  if (isNumeric(+offset)) {
	    offsets = [+offset, 0];
	  } else {
	    offsets = parseOffset(offset, popper, reference, basePlacement);
	  }

	  if (basePlacement === 'left') {
	    popper.top += offsets[0];
	    popper.left -= offsets[1];
	  } else if (basePlacement === 'right') {
	    popper.top += offsets[0];
	    popper.left += offsets[1];
	  } else if (basePlacement === 'top') {
	    popper.left += offsets[0];
	    popper.top -= offsets[1];
	  } else if (basePlacement === 'bottom') {
	    popper.left += offsets[0];
	    popper.top += offsets[1];
	  }

	  data.popper = popper;
	  return data;
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by `update` method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */


	function preventOverflow(data, options) {
	  var boundariesElement = options.boundariesElement || getOffsetParent(data.instance.popper); // If offsetParent is the reference element, we really want to
	  // go one step up and use the next offsetParent as reference to
	  // avoid to make this modifier completely useless and look like broken

	  if (data.instance.reference === boundariesElement) {
	    boundariesElement = getOffsetParent(boundariesElement);
	  } // NOTE: DOM access here
	  // resets the popper's position so that the document size can be calculated excluding
	  // the size of the popper element itself


	  var transformProp = getSupportedPropertyName('transform');
	  var popperStyles = data.instance.popper.style; // assignment to help minification

	  var top = popperStyles.top,
	      left = popperStyles.left,
	      transform = popperStyles[transformProp];
	  popperStyles.top = '';
	  popperStyles.left = '';
	  popperStyles[transformProp] = '';
	  var boundaries = getBoundaries(data.instance.popper, data.instance.reference, options.padding, boundariesElement, data.positionFixed); // NOTE: DOM access here
	  // restores the original style properties after the offsets have been computed

	  popperStyles.top = top;
	  popperStyles.left = left;
	  popperStyles[transformProp] = transform;
	  options.boundaries = boundaries;
	  var order = options.priority;
	  var popper = data.offsets.popper;
	  var check = {
	    primary: function primary(placement) {
	      var value = popper[placement];

	      if (popper[placement] < boundaries[placement] && !options.escapeWithReference) {
	        value = Math.max(popper[placement], boundaries[placement]);
	      }

	      return defineProperty({}, placement, value);
	    },
	    secondary: function secondary(placement) {
	      var mainSide = placement === 'right' ? 'left' : 'top';
	      var value = popper[mainSide];

	      if (popper[placement] > boundaries[placement] && !options.escapeWithReference) {
	        value = Math.min(popper[mainSide], boundaries[placement] - (placement === 'right' ? popper.width : popper.height));
	      }

	      return defineProperty({}, mainSide, value);
	    }
	  };
	  order.forEach(function (placement) {
	    var side = ['left', 'top'].indexOf(placement) !== -1 ? 'primary' : 'secondary';
	    popper = _extends$1({}, popper, check[side](placement));
	  });
	  data.offsets.popper = popper;
	  return data;
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by `update` method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */


	function shift(data) {
	  var placement = data.placement;
	  var basePlacement = placement.split('-')[0];
	  var shiftvariation = placement.split('-')[1]; // if shift shiftvariation is specified, run the modifier

	  if (shiftvariation) {
	    var _data$offsets = data.offsets,
	        reference = _data$offsets.reference,
	        popper = _data$offsets.popper;
	    var isVertical = ['bottom', 'top'].indexOf(basePlacement) !== -1;
	    var side = isVertical ? 'left' : 'top';
	    var measurement = isVertical ? 'width' : 'height';
	    var shiftOffsets = {
	      start: defineProperty({}, side, reference[side]),
	      end: defineProperty({}, side, reference[side] + reference[measurement] - popper[measurement])
	    };
	    data.offsets.popper = _extends$1({}, popper, shiftOffsets[shiftvariation]);
	  }

	  return data;
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by update method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */


	function hide(data) {
	  if (!isModifierRequired(data.instance.modifiers, 'hide', 'preventOverflow')) {
	    return data;
	  }

	  var refRect = data.offsets.reference;
	  var bound = find(data.instance.modifiers, function (modifier) {
	    return modifier.name === 'preventOverflow';
	  }).boundaries;

	  if (refRect.bottom < bound.top || refRect.left > bound.right || refRect.top > bound.bottom || refRect.right < bound.left) {
	    // Avoid unnecessary DOM access if visibility hasn't changed
	    if (data.hide === true) {
	      return data;
	    }

	    data.hide = true;
	    data.attributes['x-out-of-boundaries'] = '';
	  } else {
	    // Avoid unnecessary DOM access if visibility hasn't changed
	    if (data.hide === false) {
	      return data;
	    }

	    data.hide = false;
	    data.attributes['x-out-of-boundaries'] = false;
	  }

	  return data;
	}
	/**
	 * @function
	 * @memberof Modifiers
	 * @argument {Object} data - The data object generated by `update` method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {Object} The data object, properly modified
	 */


	function inner(data) {
	  var placement = data.placement;
	  var basePlacement = placement.split('-')[0];
	  var _data$offsets = data.offsets,
	      popper = _data$offsets.popper,
	      reference = _data$offsets.reference;
	  var isHoriz = ['left', 'right'].indexOf(basePlacement) !== -1;
	  var subtractLength = ['top', 'left'].indexOf(basePlacement) === -1;
	  popper[isHoriz ? 'left' : 'top'] = reference[basePlacement] - (subtractLength ? popper[isHoriz ? 'width' : 'height'] : 0);
	  data.placement = getOppositePlacement(placement);
	  data.offsets.popper = getClientRect(popper);
	  return data;
	}
	/**
	 * Modifier function, each modifier can have a function of this type assigned
	 * to its `fn` property.<br />
	 * These functions will be called on each update, this means that you must
	 * make sure they are performant enough to avoid performance bottlenecks.
	 *
	 * @function ModifierFn
	 * @argument {dataObject} data - The data object generated by `update` method
	 * @argument {Object} options - Modifiers configuration and options
	 * @returns {dataObject} The data object, properly modified
	 */

	/**
	 * Modifiers are plugins used to alter the behavior of your poppers.<br />
	 * Popper.js uses a set of 9 modifiers to provide all the basic functionalities
	 * needed by the library.
	 *
	 * Usually you don't want to override the `order`, `fn` and `onLoad` props.
	 * All the other properties are configurations that could be tweaked.
	 * @namespace modifiers
	 */


	var modifiers = {
	  /**
	   * Modifier used to shift the popper on the start or end of its reference
	   * element.<br />
	   * It will read the variation of the `placement` property.<br />
	   * It can be one either `-end` or `-start`.
	   * @memberof modifiers
	   * @inner
	   */
	  shift: {
	    /** @prop {number} order=100 - Index used to define the order of execution */
	    order: 100,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: shift
	  },

	  /**
	   * The `offset` modifier can shift your popper on both its axis.
	   *
	   * It accepts the following units:
	   * - `px` or unit-less, interpreted as pixels
	   * - `%` or `%r`, percentage relative to the length of the reference element
	   * - `%p`, percentage relative to the length of the popper element
	   * - `vw`, CSS viewport width unit
	   * - `vh`, CSS viewport height unit
	   *
	   * For length is intended the main axis relative to the placement of the popper.<br />
	   * This means that if the placement is `top` or `bottom`, the length will be the
	   * `width`. In case of `left` or `right`, it will be the `height`.
	   *
	   * You can provide a single value (as `Number` or `String`), or a pair of values
	   * as `String` divided by a comma or one (or more) white spaces.<br />
	   * The latter is a deprecated method because it leads to confusion and will be
	   * removed in v2.<br />
	   * Additionally, it accepts additions and subtractions between different units.
	   * Note that multiplications and divisions aren't supported.
	   *
	   * Valid examples are:
	   * ```
	   * 10
	   * '10%'
	   * '10, 10'
	   * '10%, 10'
	   * '10 + 10%'
	   * '10 - 5vh + 3%'
	   * '-10px + 5vh, 5px - 6%'
	   * ```
	   * > **NB**: If you desire to apply offsets to your poppers in a way that may make them overlap
	   * > with their reference element, unfortunately, you will have to disable the `flip` modifier.
	   * > You can read more on this at this [issue](https://github.com/FezVrasta/popper.js/issues/373).
	   *
	   * @memberof modifiers
	   * @inner
	   */
	  offset: {
	    /** @prop {number} order=200 - Index used to define the order of execution */
	    order: 200,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: offset,

	    /** @prop {Number|String} offset=0
	     * The offset value as described in the modifier description
	     */
	    offset: 0
	  },

	  /**
	   * Modifier used to prevent the popper from being positioned outside the boundary.
	   *
	   * A scenario exists where the reference itself is not within the boundaries.<br />
	   * We can say it has "escaped the boundaries" — or just "escaped".<br />
	   * In this case we need to decide whether the popper should either:
	   *
	   * - detach from the reference and remain "trapped" in the boundaries, or
	   * - if it should ignore the boundary and "escape with its reference"
	   *
	   * When `escapeWithReference` is set to`true` and reference is completely
	   * outside its boundaries, the popper will overflow (or completely leave)
	   * the boundaries in order to remain attached to the edge of the reference.
	   *
	   * @memberof modifiers
	   * @inner
	   */
	  preventOverflow: {
	    /** @prop {number} order=300 - Index used to define the order of execution */
	    order: 300,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: preventOverflow,

	    /**
	     * @prop {Array} [priority=['left','right','top','bottom']]
	     * Popper will try to prevent overflow following these priorities by default,
	     * then, it could overflow on the left and on top of the `boundariesElement`
	     */
	    priority: ['left', 'right', 'top', 'bottom'],

	    /**
	     * @prop {number} padding=5
	     * Amount of pixel used to define a minimum distance between the boundaries
	     * and the popper. This makes sure the popper always has a little padding
	     * between the edges of its container
	     */
	    padding: 5,

	    /**
	     * @prop {String|HTMLElement} boundariesElement='scrollParent'
	     * Boundaries used by the modifier. Can be `scrollParent`, `window`,
	     * `viewport` or any DOM element.
	     */
	    boundariesElement: 'scrollParent'
	  },

	  /**
	   * Modifier used to make sure the reference and its popper stay near each other
	   * without leaving any gap between the two. Especially useful when the arrow is
	   * enabled and you want to ensure that it points to its reference element.
	   * It cares only about the first axis. You can still have poppers with margin
	   * between the popper and its reference element.
	   * @memberof modifiers
	   * @inner
	   */
	  keepTogether: {
	    /** @prop {number} order=400 - Index used to define the order of execution */
	    order: 400,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: keepTogether
	  },

	  /**
	   * This modifier is used to move the `arrowElement` of the popper to make
	   * sure it is positioned between the reference element and its popper element.
	   * It will read the outer size of the `arrowElement` node to detect how many
	   * pixels of conjunction are needed.
	   *
	   * It has no effect if no `arrowElement` is provided.
	   * @memberof modifiers
	   * @inner
	   */
	  arrow: {
	    /** @prop {number} order=500 - Index used to define the order of execution */
	    order: 500,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: arrow,

	    /** @prop {String|HTMLElement} element='[x-arrow]' - Selector or node used as arrow */
	    element: '[x-arrow]'
	  },

	  /**
	   * Modifier used to flip the popper's placement when it starts to overlap its
	   * reference element.
	   *
	   * Requires the `preventOverflow` modifier before it in order to work.
	   *
	   * **NOTE:** this modifier will interrupt the current update cycle and will
	   * restart it if it detects the need to flip the placement.
	   * @memberof modifiers
	   * @inner
	   */
	  flip: {
	    /** @prop {number} order=600 - Index used to define the order of execution */
	    order: 600,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: flip,

	    /**
	     * @prop {String|Array} behavior='flip'
	     * The behavior used to change the popper's placement. It can be one of
	     * `flip`, `clockwise`, `counterclockwise` or an array with a list of valid
	     * placements (with optional variations)
	     */
	    behavior: 'flip',

	    /**
	     * @prop {number} padding=5
	     * The popper will flip if it hits the edges of the `boundariesElement`
	     */
	    padding: 5,

	    /**
	     * @prop {String|HTMLElement} boundariesElement='viewport'
	     * The element which will define the boundaries of the popper position.
	     * The popper will never be placed outside of the defined boundaries
	     * (except if `keepTogether` is enabled)
	     */
	    boundariesElement: 'viewport',

	    /**
	     * @prop {Boolean} flipVariations=false
	     * The popper will switch placement variation between `-start` and `-end` when
	     * the reference element overlaps its boundaries.
	     *
	     * The original placement should have a set variation.
	     */
	    flipVariations: false,

	    /**
	     * @prop {Boolean} flipVariationsByContent=false
	     * The popper will switch placement variation between `-start` and `-end` when
	     * the popper element overlaps its reference boundaries.
	     *
	     * The original placement should have a set variation.
	     */
	    flipVariationsByContent: false
	  },

	  /**
	   * Modifier used to make the popper flow toward the inner of the reference element.
	   * By default, when this modifier is disabled, the popper will be placed outside
	   * the reference element.
	   * @memberof modifiers
	   * @inner
	   */
	  inner: {
	    /** @prop {number} order=700 - Index used to define the order of execution */
	    order: 700,

	    /** @prop {Boolean} enabled=false - Whether the modifier is enabled or not */
	    enabled: false,

	    /** @prop {ModifierFn} */
	    fn: inner
	  },

	  /**
	   * Modifier used to hide the popper when its reference element is outside of the
	   * popper boundaries. It will set a `x-out-of-boundaries` attribute which can
	   * be used to hide with a CSS selector the popper when its reference is
	   * out of boundaries.
	   *
	   * Requires the `preventOverflow` modifier before it in order to work.
	   * @memberof modifiers
	   * @inner
	   */
	  hide: {
	    /** @prop {number} order=800 - Index used to define the order of execution */
	    order: 800,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: hide
	  },

	  /**
	   * Computes the style that will be applied to the popper element to gets
	   * properly positioned.
	   *
	   * Note that this modifier will not touch the DOM, it just prepares the styles
	   * so that `applyStyle` modifier can apply it. This separation is useful
	   * in case you need to replace `applyStyle` with a custom implementation.
	   *
	   * This modifier has `850` as `order` value to maintain backward compatibility
	   * with previous versions of Popper.js. Expect the modifiers ordering method
	   * to change in future major versions of the library.
	   *
	   * @memberof modifiers
	   * @inner
	   */
	  computeStyle: {
	    /** @prop {number} order=850 - Index used to define the order of execution */
	    order: 850,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: computeStyle,

	    /**
	     * @prop {Boolean} gpuAcceleration=true
	     * If true, it uses the CSS 3D transformation to position the popper.
	     * Otherwise, it will use the `top` and `left` properties
	     */
	    gpuAcceleration: true,

	    /**
	     * @prop {string} [x='bottom']
	     * Where to anchor the X axis (`bottom` or `top`). AKA X offset origin.
	     * Change this if your popper should grow in a direction different from `bottom`
	     */
	    x: 'bottom',

	    /**
	     * @prop {string} [x='left']
	     * Where to anchor the Y axis (`left` or `right`). AKA Y offset origin.
	     * Change this if your popper should grow in a direction different from `right`
	     */
	    y: 'right'
	  },

	  /**
	   * Applies the computed styles to the popper element.
	   *
	   * All the DOM manipulations are limited to this modifier. This is useful in case
	   * you want to integrate Popper.js inside a framework or view library and you
	   * want to delegate all the DOM manipulations to it.
	   *
	   * Note that if you disable this modifier, you must make sure the popper element
	   * has its position set to `absolute` before Popper.js can do its work!
	   *
	   * Just disable this modifier and define your own to achieve the desired effect.
	   *
	   * @memberof modifiers
	   * @inner
	   */
	  applyStyle: {
	    /** @prop {number} order=900 - Index used to define the order of execution */
	    order: 900,

	    /** @prop {Boolean} enabled=true - Whether the modifier is enabled or not */
	    enabled: true,

	    /** @prop {ModifierFn} */
	    fn: applyStyle,

	    /** @prop {Function} */
	    onLoad: applyStyleOnLoad,

	    /**
	     * @deprecated since version 1.10.0, the property moved to `computeStyle` modifier
	     * @prop {Boolean} gpuAcceleration=true
	     * If true, it uses the CSS 3D transformation to position the popper.
	     * Otherwise, it will use the `top` and `left` properties
	     */
	    gpuAcceleration: undefined
	  }
	};
	/**
	 * The `dataObject` is an object containing all the information used by Popper.js.
	 * This object is passed to modifiers and to the `onCreate` and `onUpdate` callbacks.
	 * @name dataObject
	 * @property {Object} data.instance The Popper.js instance
	 * @property {String} data.placement Placement applied to popper
	 * @property {String} data.originalPlacement Placement originally defined on init
	 * @property {Boolean} data.flipped True if popper has been flipped by flip modifier
	 * @property {Boolean} data.hide True if the reference element is out of boundaries, useful to know when to hide the popper
	 * @property {HTMLElement} data.arrowElement Node used as arrow by arrow modifier
	 * @property {Object} data.styles Any CSS property defined here will be applied to the popper. It expects the JavaScript nomenclature (eg. `marginBottom`)
	 * @property {Object} data.arrowStyles Any CSS property defined here will be applied to the popper arrow. It expects the JavaScript nomenclature (eg. `marginBottom`)
	 * @property {Object} data.boundaries Offsets of the popper boundaries
	 * @property {Object} data.offsets The measurements of popper, reference and arrow elements
	 * @property {Object} data.offsets.popper `top`, `left`, `width`, `height` values
	 * @property {Object} data.offsets.reference `top`, `left`, `width`, `height` values
	 * @property {Object} data.offsets.arrow] `top` and `left` offsets, only one of them will be different from 0
	 */

	/**
	 * Default options provided to Popper.js constructor.<br />
	 * These can be overridden using the `options` argument of Popper.js.<br />
	 * To override an option, simply pass an object with the same
	 * structure of the `options` object, as the 3rd argument. For example:
	 * ```
	 * new Popper(ref, pop, {
	 *   modifiers: {
	 *     preventOverflow: { enabled: false }
	 *   }
	 * })
	 * ```
	 * @type {Object}
	 * @static
	 * @memberof Popper
	 */

	var Defaults = {
	  /**
	   * Popper's placement.
	   * @prop {Popper.placements} placement='bottom'
	   */
	  placement: 'bottom',

	  /**
	   * Set this to true if you want popper to position it self in 'fixed' mode
	   * @prop {Boolean} positionFixed=false
	   */
	  positionFixed: false,

	  /**
	   * Whether events (resize, scroll) are initially enabled.
	   * @prop {Boolean} eventsEnabled=true
	   */
	  eventsEnabled: true,

	  /**
	   * Set to true if you want to automatically remove the popper when
	   * you call the `destroy` method.
	   * @prop {Boolean} removeOnDestroy=false
	   */
	  removeOnDestroy: false,

	  /**
	   * Callback called when the popper is created.<br />
	   * By default, it is set to no-op.<br />
	   * Access Popper.js instance with `data.instance`.
	   * @prop {onCreate}
	   */
	  onCreate: function onCreate() {},

	  /**
	   * Callback called when the popper is updated. This callback is not called
	   * on the initialization/creation of the popper, but only on subsequent
	   * updates.<br />
	   * By default, it is set to no-op.<br />
	   * Access Popper.js instance with `data.instance`.
	   * @prop {onUpdate}
	   */
	  onUpdate: function onUpdate() {},

	  /**
	   * List of modifiers used to modify the offsets before they are applied to the popper.
	   * They provide most of the functionalities of Popper.js.
	   * @prop {modifiers}
	   */
	  modifiers: modifiers
	};
	/**
	 * @callback onCreate
	 * @param {dataObject} data
	 */

	/**
	 * @callback onUpdate
	 * @param {dataObject} data
	 */
	// Utils
	// Methods

	var Popper = function () {
	  /**
	   * Creates a new Popper.js instance.
	   * @class Popper
	   * @param {Element|referenceObject} reference - The reference element used to position the popper
	   * @param {Element} popper - The HTML / XML element used as the popper
	   * @param {Object} options - Your custom options to override the ones defined in [Defaults](#defaults)
	   * @return {Object} instance - The generated Popper.js instance
	   */
	  function Popper(reference, popper) {
	    var _this = this;

	    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
	    classCallCheck(this, Popper);

	    this.scheduleUpdate = function () {
	      return requestAnimationFrame(_this.update);
	    }; // make update() debounced, so that it only runs at most once-per-tick


	    this.update = debounce(this.update.bind(this)); // with {} we create a new object with the options inside it

	    this.options = _extends$1({}, Popper.Defaults, options); // init state

	    this.state = {
	      isDestroyed: false,
	      isCreated: false,
	      scrollParents: []
	    }; // get reference and popper elements (allow jQuery wrappers)

	    this.reference = reference && reference.jquery ? reference[0] : reference;
	    this.popper = popper && popper.jquery ? popper[0] : popper; // Deep merge modifiers options

	    this.options.modifiers = {};
	    Object.keys(_extends$1({}, Popper.Defaults.modifiers, options.modifiers)).forEach(function (name) {
	      _this.options.modifiers[name] = _extends$1({}, Popper.Defaults.modifiers[name] || {}, options.modifiers ? options.modifiers[name] : {});
	    }); // Refactoring modifiers' list (Object => Array)

	    this.modifiers = Object.keys(this.options.modifiers).map(function (name) {
	      return _extends$1({
	        name: name
	      }, _this.options.modifiers[name]);
	    }) // sort the modifiers by order
	    .sort(function (a, b) {
	      return a.order - b.order;
	    }); // modifiers have the ability to execute arbitrary code when Popper.js get inited
	    // such code is executed in the same order of its modifier
	    // they could add new properties to their options configuration
	    // BE AWARE: don't add options to `options.modifiers.name` but to `modifierOptions`!

	    this.modifiers.forEach(function (modifierOptions) {
	      if (modifierOptions.enabled && isFunction(modifierOptions.onLoad)) {
	        modifierOptions.onLoad(_this.reference, _this.popper, _this.options, modifierOptions, _this.state);
	      }
	    }); // fire the first update to position the popper in the right place

	    this.update();
	    var eventsEnabled = this.options.eventsEnabled;

	    if (eventsEnabled) {
	      // setup event listeners, they will take care of update the position in specific situations
	      this.enableEventListeners();
	    }

	    this.state.eventsEnabled = eventsEnabled;
	  } // We can't use class properties because they don't get listed in the
	  // class prototype and break stuff like Sinon stubs


	  createClass(Popper, [{
	    key: 'update',
	    value: function update$$1() {
	      return update.call(this);
	    }
	  }, {
	    key: 'destroy',
	    value: function destroy$$1() {
	      return destroy.call(this);
	    }
	  }, {
	    key: 'enableEventListeners',
	    value: function enableEventListeners$$1() {
	      return enableEventListeners.call(this);
	    }
	  }, {
	    key: 'disableEventListeners',
	    value: function disableEventListeners$$1() {
	      return disableEventListeners.call(this);
	    }
	    /**
	     * Schedules an update. It will run on the next UI update available.
	     * @method scheduleUpdate
	     * @memberof Popper
	     */

	    /**
	     * Collection of utilities useful when writing custom modifiers.
	     * Starting from version 1.7, this method is available only if you
	     * include `popper-utils.js` before `popper.js`.
	     *
	     * **DEPRECATION**: This way to access PopperUtils is deprecated
	     * and will be removed in v2! Use the PopperUtils module directly instead.
	     * Due to the high instability of the methods contained in Utils, we can't
	     * guarantee them to follow semver. Use them at your own risk!
	     * @static
	     * @private
	     * @type {Object}
	     * @deprecated since version 1.8
	     * @member Utils
	     * @memberof Popper
	     */

	  }]);
	  return Popper;
	}();
	/**
	 * The `referenceObject` is an object that provides an interface compatible with Popper.js
	 * and lets you use it as replacement of a real DOM node.<br />
	 * You can use this method to position a popper relatively to a set of coordinates
	 * in case you don't have a DOM node to use as reference.
	 *
	 * ```
	 * new Popper(referenceObject, popperNode);
	 * ```
	 *
	 * NB: This feature isn't supported in Internet Explorer 10.
	 * @name referenceObject
	 * @property {Function} data.getBoundingClientRect
	 * A function that returns a set of coordinates compatible with the native `getBoundingClientRect` method.
	 * @property {number} data.clientWidth
	 * An ES6 getter that will return the width of the virtual reference element.
	 * @property {number} data.clientHeight
	 * An ES6 getter that will return the height of the virtual reference element.
	 */


	Popper.Utils = (typeof window !== 'undefined' ? window : global).PopperUtils;
	Popper.placements = placements;
	Popper.Defaults = Defaults;

	var vuePopper_min = createCommonjsModule$1(function (module, exports) {
	  !function (e, t) {
	    module.exports = t(Popper);
	  }(commonjsGlobal$1, function (e) {

	    function t(e, t, o) {
	      e && t && o && (document.addEventListener ? e.addEventListener(t, o, !1) : e.attachEvent("on" + t, o));
	    }

	    function o(e, t, o) {
	      e && t && (document.removeEventListener ? e.removeEventListener(t, o, !1) : e.detachEvent("on" + t, o));
	    }

	    e = e && e.hasOwnProperty("default") ? e.default : e;
	    var n = {
	      props: {
	        tagName: {
	          type: String,
	          default: "span"
	        },
	        trigger: {
	          type: String,
	          default: "hover",
	          validator: function validator(e) {
	            return ["click", "hover"].indexOf(e) > -1;
	          }
	        },
	        delayOnMouseOver: {
	          type: Number,
	          default: 10
	        },
	        delayOnMouseOut: {
	          type: Number,
	          default: 10
	        },
	        disabled: {
	          type: Boolean,
	          default: !1
	        },
	        content: String,
	        enterActiveClass: String,
	        leaveActiveClass: String,
	        boundariesSelector: String,
	        reference: {},
	        forceShow: {
	          type: Boolean,
	          default: !1
	        },
	        dataValue: {
	          default: null
	        },
	        appendToBody: {
	          type: Boolean,
	          default: !1
	        },
	        visibleArrow: {
	          type: Boolean,
	          default: !0
	        },
	        transition: {
	          type: String,
	          default: ""
	        },
	        stopPropagation: {
	          type: Boolean,
	          default: !1
	        },
	        preventDefault: {
	          type: Boolean,
	          default: !1
	        },
	        options: {
	          type: Object,
	          default: function _default() {
	            return {};
	          }
	        }
	      },
	      data: function data() {
	        return {
	          referenceElm: null,
	          popperJS: null,
	          showPopper: !1,
	          currentPlacement: "",
	          popperOptions: {
	            placement: "bottom",
	            computeStyle: {
	              gpuAcceleration: !1
	            }
	          }
	        };
	      },
	      watch: {
	        showPopper: function showPopper(e) {
	          e ? (this.$emit("show", this), this.popperJS && this.popperJS.enableEventListeners(), this.updatePopper()) : (this.popperJS && this.popperJS.disableEventListeners(), this.$emit("hide", this));
	        },
	        forceShow: {
	          handler: function handler(e) {
	            this[e ? "doShow" : "doClose"]();
	          },
	          immediate: !0
	        },
	        disabled: function disabled(e) {
	          e && (this.showPopper = !1);
	        }
	      },
	      created: function created() {
	        this.appendedArrow = !1, this.appendedToBody = !1, this.popperOptions = _extends(this.popperOptions, this.options);
	      },
	      mounted: function mounted() {
	        switch (this.referenceElm = this.reference || this.$slots.reference[0].elm, this.popper = this.$slots.default[0].elm, this.trigger) {
	          case "click":
	            t(this.referenceElm, "click", this.doToggle), t(document, "click", this.handleDocumentClick);
	            break;

	          case "hover":
	            t(this.referenceElm, "mouseover", this.onMouseOver), t(this.referenceElm, "focus", this.onMouseOver), t(this.popper, "mouseover", this.onMouseOver), t(this.popper, "focus", this.onMouseOver), t(this.referenceElm, "mouseout", this.onMouseOut), t(this.referenceElm, "blur", this.onMouseOut), t(this.popper, "mouseout", this.onMouseOut), t(this.popper, "blur", this.onMouseOut);
	        }
	      },
	      methods: {
	        doToggle: function doToggle(e) {
	          this.stopPropagation && e.stopPropagation(), this.preventDefault && e.preventDefault(), this.forceShow || (this.showPopper = !this.showPopper);
	        },
	        doShow: function doShow() {
	          this.showPopper = !0;
	        },
	        doClose: function doClose() {
	          this.showPopper = !1;
	        },
	        doDestroy: function doDestroy() {
	          this.showPopper || (this.popperJS && (this.popperJS.destroy(), this.popperJS = null), this.appendedToBody && (this.appendedToBody = !1, document.body.removeChild(this.popper.parentElement)));
	        },
	        createPopper: function createPopper() {
	          var t = this;
	          this.$nextTick(function () {
	            if (t.visibleArrow && t.appendArrow(t.popper), t.appendToBody && !t.appendedToBody && (t.appendedToBody = !0, document.body.appendChild(t.popper.parentElement)), t.popperJS && t.popperJS.destroy && t.popperJS.destroy(), t.boundariesSelector) {
	              var o = document.querySelector(t.boundariesSelector);
	              o && (t.popperOptions.modifiers = _extends({}, t.popperOptions.modifiers), t.popperOptions.modifiers.preventOverflow = _extends({}, t.popperOptions.modifiers.preventOverflow), t.popperOptions.modifiers.preventOverflow.boundariesElement = o);
	            }

	            t.popperOptions.onCreate = function () {
	              t.$emit("created", t), t.$nextTick(t.updatePopper);
	            }, t.popperJS = new e(t.referenceElm, t.popper, t.popperOptions);
	          });
	        },
	        destroyPopper: function destroyPopper() {
	          o(this.referenceElm, "click", this.doToggle), o(this.referenceElm, "mouseup", this.doClose), o(this.referenceElm, "mousedown", this.doShow), o(this.referenceElm, "focus", this.doShow), o(this.referenceElm, "blur", this.doClose), o(this.referenceElm, "mouseout", this.onMouseOut), o(this.referenceElm, "mouseover", this.onMouseOver), o(document, "click", this.handleDocumentClick), this.showPopper = !1, this.doDestroy();
	        },
	        appendArrow: function appendArrow(e) {
	          if (!this.appendedArrow) {
	            this.appendedArrow = !0;
	            var t = document.createElement("div");
	            t.setAttribute("x-arrow", ""), t.className = "popper__arrow", e.appendChild(t);
	          }
	        },
	        updatePopper: function updatePopper() {
	          this.popperJS ? this.popperJS.scheduleUpdate() : this.createPopper();
	        },
	        onMouseOver: function onMouseOver() {
	          var e = this;
	          clearTimeout(this._timer), this._timer = setTimeout(function () {
	            e.showPopper = !0;
	          }, this.delayOnMouseOver);
	        },
	        onMouseOut: function onMouseOut() {
	          var e = this;
	          clearTimeout(this._timer), this._timer = setTimeout(function () {
	            e.showPopper = !1;
	          }, this.delayOnMouseOut);
	        },
	        handleDocumentClick: function handleDocumentClick(e) {
	          this.$el && this.referenceElm && !this.elementContains(this.$el, e.target) && !this.elementContains(this.referenceElm, e.target) && this.popper && !this.elementContains(this.popper, e.target) && (this.$emit("documentClick", this), this.forceShow || (this.showPopper = !1));
	        },
	        elementContains: function elementContains(e, t) {
	          return "function" == typeof e.contains && e.contains(t);
	        }
	      },
	      destroyed: function destroyed() {
	        this.destroyPopper();
	      }
	    };
	    var r = n;
	    n.__file = "popper.js.vue";
	    return function (e, t, o, n, r, s, i, p, a, d) {
	      "function" == typeof i && (a = p, p = i, i = !1);
	      var c = "function" == typeof o ? o.options : o;
	      var u;
	      if (e && e.render && (c.render = e.render, c.staticRenderFns = e.staticRenderFns, c._compiled = !0, r && (c.functional = !0)), n && (c._scopeId = n), s ? (u = function u(e) {
	        (e = e || this.$vnode && this.$vnode.ssrContext || this.parent && this.parent.$vnode && this.parent.$vnode.ssrContext) || "undefined" == typeof __VUE_SSR_CONTEXT__ || (e = __VUE_SSR_CONTEXT__), t && t.call(this, a(e)), e && e._registeredComponents && e._registeredComponents.add(s);
	      }, c._ssrRegister = u) : t && (u = i ? function () {
	        t.call(this, d(this.$root.$options.shadowRoot));
	      } : function (e) {
	        t.call(this, p(e));
	      }), u) { if (c.functional) {
	        var _e = c.render;

	        c.render = function (t, o) {
	          return u.call(o), _e(t, o);
	        };
	      } else {
	        var _e2 = c.beforeCreate;
	        c.beforeCreate = _e2 ? [].concat(_e2, u) : [u];
	      } }
	      return o;
	    }({
	      render: function render() {
	        var e = this,
	            t = e.$createElement,
	            o = e._self._c || t;
	        return o(e.tagName, {
	          tag: "component"
	        }, [o("transition", {
	          attrs: {
	            name: e.transition,
	            "enter-active-class": e.enterActiveClass,
	            "leave-active-class": e.leaveActiveClass
	          },
	          on: {
	            "after-leave": e.doDestroy
	          }
	        }, [o("span", {
	          directives: [{
	            name: "show",
	            rawName: "v-show",
	            value: !e.disabled && e.showPopper,
	            expression: "!disabled && showPopper"
	          }],
	          ref: "popper"
	        }, [e._t("default", [e._v(e._s(e.content))])], 2)]), e._v(" "), e._t("reference")], 2);
	      },
	      staticRenderFns: []
	    }, void 0, r, void 0, !1, void 0, void 0, void 0);
	  });
	});

	var component = {
	    components: {
	        uiButton
	    },
	    methods: {},
	    computed: {}
	};

	component.originalTemplate = "createOnly";
	component.template = `
  <wizdomWebpart data-v-4a028680 :environmentInfo="environmentInfo" :chromeProperties="webpartProperties.chromeProperties" :webpartPadding="true"  :title="'Noticeboard' | translate" chromeType="none" :paddingTop="0" :paddingSides="0">
     <div data-v-4a028680 class="root" data-automation-id="noticeboard">
        

        <uiButton data-v-4a028680 class="createOnlyButton" type="primary" :disabled="!anyWriteAccess" @click="newEditItem = {}">{{webpartProperties.createButtonText | translate}}</uiButton>

        <newItem data-v-4a028680  v-if="newEditItem" v-model="newEditItem" @itemCreated="refreshItems" @itemUpdate="refreshItems" />
      
    </div>
</wizdomWebpart>
`;
	component.styles = `


`;

	return component;

});
